/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import hydra.Log;
import hydra.TestConfig;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;
import util.BaseValueHolder;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;
import util.ValueHolderPrms;

public class DeltaValueHolder
extends ValueHolder
implements Delta {
    private boolean hasDelta = false;
    public static boolean logCalls = false;

    public DeltaValueHolder() {
        this.myVersion = "delta.DeltaValueHolder";
    }

    public DeltaValueHolder(Object anObj, RandomValues randomValues) {
        super(anObj, randomValues);
        this.myVersion = "delta.DeltaValueHolder";
    }

    public DeltaValueHolder(RandomValues randomValues) {
        super(randomValues);
        this.myVersion = "delta.DeltaValueHolder";
    }

    public DeltaValueHolder(String nameFactoryName, RandomValues randomValues) {
        super(nameFactoryName, randomValues);
        this.myVersion = "delta.DeltaValueHolder";
    }

    public DeltaValueHolder(Object anObj, RandomValues randomValues, Integer initModVal) {
        super(anObj, randomValues, initModVal);
        this.myVersion = "delta.DeltaValueHolder";
    }

    public DeltaValueHolder(String nameFactoryName, RandomValues randomValues, Integer initModVal) {
        super((Object)nameFactoryName, randomValues, initModVal);
        this.myVersion = "delta.DeltaValueHolder";
    }

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        try {
            if (logCalls) {
                Log.getLogWriter().info("In DeltaValueHolder fromDelta " + TestHelper.toString(this));
            }
            this.myValue = DataSerializer.readObject((DataInput)in);
            this.extraObject = DataSerializer.readObject((DataInput)in);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean hasDelta() {
        if (logCalls) {
            Log.getLogWriter().info("In DeltaValueHolder hasDelta, returning " + this.hasDelta);
        }
        return this.hasDelta;
    }

    public void toDelta(DataOutput out) throws IOException {
        if (logCalls) {
            Log.getLogWriter().info("In DeltaValueHolder toDelta " + TestHelper.toString(this));
        }
        DataSerializer.writeObject((Object)this.myValue, (DataOutput)out);
        DataSerializer.writeObject((Object)this.extraObject, (DataOutput)out);
        this.hasDelta = false;
    }

    @Override
    public BaseValueHolder getAlternateValueHolder(RandomValues randomValues) {
        DeltaValueHolder vh = new DeltaValueHolder();
        vh.hasDelta = true;
        if (this.myValue instanceof Long) {
            vh.myValue = this.myValue.toString();
        } else if (this.myValue instanceof String) {
            vh.myValue = new Integer((String)this.myValue);
        } else if (this.myValue instanceof Integer) {
            vh.myValue = new BigInteger(this.myValue.toString());
        } else if (this.myValue instanceof BigInteger) {
            vh.myValue = new Long(this.myValue.toString());
        } else {
            throw new TestException("Cannot get replace value for myValue in " + TestHelper.toString(vh));
        }
        if (TestConfig.tab().booleanAt(ValueHolderPrms.useExtraObject)) {
            vh.extraObject = randomValues.getRandomObjectGraph();
        }
        return vh;
    }
}

