/*
 * Decompiled with CFR 0.152.
 */
package delta;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import delta.DeltaPropagation;
import delta.DeltaPropagationBB;
import delta.DeltaPropagationPrms;
import delta.DeltaTestObj;
import delta.Validator;
import hct.HctPrms;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import util.TestException;
import util.TestHelper;

public class Feeder {
    static final int TOTAL_PUT_THREADS = TestConfig.tab().intAt(DeltaPropagationPrms.numPutThreads);
    static final int PUT_KEY_RANGE = TestConfig.tab().intAt(DeltaPropagationPrms.numKeyRangePerThread);
    static Thread[] putThreads = new Thread[TOTAL_PUT_THREADS];
    static final String regionName = TestConfig.tab().stringAt(HctPrms.regionName);
    static List threadList = new ArrayList(TOTAL_PUT_THREADS);
    static volatile boolean stop = false;
    static volatile boolean exceptionOccured = false;
    static StringBuffer exceptionMsg = new StringBuffer();
    protected static final Map latestValues = new HashMap();
    protected static final String REGION_NAME = TestConfig.tab().stringAt(HctPrms.regionName);
    protected final String deltaType = TestConfig.tab().stringAt(DeltaPropagationPrms.objectType, "delta.DeltaTestObj");
    static int numOfRegion = 1;
    public static final String LAST_KEY = "last_key";
    public static boolean isClient = false;
    public static HashMap keyToMap = new HashMap();

    private static String getKeyForOperation() {
        Random r = new Random();
        int randint = r.nextInt(PUT_KEY_RANGE);
        return "KEY-" + randint;
    }

    protected static void createEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (!region.containsKey((Object)key)) {
                region.create((Object)key, (Object)(key + "_VALUE"));
            }
        }
        catch (EntryExistsException e) {
            Log.getLogWriter().warning("EntryExistsException occured while creating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while creating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void updateEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key)) {
                region.put((Object)key, (Object)(key + "_VALUE"));
            }
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while updating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void invalidateEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key) && region.get((Object)key) != null) {
                region.invalidate((Object)key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().warning("EntryNotFoundException occured while invalidating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while invalidating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void destroyEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key)) {
                region.destroy((Object)key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().warning("EntryNotFoundException occured while invalidating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while invalidating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void registerInterest(Region region) {
        String key = Feeder.getKeyForOperation();
        long start = System.currentTimeMillis();
        long total = 0L;
        try {
            region.registerInterest((Object)key);
            total = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while registerInterest. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        if (total > 0L) {
            Log.getLogWriter().info("time taken for registerInterest : " + total);
        }
    }

    protected static void unregisterInterest(Region region) {
        String key = Feeder.getKeyForOperation();
        long start = System.currentTimeMillis();
        long total = 0L;
        try {
            region.unregisterInterest((Object)key);
            total = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while unregisterInterest. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        if (total > 0L) {
            Log.getLogWriter().info("time taken for unregisterInterest : " + total);
        }
    }

    public static void feederTimedTask() {
        long end = System.currentTimeMillis() + TestConfig.tab().longAt(DeltaPropagationPrms.feederTaskTimeSec) * 1000L;
        do {
            Feeder.feederTask();
        } while (System.currentTimeMillis() < end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void feederTask() {
        List list = threadList;
        synchronized (list) {
            String exceptionReason = Validator.checkBlackBoardForException();
            if (exceptionOccured) {
                throw new TestException(exceptionMsg.toString());
            }
            if (exceptionReason != null) {
                stop = true;
                threadList.notifyAll();
                for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
                    try {
                        putThreads[i].join(120000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
                    }
                }
                throw new TestException(exceptionReason);
            }
            for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
                int newCounter = (Integer)threadList.get(i) + 1;
                threadList.set(i, new Integer(newCounter));
            }
            threadList.notifyAll();
        }
    }

    public static void populateSharedMapWithRegionData() {
        try {
            numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
            for (int i = 0; i < numOfRegion; ++i) {
                Region region = RegionHelper.getRegion(regionName + i);
                if (region == null) {
                    throw new TestException("Region created is null " + TestHelper.getStackTrace());
                }
                if (region.isEmpty()) {
                    throw new TestException(" Region has no entries to copy to the SharedMap " + TestHelper.getStackTrace());
                }
                Iterator iterator = region.entrySet(false).iterator();
                Region.Entry entry = null;
                while (iterator.hasNext()) {
                    entry = (Region.Entry)iterator.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    DeltaPropagationBB.getBB().getSharedMap().put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
        }
    }

    public static void closeTask() {
        Feeder.waitForFeederThreadsToComplete();
        Region region = RegionHelper.getRegion(regionName + 0);
        if (region == null) {
            throw new TestException("Region created is null " + TestHelper.getStackTrace());
        }
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        for (String key : keyToMap.keySet()) {
            DeltaTestObj obj = (DeltaTestObj)((Object)keyToMap.get(key));
            DeltaPropagationBB.getBB().getSharedMap().put(key, obj.getToDeltaCounter());
        }
        try {
            Long last_value = new Long(0L);
            region.put((Object)LAST_KEY, (Object)last_value);
            Log.getLogWriter().info("Putting the last key in the region: " + region.getName());
            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_CREATE, 1L);
        }
        catch (Exception e) {
            throw new TestException("Exception while performing put of the last_key" + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("No of puts done by feeder : " + (DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_UPDATE) + DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_DELTA_UPDATE) + DeltaPropagationBB.getBB().getSharedCounters().read(DeltaPropagationBB.NUM_NON_DELTA_UPDATE)));
        Log.getLogWriter().info("Close Task Complete...");
    }

    public static void verifyDeltaFailuresInC2S() {
        CachePerfStats stats = ((DistributedRegion)GemFireCacheImpl.getInstance().getRegion(regionName + 0)).getCachePerfStats();
        if (stats.getDeltaFailedUpdates() == 0) {
            throw new TestException("CachePerfStats indicating failed delta updates is expected to be non-zero.");
        }
    }

    public static void verifyDeltaFailuresInP2P() {
        CachePerfStats stats = ((DistributedRegion)GemFireCacheImpl.getInstance().getRegion(regionName + 0)).getCachePerfStats();
        if (stats.getDeltaFailedUpdates() == 0) {
            throw new TestException("CachePerfStats indicating failed delta updates is expected to be non-zero.");
        }
    }

    public static void verifyDeltaFailuresInS2C() {
        throw new TestException("CachePerfStats indicating failed delta updates is expected to be non-zero.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForFeederThreadsToComplete() {
        List list = threadList;
        synchronized (list) {
            stop = true;
            threadList.notifyAll();
        }
        for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
            try {
                putThreads[i].join(120000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
            }
        }
        if (exceptionOccured) {
            throw new TestException(exceptionMsg.toString());
        }
        Log.getLogWriter().info("Setting feed signal...");
        try {
            DeltaPropagationBB.getBB().getSharedCounters().increment(DeltaPropagationBB.feedSignal);
        }
        catch (Exception e) {
            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
            exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        Validator.checkBlackBoardForException();
    }

    protected static Long getLatestValue(String key, String threadIdKey) {
        Map latestValueForThread = (Map)latestValues.get(threadIdKey);
        Long oldVal = (Long)latestValueForThread.remove(key);
        if (oldVal == null) {
            throw new TestException("oldVal cannot be null");
        }
        return new Long(oldVal + 1L);
    }

    protected static DeltaTestObj getLatestDelta(String key, String threadIdKey, boolean isCreate) {
        Map latestValueForThread = (Map)latestValues.get(threadIdKey);
        DeltaTestObj oldVal = (DeltaTestObj)((Object)latestValueForThread.remove(key));
        if (oldVal == null) {
            throw new TestException("oldDelta cannot be null");
        }
        DeltaTestObj obj = null;
        obj = new DeltaTestObj(oldVal.getIntVar() + 1, "delta");
        if (!isCreate) {
            obj.setIntVar(oldVal.getIntVar() + 1);
        }
        return obj;
    }

    protected static boolean updateLatestValueMap(Region region, String key, String threadId, boolean isDestroyCall) throws Exception {
        Object oldVal = null;
        if (region.containsKey((Object)key)) {
            oldVal = region.get((Object)key);
            if (oldVal == null) {
                return isDestroyCall;
            }
            Map latestValueForThread = (Map)latestValues.get(threadId);
            latestValueForThread.put(key, oldVal);
            return true;
        }
        return false;
    }

    public static void initToFeedMixOfDeltaAndOthers() {
        String threadIdkeyPrefix;
        Region region;
        int i;
        if (!isClient) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
            for (i = 0; i < numOfRegion; ++i) {
                region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
                if (region == null) {
                    exceptionMsg.append("Region created is null ");
                    exceptionOccured = true;
                }
                threadIdkeyPrefix = "Thread_";
                Feeder.createMixOfDeltaEntries(region, threadIdkeyPrefix);
            }
        } else {
            DeltaPropagation.initCacheClient();
            String regionName = TestConfig.tab().stringAt(HctPrms.regionName);
            region = RegionHelper.getRegion("/" + regionName + 0);
            if (region == null) {
                exceptionMsg.append("Region created is null ");
                exceptionOccured = true;
            }
            threadIdkeyPrefix = "Thread_";
            Feeder.createMixOfDeltaEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                                    exceptionOccured = true;
                                }
                            }
                            if (stop) {
                                break;
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numNonDeltaCreate = 0;
                        int numNonDeltaUpdate = 0;
                        int numDeltaCreate = 0;
                        int numDeltaUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        Region region = RegionHelper.getRegion("/" + regionName + 0);
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(DeltaPropagationPrms.entryOperations, "put");
                                if (j % 2 == 0) {
                                    key = key + "_n_d_o";
                                }
                                if (operation.equals("put")) {
                                    Object oldVal;
                                    Object newVal;
                                    if (j % 2 == 1) {
                                        newVal = null;
                                        if (region.containsKey((Object)key)) {
                                            oldVal = (DeltaTestObj)((Object)region.get((Object)key));
                                            if (oldVal == null) {
                                                newVal = Feeder.getLatestDelta(key, threadIdkey, false);
                                                region.put((Object)key, newVal);
                                            } else {
                                                newVal = oldVal;
                                                newVal.setIntVar(oldVal.getIntVar() + 1);
                                                Log.getLogWriter().fine("update value : " + newVal);
                                                region.put((Object)key, newVal);
                                            }
                                            ++numDeltaUpdate;
                                        } else {
                                            newVal = Feeder.getLatestDelta(key, threadIdkey, true);
                                            Log.getLogWriter().fine("create value : " + newVal);
                                            region.create((Object)key, newVal);
                                            ++numDeltaCreate;
                                        }
                                        Log.getLogWriter().fine("puting entry in Map key " + key + " : value : " + newVal);
                                        keyToMap.put(key, newVal);
                                        continue;
                                    }
                                    newVal = null;
                                    if (region.containsKey((Object)key)) {
                                        oldVal = (Long)region.get((Object)key);
                                        if (oldVal == null) {
                                            newVal = Feeder.getLatestValue(key, threadIdkey);
                                            region.put((Object)key, newVal);
                                        } else {
                                            newVal = (Long)oldVal + 1L;
                                            Log.getLogWriter().fine("update value : " + newVal);
                                            region.put((Object)key, newVal);
                                        }
                                        ++numNonDeltaUpdate;
                                        continue;
                                    }
                                    newVal = Feeder.getLatestValue(key, threadIdkey);
                                    Log.getLogWriter().fine("create value : " + newVal);
                                    region.create((Object)key, newVal);
                                    ++numNonDeltaCreate;
                                    continue;
                                }
                                if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        region.destroy((Object)key);
                                        ++numDestroy;
                                        Log.getLogWriter().fine("remove/destroy entry in Map key " + key);
                                        keyToMap.remove(key);
                                    }
                                    continue;
                                }
                                throw new TestException("Unknown entry operation: " + operation);
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                                exceptionOccured = true;
                            }
                        }
                        try {
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_NON_DELTA_CREATE, numNonDeltaCreate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_NON_DELTA_UPDATE, numNonDeltaUpdate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_INVALIDATE, numInvalidate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_DESTROY, numDestroy);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_DELTA_CREATE, numDeltaCreate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_DELTA_UPDATE, numDeltaUpdate);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                            exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed for thread id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    public static void initTask() {
        int i;
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region == null) {
                exceptionMsg.append("Region created is null");
                exceptionOccured = true;
            }
            String threadIdkeyPrefix = "Thread_";
            Feeder.createDeltaEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        Feeder.spawnFeederThreads();
    }

    public static void feederCreateRegions() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
        for (int i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region != null) continue;
            exceptionMsg.append("Region created is null");
            exceptionOccured = true;
        }
    }

    public static void feederSpawnThreads() {
        int i;
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.getRegion(regionName + i);
            String threadIdkeyPrefix = "Thread_";
            Feeder.createDeltaEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        Feeder.spawnFeederThreads();
    }

    public static void initTaskOnBridge() {
        int i;
        numOfRegion = TestConfig.tab().intAt(DeltaPropagationPrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = GemFireCacheImpl.getInstance().getRegion(regionName + i);
            String threadIdkeyPrefix = "Thread_";
            Feeder.createDeltaEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        Feeder.spawnFeederThreads();
    }

    public static void doNothing() {
    }

    private static void spawnFeederThreads() {
        for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                                    exceptionOccured = true;
                                }
                            }
                            if (stop) {
                                break;
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        int numRegion = TestConfig.tab().intAt(DeltaPropagationPrms.regionRange, 1) - 1;
                        Region region = RegionHelper.getRegion(regionName + numRegion);
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(DeltaPropagationPrms.entryOperations, "put");
                                if (operation.equals("put")) {
                                    DeltaTestObj newVal = null;
                                    if (region.containsKey((Object)key)) {
                                        DeltaTestObj oldVal = (DeltaTestObj)((Object)region.get((Object)key));
                                        if (oldVal == null) {
                                            newVal = Feeder.getLatestDelta(key, threadIdkey, false);
                                            region.put((Object)key, (Object)newVal);
                                        } else {
                                            newVal = new DeltaTestObj(oldVal);
                                            newVal.setIntVar(oldVal.getIntVar() + 1);
                                            Log.getLogWriter().info("update value: " + (Object)((Object)newVal));
                                            if (region instanceof PartitionedRegion && ((PartitionedRegion)region).getLocalMaxMemory() == 0) {
                                                newVal.setToDeltaCounter(newVal.getIntVar() - 1);
                                            }
                                            region.put((Object)key, (Object)newVal);
                                        }
                                        ++numUpdate;
                                    } else {
                                        newVal = Feeder.getLatestDelta(key, threadIdkey, true);
                                        Log.getLogWriter().info("create value: " + (Object)((Object)newVal));
                                        region.create((Object)key, (Object)newVal);
                                        ++numCreate;
                                    }
                                    Log.getLogWriter().info("Put entry in Map. key: " + key + ", value: " + (Object)((Object)newVal));
                                    keyToMap.put(key, newVal);
                                    continue;
                                }
                                if (operation.equals("invalidate")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                        region.invalidate((Object)key);
                                        ++numInvalidate;
                                        Log.getLogWriter().info("Invalidated entry in Map. key: " + key + ", value: " + null);
                                        keyToMap.put(key, null);
                                    }
                                    continue;
                                }
                                if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        region.destroy((Object)key);
                                        ++numDestroy;
                                        Log.getLogWriter().info("Destroyed entry in Map. key: " + key);
                                        keyToMap.remove(key);
                                    }
                                    continue;
                                }
                                throw new TestException("Unknown entry operation: " + operation);
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                                exceptionOccured = true;
                            }
                        }
                        try {
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_CREATE, numCreate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_UPDATE, numUpdate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_INVALIDATE, numInvalidate);
                            DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_DESTROY, numDestroy);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter");
                            exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed for thread id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    private static void createDeltaEntries(Region region, String threadIdKeyPrefix) {
        for (int j = 0; j < TOTAL_PUT_THREADS; ++j) {
            String threadIdkey = threadIdKeyPrefix + j;
            HashMap<String, DeltaTestObj> values = new HashMap<String, DeltaTestObj>();
            for (int k = 0; k < PUT_KEY_RANGE; ++k) {
                String key = region.getFullPath() + threadIdkey + "_" + k;
                try {
                    DeltaTestObj initValue = new DeltaTestObj(0, "delta");
                    region.create((Object)key, (Object)initValue);
                    values.put(key, initValue);
                    keyToMap.put(key, initValue);
                    continue;
                }
                catch (Exception e) {
                    Log.getLogWriter().info(TOTAL_PUT_THREADS + "Exception in creating entry for starting with " + j + " for key = " + key);
                    exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                    exceptionOccured = true;
                }
            }
            latestValues.put(threadIdkey, values);
            try {
                DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_CREATE, PUT_KEY_RANGE);
                continue;
            }
            catch (Exception e) {
                Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                exceptionOccured = true;
            }
        }
        Log.getLogWriter().info("Created entries on region : " + region.getFullPath());
    }

    private static void createMixOfDeltaEntries(Region region, String threadIdKeyPrefix) {
        for (int j = 0; j < TOTAL_PUT_THREADS; ++j) {
            String threadIdkey = threadIdKeyPrefix + j;
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int k = 0; k < PUT_KEY_RANGE; ++k) {
                String key = region.getFullPath() + threadIdkey + "_" + k;
                if (k % 2 == 1) {
                    DeltaTestObj newVal = new DeltaTestObj(0, "delta");
                    try {
                        region.create((Object)key, (Object)newVal);
                    }
                    catch (Exception e) {
                        Log.getLogWriter().info(TOTAL_PUT_THREADS + "Exception in creating entry for starting with " + j + " for key = " + key);
                        exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                        exceptionOccured = true;
                    }
                    values.put(key, (Object)newVal);
                    keyToMap.put(key, newVal);
                    try {
                        DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_DELTA_CREATE, 1L);
                    }
                    catch (Exception e) {
                        Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                        exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                        exceptionOccured = true;
                    }
                    continue;
                }
                Long initValue = new Long(0L);
                key = key + "_n_d_o";
                try {
                    region.create((Object)key, (Object)initValue);
                }
                catch (Exception e) {
                    Log.getLogWriter().info(TOTAL_PUT_THREADS + "Exception in creating entry for starting with " + j + " for key = " + key);
                    exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                    exceptionOccured = true;
                }
                values.put(key, initValue);
                try {
                    DeltaPropagationBB.getBB().getSharedCounters().add(DeltaPropagationBB.NUM_NON_DELTA_CREATE, 1L);
                    continue;
                }
                catch (Exception e) {
                    Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                    exceptionMsg.append(e.getMessage() + " " + TestHelper.getStackTrace(e));
                    exceptionOccured = true;
                }
            }
            latestValues.put(threadIdkey, values);
        }
        Log.getLogWriter().info("Created entries on region: " + region.getFullPath());
    }

    public static void feederIsClient() {
        isClient = true;
    }

    public static void noResetTask() {
        DeltaTestObj.NEED_TO_RESET_T0_DELTA = false;
    }
}

