/*
 * Decompiled with CFR 0.152.
 */
package diskRecovery;

import hydra.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import util.TestException;
import util.TestHelper;

public class InstantiationHelper {
    public static final String wellKnownFileName = "allowInstaniation.ser";

    public static boolean allowInstantiation() {
        try {
            FileInputStream fis = new FileInputStream(wellKnownFileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            boolean allowInstantiation = ois.readBoolean();
            return allowInstantiation;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void setAllowInstantiation(boolean aVal) {
        try {
            FileOutputStream fos = new FileOutputStream(wellKnownFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeBoolean(aVal);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        boolean allow = InstantiationHelper.allowInstantiation();
        if (allow != aVal) {
            throw new TestException("Test problem; unable to retrieve allowInstantion from file");
        }
        Log.getLogWriter().info("Set allowInstantiation to " + aVal);
    }
}

