/*
 * Decompiled with CFR 0.152.
 */
package diskRecovery;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import diskRecovery.ConverterTxListener;
import diskRecovery.InstantiationHelper;
import diskRecovery.PersistenceCountObserver;
import diskRecovery.RecoveryBB;
import diskRecovery.RecoveryPrms;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.DiskStorePrms;
import hydra.DistributedSystemBlackboard;
import hydra.DistributedSystemHelper;
import hydra.FileUtil;
import hydra.GatewayHubBlackboard;
import hydra.GatewayHubHelper;
import hydra.GsRandom;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraThreadGroup;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.VersionPrms;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import management.test.cli.CommandTest;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import parReg.ParRegUtil;
import util.AdminHelper;
import util.BaseValueHolder;
import util.CliHelper;
import util.CliHelperPrms;
import util.NameBB;
import util.NameFactory;
import util.PRObserver;
import util.PersistenceUtil;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.SummaryLogListener;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.VHDataSerializable;
import util.VHDataSerializableInstantiator;
import util.VHDataSerializer;
import util.ValueHolder;

public class RecoveryTest {
    public static RecoveryTest testInstance = null;
    private static final String STARTING_STEP = "Starting";
    private static final String DESTROY_STEP = "Destroying";
    private static final String COMPACTION_STEP = "Compaction";
    private static final String STOP_START_STEP = "Stopping/Starting";
    private static final String VERIFY_STEP = "Verifying";
    private static final String ADD_STEP = "Adding";
    private boolean isBridgeConfiguration;
    private boolean isBridgeClient;
    protected List<Region> allRegions = new ArrayList<Region>();
    private int regionNameCounter = 1;
    private RandomValues randomValues = new RandomValues();
    private boolean uniqueKeys = true;
    private boolean extraRegionsCreated = false;
    static Cache theCache = null;
    private AtomicInteger compactionCoordinator = new AtomicInteger(0);
    private AtomicInteger verifyCoordinator = new AtomicInteger(0);
    private AtomicInteger startingCoordinator = new AtomicInteger(0);
    protected AtomicInteger readyForSnapshot = new AtomicInteger(0);
    private static HydraThreadLocal destroysCompleted = new HydraThreadLocal();
    private static HydraThreadLocal addsCompleted = new HydraThreadLocal();
    protected static HydraThreadLocal threadIsPaused = new HydraThreadLocal();
    private static final String persistentRegionKey = "VmContainsPersistentRegions_";
    private static final String startupStatsForVmKey = "startupStatsForVM_";
    private static final String localInitializationsKey = "localInitializationsForRegion_";
    private static final String remoteInitializationsKey = "remoteInitializationsForRegion_";
    private static final String vmMarkerKey = "markerForVM_";
    private static final String expectDiskRecoveryKey = "expectDiskRecoveryInVM_";
    private static final String allRegionNamesKey = "allRegions";
    private static final String allRegionsSnapshotKey = "allRegionsSnapshot";
    private static final String uniqueKeyIndex = "uniqueKeyIndexForThread_";
    private static final String recoveryCanBeTieKey = "recoveryCanBeTie";
    public static final String oldVersionXmlKey = "oldVersionXmlFile";
    public static final String newVersionXmlKey = "newVersionXmlFile";
    private static final String useXmlKey = "createRegionsWithXml";
    private static final String oldVersionXmlFilesKey = "oldVersionXmlFiles";
    private static final String newVersionXmlFilesKey = "newVersionXmlFiles";
    private static final String singleConvertedVmIdKey = "singleConvertedVmId";
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int ENTRY_PUTALL_OPERATION = 9;
    protected static final int CACHE_OPERATIONS = 10;
    protected static final int PUTS_FOR_KEY_ORDER_POLICY = 11;
    protected static final int CLEAR_REGION = 12;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";

    public static synchronized void HydraTask_createLocator() throws Throwable {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void HydraTask_startLocatorAndDS() throws Throwable {
        DistributedSystemHelper.startLocatorAndDS();
    }

    public static synchronized void HydraTask_initializeClient() throws Throwable {
        if (testInstance == null) {
            testInstance = new RecoveryTest();
            testInstance.initializeInstance();
            theCache = CacheHelper.createCache("cache1");
            Vector regionConfigNames = RecoveryPrms.getRegionConfigNames();
            testInstance.createRegionHier(regionConfigNames, null);
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
            if (RecoveryTest.testInstance.isBridgeConfiguration) {
                RecoveryTest.testInstance.isBridgeClient = true;
                boolean registerInterest = RecoveryPrms.getRegisterInterest();
                if (registerInterest) {
                    RecoveryTest.registerInterest();
                }
            }
        }
        testInstance.initializeInstancePerThread();
    }

    public static synchronized void HydraTask_initialize() throws Throwable {
        RecoveryTestVersionHelper.initPdxClassLoader();
        if (testInstance == null) {
            testInstance = new RecoveryTest();
            testInstance.initializeInstance();
            theCache = CacheHelper.createCache("cache1");
            Vector regionConfigNames = RecoveryPrms.getRegionConfigNames();
            testInstance.createRegionHier(regionConfigNames, null);
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
            if (RecoveryTest.testInstance.isBridgeConfiguration) {
                RecoveryTest.testInstance.isBridgeClient = false;
                BridgeHelper.startBridgeServer("bridge");
            }
        }
        testInstance.initializeInstancePerThread();
    }

    public static synchronized void HydraTask_initializeController() {
        if (testInstance == null) {
            testInstance = new RecoveryTest();
            testInstance.initializeInstance();
            RecoveryBB.getBB().getSharedMap().put("firstKeyIndex", new Long(1L));
            RecoveryBB.getBB().getSharedMap().put("lastKeyIndex", new Long(RecoveryPrms.getMaxNumEntriesPerRegion()));
            RecoveryBB.getBB().getSharedMap().put("taskStep", STARTING_STEP);
        }
    }

    public static synchronized void HydraTask_multiRegionInitialize() throws Throwable {
        if (testInstance == null) {
            testInstance = new RecoveryTest();
            testInstance.initializeInstance();
            String xmlFileName = RecoveryTest.getExistingXmlFile();
            RecoveryBB.getBB().getSharedMap().replace(useXmlKey, null, RecoveryPrms.getCreateRegionsWithXml());
            Boolean useXml = (Boolean)RecoveryBB.getBB().getSharedMap().get(useXmlKey);
            if (useXml.booleanValue() && xmlFileName != null) {
                if (!RecoveryPrms.getConvertWithNewVersionXml()) {
                    List oldVersionXmlFiles = (List)RecoveryBB.getBB().getSharedMap().get(oldVersionXmlFilesKey);
                    List newVersionXmlFiles = (List)RecoveryBB.getBB().getSharedMap().get(newVersionXmlFilesKey);
                    if (newVersionXmlFiles != null) {
                        int myVmId = RemoteTestModule.getMyVmid();
                        for (int i = 0; i < newVersionXmlFiles.size(); ++i) {
                            String currXmlFileName = (String)newVersionXmlFiles.get(i);
                            if (!currXmlFileName.startsWith("vm_" + myVmId + "_")) continue;
                            xmlFileName = (String)oldVersionXmlFiles.get(i);
                            break;
                        }
                    }
                }
                Log.getLogWriter().info("Creating regions from " + xmlFileName);
                theCache = CacheHelper.createCacheFromXml(xmlFileName);
                RecoveryTest.testInstance.allRegions = new ArrayList<Region>();
                RecoveryTest.testInstance.allRegions.addAll(CacheHelper.getCache().rootRegions());
                for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                    RecoveryTest.testInstance.allRegions.addAll(aRegion.subregions(true));
                }
            } else {
                theCache = CacheHelper.createCache("cache1");
                HydraVector regionConfigNames = TestConfig.tab().vecAt(RegionPrms.names);
                HydraVector diskStoreNames = TestConfig.tab().vecAt(DiskStorePrms.names);
                testInstance.createRegionHier(regionConfigNames, diskStoreNames);
                if (RecoveryTest.testInstance.allRegions.size() < regionConfigNames.size()) {
                    throw new TestException("Test configuration problem; test did not create enough regions to create all regions specified in RegionPrms.names; number of regions specified in RegionPrms.names: " + regionConfigNames.size() + ", number of regions created: " + RecoveryTest.testInstance.allRegions.size());
                }
            }
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        }
        testInstance.initializeInstancePerThread();
    }

    public static void HydraTask_createXmlFile() {
        RecoveryTestVersionHelper.createXmlFile();
    }

    private static String getExistingXmlFile() {
        String[] dirContents;
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        int myVmID = RemoteTestModule.getMyVmid();
        for (String fileName : dirContents = currDir.list()) {
            if (!fileName.startsWith("vm_" + myVmID + "_") && !fileName.startsWith("vm_" + myVmID + ".") || !fileName.endsWith(".xml")) continue;
            return fileName;
        }
        return null;
    }

    private void initializeInstance() {
        this.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
        RecoveryTestVersionHelper.installPersistenceObserver();
        this.uniqueKeys = RecoveryPrms.getUseUniqueKeys();
        RecoveryBB.getBB().getSharedMap().put("shutDownAllKey", new Boolean(false));
        RecoveryTestVersionHelper.installPRObserver();
        if (RecoveryPrms.getRegisterSerializer()) {
            Log.getLogWriter().info("Registering " + VHDataSerializer.class.getName());
            DataSerializer.register(VHDataSerializer.class);
        }
        if (RecoveryPrms.setIgnorePreallocate()) {
            Log.getLogWriter().info("workaround for #50184, setting DiskStoreImpl.SET_IGNORE_PREALLOCATE = true");
            DiskStoreImpl.SET_IGNORE_PREALLOCATE = true;
        }
    }

    private void initializeInstancePerThread() {
        destroysCompleted.set(new Boolean(false));
        addsCompleted.set(new Boolean(false));
        threadIsPaused.set(new Boolean(false));
        int thisThreadID = RemoteTestModule.getCurrentThread().getThreadId();
        String mapKey = uniqueKeyIndex + thisThreadID;
        Object mapValue = RecoveryBB.getBB().getSharedMap().get(mapKey);
        if (mapValue == null) {
            RecoveryBB.getBB().getSharedMap().put(mapKey, thisThreadID);
        } else {
            RecoveryBB.getBB().getSharedMap().put(mapKey, mapValue);
        }
    }

    public static void HydraTask_load() {
        int maxNumEntriesPerRegion = RecoveryPrms.getMaxNumEntriesPerRegion();
        boolean allAddsCompleted = testInstance.addToRegions(maxNumEntriesPerRegion);
        if (allAddsCompleted) {
            throw new StopSchedulingTaskOnClientOrder("Put " + maxNumEntriesPerRegion + " entries in each of " + RecoveryTest.testInstance.allRegions.size() + " regions");
        }
    }

    public static void HydraTask_compactionController() {
        testInstance.compactionController();
    }

    public static void HydraTask_compactionResponder() {
        testInstance.compactionResponder();
    }

    public static void HydraTask_latestRecoveryTest() throws ClientVmNotFoundException, InterruptedException {
        RecoveryTest.latestRecoveryTest();
    }

    public static void HydraTask_recordStartupState() {
        TreeMap<String, Integer> statsMap = new TreeMap<String, Integer>();
        for (Region aRegion : RecoveryTest.testInstance.allRegions) {
            DiskRegionStats diskStats = ((LocalRegion)aRegion).getDiskRegion().getStats();
            String regionName = aRegion.getFullPath();
            statsMap.put(localInitializationsKey + regionName, diskStats.getLocalInitializations());
            statsMap.put(remoteInitializationsKey + regionName, diskStats.getRemoteInitializations());
        }
        String key = startupStatsForVmKey + RemoteTestModule.getMyVmid();
        RecoveryBB.getBB().getSharedMap().put(key, statsMap);
        Log.getLogWriter().info("Wrote to blackboard key " + key + ": " + statsMap);
    }

    public static void HydraTask_verifyRegions() {
        testInstance.verifyRegions();
    }

    public static void HydraTask_verifyStartupState() {
        RecoveryTest.verifyStartupState();
    }

    public static void HydraTask_markVmInBlackboard() {
        RecoveryBB.getBB().getSharedMap().put(vmMarkerKey + RemoteTestModule.getMyVmid(), RecoveryPrms.getVmMarker());
    }

    public static void HydraTask_verifyEmptyRegions() {
        for (Region aRegion : RecoveryTest.testInstance.allRegions) {
            if (aRegion.size() == 0) continue;
            throw new TestException("Expected " + aRegion.getFullPath() + " to be empty, but its size is " + aRegion.size());
        }
    }

    public static void HydraTask_concRecoverLatestController() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        RecoveryTest.recoverLatestController();
    }

    public static void HydraTask_concRecoverLatestResponder() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        testInstance.concRecoverLatestResponder();
    }

    public static void HydraTask_verifyFromSnapshot() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        testInstance.verifyFromSnapshot();
    }

    public static void HydraTask_writeSnapshot() {
        testInstance.writeSnapshot();
    }

    public static void HydraTask_verifyFromSnapshotAndSync() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        testInstance.verifyFromSnapshot();
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads(), true, -1L, 2000L);
    }

    public static void HydraTask_convertVerifyFromSnapshotAndSync() {
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L && RecoveryPrms.getConvertWithNewVersionXml()) {
            List[] aList = RecoveryTest.extractFromXmlFile(RecoveryTest.getXmlFileName(RemoteTestModule.getMyVmid()));
            List regionNames = aList[0];
            Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
            for (int i = 0; i < regionNames.size(); ++i) {
                String rName = (String)regionNames.get(i);
                if (!rName.startsWith("/extra") || allRegionsSnapshot.containsKey(rName)) continue;
                Log.getLogWriter().info("Adding region " + rName + " to snapshot");
                allRegionsSnapshot.put(rName, new HashMap());
            }
            RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        }
        testInstance.verifyFromSnapshot();
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads(), true, -1L, 2000L);
        RecoveryTest.HydraTask_prepareForNewVersionOps();
    }

    public static void HydraTask_convertVerifyFromSnapshot() {
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L && RecoveryPrms.getConvertWithNewVersionXml()) {
            List[] aList = RecoveryTest.extractFromXmlFile(RecoveryTest.getXmlFileName(RemoteTestModule.getMyVmid()));
            List regionNames = aList[0];
            Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
            for (int i = 0; i < regionNames.size(); ++i) {
                String rName = (String)regionNames.get(i);
                if (!rName.startsWith("/extra") || allRegionsSnapshot.containsKey(rName)) continue;
                Log.getLogWriter().info("Adding region " + rName + " to snapshot");
                allRegionsSnapshot.put(rName, new HashMap());
            }
            RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        }
        MasterController.sleepForMs(15000);
        SummaryLogListener.waitForSilence(30L, 2000L);
        testInstance.verifyFromSnapshot();
        RecoveryTest.HydraTask_prepareForNewVersionOps();
    }

    public static void HydraTask_concRecoverAllController() {
        RecoveryTest.concRecoverAllController();
    }

    public static void HydraTask_verifyFromLeaderSnapshot() {
        RecoveryTestVersionHelper.initPdxClassLoader();
        testInstance.verifyFromLeaderSnapshot();
    }

    public static void HydraTask_doOperations() throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doOperations(minTaskGranularityMS);
    }

    public static void HydraTask_doOperationsWithPause() throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doOperations(minTaskGranularityMS);
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.pausing) > 0L) {
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
            String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
            HydraThreadGroup tg = TestConfig.getInstance().getThreadGroup(tgname);
            int threadCount = tg.getTotalThreads();
            int desiredCounterValue = threadCount + 1;
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.pausing", RecoveryBB.pausing, desiredCounterValue, true, -1L, 2000L);
            long leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader);
            if (leader == 1L) {
                testInstance.writeSnapshot();
                String stopMode = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                if (stopMode.equalsIgnoreCase("shutDownAll")) {
                    AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
                    StopStartVMs.shutDownAllMembers(adminDS);
                }
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
            }
            throw new StopSchedulingTaskOnClientOrder("All vms have paused");
        }
    }

    public static void HydraTask_doOperationsShutDownAll() throws Exception {
        RecoveryTestVersionHelper.doOperationsShutDownAll(testInstance);
    }

    public static void HydraTask_doOperationsHA() throws Exception {
        RecoveryTestVersionHelper.initPdxClassLoader();
        RecoveryTestVersionHelper.doOperationsHA(testInstance);
    }

    public static void HydraTask_backupController() {
        new RecoveryTest().backupController();
    }

    public static void HydraTask_backupResponder() throws Exception {
        testInstance.backupResponder();
    }

    public static void HydraTask_doRecovery() {
        RecoveryTest.logExecutionNumber();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        List<ClientVmInfo> targetVMs = new ArrayList();
        if (RecoveryPrms.getUseShutDownAll()) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            if (adminDS == null) {
                throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
            }
            Object[] anArr = StopStartVMs.shutDownAllMembers(adminDS);
            targetVMs = (List)anArr[0];
        } else {
            Vector vmIDs = ClientVmMgr.getOtherClientVmids();
            ArrayList<String> stopModesList = new ArrayList<String>();
            for (Object vmID : vmIDs) {
                targetVMs.add(new ClientVmInfo((Integer)vmID));
                stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            }
            StopStartVMs.stopVMs(targetVMs, stopModesList);
        }
        PRObserver.initialize();
        StopStartVMs.startVMs(targetVMs);
    }

    public static void HydraTask_operationsController() {
        new RecoveryTest().operationsController();
    }

    public static void HydraTask_operationsResponder() throws Exception {
        testInstance.operationsResponder();
    }

    public static void HydraTask_snapshotController() {
        new RecoveryTest().snapshotController();
    }

    public static void HydraTask_snapshotResponder() throws Exception {
        RecoveryTestVersionHelper.snapshotResponder(testInstance);
    }

    public static void HydraTask_diskConvOperationsController() {
        new RecoveryTest().diskConvOperationsController();
    }

    public static void HydraTask_diskConvOperationsResponder() throws Exception {
        String clientName;
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) <= 1L && (clientName = System.getProperty("clientName")).indexOf("newVersion") >= 0) {
            Log.getLogWriter().info("Sleeping for 10 seconds...");
            MasterController.sleepForMs(10000);
            return;
        }
        testInstance.operationsResponder();
    }

    public static void HydraTask_recoverAfterGiiTest() throws Exception {
        RecoveryTestVersionHelper.initPdxClassLoader();
        testInstance.recoverAfterGiiTest();
    }

    public static void HydraTask_logRegions() {
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
    }

    public static synchronized void HydraTask_createExtraRegions() {
        if (!RecoveryTest.testInstance.extraRegionsCreated) {
            int NUM_EXTRA_REGIONS = 20;
            int regionNameIndex = 1;
            if (System.getProperty("clientName").indexOf("newVersion") >= 0) {
                regionNameIndex = 21;
            }
            HydraVector aVec = TestConfig.tab().vecAt(RegionPrms.names);
            for (int i = 1; i <= 20; ++i) {
                String regionConfigName = (String)aVec.get(i % aVec.size());
                String regionName = "extra_Region_" + regionNameIndex++;
                AttributesFactory factory = RecoveryTestVersionHelper.setDiskStoreIfNeeded(regionConfigName);
                RecoveryTest.testInstance.allRegions.add(RegionHelper.createRegion(regionName, factory));
            }
            RecoveryTest.testInstance.extraRegionsCreated = true;
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
        }
    }

    public static synchronized void HydraTask_createRegions() {
        if (testInstance == null) {
            testInstance = new RecoveryTest();
            testInstance.initializeInstance();
            int myVmId = RemoteTestModule.getMyVmid();
            String xmlFileName = RecoveryTest.getXmlFileName(myVmId);
            File xmlFile = new File(xmlFileName);
            boolean postConvert = xmlFile.exists();
            if (postConvert) {
                if (!RecoveryPrms.getConvertWithNewVersionXml()) {
                    List oldVersionXmlFiles = (List)RecoveryBB.getBB().getSharedMap().get(oldVersionXmlFilesKey);
                    List newVersionXmlFiles = (List)RecoveryBB.getBB().getSharedMap().get(newVersionXmlFilesKey);
                    for (int i = 0; i < newVersionXmlFiles.size(); ++i) {
                        String currXmlFileName = (String)newVersionXmlFiles.get(i);
                        if (!currXmlFileName.startsWith("vm_" + myVmId + "_")) continue;
                        xmlFileName = (String)oldVersionXmlFiles.get(i);
                        break;
                    }
                }
                Log.getLogWriter().info("Creating cache with xml " + xmlFileName);
                theCache = CacheHelper.createCacheFromXml(xmlFileName);
            } else {
                theCache = CacheHelper.createCache("cache1");
                CacheHelper.getCache().getCacheTransactionManager().addListener((TransactionListener)new ConverterTxListener());
                RecoveryTest.testInstance.isBridgeClient = RecoveryTest.testInstance.isBridgeConfiguration && RecoveryPrms.getRegisterInterest();
                HydraVector aVec = TestConfig.tab().vecAt(RegionPrms.names);
                for (int i = 0; i < aVec.size(); ++i) {
                    String regionConfigName = (String)aVec.get(i);
                    if (regionConfigName.equals("edgeClientRegion")) continue;
                    String configToUse = regionConfigName;
                    if (RecoveryTest.testInstance.isBridgeClient) {
                        configToUse = "edgeClientRegion";
                    }
                    RegionHelper.createRegion("Region_" + (i + 1), configToUse);
                }
            }
            Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
            RecoveryTest.testInstance.allRegions = new ArrayList<Region>();
            RecoveryTest.testInstance.allRegions.addAll(CacheHelper.getCache().rootRegions());
            for (Region aRegion : CacheHelper.getCache().rootRegions()) {
                RecoveryTest.testInstance.allRegions.addAll(aRegion.subregions(true));
            }
            if (RecoveryTest.testInstance.isBridgeConfiguration) {
                if (RecoveryTest.testInstance.isBridgeClient) {
                    RecoveryTest.registerInterest();
                }
                if (RecoveryPrms.getStartBridgeServer()) {
                    BridgeHelper.startBridgeServer("bridge");
                }
            }
        }
        testInstance.initializeInstancePerThread();
    }

    public static void HydraTask_createGatewayHub() {
        String hubConfigName = RecoveryPrms.getHubConfigName();
        Log.getLogWriter().info("Creating gateway hub with hub config: " + hubConfigName);
        GatewayHubHelper.createGatewayHub(hubConfigName);
    }

    public static void HydraTask_addGatewayHub() {
        String gatewayConfigName = RecoveryPrms.getGatewayConfigName();
        Log.getLogWriter().info("Adding gateway with gateway config: " + gatewayConfigName);
        GatewayHubHelper.addGateways(gatewayConfigName);
    }

    public static void HydraTask_startGatewayHub() {
        Log.getLogWriter().info("Starting gateway hub");
        GatewayHubHelper.startGatewayHub();
    }

    public static synchronized void HydraTask_createRegionsConvertedFirst() {
        if (testInstance == null) {
            Integer convertedVmId = (Integer)RecoveryBB.getBB().getSharedMap().get(singleConvertedVmIdKey);
            int myVmId = RemoteTestModule.getMyVmid();
            if (convertedVmId == myVmId) {
                RecoveryTest.HydraTask_createRegions();
                RecoveryBB.getBB().getSharedMap().remove(singleConvertedVmIdKey);
            } else {
                while (convertedVmId != null) {
                    MasterController.sleepForMs(5000);
                    convertedVmId = (Integer)RecoveryBB.getBB().getSharedMap().get(singleConvertedVmIdKey);
                    if (convertedVmId != null) continue;
                    RecoveryTest.HydraTask_createRegions();
                }
            }
        }
        testInstance.initializeInstancePerThread();
    }

    public static void HydraTask_writeToBB() {
        if (RecoveryPrms.getConvertWithNewVersionXml()) {
            testInstance.removeExtraRegionsFromAllRegions();
        }
        testInstance.writeSnapshot();
    }

    public static void HydraTask_disconnect() {
        DistributedSystemHelper.disconnect();
        testInstance = null;
        RecoveryTestVersionHelper.initPRObserver();
    }

    public static void HydraTask_stopGatewayHub() {
        GatewayHubHelper.stopGatewayHub();
        GatewayHubBlackboard.getInstance().getSharedMap().clear();
        DistributedSystemBlackboard.getInstance().getSharedMap().clear();
    }

    public static void HydraTask_doSingleConvert() {
        long leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader);
        if (leader == 1L) {
            int convertedIndex = RecoveryTest.doSingleConvert(true);
            List newVersionXmlFileList = (List)RecoveryBB.getBB().getSharedMap().get(newVersionXmlFilesKey);
            String newVersionXmlFile = (String)newVersionXmlFileList.get(convertedIndex);
            int vmId = RecoveryTest.getVmIdFromXmlFileName(newVersionXmlFile);
            RecoveryBB.getBB().getSharedMap().put(singleConvertedVmIdKey, vmId);
        }
    }

    public static void HydraTask_verifyPRs() {
        StringBuffer aStr = new StringBuffer();
        for (Region aRegion : RecoveryTest.testInstance.allRegions) {
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            int redundantCopies = aRegion.getAttributes().getPartitionAttributes().getRedundantCopies();
            Log.getLogWriter().info("Verifying PR " + aRegion.getFullPath() + " with " + redundantCopies + " redundantCopies");
            try {
                ParRegUtil.verifyPRMetaData(aRegion);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            try {
                ParRegUtil.verifyPrimaries(aRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            try {
                ParRegUtil.verifyBucketCopies(aRegion, redundantCopies);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            catch (TestException e) {
                aStr.append(e.toString() + "\n");
            }
            if (aStr.length() > 0) {
                throw new TestException(aStr.toString());
            }
            Log.getLogWriter().info("Done verifying PR internal consistency for " + aRegion.getFullPath());
        }
    }

    public static void HydraTask_waitForMyStartupRecovery() {
        int numPRs = 0;
        ArrayList<String> prNameList = new ArrayList<String>();
        int myVmID = RemoteTestModule.getMyVmid();
        for (Region aRegion : RecoveryTest.testInstance.allRegions) {
            PartitionAttributes prAttr;
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning() || (prAttr = aRegion.getAttributes().getPartitionAttributes()).getStartupRecoveryDelay() < 0L || prAttr.getRedundantCopies() == 0) continue;
            ++numPRs;
            prNameList.add(aRegion.getFullPath());
        }
        if (numPRs > 0) {
            PRObserver.waitForRebalRecov(myVmID, 1, numPRs, prNameList, null, false);
        }
    }

    public static void HydraTask_convertPre65Controller() {
        List newVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        newVersionVMs.removeAll(StopStartVMs.getMatchVMs(newVersionVMs, "newVersionLocator"));
        ArrayList<String> stopModesList = new ArrayList<String>();
        for (int i = 1; i <= newVersionVMs.size(); ++i) {
            stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        StopStartVMs.stopVMs(newVersionVMs, stopModesList);
        int sleepMs = 60000;
        Log.getLogWriter().info("Sleeping " + sleepMs + "ms so ops can run...");
        MasterController.sleepForMs(sleepMs);
        List oldVersionVMs = StopStartVMs.getAllVMs();
        oldVersionVMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion");
        for (ClientVmInfo target : oldVersionVMs) {
            try {
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, target);
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        int convertedIndex = RecoveryTest.doSingleConvert(true);
        List newVersionXmlFileList = (List)RecoveryBB.getBB().getSharedMap().get(newVersionXmlFilesKey);
        String newVersionXmlFile = (String)newVersionXmlFileList.get(convertedIndex);
        int vmId = RecoveryTest.getVmIdFromXmlFileName(newVersionXmlFile);
        int startFirstIndex = -1;
        for (int i = 0; i < newVersionVMs.size(); ++i) {
            if (((ClientVmInfo)newVersionVMs.get(i)).getVmid() != vmId) continue;
            startFirstIndex = i;
            break;
        }
        ArrayList startFirstList = new ArrayList();
        startFirstList.add(newVersionVMs.get(startFirstIndex));
        List startThread = StopStartVMs.startAsync(startFirstList);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        newVersionVMs.remove(startFirstIndex);
        StopStartVMs.startVMs(newVersionVMs);
        for (Thread aThread : startThread) {
            try {
                aThread.join();
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_upgradeController() {
        String[] dirContents;
        List newVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        newVersionVMs.removeAll(StopStartVMs.getMatchVMs(newVersionVMs, "newVersionLocator"));
        ArrayList<String> stopModesList = new ArrayList<String>();
        for (int i = 1; i <= newVersionVMs.size(); ++i) {
            stopModesList.add("nice_exit");
        }
        StopStartVMs.stopVMs(newVersionVMs, stopModesList);
        int myVmId = RemoteTestModule.getMyVmid();
        ArrayList<String> oldXmlFiles = new ArrayList<String>();
        ArrayList<String> newXmlFiles = new ArrayList<String>();
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (String fileName : dirContents = currDir.list()) {
            if (!fileName.endsWith(".xml")) continue;
            if (fileName.indexOf("oldVersion") >= 0) {
                oldXmlFiles.add(fileName);
                continue;
            }
            if (fileName.indexOf("newVersion") < 0) continue;
            newXmlFiles.add(fileName);
        }
        RecoveryBB.getBB().getSharedMap().put(oldVersionXmlFilesKey, oldXmlFiles);
        RecoveryBB.getBB().getSharedMap().put(newVersionXmlFilesKey, newXmlFiles);
        int sleepMs = 60000;
        Log.getLogWriter().info("Sleeping " + sleepMs + "ms so ops can run...");
        MasterController.sleepForMs(sleepMs);
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        String stopMode = TestConfig.tab().stringAt(StopStartPrms.stopModes);
        if (!stopMode.equalsIgnoreCase("shutDownAll")) {
            List oldVersionVMs = StopStartVMs.getAllVMs();
            oldVersionVMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion");
            ArrayList<String> stopModes = new ArrayList<String>();
            for (int i = 0; i < oldVersionVMs.size(); ++i) {
                stopModes.add(stopMode);
            }
            StopStartVMs.stopVMs(oldVersionVMs, stopModes);
        }
        StopStartVMs.startVMs(newVersionVMs);
    }

    public static void HydraTask_resetUniqueKeyIndex() {
        RecoveryTest.HydraTask_prepareForNewVersionOps();
    }

    public static void HydraTask_prepareForNewVersionOps() {
        int myThreadId;
        long max = NameBB.getBB().getSharedCounters().read(NameBB.POSITIVE_NAME_COUNTER);
        int incValue = TestHelper.getNumThreads();
        int myKeyIndexValue = myThreadId = RemoteTestModule.getCurrentThread().getThreadId();
        while ((long)myKeyIndexValue < max) {
            myKeyIndexValue += incValue;
        }
        Log.getLogWriter().info("Setting this threads uniqueKeyIndex to " + myKeyIndexValue);
        RecoveryBB.getBB().getSharedMap().put(uniqueKeyIndex + myThreadId, myKeyIndexValue);
    }

    public static void HydraTask_convertWANTestController() {
        RecoveryTest.logExecutionNumber();
        List newVersionVMs = StopStartVMs.getAllVMs();
        List oldVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        oldVersionVMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion");
        List newLocators = StopStartVMs.getMatchVMs(newVersionVMs, "newVersionLocator");
        for (ClientVmInfo info : newLocators) {
            if (info.getVmid() != RemoteTestModule.getMyVmid()) continue;
            newLocators.remove(info);
            break;
        }
        List oldLocators = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersionLocator");
        List newWanSite1VMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_1_");
        List newWanSite2VMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_2_");
        List newWanSite3VMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_3_");
        List oldWanSite1VMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion_1_");
        List oldWanSite2VMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion_2_");
        List oldWanSite3VMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion_3_");
        Log.getLogWriter().info("newVersionVMs: " + newVersionVMs);
        Log.getLogWriter().info("oldVersionVMs: " + oldVersionVMs);
        Log.getLogWriter().info("newWanSite1VMs: " + newWanSite1VMs);
        Log.getLogWriter().info("newWanSite2VMs: " + newWanSite2VMs);
        Log.getLogWriter().info("newWanSite3VMs: " + newWanSite3VMs);
        Log.getLogWriter().info("oldWanSite1VMs: " + oldWanSite1VMs);
        Log.getLogWriter().info("oldWanSite2VMs: " + oldWanSite2VMs);
        Log.getLogWriter().info("oldWanSite3VMs: " + oldWanSite3VMs);
        ArrayList<String> stopModesList = new ArrayList<String>();
        List targetVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_");
        for (int i = 1; i <= targetVMs.size(); ++i) {
            stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        StopStartVMs.stopVMs(targetVMs, stopModesList);
        StopStartVMs.stopVMs(newLocators, stopModesList);
        int sleepMs = 60000;
        Log.getLogWriter().info("Sleeping " + sleepMs + "ms so ops can run...");
        MasterController.sleepForMs(sleepMs);
        try {
            for (int i = 1; i < oldWanSite1VMs.size(); ++i) {
                Log.getLogWriter().info("Stopping: " + oldWanSite1VMs.get(i));
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite1VMs.get(i));
                Log.getLogWriter().info("Stopping: " + oldWanSite2VMs.get(i));
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite2VMs.get(i));
                Log.getLogWriter().info("Stopping: " + oldWanSite3VMs.get(i));
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite3VMs.get(i));
            }
            Log.getLogWriter().info("Stopping: " + oldWanSite2VMs.get(0));
            ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite2VMs.get(0));
            Log.getLogWriter().info("Stopping: " + oldWanSite3VMs.get(0));
            ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite3VMs.get(0));
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 1000L);
        try {
            Log.getLogWriter().info("Stopping: " + oldWanSite1VMs.get(0));
            ClientVmMgr.stop("Stopping old version vm", -21, -31, (ClientVmInfo)oldWanSite1VMs.get(0));
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Stopping the old version locator(s)");
        for (ClientVmInfo info : oldLocators) {
            try {
                ClientVmMgr.stop("Stopping old version locator", -21, -31, info);
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        RecoveryTest.convertPre65AndValidate(RecoveryTest.getXmlFileName(((ClientVmInfo)oldWanSite1VMs.get(0)).getVmid()), RecoveryTest.getXmlFileName(((ClientVmInfo)newWanSite1VMs.get(0)).getVmid()));
        RecoveryTest.convertPre65AndValidate(RecoveryTest.getXmlFileName(((ClientVmInfo)oldWanSite2VMs.get(0)).getVmid()), RecoveryTest.getXmlFileName(((ClientVmInfo)newWanSite2VMs.get(0)).getVmid()));
        RecoveryTest.convertPre65AndValidate(RecoveryTest.getXmlFileName(((ClientVmInfo)oldWanSite3VMs.get(0)).getVmid()), RecoveryTest.getXmlFileName(((ClientVmInfo)newWanSite3VMs.get(0)).getVmid()));
        GatewayHubBlackboard.getInstance().getSharedMap().clear();
        DistributedSystemBlackboard.getInstance().getSharedMap().clear();
        StopStartVMs.startVMs(newLocators);
        try {
            Log.getLogWriter().info("Starting: " + newWanSite1VMs.get(0));
            ClientVmMgr.start("Starting after conversion", (ClientVmInfo)newWanSite1VMs.get(0));
            Log.getLogWriter().info("Starting: " + newWanSite2VMs.get(0));
            ClientVmMgr.start("Starting after conversion", (ClientVmInfo)newWanSite2VMs.get(0));
            Log.getLogWriter().info("Starting: " + newWanSite3VMs.get(0));
            ClientVmMgr.start("Starting after conversion", (ClientVmInfo)newWanSite3VMs.get(0));
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_convertWANTestResponder() throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doOperations(minTaskGranularityMS);
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.pausing) > 0L) {
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.Pausing", RecoveryBB.pausing, 11L, true, -1L, 1000L);
            long leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader);
            if (leader == 1L) {
                RecoveryTest.HydraTask_writeToBB();
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
            }
            MasterController.sleepForMs(Integer.MAX_VALUE);
        }
    }

    public static void HydraTask_restoreBackups() throws Exception {
        int numVMs = TestHelper.getNumVMs();
        long counter = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.verifyBackups);
        if (counter == 1L) {
            File[] contents;
            Log.getLogWriter().info("This thread is the restore leader");
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.backupRestored);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.Reinitialized);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.FinishedVerify);
            ArrayList<File> backupDirList = new ArrayList<File>();
            String currDirName = System.getProperty("user.dir");
            File currDir = new File(currDirName);
            for (File aDir : contents = currDir.listFiles()) {
                if (!aDir.getName().startsWith("backup_")) continue;
                backupDirList.add(aDir);
            }
            Log.getLogWriter().info("Backup dir list is " + backupDirList);
            Log.getLogWriter().info("Restoring backups, expect to fail because disk dirs already exist");
            for (File backupDir : backupDirList) {
                RecoveryTest.runRestoreScript(backupDir, false);
            }
            Log.getLogWriter().info("Done restoring failed backups");
            for (int i = 0; i < backupDirList.size(); ++i) {
                File backupDir = (File)backupDirList.get(i);
                String backupDirName = backupDir.getName();
                long backupNum = Long.valueOf(backupDirName.substring(backupDirName.indexOf("_") + 1, backupDirName.length()));
                RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.onlineBackupNumber);
                RecoveryBB.getBB().getSharedCounters().setIfLarger(RecoveryBB.onlineBackupNumber, backupNum);
                PRObserver.initialize();
                Log.getLogWriter().info("Backup number is " + backupNum);
                Log.getLogWriter().info("Restoring from " + backupDir.getName());
                RecoveryTest.deleteExistingDiskDirs();
                RecoveryTest.runRestoreScript(backupDir, true);
                Log.getLogWriter().info("Done restoring from " + backupDir.getName());
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.backupRestored);
                Log.getLogWriter().info("Initializing...");
                try {
                    RecoveryTest.HydraTask_multiRegionInitialize();
                }
                catch (Throwable throwable) {
                    throw new TestException("Exception during restore backups: ", throwable);
                }
                Log.getLogWriter().info("Done initializing");
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.Reinitialized", RecoveryBB.Reinitialized, numVMs - 2, true, -1L);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.Reinitialized);
                RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.ReadyToBegin);
                testInstance.validateAfterRestore(backupNum);
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.FinishedVerify", RecoveryBB.FinishedVerify, numVMs - 2, true, -1L);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.FinishedVerify);
                Log.getLogWriter().info("Preparing for next restore...");
                RecoveryTest.HydraTask_disconnect();
                RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.backupRestored);
                RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.Reinitialized);
                if (i == backupDirList.size() - 1) {
                    RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.backupsDone);
                }
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.ReadyToBegin", RecoveryBB.ReadyToBegin, numVMs - 2, true, -1L);
                RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.FinishedVerify);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.ReadyToBegin);
            }
        } else {
            do {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.backupRestored", RecoveryBB.backupRestored, 1L, true, -1L);
                Log.getLogWriter().info("Initializing...");
                try {
                    RecoveryTest.HydraTask_multiRegionInitialize();
                }
                catch (Throwable throwable) {
                    throw new TestException("Exception during restore backups: ", throwable);
                }
                Log.getLogWriter().info("Done initializing");
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.Reinitialized);
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.Reinitialized", RecoveryBB.Reinitialized, numVMs - 1, true, -1L);
                long backupNumber = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.onlineBackupNumber);
                testInstance.validateAfterRestore(backupNumber);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.FinishedVerify);
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.FinishedVerify", RecoveryBB.FinishedVerify, numVMs - 1, true, -1L);
                Log.getLogWriter().info("Preparing for next restore...");
                RecoveryTest.HydraTask_disconnect();
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.ReadyToBegin);
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.ReadyToBegin", RecoveryBB.ReadyToBegin, numVMs - 1, true, -1L);
            } while (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.backupsDone) <= 0L);
            Log.getLogWriter().info("All backups have been restored");
        }
    }

    protected void validateAfterRestore(long backupNum) throws Exception {
        Map snapshot = null;
        ObjectInputStream ois = null;
        String snapFileName = "snapshotForBackup_" + backupNum + ".ser";
        try {
            ois = new ObjectInputStream(new FileInputStream(snapFileName));
            snapshot = (Map)ois.readObject();
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        finally {
            if (null != ois) {
                ois.close();
            }
        }
        RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, snapshot);
        this.verifyFromSnapshot();
    }

    private void compactionController() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        String currentTaskStep = (String)RecoveryBB.getBB().getSharedMap().get("taskStep");
        Log.getLogWriter().info("In compactionController, currentTaskStep is " + currentTaskStep);
        if (currentTaskStep.equals(STARTING_STEP)) {
            RecoveryTest.logExecutionNumber();
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneDestroyingCounter);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneCompactingCounter);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneStartingCounter", RecoveryBB.doneStartingCounter, TestHelper.getNumVMs() - 1, true, -1L, 1000L);
            NameBB.getBB().getSharedCounters().zero(NameBB.POSITIVE_NAME_COUNTER);
            long firstKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("firstKeyIndex");
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, firstKeyIndex - 1L);
            currentTaskStep = DESTROY_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            return;
        }
        if (currentTaskStep.equals(DESTROY_STEP)) {
            try {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneDestroyingCounter", RecoveryBB.doneDestroyingCounter, TestHelper.getNumThreads() - 1, false, minTaskGranularityMS, 5000L);
            }
            catch (TestException e) {
                return;
            }
            long firstKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("firstKeyIndex");
            RecoveryBB.getBB().getSharedMap().put("firstKeyIndex", firstKeyIndex += (long)RecoveryPrms.getChunkSize());
            currentTaskStep = COMPACTION_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            return;
        }
        if (currentTaskStep.equals(COMPACTION_STEP)) {
            try {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoverBB.doneCompactingCounter", RecoveryBB.doneCompactingCounter, TestHelper.getNumVMs() - 1, true, minTaskGranularityMS, 5000L);
            }
            catch (TestException e) {
                return;
            }
            currentTaskStep = STOP_START_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            return;
        }
        if (currentTaskStep.equals(STOP_START_STEP)) {
            Vector otherVmIds = ClientVmMgr.getOtherClientVmids();
            ArrayList<ClientVmInfo> otherVMs = new ArrayList<ClientVmInfo>();
            ArrayList<ClientVmInfo> replicateVMs = new ArrayList<ClientVmInfo>();
            ArrayList<ClientVmInfo> persistentVMs = new ArrayList<ClientVmInfo>();
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (int i = 0; i < otherVmIds.size(); ++i) {
                Integer otherVmId = (Integer)otherVmIds.get(i);
                ClientVmInfo info = new ClientVmInfo(otherVmId);
                otherVMs.add(info);
                if (RecoveryBB.getBB().getSharedMap().containsKey(persistentRegionKey + otherVmId)) {
                    persistentVMs.add(info);
                } else {
                    replicateVMs.add(info);
                }
                String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                stopModeList.add(choice);
            }
            StopStartVMs.stopVMs(otherVMs, stopModeList);
            StopStartVMs.startVMs(persistentVMs);
            StopStartVMs.startVMs(replicateVMs);
            currentTaskStep = VERIFY_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneStartingCounter);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneAddingCounter);
            return;
        }
        if (currentTaskStep.equals(VERIFY_STEP)) {
            try {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, TestHelper.getNumVMs() - 1, true, minTaskGranularityMS, 5000L);
            }
            catch (TestException e) {
                return;
            }
            long lastKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("lastKeyIndex");
            NameBB.getBB().getSharedCounters().zero(NameBB.POSITIVE_NAME_COUNTER);
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, lastKeyIndex);
            currentTaskStep = ADD_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            return;
        }
        if (currentTaskStep.equals(ADD_STEP)) {
            try {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneAddingCounter", RecoveryBB.doneAddingCounter, TestHelper.getNumThreads() - 1, true, minTaskGranularityMS, 10000L);
            }
            catch (TestException e) {
                return;
            }
            long lastKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("lastKeyIndex");
            RecoveryBB.getBB().getSharedMap().put("lastKeyIndex", lastKeyIndex += (long)RecoveryPrms.getChunkSize());
            currentTaskStep = STARTING_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            return;
        }
    }

    private void compactionResponder() {
        String currentTaskStep = (String)RecoveryBB.getBB().getSharedMap().get("taskStep");
        Log.getLogWriter().info("In compactionResponder, currentTaskStep is " + currentTaskStep);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        if (currentTaskStep.equals(STARTING_STEP)) {
            if (this.startingCoordinator.incrementAndGet() == 1) {
                Log.getLogWriter().info("Initializing for startup...");
                this.compactionCoordinator = new AtomicInteger(0);
                this.verifyCoordinator = new AtomicInteger(0);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneStartingCounter);
            } else {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneStartingCounter", RecoveryBB.doneStartingCounter, TestHelper.getNumVMs() - 1, true, -1L, 1000L);
            }
        } else if (currentTaskStep.equals(DESTROY_STEP)) {
            if (((Boolean)destroysCompleted.get()).booleanValue()) {
                try {
                    TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneDestroyingCounter", RecoveryBB.doneDestroyingCounter, TestHelper.getNumThreads() - 1, true, minTaskGranularityMS, 1000L);
                }
                catch (TestException e) {
                    return;
                }
            } else {
                long firstKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("firstKeyIndex");
                boolean allDestroysDone = this.doDestroyStep(firstKeyIndex + (long)RecoveryPrms.getChunkSize() - 1L);
                if (allDestroysDone) {
                    destroysCompleted.set(new Boolean(true));
                    RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneDestroyingCounter);
                }
            }
        } else if (currentTaskStep.equals(COMPACTION_STEP)) {
            this.startingCoordinator = new AtomicInteger(0);
            this.doCompactionStep();
        } else if (currentTaskStep.equals(STOP_START_STEP)) {
            MasterController.sleepForMs(5000);
        } else if (currentTaskStep.equals(VERIFY_STEP)) {
            this.doVerificationStep();
        } else if (currentTaskStep.equals(ADD_STEP)) {
            if (((Boolean)addsCompleted.get()).booleanValue()) {
                try {
                    TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneAddingCounter", RecoveryBB.doneAddingCounter, TestHelper.getNumThreads() - 1, true, minTaskGranularityMS, 1000L);
                }
                catch (TestException e) {
                    return;
                }
            } else {
                long lastKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("lastKeyIndex");
                boolean allAddsCompleted = this.addToRegions(lastKeyIndex + (long)RecoveryPrms.getChunkSize());
                if (allAddsCompleted) {
                    addsCompleted.set(new Boolean(true));
                    RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneAddingCounter);
                }
            }
        }
    }

    private boolean doDestroyStep(long lastKeyIndexToDestroy) {
        int chunkSize = RecoveryPrms.getChunkSize();
        Log.getLogWriter().info("Destroying " + chunkSize + " keys in each of " + this.allRegions.size() + " regions; last key index to destroy is " + lastKeyIndexToDestroy);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < minTaskGranularityMS) {
            String key = NameFactory.getNextPositiveObjectName();
            long nameCounter = NameFactory.getCounterForName(key);
            if (nameCounter <= lastKeyIndexToDestroy) {
                for (Region aRegion : this.allRegions) {
                    Log.getLogWriter().info("Destroying key " + key + " in region " + aRegion.getFullPath());
                    aRegion.destroy((Object)key);
                }
                continue;
            }
            Log.getLogWriter().info("Done destroying " + chunkSize + " keys in each of " + this.allRegions.size() + " regions");
            return true;
        }
        return false;
    }

    private synchronized void doCompactionStep() {
        int coord = this.compactionCoordinator.incrementAndGet();
        if (coord == 1) {
            for (Region aRegion : this.allRegions) {
                DataPolicy dataPolicy = aRegion.getAttributes().getDataPolicy();
                if (!dataPolicy.withPersistence() || !dataPolicy.withReplication()) continue;
                Log.getLogWriter().info("Causing compaction of disk files for region " + aRegion.getFullPath());
                long startTime = System.currentTimeMillis();
                boolean compactionResult = ((LocalRegion)aRegion).getDiskStore().forceCompaction();
                long duration = System.currentTimeMillis() - startTime;
                Log.getLogWriter().info("Done with compaction of disk files for region " + aRegion.getFullPath() + ", compaction took " + duration + " ms");
                if (compactionResult) continue;
                throw new TestException("forceCompaction returned " + compactionResult + " for " + aRegion.getFullPath());
            }
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneCompactingCounter);
        } else {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoverBB.doneCompactingCounter", RecoveryBB.doneCompactingCounter, TestHelper.getNumVMs() - 1, true, -1L, 10000L);
        }
    }

    private void doVerificationStep() {
        int coord = this.verifyCoordinator.incrementAndGet();
        if (coord == 1) {
            long firstKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("firstKeyIndex");
            long lastKeyIndex = (Long)RecoveryBB.getBB().getSharedMap().get("lastKeyIndex");
            Log.getLogWriter().info("Verifying with firstKeyIndex " + firstKeyIndex + ", lastKeyIndex " + lastKeyIndex);
            StringBuffer errStr = new StringBuffer();
            long cumulativeRegionSizes = 0L;
            for (Region aRegion : this.allRegions) {
                Log.getLogWriter().info("Verifying keys for " + aRegion.getFullPath());
                for (Object key : aRegion.keySet()) {
                    long nameCounter = NameFactory.getCounterForName(key);
                    if (nameCounter >= firstKeyIndex && nameCounter <= lastKeyIndex) continue;
                    errStr.append("Found unexpected key " + key + " in " + aRegion.getFullPath() + "\n");
                }
                long expectedNumKeys = lastKeyIndex - firstKeyIndex + 1L;
                if ((long)aRegion.size() == expectedNumKeys) continue;
                for (long i = firstKeyIndex; i <= lastKeyIndex; ++i) {
                    String key = NameFactory.getObjectNameForCounter(i);
                    if (aRegion.containsKey((Object)key)) continue;
                    errStr.append(key + " is missing from " + aRegion.getFullPath() + "\n");
                }
            }
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
            if (errStr.length() > 0) {
                throw new TestException(errStr.toString());
            }
        }
    }

    private boolean addToRegions(long finalKeyIndex) {
        long startTime;
        Log.getLogWriter().info("Adding to region(s) until biggest key has index " + finalKeyIndex);
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long logIntervalMS = 10000L;
        long lastLogTime = startTime = System.currentTimeMillis();
        int numCreated = 0;
        while (System.currentTimeMillis() - startTime < minTaskGranularityMS) {
            String key = NameFactory.getNextPositiveObjectName();
            long nameCounter = NameFactory.getCounterForName(key);
            ++numCreated;
            if (nameCounter <= finalKeyIndex) {
                for (Region aRegion : this.allRegions) {
                    aRegion.put((Object)key, this.getValueForKey(key));
                    if (System.currentTimeMillis() - lastLogTime <= logIntervalMS) continue;
                    Log.getLogWriter().info("Created " + numCreated + " entries per region so far this task; number remaining to create " + (finalKeyIndex - nameCounter));
                    lastLogTime = System.currentTimeMillis();
                }
                continue;
            }
            return true;
        }
        return false;
    }

    private void verifyRegions() {
        if (this.allRegions.size() == 0) {
            throw new TestException("No regions in this vm");
        }
        int expectedSize = RecoveryPrms.getMaxNumEntriesPerRegion();
        for (Region aRegion : this.allRegions) {
            Log.getLogWriter().info("Size of " + aRegion.getFullPath() + " is " + aRegion.size() + "; expected size is " + expectedSize);
            if (aRegion.size() == expectedSize) continue;
            throw new TestException("Expected region " + aRegion.getFullPath() + " to be size " + expectedSize + ", but it is size " + aRegion.size());
        }
    }

    private static void verifyStartupState() {
        Boolean recoveryCanBeTie = (Boolean)RecoveryBB.getBB().getSharedMap().get(recoveryCanBeTieKey);
        if (recoveryCanBeTie != null && recoveryCanBeTie.booleanValue()) {
            RecoveryTest.verifyTieStartup();
        } else {
            Map sharedMap = RecoveryBB.getBB().getSharedMap().getMap();
            Iterator it = sharedMap.keySet().iterator();
            StringBuffer logStr = new StringBuffer();
            StringBuffer errStr = new StringBuffer();
            HashSet<Integer> vmIDsWithDiskRecovery = new HashSet<Integer>();
            boolean expectAnyVmToRecoverFromDisk = false;
            while (it.hasNext()) {
                String aStr;
                String strKey;
                Object key = it.next();
                if (!(key instanceof String) || !(strKey = (String)key).startsWith(startupStatsForVmKey)) continue;
                Map statsMap = (Map)sharedMap.get(strKey);
                Integer vmID = Integer.valueOf(strKey.substring(startupStatsForVmKey.length(), strKey.length()));
                Boolean expectDiskRecovery = (Boolean)RecoveryBB.getBB().getSharedMap().get(expectDiskRecoveryKey + vmID);
                if (expectDiskRecovery != null) {
                    expectAnyVmToRecoverFromDisk = expectAnyVmToRecoverFromDisk || expectDiskRecovery != false;
                }
                Log.getLogWriter().info("Found startup stats for vmID " + vmID + ": " + statsMap + ", vmID " + vmID + " expected disk recovery: " + expectDiskRecovery);
                logStr.append("For vmID " + vmID + ", startup stats are:\n");
                int numDiskRecoveries = 0;
                int numGiis = 0;
                for (String statsMapKey : statsMap.keySet()) {
                    String regionName;
                    if (statsMapKey.startsWith(localInitializationsKey)) {
                        regionName = statsMapKey.substring(localInitializationsKey.length(), statsMapKey.length());
                        int localInit = (Integer)statsMap.get(statsMapKey);
                        numDiskRecoveries += localInit;
                        if (localInit != 0) {
                            vmIDsWithDiskRecovery.add(vmID);
                        }
                        logStr.append("   " + regionName + " localInitializations (disk recovery): " + localInit + "\n");
                        continue;
                    }
                    if (statsMapKey.startsWith(remoteInitializationsKey)) {
                        regionName = statsMapKey.substring(remoteInitializationsKey.length(), statsMapKey.length());
                        int remoteInit = (Integer)statsMap.get(statsMapKey);
                        numGiis += remoteInit;
                        logStr.append("   " + regionName + " remoteInitalizations (gii): " + remoteInit + "\n");
                        continue;
                    }
                    throw new TestException("Unknown key in stats map: " + statsMapKey);
                }
                if (numGiis != 0 && numDiskRecoveries != 0 || numGiis == 0 && numDiskRecoveries == 0) {
                    aStr = "For vmID " + vmID + ", expected all regions to obtain data from either disk or gii, but " + numGiis + " regions obtained data from gii and " + numDiskRecoveries + " regions obtained data from disk\n";
                    Log.getLogWriter().info(aStr);
                    errStr.append(aStr);
                }
                if (expectDiskRecovery == null) continue;
                if (expectDiskRecovery.booleanValue()) {
                    if (numDiskRecoveries > 0) continue;
                    aStr = "For vmID " + vmID + ", expected all regions to recover from " + "disk, but the number of regions that recovered from disk is " + numDiskRecoveries + "\n";
                    Log.getLogWriter().info(aStr);
                    errStr.append(aStr);
                    continue;
                }
                if (numGiis > 0) continue;
                aStr = "For vmID " + vmID + ", expected all regions to obtain data from " + "gii, but the number of regions that obtained data from gii is " + numDiskRecoveries + "\n";
                Log.getLogWriter().info(aStr);
                errStr.append(aStr);
            }
            if (expectAnyVmToRecoverFromDisk && vmIDsWithDiskRecovery.size() != 1) {
                String aStr = "Expected only 1 vm to recover from disk, but the following vmIDs recovered from disk: " + vmIDsWithDiskRecovery + "\n";
                Log.getLogWriter().info(aStr);
                errStr.append(aStr);
            }
            Log.getLogWriter().info(logStr.toString());
            if (errStr.length() > 0) {
                throw new TestException(errStr.toString());
            }
        }
    }

    private static void verifyTieStartup() {
        Integer vmID;
        int i;
        ArrayList<Integer> vmIdList = new ArrayList<Integer>();
        ArrayList diskRecoveryRegions = new ArrayList();
        ArrayList giiRegions = new ArrayList();
        Map sharedMap = RecoveryBB.getBB().getSharedMap().getMap();
        Iterator it = sharedMap.keySet().iterator();
        StringBuffer logStr = new StringBuffer();
        StringBuffer errStr = new StringBuffer();
        while (it.hasNext()) {
            String strKey;
            Object key = it.next();
            if (!(key instanceof String) || !(strKey = (String)key).startsWith(startupStatsForVmKey)) continue;
            Map map = (Map)sharedMap.get(strKey);
            Integer vmID2 = Integer.valueOf(strKey.substring(startupStatsForVmKey.length(), strKey.length()));
            Log.getLogWriter().info("Found startup stats for vmID " + vmID2 + ": " + map);
            vmIdList.add(vmID2);
            logStr.append("For vmID " + vmID2 + ", startup stats are:\n");
            HashSet<String> diskRegionsSet = new HashSet<String>();
            HashSet<String> giiRegionsSet = new HashSet<String>();
            diskRecoveryRegions.add(diskRegionsSet);
            giiRegions.add(giiRegionsSet);
            for (String statsMapKey : map.keySet()) {
                String regionName;
                if (statsMapKey.startsWith(localInitializationsKey)) {
                    regionName = statsMapKey.substring(localInitializationsKey.length(), statsMapKey.length());
                    int localInit = (Integer)map.get(statsMapKey);
                    if (localInit > 0) {
                        diskRegionsSet.add(regionName);
                    }
                    logStr.append("   " + regionName + " localInitializations (disk recovery): " + localInit + "\n");
                    continue;
                }
                if (statsMapKey.startsWith(remoteInitializationsKey)) {
                    regionName = statsMapKey.substring(remoteInitializationsKey.length(), statsMapKey.length());
                    int remoteInit = (Integer)map.get(statsMapKey);
                    if (remoteInit > 0) {
                        giiRegionsSet.add(regionName);
                    }
                    logStr.append("   " + regionName + " remoteInitalizations (gii): " + remoteInit + "\n");
                    continue;
                }
                throw new TestException("Unknown key in stats map: " + statsMapKey);
            }
        }
        if (vmIdList.size() != diskRecoveryRegions.size() || diskRecoveryRegions.size() != giiRegions.size()) {
            Log.getLogWriter().info(logStr.toString());
            throw new TestException("Test error; vmIdList size is " + vmIdList.size() + ", diskRecoveryRegions size is " + diskRecoveryRegions.size() + ", giiRegions size is " + giiRegions.size());
        }
        for (i = 0; i < vmIdList.size(); ++i) {
            vmID = (Integer)vmIdList.get(i);
            Set set = (Set)diskRecoveryRegions.get(i);
            Set giiSet = (Set)giiRegions.get(i);
            HashSet intersection = new HashSet(set);
            intersection.retainAll(giiSet);
            if (intersection.size() == 0) continue;
            errStr.append("Stats show that region(s) " + intersection + " in vmID " + vmID + " both obtained data from disk and gii\n");
        }
        for (i = 0; i < vmIdList.size(); ++i) {
            vmID = (Integer)vmIdList.get(i);
            Set set = (Set)diskRecoveryRegions.get(i);
            for (int j = 0; j < vmIdList.size(); ++j) {
                if (i == j) continue;
                Integer otherVmID = (Integer)vmIdList.get(j);
                Set otherGiiSet = (Set)giiRegions.get(j);
                if (otherGiiSet.containsAll(set)) continue;
                errStr.append("vm with id " + vmID + " recovered the following regions from disk " + set + ", expected those regions in vm id " + otherVmID + " to obtain data via gii, but the regions " + " that obtained data from gii are " + otherGiiSet + "\n");
            }
        }
        HashSet diskRegionsUnion = new HashSet();
        for (Set set : diskRecoveryRegions) {
            diskRegionsUnion.addAll(set);
        }
        Set testRegions = (Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey);
        if (!diskRegionsUnion.equals(testRegions)) {
            errStr.append("Expected region(s) " + testRegions + " to all recover from disk, but " + diskRegionsUnion + " recovered from disk\n");
        }
        Log.getLogWriter().info(logStr.toString());
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    private static void latestRecoveryTest() throws ClientVmNotFoundException, InterruptedException {
        Object[] anArr = StopStartVMs.getOtherVMsDivided(new String[]{"locator"});
        List allOtherVMsExceptLast = (List)anArr[0];
        List stopModesExceptLast = (List)anArr[1];
        ClientVmInfo lastVM = (ClientVmInfo)anArr[2];
        String lastStopMode = (String)anArr[3];
        List allOtherVMs = (List)anArr[4];
        List stopModeList = (List)anArr[5];
        String testStrategy = RecoveryPrms.getTestStrategy();
        Log.getLogWriter().info("Test strategy is " + testStrategy);
        if (testStrategy.equalsIgnoreCase("tie")) {
            RecoveryBB.getBB().getSharedMap().put(recoveryCanBeTieKey, new Boolean(true));
            for (ClientVmInfo info : allOtherVMs) {
                int vmID = info.getVmid();
                RecoveryBB.getBB().getSharedMap().put("allowPersistedMemberInfo" + vmID, new Boolean(false));
            }
            StopStartVMs.stopVMs(allOtherVMs, stopModeList);
            List thrList = StopStartVMs.startAsync(allOtherVMsExceptLast);
            if (RecoveryPrms.getConcurrentRegionCreation()) {
                Set allRegionNames = (Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey);
                RecoveryTestVersionHelper.verifyWaiting(lastVM, allOtherVMsExceptLast);
                RecoveryTest.verifyNoRegionCreation(allOtherVMsExceptLast, allRegionNames);
            } else {
                RecoveryTestVersionHelper.verifyWaiting(lastVM, allOtherVMsExceptLast);
                HashSet<String> regNameSet = new HashSet<String>();
                regNameSet.add("/Region_1");
                RecoveryTest.verifyNoRegionCreation(allOtherVMsExceptLast, regNameSet);
            }
            StopStartVMs.startVM(lastVM);
            for (Thread aThread : thrList) {
                aThread.join();
            }
            Log.getLogWriter().info("Done starting " + allOtherVMsExceptLast);
        } else if (testStrategy.equalsIgnoreCase("latestStartsFirst")) {
            StopStartVMs.stopVMs(allOtherVMsExceptLast, stopModesExceptLast);
            MasterController.sleepForMs(20000);
            StopStartVMs.stopVM(lastVM, lastStopMode);
            StopStartVMs.startVM(lastVM);
            StopStartVMs.startVMs(allOtherVMsExceptLast);
            RecoveryTest.markDataSource(lastVM, true);
            RecoveryTest.markDataSource(allOtherVMsExceptLast, false);
            RecoveryTest.markDataSource(allOtherVMsExceptLast, false);
        } else if (testStrategy.equalsIgnoreCase("latestStartsLast")) {
            StopStartVMs.stopVMs(allOtherVMsExceptLast, stopModesExceptLast);
            MasterController.sleepForMs(20000);
            StopStartVMs.stopVM(lastVM, lastStopMode);
            List thrList = StopStartVMs.startAsync(allOtherVMsExceptLast);
            if (RecoveryPrms.getConcurrentRegionCreation()) {
                Set allRegionNames = (Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey);
                RecoveryTestVersionHelper.verifyWaiting(lastVM, allOtherVMsExceptLast);
                RecoveryTest.verifyNoRegionCreation(allOtherVMsExceptLast, allRegionNames);
            } else {
                RecoveryTestVersionHelper.verifyWaiting(lastVM, allOtherVMsExceptLast);
                HashSet<String> regNameSet = new HashSet<String>();
                regNameSet.add("/Region_1");
                RecoveryTest.verifyNoRegionCreation(allOtherVMsExceptLast, regNameSet);
            }
            StopStartVMs.startVM(lastVM);
            for (Thread aThread : thrList) {
                aThread.join();
            }
            RecoveryTest.markDataSource(lastVM, true);
            RecoveryTest.markDataSource(allOtherVMsExceptLast, false);
            RecoveryTest.markDataSource(allOtherVMsExceptLast, false);
        } else if (testStrategy.equalsIgnoreCase("forceRecovery")) {
            if (allOtherVMsExceptLast.size() > 1) {
                RecoveryBB.getBB().getSharedMap().put(recoveryCanBeTieKey, new Boolean(true));
            }
            StopStartVMs.stopVMs(allOtherVMsExceptLast, stopModesExceptLast);
            MasterController.sleepForMs(2000);
            StopStartVMs.stopVM(lastVM, lastStopMode);
            List thrList = StopStartVMs.startAsync(allOtherVMsExceptLast);
            TreeSet<String> allRegionNames = new TreeSet<String>((Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey));
            RecoveryTestVersionHelper.verifyWaiting(lastVM, allOtherVMsExceptLast);
            RecoveryTest.verifyNoRegionCreation(allOtherVMsExceptLast, allRegionNames);
            RecoveryTestVersionHelper.forceRecovery(true);
            for (Thread aThread : thrList) {
                aThread.join();
            }
        } else if (testStrategy.equalsIgnoreCase("membersNotSimultaneous")) {
            List<ClientVmInfo> group1VMs = RecoveryTest.getMarkedVMs("group1");
            List<ClientVmInfo> group2VMs = RecoveryTest.getMarkedVMs("group2");
            List<ClientVmInfo> group3VMs = RecoveryTest.getMarkedVMs("group3");
            StopStartVMs.stopVMs(group3VMs, stopModeList.subList(0, group3VMs.size()));
            StopStartVMs.stopVMs(group1VMs, stopModeList.subList(0, group1VMs.size()));
            StopStartVMs.startVMs(group3VMs);
            StopStartVMs.stopVMs(group2VMs, stopModeList.subList(0, group2VMs.size()));
            StopStartVMs.startVMs(group1VMs);
            RecoveryTest.markDataSource(group1VMs, false);
            RecoveryTest.markDataSource(group3VMs, false);
        } else if (testStrategy.equalsIgnoreCase("refuseRecovery")) {
            NameBB.getBB().getSharedCounters().zero(NameBB.POSITIVE_NAME_COUNTER);
            List<ClientVmInfo> fullInitVMs = RecoveryTest.getMarkedVMs("fullInitialization");
            List<ClientVmInfo> noInitVMs = RecoveryTest.getMarkedVMs("noInitialization");
            StopStartVMs.stopVMs(allOtherVMs, stopModeList);
            StopStartVMs.startVMs(noInitVMs);
            StopStartVMs.startVMs(fullInitVMs);
        } else {
            throw new TestException("Unknown test strategy: " + testStrategy);
        }
    }

    private static void verifyNoRegionCreation(List<ClientVmInfo> members, Set<String> regions) {
        Log.getLogWriter().info("Verifying that vm(s) " + members + " are waiting");
        for (ClientVmInfo info : members) {
            for (String aRegionName : regions) {
                if (!RecoveryBB.getBB().getSharedMap().containsKey(RecoveryTest.getRegionCreatedKey(info.getVmid(), aRegionName))) continue;
                throw new TestException("Expected vm with id " + info.getVmid() + " to wait for recovery,  it has already created region(s)");
            }
        }
        Log.getLogWriter().info("Vm(s) " + members + " did not create any regions");
    }

    private void recoverAfterGiiTest() throws Exception {
        long executionNumber = RecoveryTest.logExecutionNumber();
        Vector otherVmIDs = ClientVmMgr.getOtherClientVmids();
        if (otherVmIDs.size() != 1) {
            throw new TestException("Expected 2 vms in this test but found " + otherVmIDs.size());
        }
        ClientVmInfo otherVM = new ClientVmInfo((Integer)otherVmIDs.get(0));
        ArrayList<ClientVmInfo> otherVMList = new ArrayList<ClientVmInfo>();
        otherVMList.add(otherVM);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        if (executionNumber == 1L) {
            Log.getLogWriter().info("First execution of task, stopping the other vm");
            StopStartVMs.stopVM(otherVM, "nice_exit");
        }
        if (executionNumber % 2L == 1L) {
            Log.getLogWriter().info("Task is doing test step 1");
            RecoveryBB.getBB().getSharedMap().remove(allRegionsSnapshotKey);
            long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
            long minTaskGranularityMS = minTaskGranularitySec * 1000L;
            List thrList = StopStartVMs.startAsync(otherVMList);
            this.doOperations(minTaskGranularityMS);
            for (Thread aThread : thrList) {
                try {
                    aThread.join();
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
            SilenceListener.waitForSilence(30L, 1000L);
            this.writeSnapshot();
            try {
                ClientVmMgr.stop("Stopping myself", -21, -31);
                throw new TestException("Test error; did not expect to get here");
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Task is doing test step 2");
        Log.getLogWriter().info("Verifying from snapshot BEFORE stopping this vm and recovering from disk");
        this.verifyFromSnapshot();
        this.waitForOfflineEvents();
        Log.getLogWriter().info("Stopping myself so restarted vm can verify disk files with init task on startup");
        try {
            ClientVmMgr.stop("Stopping myself (followed by init task validation)", -21, -30);
            throw new TestException("Test error; did not expect to get here");
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private void waitForOfflineEvents() {
        int numRegions = this.allRegions.size();
        while (true) {
            int counterValue;
            if ((counterValue = PersistenceCountObserver.afterPersistedOfflineCount.get()) == numRegions) {
                Log.getLogWriter().info("Found expected number of afterPersistedOffline calls: " + counterValue);
                return;
            }
            Log.getLogWriter().info("Waiting for count of afterPersistedOffline calls to be " + numRegions + ", current count is " + counterValue);
            MasterController.sleepForMs(1000);
        }
    }

    private void backupController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Log.getLogWriter().info("Pausing...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.pausing", RecoveryBB.pausing, TestHelper.getNumThreads(), true, -1L, 2000L);
        SummaryLogListener.waitForSilence(30L, 1000L);
        Log.getLogWriter().info("Directing responder to write to the blackboard...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.writeSnapshot);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        RecoveryTestVersionHelper.performBackup();
        Log.getLogWriter().info("Completed backup for iteration " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.pausing);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.leader);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    private void snapshotToDisk(Map snapshot) throws Exception {
        ObjectOutputStream oos = null;
        try {
            long snapshotNumber = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber);
            String snapFileName = "snapshotForBackup_" + snapshotNumber + ".ser";
            oos = new ObjectOutputStream(new FileOutputStream(snapFileName));
            oos.writeObject(snapshot);
            oos.flush();
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        finally {
            if (null != oos) {
                oos.close();
            }
        }
    }

    private void backupResponder() throws Exception {
        long pausing = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.pausing);
        if (pausing > 0L) {
            long leader;
            if (((Boolean)threadIsPaused.get()).booleanValue()) {
                Log.getLogWriter().info("Thread has paused");
            } else {
                Log.getLogWriter().info("This thread is pausing");
                threadIsPaused.set(Boolean.TRUE);
                long pausingValue = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.pausing);
                Log.getLogWriter().info("operationsResponder: pausing is " + pausingValue);
            }
            long writeSnapshot = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.writeSnapshot);
            if (writeSnapshot > 0L && (leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader)) == 1L) {
                Log.getLogWriter().info("This thread is the leader; it will write the snapshot");
                if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L && RecoveryPrms.getConvertWithNewVersionXml()) {
                    this.removeExtraRegionsFromAllRegions();
                }
                this.snapshotToDisk(this.writeSnapshot());
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
            }
            MasterController.sleepForMs(5000);
        } else {
            threadIsPaused.set(Boolean.FALSE);
            long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
            long minTaskGranularityMS = minTaskGranularitySec * 1000L;
            this.doOperations(minTaskGranularityMS);
        }
    }

    private void operationsController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Log.getLogWriter().info("Pausing...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.pausing", RecoveryBB.pausing, TestHelper.getNumThreads(), true, -1L, 2000L);
        SummaryLogListener.waitForSilence(30L, 1000L);
        Log.getLogWriter().info("Directing responder to write to the blackboard...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.writeSnapshot);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        List<ClientVmInfo> targetVMs = new ArrayList();
        if (RecoveryPrms.getUseShutDownAll()) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            if (adminDS == null) {
                throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
            }
            Object[] anArr = StopStartVMs.shutDownAllMembers(adminDS);
            targetVMs = (List)anArr[0];
        } else {
            Vector vmIDs = ClientVmMgr.getOtherClientVmids();
            ArrayList<String> stopModesList = new ArrayList<String>();
            for (Object vmID : vmIDs) {
                targetVMs.add(new ClientVmInfo((Integer)vmID));
                stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            }
            StopStartVMs.stopVMs(targetVMs, stopModesList);
        }
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.pausing);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.leader);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        PRObserver.initialize();
        StopStartVMs.startVMs(targetVMs);
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    private void operationsResponder() throws Exception {
        long pausing = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.pausing);
        if (pausing > 0L) {
            long leader;
            if (((Boolean)threadIsPaused.get()).booleanValue()) {
                Log.getLogWriter().info("Thread has paused");
            } else {
                Log.getLogWriter().info("This thread is pausing");
                threadIsPaused.set(new Boolean(true));
                RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.pausing);
            }
            long writeSnapshot = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.writeSnapshot);
            if (writeSnapshot > 0L && (leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader)) == 1L) {
                Log.getLogWriter().info("This thread is the leader; it will write the snapshot");
                if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L && RecoveryPrms.getConvertWithNewVersionXml()) {
                    this.removeExtraRegionsFromAllRegions();
                }
                this.writeSnapshot();
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
            }
            MasterController.sleepForMs(5000);
        } else {
            long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
            long minTaskGranularityMS = minTaskGranularitySec * 1000L;
            this.doOperations(minTaskGranularityMS);
        }
    }

    private void snapshotController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Log.getLogWriter().info("Pausing...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.pausing", RecoveryBB.pausing, TestHelper.getNumThreads(), true, -1L, 2000L);
        SummaryLogListener.waitForSilence(30L, 1000L);
        Log.getLogWriter().info("Directing responder to write to the blackboard and export snapshot ...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.writeSnapshot);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        List<ClientVmInfo> targetVMs = new ArrayList();
        if (RecoveryPrms.getUseShutDownAll()) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            if (adminDS == null) {
                throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
            }
            Object[] anArr = StopStartVMs.shutDownAllMembers(adminDS);
            targetVMs = (List)anArr[0];
        } else {
            Vector vmIDs = ClientVmMgr.getOtherClientVmids();
            ArrayList<String> stopModesList = new ArrayList<String>();
            for (Object vmID : vmIDs) {
                targetVMs.add(new ClientVmInfo((Integer)vmID));
                stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            }
            StopStartVMs.stopVMs(targetVMs, stopModesList);
        }
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.pausing);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.importSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotImported);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.leader);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        PRObserver.initialize();
        StopStartVMs.startVMs(targetVMs);
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    private void diskConvOperationsController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        boolean firstControllerExecution = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L;
        List newVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        if (firstControllerExecution) {
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (int i = 1; i <= newVersionVMs.size(); ++i) {
                stopModeList.add("MEAN_KILL");
            }
            StopStartVMs.stopVMs(newVersionVMs, stopModeList);
        }
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Log.getLogWriter().info("Pausing...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.pausing", RecoveryBB.pausing, TestHelper.getNumThreads() / 2, true, -1L, 2000L);
        SummaryLogListener.waitForSilence(30L, 1000L);
        Log.getLogWriter().info("Directing responder to write to the blackboard...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.writeSnapshot);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        List targetVMs = StopStartVMs.getAllVMs();
        targetVMs = firstControllerExecution ? StopStartVMs.getMatchVMs(targetVMs, "oldVersion") : StopStartVMs.getMatchVMs(targetVMs, "newVersion");
        ArrayList<String> stopModesList = new ArrayList<String>();
        for (int i = 1; i <= targetVMs.size(); ++i) {
            stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        if (RecoveryPrms.getUseShutDownAll()) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            if (adminDS == null) {
                throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
            }
            Object[] anArr = StopStartVMs.shutDownAllMembers(adminDS);
            targetVMs = (List)anArr[0];
        }
        StopStartVMs.stopVMs(targetVMs, stopModesList);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.pausing);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.leader);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        if (firstControllerExecution) {
            int convertedIndex = RecoveryTest.doSingleConvert(true);
            List newVersionXmlFileList = (List)RecoveryBB.getBB().getSharedMap().get(newVersionXmlFilesKey);
            String newVersionXmlFile = (String)newVersionXmlFileList.get(convertedIndex);
            int vmId = RecoveryTest.getVmIdFromXmlFileName(newVersionXmlFile);
            int startFirstIndex = -1;
            for (int i = 0; i < newVersionVMs.size(); ++i) {
                if (((ClientVmInfo)newVersionVMs.get(i)).getVmid() != vmId) continue;
                startFirstIndex = i;
                break;
            }
            ArrayList startFirstList = new ArrayList();
            startFirstList.add(newVersionVMs.get(startFirstIndex));
            List startThread = StopStartVMs.startAsync(startFirstList);
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, 1L, false, -1L, 2000L);
            newVersionVMs.remove(startFirstIndex);
            StopStartVMs.startVMs(newVersionVMs);
            for (Thread aThread : startThread) {
                try {
                    aThread.join();
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
        } else {
            StopStartVMs.startVMs(targetVMs);
        }
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    private void createRegionHier(List<String> regionConfigNames, List<String> diskStoreNames) throws Throwable {
        int i;
        int numRootRegions = RecoveryPrms.getNumRootRegions();
        int numSubregions = RecoveryPrms.getNumSubregions();
        int hierDepth = RecoveryPrms.getRegionHierarchyDepth();
        boolean concurrentCreation = RecoveryPrms.getConcurrentRegionCreation();
        Log.getLogWriter().info("In createRegionHier: concurrentRegionCreation is " + concurrentCreation);
        long seed = TestConfig.tab().longAt(Prms.randomSeed);
        Log.getLogWriter().info("Initializing region generation random seed to " + seed);
        GsRandom rand = new GsRandom(seed);
        ArrayList<String> prRegionConfigNames = new ArrayList<String>();
        ArrayList<String> nonPrRegionConfigNames = new ArrayList<String>();
        for (String configName : regionConfigNames) {
            if (configName.startsWith("pr")) {
                prRegionConfigNames.add(configName);
                continue;
            }
            nonPrRegionConfigNames.add(configName);
        }
        if (nonPrRegionConfigNames.size() == 0 && hierDepth > 1) {
            throw new TestException("Test configuration problem; test has configured only PR regions  with a hierarchy depth of " + hierDepth + ", PRs cannot have subregions so this configuration " + " is invalid");
        }
        List<String> regionConfigNamesToUse = regionConfigNames;
        if (hierDepth > 1) {
            regionConfigNamesToUse = nonPrRegionConfigNames;
        }
        final Vector regions = new Vector();
        regions.setSize(numRootRegions);
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        final ArrayList exceptionList = new ArrayList();
        int randomIndex = rand.nextInt(0, regionConfigNamesToUse.size() - 1);
        for (i = 1; i <= numRootRegions; ++i) {
            final String regionName = "Region_" + this.regionNameCounter++;
            final String regionConfigName = regionConfigNamesToUse.get(randomIndex);
            randomIndex = (randomIndex + 1) % regionConfigNamesToUse.size();
            RegionAttributes baseAttr = RegionHelper.getRegionAttributes(regionConfigName);
            AttributesFactory attrFac = RegionHelper.getAttributesFactory(regionConfigName);
            RecoveryTestVersionHelper.setRandomDiskStore(baseAttr, attrFac, diskStoreNames, rand);
            final RegionAttributes attr = attrFac.create();
            final int index = i - 1;
            Thread regionCreationThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String diskStoreNameLogging = RecoveryTestVersionHelper.createDiskStore(attr);
                        Log.getLogWriter().info("Starting creation of root region " + regionName + " using region config name " + regionConfigName + " " + diskStoreNameLogging);
                        long startTime = System.currentTimeMillis();
                        Region aRegion = theCache.createRegion(regionName, attr);
                        long duration = System.currentTimeMillis() - startTime;
                        Log.getLogWriter().info("Finished creation of region" + aRegion.getFullPath() + ", creation took " + duration + "ms");
                        regions.set(index, aRegion);
                        RecoveryBB.getBB().getSharedMap().put(RecoveryTest.getRegionCreatedKey(RemoteTestModule.getMyVmid(), regionName), new Boolean(true));
                        DataPolicy dataPolicy = attr.getDataPolicy();
                        if (dataPolicy.withPersistence() && dataPolicy.withReplication()) {
                            RecoveryBB.getBB().getSharedMap().put(RecoveryTest.persistentRegionKey + RemoteTestModule.getMyVmid(), new Boolean(true));
                        }
                    }
                    catch (Exception e) {
                        String errStr = "Caught " + TestHelper.getStackTrace(e) + " while creating region " + regionName;
                        Log.getLogWriter().info(errStr);
                        List list = exceptionList;
                        synchronized (list) {
                            exceptionList.add(e);
                        }
                    }
                    catch (Error e) {
                        String errStr = "Caught " + TestHelper.getStackTrace(e) + " while creating region " + regionName;
                        Log.getLogWriter().info(errStr);
                        List list = exceptionList;
                        synchronized (list) {
                            exceptionList.add(e);
                        }
                    }
                }
            });
            if (!concurrentCreation) {
                regionCreationThread.start();
                try {
                    regionCreationThread.join();
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                if (exceptionList.size() <= 0) continue;
                throw (Throwable)exceptionList.get(0);
            }
            threadList.add(regionCreationThread);
        }
        if (concurrentCreation) {
            for (Thread aThread : threadList) {
                aThread.start();
            }
            for (i = 0; i < threadList.size(); ++i) {
                try {
                    ((Thread)threadList.get(i)).join();
                }
                catch (InterruptedException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                if (exceptionList.size() <= 0) continue;
                throw (Throwable)exceptionList.get(0);
            }
        }
        this.allRegions = new ArrayList<Region>(regions);
        AbstractList currentRegList = regions;
        if (numSubregions > 0) {
            for (int currentDepth = 1; currentDepth < hierDepth; ++currentDepth) {
                if (currentDepth == hierDepth - 1 && prRegionConfigNames.size() > 0) {
                    regionConfigNamesToUse = prRegionConfigNames;
                }
                ArrayList createdRegions = new ArrayList();
                for (int i2 = 0; i2 < currentRegList.size(); ++i2) {
                    Region aRegion = (Region)currentRegList.get(i2);
                    List newRegions = this.createSubregions(aRegion, regionConfigNamesToUse, diskStoreNames, seed + (long)i2);
                    createdRegions.addAll(newRegions);
                }
                currentRegList = createdRegions;
            }
        }
        HashSet<String> regionNames = new HashSet<String>();
        for (Region aRegion : this.allRegions) {
            regionNames.add(aRegion.getFullPath());
        }
        RecoveryBB.getBB().getSharedMap().put(allRegionNamesKey, regionNames);
    }

    private List createSubregions(Region region, List<String> regionConfigNames, List<String> diskStoreNames, long randomSeed) {
        GsRandom rand = new GsRandom(randomSeed);
        ArrayList<Region> createdRegions = new ArrayList<Region>();
        int numSubregions = RecoveryPrms.getNumSubregions();
        int randomIndex = rand.nextInt(0, regionConfigNames.size() - 1);
        for (int i = 1; i <= numSubregions; ++i) {
            String regionName = "Region_" + this.regionNameCounter++;
            String regionConfigName = regionConfigNames.get(randomIndex);
            randomIndex = (randomIndex + 1) % regionConfigNames.size();
            RegionAttributes attr = RegionHelper.getRegionAttributes(regionConfigName);
            AttributesFactory attrFac = RegionHelper.getAttributesFactory(regionConfigName);
            RecoveryTestVersionHelper.setRandomDiskStore(attr, attrFac, diskStoreNames, rand);
            attr = attrFac.create();
            RecoveryTestVersionHelper.createDiskStore(attr);
            long startTime = System.currentTimeMillis();
            Region subregion = region.createSubregion(regionName, attr);
            long duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("Finished creation of region" + subregion.getFullPath() + ", creation took " + duration + "ms");
            RecoveryBB.getBB().getSharedMap().put(RecoveryTest.getRegionCreatedKey(RemoteTestModule.getMyVmid(), regionName), new Boolean(true));
            createdRegions.add(subregion);
            this.allRegions.add(subregion);
        }
        return createdRegions;
    }

    protected static String regionHierarchyToString() {
        Cache theCache = CacheHelper.getCache();
        if (theCache == null) {
            return "Cache is null; unable to get region hierarchy";
        }
        Set roots = theCache.rootRegions();
        StringBuffer aStr = new StringBuffer();
        int totalNumRegions = 0;
        for (Region aRegion : roots) {
            aStr.append(aRegion.getFullPath() + "  (size " + aRegion.size() + " dataPolicy " + aRegion.getAttributes().getDataPolicy() + " eviction " + aRegion.getAttributes().getEvictionAttributes());
            RecoveryTestVersionHelper.logDiskStore(aRegion, aStr);
            aStr.append(")\n");
            ++totalNumRegions;
            Object[] tmp = RecoveryTest.subregionsToString(aRegion, 1);
            aStr.append(tmp[0]);
            totalNumRegions += ((Integer)tmp[1]).intValue();
        }
        return "Region hierarchy with " + totalNumRegions + " regions\n" + aStr.toString();
    }

    private static Object[] subregionsToString(Region region, int level) {
        Set subregionSet = region.subregions(false);
        StringBuffer aStr = new StringBuffer();
        int numRegions = subregionSet.size();
        for (Region reg : subregionSet) {
            for (int i = 1; i <= level; ++i) {
                aStr.append("  ");
            }
            aStr.append(reg.getFullPath() + "  (size " + reg.size() + " dataPolicy " + reg.getAttributes().getDataPolicy() + " eviction " + reg.getAttributes().getEvictionAttributes());
            RecoveryTestVersionHelper.logDiskStore(reg, aStr);
            aStr.append(")\n");
            Object[] tmp = RecoveryTest.subregionsToString(reg, level + 1);
            aStr.append(tmp[0]);
            numRegions += ((Integer)tmp[1]).intValue();
        }
        return new Object[]{aStr.toString(), numRegions};
    }

    protected static void recoverLatestController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Object[] anArr = StopStartVMs.getOtherVMsDivided();
        List otherVMsExceptOne = (List)anArr[0];
        List otherStopModesExceptOne = (List)anArr[1];
        ClientVmInfo remainingVM = (ClientVmInfo)anArr[2];
        String remainingStopMode = (String)anArr[3];
        List otherVMs = (List)anArr[4];
        StopStartVMs.stopVMs(otherVMsExceptOne, otherStopModesExceptOne);
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.writeSnapshot);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        StopStartVMs.stopVM(remainingVM, remainingStopMode);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        StopStartVMs.startVMs(otherVMs);
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void concRecoverLatestResponder() {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        long startTime = System.currentTimeMillis();
        int numThreadsInThisVM = Integer.getInteger("numThreads");
        Log.getLogWriter().info("number of threads in this vm: " + numThreadsInThisVM);
        do {
            if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.writeSnapshot) > 0L) {
                RecoveryTest.testInstance.readyForSnapshot.addAndGet(1);
                while (RecoveryTest.testInstance.readyForSnapshot.get() < numThreadsInThisVM) {
                    Log.getLogWriter().info("Waiting for all threads in this vm to pause before writing snapshot, counter is " + RecoveryTest.testInstance.readyForSnapshot.get());
                    MasterController.sleepForMs(1000);
                }
                Log.getLogWriter().info("All threads in this vm have paused");
                Class<RecoveryTestVersionHelper> clazz = RecoveryTestVersionHelper.class;
                // MONITORENTER : diskRecovery.RecoveryTestVersionHelper.class
                if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.snapshotWritten) > 0L) {
                    MasterController.sleepForMs(2000);
                    // MONITOREXIT : clazz
                    return;
                }
                testInstance.writeSnapshot();
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
                // MONITOREXIT : clazz
                continue;
            }
            try {
                testInstance.doOperations(5000L);
            }
            catch (Exception e) {
                RecoveryTestVersionHelper.handleOpsException(e);
            }
        } while (System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    private static void convertPre65AndValidate(String oldVersionXmlFilePath, String newVersionXmlFilePath) {
        InstantiationHelper.setAllowInstantiation(false);
        List<File> oldVersionDiskFiles = RecoveryTest.getOldVersionDiskFiles(oldVersionXmlFilePath);
        RecoveryTest.listDiskFiles();
        String scriptLocation = RecoveryPrms.getScriptLocation();
        String exeName = "DiskFileConverter.sh";
        if (HostHelper.isWindows()) {
            exeName = "DiskFileConverter.bat";
        }
        String command = scriptLocation + File.separator + exeName + " CLASSPATH=" + System.getProperty("JTESTS") + " OLD_GEMFIRE=" + RecoveryTest.getGemFireHome("oldVersion") + " OLD_CACHE_XML=" + oldVersionXmlFilePath + " GEMFIRE=" + RecoveryTest.getGemFireHome("newVersion") + " CACHE_XML=" + newVersionXmlFilePath;
        Log.getLogWriter().info("Executing " + command + "...");
        long startTime = System.currentTimeMillis();
        String result = ProcessMgr.fgexec(command, 0);
        long duration = System.currentTimeMillis() - startTime;
        Log.getLogWriter().info("Done executing " + command + ", result is " + result);
        Log.getLogWriter().info("Disk file conversion tool took " + duration + " millis");
        String gemFireVersion = GemFireVersion.getGemFireVersion();
        for (int i = 0; i < gemFireVersion.length(); ++i) {
            char ch = gemFireVersion.charAt(i);
            if (Character.isDigit(ch) || ch == '.') continue;
            gemFireVersion = gemFireVersion.substring(0, i);
            break;
        }
        Log.getLogWriter().info("GemFire version is " + gemFireVersion);
        String[] lines = result.split("\n");
        if (result.indexOf("Exception") >= 0 || result.indexOf("find:") >= 0 || result.indexOf("rerun the tool") >= 0 || result.indexOf("Some errors happened") >= 0) {
            throw new TestException("Disk file converter contained unexpected output: " + result);
        }
        RecoveryTest.listDiskFiles();
        RecoveryTest.verifyDiskFileConversion(oldVersionXmlFilePath, newVersionXmlFilePath, oldVersionDiskFiles);
        InstantiationHelper.setAllowInstantiation(true);
    }

    private static void listDiskFiles() {
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        File[] dirContents = currDir.listFiles();
        StringBuffer resultStr = new StringBuffer();
        for (File aFile : dirContents) {
            File[] diskFiles;
            if (!aFile.isDirectory() || aFile.getName().indexOf("disk_") <= 0) continue;
            resultStr.append("Disk directory " + aFile.getAbsolutePath() + "\n");
            for (File diskFile : diskFiles = aFile.listFiles()) {
                resultStr.append("   " + diskFile.getName() + "\n");
            }
        }
        Log.getLogWriter().info("Existing disk files:\n" + resultStr);
    }

    private static void moveDiskFiles(List oldXmlFiles, List newXmlFiles) {
        for (int i = 0; i < oldXmlFiles.size(); ++i) {
            String oldXmlFilename = (String)oldXmlFiles.get(i);
            String newXmlFilename = (String)newXmlFiles.get(i);
            int oldVersionVmId = RecoveryTest.getVmIdFromXmlFileName(oldXmlFilename);
            int newVersionVmId = RecoveryTest.getVmIdFromXmlFileName(newXmlFilename);
            Log.getLogWriter().info("Moving disk files from vm_" + oldVersionVmId + " to newVersion disk-dirs for vm_" + newVersionVmId);
            String currDirName = System.getProperty("user.dir");
            File currDir = new File(currDirName);
            List<String> oldDiskDirNames = RecoveryTest.getDiskDirsForVmId(currDir, oldVersionVmId);
            for (String oldDiskDirName : oldDiskDirNames) {
                File[] diskFiles;
                String newDiskDirName = RecoveryTest.getMatchingNewDiskDir(currDir, oldDiskDirName, newVersionVmId);
                if (oldDiskDirName == null || newDiskDirName == null) continue;
                File oldDiskDir = new File(oldDiskDirName);
                File newDiskDir = new File(newDiskDirName);
                for (File diskFile : diskFiles = oldDiskDir.listFiles()) {
                    Log.getLogWriter().info("Working to move file:" + diskFile.getAbsolutePath());
                    if (!diskFile.exists()) continue;
                    File destFile = new File(newDiskDir, diskFile.getName());
                    if (HostHelper.isWindows() && destFile.exists()) {
                        destFile.delete();
                    }
                    Log.getLogWriter().info("moving (renameTo) " + diskFile.getName() + " from " + oldDiskDir.getAbsolutePath() + " to " + newDiskDir.getAbsolutePath());
                    boolean success = diskFile.renameTo(destFile);
                    if (success) continue;
                    throw new TestException("moveDiskFiles failed to move file, " + diskFile.getName() + " from oldDiskDir (" + oldDiskDir.getAbsolutePath() + ") to newDiskDir (" + newDiskDir.getAbsolutePath());
                }
            }
        }
    }

    private static String getMatchingNewDiskDir(File dir, String oldDiskDir, int newVmId) {
        int searchIndex;
        String fn = FileUtil.filenameFor(oldDiskDir);
        String diskNum = fn.substring((searchIndex = fn.lastIndexOf(95)) + 1);
        class DiskNumFileFilter
        implements FileFilter {
            String prefix;
            String diskStr;

            public DiskNumFileFilter(int vmId, String diskNum) {
                this.prefix = "vm_" + vmId + "_";
                this.diskStr = "_disk_" + diskNum;
            }

            @Override
            public boolean accept(File fn) {
                String fname = fn.getName();
                return fname.startsWith(this.prefix) && fname.endsWith(this.diskStr);
            }
        }
        List dirs = FileUtil.getFiles(dir, new DiskNumFileFilter(newVmId, diskNum), false);
        if (dirs.size() > 1) {
            throw new TestException("getMatchingNewDiskDir found more than one match for vm_" + newVmId + " and disk_" + diskNum);
        }
        File matchingDiskDir = (File)dirs.get(0);
        return matchingDiskDir.getAbsolutePath();
    }

    private static List<String> getDiskDirsForVmId(File dir, int vmId) {
        ArrayList<String> diskDirList = new ArrayList<String>();
        class VmIdFileFilter
        implements FileFilter {
            String prefix;
            String diskStr;

            public VmIdFileFilter(int vmId) {
                this.prefix = "vm_" + vmId + "_";
                this.diskStr = "_disk_";
            }

            @Override
            public boolean accept(File fn) {
                String fname = fn.getName();
                return fname.startsWith(this.prefix) && fname.indexOf(this.diskStr) > 0;
            }
        }
        List dirs = FileUtil.getFiles(dir, new VmIdFileFilter(vmId), false);
        for (File diskFile : dirs) {
            diskDirList.add(diskFile.getAbsolutePath());
        }
        return diskDirList;
    }

    private static List<File> getOldVersionDiskFiles(String oldVersionXmlFilePath) {
        ArrayList<File> oldFileNames = new ArrayList<File>();
        List oldVersionDiskDirs = RecoveryTest.extractFromXmlFile(oldVersionXmlFilePath)[2];
        for (List diskDirList : oldVersionDiskDirs) {
            for (String diskDir : diskDirList) {
                File aDir = new File(diskDir);
                oldFileNames.addAll(Arrays.asList(aDir.listFiles()));
            }
        }
        return oldFileNames;
    }

    private static void verifyDiskFileConversion(String oldVersionXmlFilePath, String newVersionXmlFilePath, List<File> oldVersionDiskFiles) {
        List[] oldVersionXmlInfo = RecoveryTest.extractFromXmlFile(oldVersionXmlFilePath);
        List oldVersionRegionNames = oldVersionXmlInfo[0];
        List[] newVersionXmlInfo = RecoveryTest.extractFromXmlFile(newVersionXmlFilePath);
        List newVersionRegionNames = newVersionXmlInfo[0];
        List newVersionDiskStoreNames = newVersionXmlInfo[1];
        List newVersionDiskDirs = newVersionXmlInfo[2];
        List newVersionDataPolicy = newVersionXmlInfo[3];
        HashSet uniqueDiskStoreNames = new HashSet(newVersionDiskStoreNames);
        for (String diskStoreName : uniqueDiskStoreNames) {
            if (diskStoreName == null) continue;
            HashSet persistRegNamesForDiskStore = new HashSet();
            HashSet diskDirsForDiskStore = new HashSet();
            for (int i = 0; i < newVersionDiskStoreNames.size(); ++i) {
                if (newVersionDiskStoreNames.get(i) == null || !((String)newVersionDiskStoreNames.get(i)).equals(diskStoreName)) continue;
                diskDirsForDiskStore.addAll((Collection)newVersionDiskDirs.get(i));
                if (newVersionDataPolicy.get(i) == null || ((String)newVersionDataPolicy.get(i)).indexOf("persistent") < 0) continue;
                persistRegNamesForDiskStore.add(newVersionRegionNames.get(i));
            }
            HashSet<String> expectedRegionNames = new HashSet<String>(oldVersionRegionNames);
            expectedRegionNames.retainAll(persistRegNamesForDiskStore);
            for (String regName : persistRegNamesForDiskStore) {
                if (!regName.startsWith("/extra_")) continue;
                expectedRegionNames.add(regName);
            }
            Log.getLogWriter().info("Expected region names for DiskStore " + diskStoreName + ": " + expectedRegionNames);
            ArrayList<File> diskDirsAsFile = new ArrayList<File>();
            for (String diskDirPath : diskDirsForDiskStore) {
                diskDirsAsFile.add(new File(diskDirPath));
            }
            File[] diskDirArr = new File[diskDirsAsFile.size()];
            diskDirsAsFile.toArray(diskDirArr);
            Object[] valResult = null;
            try {
                valResult = PersistenceUtil.runOfflineValidate(diskStoreName, diskDirArr);
            }
            catch (HydraRuntimeException e) {
                if (expectedRegionNames.size() == 0) {
                    String errStr = e.getCause().toString();
                    if (errStr.indexOf("The init file") >= 0 && errStr.indexOf(" does not exist") > 0) {
                        Log.getLogWriter().info("Got expected exception " + (Object)((Object)e) + " with cause " + errStr + " due to no persistent regions in " + " DiskStore " + diskStoreName);
                        valResult = new Object[]{"", new HashMap()};
                    }
                    throw e;
                }
                throw e;
            }
            Map regionNameMap = (Map)valResult[1];
            Set convertedRegionNames = regionNameMap.keySet();
            HashSet missingConvertedRegNames = new HashSet(expectedRegionNames);
            missingConvertedRegNames.removeAll(convertedRegionNames);
            HashSet extraConvertedRegNames = new HashSet(convertedRegionNames);
            extraConvertedRegNames.removeAll(expectedRegionNames);
            if (missingConvertedRegNames.size() != 0) {
                throw new TestException("After converting disk files, these regions were missing from the converted files for DiskStore " + diskStoreName + ": " + missingConvertedRegNames + ", result from validator is " + valResult[0]);
            }
            Iterator it = extraConvertedRegNames.iterator();
            while (it.hasNext()) {
                String aStr = (String)it.next();
                if (!aStr.endsWith("EVENT_QUEUE")) continue;
                extraConvertedRegNames.remove(aStr);
                it = extraConvertedRegNames.iterator();
            }
            if (extraConvertedRegNames.size() != 0) {
                throw new TestException("After converting disk files, these regions were extra in the converted files for DiskStore " + diskStoreName + ": " + extraConvertedRegNames + ", result from validator is " + valResult[0]);
            }
            Log.getLogWriter().info("Converted disk files " + diskDirsForDiskStore + " for DiskStore " + diskStoreName + " contained expected regions " + expectedRegionNames);
        }
        for (File diskFile : oldVersionDiskFiles) {
            if (diskFile.getName().endsWith(".olg") || diskFile.getName().endsWith("lk") || diskFile.getName().startsWith("OVERFLOW") || diskFile.exists()) continue;
            throw new TestException("old disk file " + diskFile.getAbsolutePath() + " is missing after conversion");
        }
        Log.getLogWriter().info("Finished verifying disk file conversion");
    }

    private static List[] extractFromXmlFile(String xmlFilePath) {
        ArrayList regionNameList = new ArrayList();
        ArrayList diskStoreNameList = new ArrayList();
        ArrayList diskDirsList = new ArrayList();
        ArrayList dataPolicyList = new ArrayList();
        File file = new File(xmlFilePath);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((EntityResolver)new CacheXmlParser());
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList baseNodeList = doc.getElementsByTagName("cache");
            for (int i = 0; i < baseNodeList.getLength(); ++i) {
                Node cacheNode = baseNodeList.item(i);
                NodeList cacheNodeList = cacheNode.getChildNodes();
                for (int index2 = 0; index2 < cacheNodeList.getLength(); ++index2) {
                    Node regionNode = cacheNodeList.item(index2);
                    if (!regionNode.getNodeName().equals("region")) continue;
                    List[] result = RecoveryTest.extractFromRegionNode("", regionNode);
                    regionNameList.addAll(result[0]);
                    diskStoreNameList.addAll(result[1]);
                    diskDirsList.addAll(result[2]);
                    dataPolicyList.addAll(result[3]);
                }
                if (regionNameList.size() > diskStoreNameList.size()) {
                    diskStoreNameList.add(null);
                }
                if (regionNameList.size() > diskDirsList.size()) {
                    diskDirsList.add(null);
                }
                if (regionNameList.size() > dataPolicyList.size()) {
                    dataPolicyList.add(null);
                }
                if (regionNameList.size() == diskStoreNameList.size() && regionNameList.size() == diskDirsList.size() && regionNameList.size() == dataPolicyList.size()) continue;
                throw new TestException("Test problem; expected equal sizes for parallel Lists, regionNameList is size " + regionNameList.size() + " " + "diskStoreNameList is size " + diskStoreNameList.size() + " " + "diskDirsList is size " + diskDirsList.size() + " " + "dataPolicyList is size " + dataPolicyList.size());
            }
        }
        catch (ParserConfigurationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SAXException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return new List[]{regionNameList, diskStoreNameList, diskDirsList, dataPolicyList};
    }

    private static List[] extractFromRegionNode(String parentRegionName, Node regionNode) {
        ArrayList<String> regionNameList = new ArrayList<String>();
        ArrayList<String> diskStoreNameList = new ArrayList<String>();
        ArrayList diskDirsList = new ArrayList();
        ArrayList<String> dataPolicyList = new ArrayList<String>();
        NamedNodeMap baseNodeAttributes = regionNode.getAttributes();
        Node nameObj = baseNodeAttributes.getNamedItem("name");
        String regionName = nameObj.getNodeValue();
        regionName = parentRegionName + "/" + regionName;
        regionNameList.add(regionName);
        NodeList regionChildNodes = regionNode.getChildNodes();
        for (int index1 = 0; index1 < regionChildNodes.getLength(); ++index1) {
            Node regionChild = regionChildNodes.item(index1);
            if (regionChild.getNodeName().equals("region-attributes")) {
                NamedNodeMap regionNodeAttr = regionChild.getAttributes();
                Node diskStoreNode = regionNodeAttr.getNamedItem("disk-store-name");
                if (diskStoreNode == null) {
                    diskStoreNameList.add(null);
                } else {
                    diskStoreNameList.add(diskStoreNode.getNodeValue());
                }
                dataPolicyList.add(regionNodeAttr.getNamedItem("data-policy").getNodeValue());
                ArrayList<String> diskDirsThisRegion = new ArrayList<String>();
                NodeList attrNodeList = regionChild.getChildNodes();
                for (int index2 = 0; index2 < attrNodeList.getLength(); ++index2) {
                    Node attrNode = attrNodeList.item(index2);
                    if (!attrNode.getNodeName().equals("disk-dirs")) continue;
                    NodeList diskDirsNodeList = attrNode.getChildNodes();
                    for (int index3 = 0; index3 < diskDirsNodeList.getLength(); ++index3) {
                        Node diskDirsNode = diskDirsNodeList.item(index3);
                        if (!diskDirsNode.getNodeName().equals("disk-dir")) continue;
                        NodeList diskDirNodeList = diskDirsNode.getChildNodes();
                        for (int index4 = 0; index4 < diskDirNodeList.getLength(); ++index4) {
                            Node diskDirNode = diskDirNodeList.item(index4);
                            diskDirsThisRegion.add(diskDirNode.getNodeValue());
                        }
                    }
                }
                diskDirsList.add(diskDirsThisRegion);
                continue;
            }
            if (!regionChild.getNodeName().equals("region")) continue;
            List[] result = RecoveryTest.extractFromRegionNode(regionName, regionChild);
            regionNameList.addAll(result[0]);
            diskStoreNameList.addAll(result[1]);
            diskDirsList.addAll(result[2]);
            dataPolicyList.addAll(result[3]);
        }
        return new List[]{regionNameList, diskStoreNameList, diskDirsList, dataPolicyList};
    }

    private static String getGemFireHome(String versionName) {
        HydraVector versionNamesVec = TestConfig.tab().vecAt(VersionPrms.names);
        HydraVector versionHomeVec = TestConfig.tab().vecAt(VersionPrms.gemfireHome);
        int index = versionNamesVec.indexOf(versionName);
        if (index < 0) {
            throw new TestException("Could not find " + versionName + " in VersionPrms.names");
        }
        String gemfireHome = (String)versionHomeVec.get(index);
        if (gemfireHome.equals("default")) {
            return System.getProperty("gemfire.home");
        }
        return gemfireHome;
    }

    Map writeSnapshot() {
        return this.writeSnapshot(false);
    }

    Map writeSnapshot(boolean includeNonPersistentRegions) {
        Log.getLogWriter().info("Preparing to write snapshot for " + this.allRegions.size() + " regions");
        HashMap allRegionsSnapshot = new HashMap();
        for (Region aRegion : this.allRegions) {
            HashMap regionSnapshot = new HashMap();
            if (includeNonPersistentRegions || RecoveryTestVersionHelper.withPersistence(aRegion)) {
                for (Object key : aRegion.keySet()) {
                    Object value = null;
                    if (aRegion.containsValueForKey(key)) {
                        value = aRegion.get(key);
                    }
                    if (value instanceof BaseValueHolder) {
                        regionSnapshot.put(key, ((BaseValueHolder)value).myValue);
                        continue;
                    }
                    if (RecoveryTestVersionHelper.instanceOfPdxInstance(value)) {
                        BaseValueHolder vh = RecoveryTestVersionHelper.toValueHolder(value);
                        regionSnapshot.put(key, vh.myValue);
                        continue;
                    }
                    regionSnapshot.put(key, value);
                }
            } else {
                Log.getLogWriter().info(aRegion.getFullPath() + " is size " + aRegion.size() + " but it is not persistent, so snapshot size is " + regionSnapshot.size() + " (the region will be empty after stop/restart)");
            }
            allRegionsSnapshot.put(aRegion.getFullPath(), regionSnapshot);
            Log.getLogWriter().info("Region snapshot for " + aRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        }
        RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        Log.getLogWriter().info("Put snapshot for " + this.allRegions.size() + " regions into blackboard at key " + allRegionsSnapshotKey);
        return allRegionsSnapshot;
    }

    protected void verifyFromSnapshot() {
        Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
        if (allRegionsSnapshot == null) {
            Log.getLogWriter().info("Not verifying from snapshot because the snapshot in the blackboard is null");
            return;
        }
        Set snapshotRegionNames = allRegionsSnapshot.keySet();
        HashSet<String> definedRegionNames = new HashSet<String>();
        for (Region aRegion : theCache.rootRegions()) {
            definedRegionNames.add(aRegion.getFullPath());
            Set subRegSet = aRegion.subregions(true);
            for (Region subReg : subRegSet) {
                definedRegionNames.add(subReg.getFullPath());
            }
        }
        HashSet missingRegionsInCache = new HashSet(snapshotRegionNames);
        missingRegionsInCache.removeAll(definedRegionNames);
        HashSet extraRegionsInCache = new HashSet(definedRegionNames);
        extraRegionsInCache.removeAll(snapshotRegionNames);
        if (missingRegionsInCache.size() != 0) {
            throw new TestException("Expected to find regions " + missingRegionsInCache + " defined in cache");
        }
        if (extraRegionsInCache.size() != 0) {
            throw new TestException("Found unexpected regions defined in cache: " + extraRegionsInCache);
        }
        for (String regionName : allRegionsSnapshot.keySet()) {
            Map regionSnapshot = (Map)allRegionsSnapshot.get(regionName);
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            this.verifyFromSnapshot(aRegion, regionSnapshot);
        }
    }

    public void verifyFromSnapshot(Region aRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = aRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + "  of size " + aRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (snapshotSize != regionSize) {
            ((LocalRegion)aRegion).dumpBackingMap();
            errStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
        }
        for (Object key : regionSnapshot.keySet()) {
            try {
                ParRegUtil.verifyContainsKey(aRegion, key, true);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            boolean containsValueForKey = aRegion.containsValueForKey(key);
            Object expectedValue = regionSnapshot.get(key);
            try {
                ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null);
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
            if (!containsValueForKey) continue;
            try {
                Object actualValue = aRegion.get(key);
                if (actualValue instanceof BaseValueHolder) {
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (RecoveryTestVersionHelper.instanceOfPdxInstance(actualValue)) {
                    actualValue = RecoveryTestVersionHelper.toValueHolder(actualValue);
                    ParRegUtil.verifyMyValue(key, expectedValue, actualValue, ParRegUtil.EQUAL);
                    continue;
                }
                if (actualValue instanceof byte[] && expectedValue instanceof byte[]) {
                    byte[] actual = (byte[])actualValue;
                    byte[] expected = (byte[])expectedValue;
                    if (actual.length == expected.length) continue;
                    throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
                }
                throw new TestException("Expected value for key " + key + " to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue));
            }
            catch (TestException e) {
                errStr.append(e.getMessage() + "\n");
            }
        }
        HashSet aRegionKeySet = new HashSet(aRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        aRegionKeySet.removeAll(snapshotKeySet);
        if (aRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + aRegion.getFullPath() + ": " + aRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + aRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, " + "verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }

    private static void concRecoverAllController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        List<ClientVmInfo> stopVMs = new ArrayList();
        if (RecoveryPrms.getUseShutDownAll()) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            RecoveryBB.getBB().getSharedMap().put("shutDownAllKey", true);
            stopVMs = (List)StopStartVMs.shutDownAllMembers(adminDS)[0];
            RecoveryBB.getBB().getSharedMap().put("shutDownAllKey", false);
        } else {
            Vector vmIDs = ClientVmMgr.getOtherClientVmids();
            ArrayList<String> stopModesList = new ArrayList<String>();
            for (Object vmID : vmIDs) {
                stopVMs.add(new ClientVmInfo((Integer)vmID));
                stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            }
            StopStartVMs.stopVMs(stopVMs, stopModesList);
        }
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        StopStartVMs.startVMs(stopVMs);
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    public static void HydraTask_importAndVerify() {
        RecoveryTestVersionHelper.importAndVerify(testInstance);
    }

    private void verifyFromLeaderSnapshot() {
        long counter = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.writeSnapshot);
        if (counter == 1L) {
            this.writeSnapshot();
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
        } else {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
            this.verifyFromSnapshot();
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
        }
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads() - 1, true, -1L, 2000L);
    }

    protected void doOperations(long msToRun) throws Exception {
        Log.getLogWriter().info("In doOperations, running for " + msToRun + " seconds");
        long startTime = System.currentTimeMillis();
        int numOps = 0;
        do {
            Region aRegion = null;
            try {
                aRegion = this.allRegions.get(TestConfig.tab().getRandGen().nextInt(0, this.allRegions.size() - 1));
                int whichOp = this.getOperation(aRegion);
                switch (whichOp) {
                    case 1: {
                        this.addEntry(aRegion);
                        break;
                    }
                    case 3: {
                        this.invalidateEntry(aRegion, false);
                        break;
                    }
                    case 2: {
                        this.destroyEntry(aRegion, false);
                        break;
                    }
                    case 6: {
                        this.updateEntry(aRegion);
                        break;
                    }
                    case 7: {
                        this.getExistingKey(aRegion);
                        break;
                    }
                    case 8: {
                        this.getNewKey(aRegion);
                        break;
                    }
                    case 5: {
                        this.invalidateEntry(aRegion, true);
                        break;
                    }
                    case 4: {
                        this.destroyEntry(aRegion, true);
                        break;
                    }
                    case 9: {
                        this.putAll(aRegion);
                        break;
                    }
                    case 10: {
                        this.cacheRegionOperations();
                        break;
                    }
                    case 11: {
                        RecoveryTest.putsForKeyOrderPolicy(aRegion);
                        break;
                    }
                    case 12: {
                        aRegion = this.clearRegion();
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
                Log.getLogWriter().info("Completed op " + ++numOps + " for this task");
            }
            catch (EntryExistsException e) {
                if (this.uniqueKeys) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with multiple writers (uniqueKeys==false), continuing test");
            }
            catch (EntryNotFoundException e) {
                if (this.uniqueKeys) {
                    boolean allowENFE = false;
                    long stoppingVMs = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.stoppingVMs);
                    if (stoppingVMs > 0L) {
                        allowENFE = true;
                        Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with HA, continuing test");
                    } else {
                        long clearRegion = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.clears);
                        if (clearRegion > 0L && this.isClearedRegion(aRegion)) {
                            allowENFE = true;
                            Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", due to concurrent clear on " + aRegion.getFullPath() + ", continuing test");
                        }
                    }
                    if (allowENFE) continue;
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                Log.getLogWriter().info("Caught " + (Object)((Object)e) + ", expected with multiple writers (uniqueKeys==false), continuing test");
            }
            catch (Exception e) {
                boolean undergoingShutDownAll = (Boolean)RecoveryBB.getBB().getSharedMap().get("shutDownAllKey");
                if (undergoingShutDownAll) {
                    RecoveryTestVersionHelper.handleOpsExceptionDuringShutDownAll(e);
                    continue;
                }
                throw e;
            }
        } while (System.currentTimeMillis() - startTime < msToRun);
        Log.getLogWriter().info("Done in doOperations");
        Log.getLogWriter().info(RecoveryTest.regionHierarchyToString());
    }

    protected int getOperation(Region aRegion) {
        int size;
        Long opsPrm = RecoveryPrms.operations;
        Long upperThresholdOpsPrm = RecoveryPrms.upperThresholdOperations;
        Long lowerThresholdOpsPrm = RecoveryPrms.lowerThresholdOperations;
        int upperThreshold = RecoveryPrms.getUpperThreshold();
        int lowerThreshold = RecoveryPrms.getLowerThreshold();
        if (this.isBridgeClient) {
            opsPrm = RecoveryPrms.clientOperations;
            upperThresholdOpsPrm = RecoveryPrms.upperThresholdClientOperations;
            lowerThresholdOpsPrm = RecoveryPrms.lowerThresholdClientOperations;
            upperThreshold = RecoveryPrms.getUpperThresholdClient();
            lowerThreshold = RecoveryPrms.getLowerThresholdClient();
        }
        if ((size = aRegion.size()) >= upperThreshold) {
            return this.getOperation(upperThresholdOpsPrm);
        }
        if (size <= lowerThreshold) {
            return this.getOperation(lowerThresholdOpsPrm);
        }
        return this.getOperation(opsPrm);
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putAll")) {
            op = 9;
        } else if (operation.equals("cacheOperations")) {
            op = 10;
        } else if (operation.equals("putsForKeyOrderPolicy")) {
            op = 11;
        } else if (operation.equals("clear")) {
            op = 12;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected void getExistingKey(Region aRegion) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("No keys available in " + aRegion.getFullPath() + ", cannot do get on existing key");
            return;
        }
        Log.getLogWriter().info("Getting existing key " + key + " from region " + aRegion.getFullPath());
        Object result = aRegion.get(key);
        Log.getLogWriter().info("Done getting existing key " + key + ", returned value " + result);
    }

    protected Object addEntry(Region aRegion) {
        Object key = this.obtainNewKey();
        this.addEntry(aRegion, key);
        return key;
    }

    protected void addEntry(Region aRegion, Object key) {
        Object anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.create(key, anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                aRegion.create(key, anObj);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            }
        } else {
            Object returnVal = null;
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
                returnVal = aRegion.put(key, anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            } else {
                Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                returnVal = aRegion.put(key, anObj);
                Log.getLogWriter().info("addEntry: done putting key " + key + ", returnVal is " + returnVal);
            }
        }
    }

    protected void putAll(Region aRegion) {
        Map mapToPut = this.getPutAllMap(aRegion);
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries, region is " + aRegion.getFullPath());
        aRegion.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected Map getPutAllMap(Region aRegion) {
        int numPutAllNewKeys = RecoveryPrms.getNumPutAllNewKeys();
        HashMap<Object, Object> mapToPut = new HashMap<Object, Object>();
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numPutAllNewKeys; ++i) {
            Object key = this.obtainNewKey();
            Object anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(RecoveryPrms.numPutAllExistingKeys);
        List<String> existingKeysList = this.obtainExistingKeys(aRegion, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        int count = 0;
        for (String key : existingKeysList) {
            Object anObj = this.getUpdateObject(aRegion, key);
            mapToPut.put(key, anObj);
            existingKeys.append(key + " ");
            if (++count % 10 != 0) continue;
            existingKeys.append("\n");
        }
        Log.getLogWriter().info(aRegion.getFullPath() + " size is " + aRegion.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numPutAllNewKeys + " new keys and " + numPutAllExistingKeys + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\n" + "existing keys are: " + existingKeys);
        return mapToPut;
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("invalidateEntry: No keys in region " + aRegion.getFullPath());
            return;
        }
        this.invalidateEntry(aRegion, key, isLocalInvalidate);
    }

    protected void invalidateEntry(Region aRegion, Object key, boolean isLocalInvalidate) {
        String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
        if (isLocalInvalidate) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.localInvalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + ", region is " + aRegion.getFullPath());
                aRegion.localInvalidate(key);
                Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.invalidate(key, (Object)callback);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        } else {
            Log.getLogWriter().info("invalidateEntry: invalidating key " + key + ", aRegion is " + aRegion.getFullPath());
            aRegion.invalidate(key);
            Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("destroyEntry: No keys in region " + aRegion.getFullPath());
            return;
        }
        this.destroyEntry(aRegion, key, isLocalDestroy);
    }

    protected void destroyEntry(Region aRegion, Object key, boolean isLocalDestroy) {
        String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
        if (isLocalDestroy) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.localDestroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: local destroy for " + key + ", region is " + aRegion.getFullPath());
                aRegion.localDestroy(key);
                Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.destroy(key, (Object)callback);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        } else {
            Log.getLogWriter().info("destroyEntry: destroying key " + key + ", region is " + aRegion.getFullPath());
            aRegion.destroy(key);
            Log.getLogWriter().info("destroyEntry: done destroying key " + key);
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = this.obtainExistingKey(aRegion);
        if (key == null) {
            Log.getLogWriter().info("updateEntry: No keys in region " + aRegion.getFullPath());
            return;
        }
        this.updateEntry(aRegion, key);
    }

    protected void updateEntry(Region aRegion, Object key) {
        Object anObj = this.getUpdateObject(aRegion, (String)key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        Object returnVal = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback + ", region is " + aRegion.getFullPath());
            returnVal = aRegion.put(key, anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            returnVal = aRegion.put(key, anObj, (Object)false);
            Log.getLogWriter().info("Done with call to put (update), returnVal is " + returnVal);
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.obtainNewKey();
        this.getThisNewKey(aRegion, key);
    }

    protected void getThisNewKey(Region aRegion, Object key) {
        Object anObj;
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback + ", region is " + aRegion.getFullPath());
            anObj = aRegion.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", region is " + aRegion.getFullPath());
            anObj = aRegion.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    protected Object obtainExistingKey(Region aRegion) {
        if (aRegion.size() == 0) {
            return null;
        }
        Object[] keyArr = aRegion.keySet().toArray();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        for (Object key : keyArr) {
            if (this.uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                return key;
            }
            return key;
        }
        return null;
    }

    protected List<String> obtainExistingKeys(Region aRegion, int numToObtain) {
        ArrayList<String> aList = new ArrayList<String>();
        if (aRegion.size() == 0) {
            return aList;
        }
        Object[] keyArr = aRegion.keySet().toArray();
        int myTid = RemoteTestModule.getCurrentThread().getThreadId();
        int numThreads = TestHelper.getNumThreads();
        for (Object key : keyArr) {
            if (this.uniqueKeys) {
                long keyIndex = NameFactory.getCounterForName(key);
                if (keyIndex % (long)numThreads != (long)myTid) continue;
                aList.add((String)key);
                if (aList.size() != numToObtain) continue;
                return aList;
            }
            aList.add((String)key);
            if (aList.size() != numToObtain) continue;
            return aList;
        }
        return aList;
    }

    protected void cacheRegionOperations() {
        Log.getLogWriter().info("Getting rootRegions");
        Set rootRegions = theCache.rootRegions();
        Log.getLogWriter().info("Getting subregions");
        HashSet<Region> all = new HashSet<Region>(rootRegions);
        for (Region aRegion : rootRegions) {
            all.add(aRegion);
            all.addAll(aRegion.subregions(true));
        }
        Log.getLogWriter().info("Getting individual regions from Cache");
        for (Region aRegion : all) {
            String fullName = aRegion.getFullPath();
            theCache.getRegion(fullName);
        }
    }

    public static void putsForKeyOrderPolicy(Region aRegion) {
        RecoveryBB bb = RecoveryBB.getBB();
        int vmId = RemoteTestModule.getMyVmid();
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        String mapKey = "vm_" + vmId + "_thr_" + tid;
        if (bb.getSharedMap().get(mapKey) == null) {
            bb.getSharedMap().put(mapKey, 0);
        }
        int opNum = (Integer)bb.getSharedMap().get(mapKey);
        int myUniqueKey = (Integer)bb.getSharedMap().get(uniqueKeyIndex + tid);
        Log.getLogWriter().info("Updating sequential values for " + myUniqueKey);
        String key = NameFactory.getObjectNameForCounter(myUniqueKey);
        for (int i = 1; i <= 1000; ++i) {
            ValueHolder value = new ValueHolder((Object)key, RecoveryTest.testInstance.randomValues, new Integer(opNum));
            aRegion.put((Object)key, (Object)value, (Object)mapKey);
            ++opNum;
        }
        bb.getSharedMap().put(mapKey, new Integer(opNum));
        Log.getLogWriter().info("Done updating sequential values for " + myUniqueKey);
    }

    protected Region clearRegion() {
        Object[] regionInfo = this.getNonPartitionedRegionInfo();
        Region aRegion = (Region)regionInfo[0];
        int numNonPartitionedRegions = (Integer)regionInfo[1];
        long numClears = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.clears);
        if (numClears < (long)(numNonPartitionedRegions / 10)) {
            Log.getLogWriter().info("numClears = " + numClears + " of " + numNonPartitionedRegions / 10 + " permitted by this test");
            if (aRegion != null) {
                String fullPathName = aRegion.getFullPath();
                RecoveryBB.getBB().addToClearedRegionList(fullPathName);
                Log.getLogWriter().info("Starting clearRegion on " + fullPathName);
                aRegion.clear();
                Log.getLogWriter().info("Completed clearRegion on " + fullPathName);
            } else {
                Log.getLogWriter().info("clearRegion invoked, but there are no non-PartitionedRegions in this test");
            }
        }
        return aRegion;
    }

    protected Object[] getNonPartitionedRegionInfo() {
        ArrayList<Region> nonPartitionedRegions = new ArrayList<Region>();
        for (Region aRegion : this.allRegions) {
            if (aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            nonPartitionedRegions.add(aRegion);
        }
        Region aRegion = null;
        int size = nonPartitionedRegions.size();
        if (size > 0) {
            aRegion = (Region)nonPartitionedRegions.get(TestConfig.tab().getRandGen().nextInt(0, size - 1));
            Log.getLogWriter().info("getNonPartitionedRegionInfo returning target Region " + aRegion.getFullPath() + " from list of regions of size " + size);
        }
        Object[] info = new Object[]{aRegion, new Integer(size)};
        return info;
    }

    protected boolean isClearedRegion(Region aRegion) {
        boolean cleared = false;
        List regionList = (List)RecoveryBB.getBB().getSharedMap().get("clearedRegionFullPaths");
        if (regionList != null && regionList.contains(aRegion.getFullPath())) {
            cleared = true;
        }
        return cleared;
    }

    protected static void runRestoreScript(File backupDir, boolean expectSuccess) {
        File[] dateDirContents;
        File[] backupContents = backupDir.listFiles();
        if (backupContents.length != 1) {
            throw new TestException("Expecting backup directory to contain 1 directory, but it contains " + backupContents.length);
        }
        File dateDir = backupContents[0];
        block4: for (File hostAndPidDir : dateDirContents = dateDir.listFiles()) {
            File[] hostAndPidContents;
            for (File aFile : hostAndPidContents = hostAndPidDir.listFiles()) {
                if (!aFile.getName().equals("restore.sh") && !aFile.getName().equals("restore.bat")) continue;
                try {
                    String cmd = null;
                    cmd = HostHelper.isWindows() ? "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c " : "/bin/bash ";
                    cmd = cmd + aFile.getCanonicalPath();
                    try {
                        Log.getLogWriter().info("Running restore scripts");
                        String cmdResult = ProcessMgr.fgexec(cmd, 0);
                        Log.getLogWriter().info("Result is " + cmdResult);
                        if (!expectSuccess) {
                            throw new TestException("Expected restore script to fail, but it succeeded");
                        }
                        Log.getLogWriter().info("Restore script executed successfully");
                        continue block4;
                    }
                    catch (HydraRuntimeException e) {
                        if (expectSuccess) {
                            throw e;
                        }
                        String errStr = e.getCause().toString();
                        if (errStr.indexOf("Backup not restored. Refusing to overwrite") >= 0) {
                            Log.getLogWriter().info("restore script got expected exception " + (Object)((Object)e) + " " + e.getCause());
                            continue block4;
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
        }
    }

    protected static void deleteDir(File aDir) {
        try {
            File[] contents;
            for (File aFile : contents = aDir.listFiles()) {
                if (aFile.isDirectory()) {
                    RecoveryTest.deleteDir(aFile);
                    continue;
                }
                if (aFile.delete()) continue;
                throw new TestException("Could not delete " + aFile.getCanonicalPath());
            }
            if (!aDir.delete()) {
                throw new TestException("Could not delete " + aDir.getCanonicalPath());
            }
            Log.getLogWriter().info("Successfully deleted " + aDir.getCanonicalPath());
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected static void deleteExistingDiskDirs() {
        File[] contents;
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (File aDir : contents = currDir.listFiles()) {
            if (!aDir.isDirectory() || aDir.getName().indexOf("_disk_") < 0 || aDir.list().length == 0) continue;
            RecoveryTest.deleteDir(aDir);
        }
    }

    protected static void registerInterest() {
        Set rootRegions = theCache.rootRegions();
        for (Region aRegion : rootRegions) {
            Log.getLogWriter().info("Calling registerInterest for all keys, result interest policy KEYS_VALUES for region " + aRegion.getFullPath());
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Done calling registerInterest for all keys, result interest policy KEYS_VALUES, " + aRegion.getFullPath() + " size is " + aRegion.size());
        }
    }

    protected static long logExecutionNumber() {
        long exeNum = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.executionNumber);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        return exeNum;
    }

    private static List<ClientVmInfo> getMarkedVMs(String targetMarkerValue) {
        Map aMap = RecoveryBB.getBB().getSharedMap().getMap();
        ArrayList<ClientVmInfo> aList = new ArrayList<ClientVmInfo>();
        for (Object objKey : aMap.keySet()) {
            String markerValue;
            String key;
            if (!(objKey instanceof String) || !(key = (String)objKey).startsWith(vmMarkerKey) || !(markerValue = (String)aMap.get(key)).equals(targetMarkerValue)) continue;
            Integer vmID = Integer.valueOf(key.substring(vmMarkerKey.length(), key.length()));
            ClientVmInfo info = new ClientVmInfo(vmID);
            aList.add(info);
        }
        return aList;
    }

    private static void markDataSource(ClientVmInfo aVM, boolean expectDiskRecovery) {
        if (expectDiskRecovery) {
            Log.getLogWriter().info("Marking in the blackboard that vm with ID " + aVM.getVmid() + " expects disk recovery");
        } else {
            Log.getLogWriter().info("Marking in the blackboard that vm with ID " + aVM.getVmid() + " expects to obtain data from a remote peer (gii)");
        }
        RecoveryBB.getBB().getSharedMap().put(expectDiskRecoveryKey + aVM.getVmid(), new Boolean(expectDiskRecovery));
    }

    private static void markDataSource(List<ClientVmInfo> aList, boolean expectDiskRecovery) {
        for (ClientVmInfo info : aList) {
            RecoveryTest.markDataSource(info, expectDiskRecovery);
        }
    }

    protected static void checkForLastIteration() {
        int secondsToRun = RecoveryPrms.getSecondsToRun();
        long taskStartTime = 0L;
        String bbKey = "taskStartTime";
        Object anObj = RecoveryBB.getBB().getSharedMap().get("taskStartTime");
        if (anObj == null) {
            taskStartTime = System.currentTimeMillis();
            RecoveryBB.getBB().getSharedMap().put("taskStartTime", new Long(taskStartTime));
            Log.getLogWriter().info("Initialized taskStartTime to " + taskStartTime);
        } else {
            taskStartTime = (Long)anObj;
        }
        if (System.currentTimeMillis() - taskStartTime >= (long)(secondsToRun * 1000)) {
            Log.getLogWriter().info("This is the last iteration of this task");
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.timeToStop);
        } else {
            Log.getLogWriter().info("Running for " + secondsToRun + " seconds; time remaining is " + ((long)secondsToRun - (System.currentTimeMillis() - taskStartTime) / 1000L) + " seconds");
        }
    }

    protected Object obtainNewKey() {
        if (this.uniqueKeys) {
            int thisThreadID = RemoteTestModule.getCurrentThread().getThreadId();
            int anInt = (Integer)RecoveryBB.getBB().getSharedMap().get(uniqueKeyIndex + thisThreadID);
            RecoveryBB.getBB().getSharedMap().put(uniqueKeyIndex + thisThreadID, anInt += TestHelper.getNumThreads());
            NameBB.getBB().getSharedCounters().setIfLarger(NameBB.POSITIVE_NAME_COUNTER, anInt);
            return NameFactory.getObjectNameForCounter(anInt);
        }
        return NameFactory.getNextPositiveObjectName();
    }

    private Object getValueForKey(Object key) {
        String valueClassName = RecoveryPrms.getValueClassName();
        BaseValueHolder vh = null;
        if (valueClassName.equals(ValueHolder.class.getName())) {
            vh = new ValueHolder((String)key, this.randomValues);
        } else if (valueClassName.equals(VHDataSerializable.class.getName())) {
            vh = new VHDataSerializable((String)key, this.randomValues);
        } else if (valueClassName.equals(VHDataSerializableInstantiator.class.getName())) {
            vh = new VHDataSerializableInstantiator((String)key, this.randomValues);
        } else {
            if (valueClassName.equals("util.PdxVersionedValueHolder") || valueClassName.equals("util.VersionedValueHolder")) {
                vh = RecoveryTestVersionHelper.getVersionedValueHolder(valueClassName, (String)key, this.randomValues);
                return vh;
            }
            throw new TestException("Test does not support RecoveryPrms.valueClassName " + valueClassName);
        }
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Object anObj = vh.extraObject;
            if (anObj == null) {
                throw new TestException("Test config problem: ValueHolder does not have extraObj");
            }
            return anObj;
        }
        return vh;
    }

    protected Object getUpdateObject(Region r, String key) {
        Object anObj = r.get((Object)key);
        Object newObj = null;
        newObj = anObj == null || !(anObj instanceof BaseValueHolder) ? this.getValueForKey(key) : ((BaseValueHolder)anObj).getAlternateValueHolder(this.randomValues);
        if (newObj instanceof BaseValueHolder && TestConfig.tab().getRandGen().nextBoolean()) {
            return ((BaseValueHolder)newObj).extraObject;
        }
        return newObj;
    }

    protected static String getRegionCreatedKey(int vmID, String regionName) {
        return "regionCreatedInVM_" + vmID + "_regionName_" + regionName;
    }

    private void createDiskDirBackup(String backupDirName) {
        PrintWriter aFile;
        Log.getLogWriter().info("Making a copy of all disk directories in " + backupDirName);
        File backupDir = new File(backupDirName);
        if (backupDir.exists()) {
            throw new TestException("Backup directory " + backupDirName + " already exists");
        }
        backupDir.mkdir();
        String scriptFileName = "makeBackup.sh";
        File scriptFile = new File(scriptFileName);
        try {
            aFile = new PrintWriter(new FileOutputStream(scriptFile));
        }
        catch (FileNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        aFile.print("#! /bin/sh\ncp -r vm*_disk_* $1\n");
        aFile.flush();
        aFile.close();
        String cmd = "/bin/bash " + scriptFileName + " " + backupDirName;
        String cmdResults = ProcessMgr.fgexec(cmd, 0);
        Log.getLogWriter().info("Results from " + cmd + " is " + cmdResults);
    }

    public static String getXmlFileName(int vmID) {
        List infoList = StopStartVMs.getAllVMs();
        for (ClientVmInfo info : infoList) {
            if (info.getVmid() != vmID) continue;
            String clientName = info.getClientName();
            String fileName = "vm_" + vmID;
            if (clientName.indexOf("oldVersion") >= 0) {
                fileName = fileName + "_oldVersion";
            } else if (clientName.indexOf("newVersion") >= 0) {
                fileName = fileName + "_newVersion";
            }
            return fileName + ".xml";
        }
        throw new TestException("Could not determine clientName for vmID " + vmID);
    }

    private static int getVmIdFromXmlFileName(String xmlFileName) {
        String searchStr = "vm_";
        int index = xmlFileName.indexOf(searchStr);
        int index2 = xmlFileName.indexOf("_", index + searchStr.length());
        int vmID = Integer.valueOf(xmlFileName.substring(index + searchStr.length(), index2));
        return vmID;
    }

    private static int doSingleConvert(boolean convertRandom) throws TestException {
        String[] dirContents;
        int myVmId = RemoteTestModule.getMyVmid();
        ArrayList<String> oldXmlFiles = new ArrayList<String>();
        ArrayList<String> newXmlFiles = new ArrayList<String>();
        int indexToConvert = -1;
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (String fileName : dirContents = currDir.list()) {
            if (!fileName.endsWith(".xml")) continue;
            if (fileName.indexOf("oldVersion") >= 0) {
                oldXmlFiles.add(fileName);
                continue;
            }
            if (fileName.indexOf("newVersion") < 0) continue;
            newXmlFiles.add(fileName);
            if (!fileName.startsWith("vm_" + myVmId + "_")) continue;
            indexToConvert = newXmlFiles.size() - 1;
        }
        if (convertRandom) {
            indexToConvert = TestConfig.tab().getRandGen().nextInt(0, oldXmlFiles.size() - 1);
        }
        if (oldXmlFiles.size() != newXmlFiles.size()) {
            throw new TestException("Test expects equal number of oldVersion and newVersion *.xml files");
        }
        RecoveryBB.getBB().getSharedMap().put(oldVersionXmlFilesKey, oldXmlFiles);
        RecoveryBB.getBB().getSharedMap().put(newVersionXmlFilesKey, newXmlFiles);
        String oldXmlFile = (String)oldXmlFiles.get(indexToConvert);
        String newXmlFile = (String)newXmlFiles.get(indexToConvert);
        if (RecoveryPrms.getConvertWithNewVersionXml()) {
            RecoveryTest.convertPre65AndValidate(oldXmlFile, newXmlFile);
        } else {
            RecoveryTest.convertPre65AndValidate(oldXmlFile, oldXmlFile);
        }
        return indexToConvert;
    }

    private void removeExtraRegionsFromAllRegions() {
        ArrayList<Region> allRegionsExceptExtra = new ArrayList<Region>();
        for (Region aRegion : RecoveryTest.testInstance.allRegions) {
            if (aRegion.getName().startsWith("extra")) continue;
            allRegionsExceptExtra.add(aRegion);
        }
        this.allRegions = allRegionsExceptExtra;
    }

    public static void HydraTask_rvvConvertOperationsController() {
        new RecoveryTest().rvvConvertOperationsController();
    }

    private void rvvConvertOperationsController() {
        RecoveryTest.logExecutionNumber();
        RecoveryTest.checkForLastIteration();
        boolean firstControllerExecution = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L;
        List newVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        if (firstControllerExecution) {
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (int i = 1; i <= newVersionVMs.size(); ++i) {
                stopModeList.add("MEAN_KILL");
            }
            StopStartVMs.stopVMs(newVersionVMs, stopModeList);
        }
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Sleeping for " + minTaskGranularityMS + " ms to allow other vms to do random ops...");
        MasterController.sleepForMs((int)minTaskGranularityMS);
        Log.getLogWriter().info("Pausing...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.pausing", RecoveryBB.pausing, TestHelper.getNumThreads() / 2, true, -1L, 2000L);
        SummaryLogListener.waitForSilence(30L, 1000L);
        Log.getLogWriter().info("Directing responder to write to the blackboard...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.writeSnapshot);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 2000L);
        Log.getLogWriter().info("Directing oldVersionAdmin to backup disk files ...");
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.backupDiskFiles);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.backupCompleted", RecoveryBB.backupCompleted, 1L, true, -1L, 2000L);
        List targetVMs = StopStartVMs.getAllVMs();
        targetVMs = firstControllerExecution ? StopStartVMs.getMatchVMs(targetVMs, "oldVersion") : StopStartVMs.getMatchVMs(targetVMs, "newVersion");
        ArrayList<String> stopModesList = new ArrayList<String>();
        for (int i = 1; i <= targetVMs.size(); ++i) {
            stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        if (RecoveryPrms.getUseShutDownAll()) {
            AdminDistributedSystem adminDS = AdminHelper.getAdminDistributedSystem();
            if (adminDS == null) {
                throw new TestException("Test is configured to use shutDownAllMembers, but this vm must be an admin vm to use it");
            }
            Object[] anArr = StopStartVMs.shutDownAllMembers(adminDS);
            targetVMs = (List)anArr[0];
        }
        StopStartVMs.stopVMs(targetVMs, stopModesList);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.pausing);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.writeSnapshot);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.snapshotWritten);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.leader);
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
        if (firstControllerExecution) {
            Log.getLogWriter().info("Directing oldVersionAdmin to run offline validation and compaction on old disk files ...");
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.compactOldVersionFiles);
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.compactionCompleted", RecoveryBB.compactionCompleted, 1L, true, -1L, 2000L);
            RecoveryTest.rvvConvert();
            StopStartVMs.startVMs(newVersionVMs);
        } else {
            StopStartVMs.startVMs(targetVMs);
        }
        long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
        if (counter >= 1L) {
            throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
        }
    }

    public static void HydraTask_rvvConvertOperationsResponder() throws Exception {
        String clientName = System.getProperty("clientName");
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) <= 1L) {
            if (clientName.indexOf("newVersion") >= 0) {
                Log.getLogWriter().info("Sleeping for 10 seconds...");
                MasterController.sleepForMs(10000);
                return;
            }
            if (clientName.indexOf("oldVersionAdmin") >= 0) {
                long backupDiskFiles = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.backupDiskFiles);
                long backupCompleted = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.backupCompleted);
                if (backupDiskFiles > 0L && backupCompleted == 0L) {
                    if (!CliHelperPrms.getUseCli()) {
                        PersistenceUtil.doOnlineBackup(false);
                    }
                    RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.backupCompleted);
                } else {
                    long compactOldVersionFiles = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.compactOldVersionFiles);
                    long compactionCompleted = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.compactionCompleted);
                    if (compactOldVersionFiles > 0L && compactionCompleted == 0L) {
                        if (!CliHelperPrms.getUseCli()) {
                            RecoveryTest.doOfflineValAndCompaction();
                        }
                        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.compactionCompleted);
                    } else {
                        Log.getLogWriter().info("Sleeping for 10 seconds...");
                        MasterController.sleepForMs(10000);
                    }
                }
                return;
            }
        }
        if (clientName.indexOf("oldVersionAdmin") >= 0) {
            MasterController.sleepForMs(10000);
        } else {
            testInstance.operationsResponder();
        }
    }

    public static void HydraTask_convertPre70Controller() {
        List newVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        newVersionVMs.removeAll(StopStartVMs.getMatchVMs(newVersionVMs, "newVersionLocator"));
        ArrayList<String> stopModesList = new ArrayList<String>();
        for (int i = 1; i <= newVersionVMs.size(); ++i) {
            stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        StopStartVMs.stopVMs(newVersionVMs, stopModesList);
        int sleepMs = 60000;
        Log.getLogWriter().info("Sleeping " + sleepMs + "ms so ops can run...");
        MasterController.sleepForMs(sleepMs);
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.stoppingVMs);
        List oldVersionVMs = StopStartVMs.getAllVMs();
        oldVersionVMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion");
        for (ClientVmInfo target : oldVersionVMs) {
            try {
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, target);
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.stoppingVMs);
        RecoveryTest.rvvConvert();
        StopStartVMs.startVMs(newVersionVMs);
    }

    public static void HydraTask_rvvConvertVerifyFromSnapshotAndSync() {
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L && RecoveryPrms.getConvertWithNewVersionXml()) {
            List[] aList = RecoveryTest.extractFromXmlFile(RecoveryTest.getXmlFileName(RemoteTestModule.getMyVmid()));
            List regionNames = aList[0];
            Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
            for (int i = 0; i < regionNames.size(); ++i) {
                String rName = (String)regionNames.get(i);
                if (!rName.startsWith("/extra") || allRegionsSnapshot.containsKey(rName)) continue;
                Log.getLogWriter().info("Adding region " + rName + " to snapshot");
                allRegionsSnapshot.put(rName, new HashMap());
            }
            RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        }
        testInstance.verifyFromSnapshot();
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads(), true, -1L, 2000L);
        RecoveryTest.HydraTask_prepareForNewVersionOps();
    }

    public static void HydraTask_rvvConvertVerifyFromSnapshot() {
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber) == 1L && RecoveryPrms.getConvertWithNewVersionXml()) {
            List[] aList = RecoveryTest.extractFromXmlFile(RecoveryTest.getXmlFileName(RemoteTestModule.getMyVmid()));
            List regionNames = aList[0];
            Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
            for (int i = 0; i < regionNames.size(); ++i) {
                String rName = (String)regionNames.get(i);
                if (!rName.startsWith("/extra") || allRegionsSnapshot.containsKey(rName)) continue;
                Log.getLogWriter().info("Adding region " + rName + " to snapshot");
                allRegionsSnapshot.put(rName, new HashMap());
            }
            RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        }
        MasterController.sleepForMs(15000);
        SummaryLogListener.waitForSilence(30L, 2000L);
        testInstance.verifyFromSnapshot();
        RecoveryTest.HydraTask_prepareForNewVersionOps();
    }

    public static void HydraTask_rvvConvertWANTestController() {
        RecoveryTest.logExecutionNumber();
        List newVersionVMs = StopStartVMs.getAllVMs();
        List oldVersionVMs = StopStartVMs.getAllVMs();
        newVersionVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion");
        oldVersionVMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion");
        List newLocators = StopStartVMs.getMatchVMs(newVersionVMs, "newVersionLocator");
        for (ClientVmInfo info : newLocators) {
            if (info.getVmid() != RemoteTestModule.getMyVmid()) continue;
            newLocators.remove(info);
            break;
        }
        List oldLocators = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersionLocator");
        List newWanSite1VMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_1_");
        List newWanSite2VMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_2_");
        List newWanSite3VMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_3_");
        List oldWanSite1VMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion_1_");
        List oldWanSite2VMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion_2_");
        List oldWanSite3VMs = StopStartVMs.getMatchVMs(oldVersionVMs, "oldVersion_3_");
        Log.getLogWriter().info("newVersionVMs: " + newVersionVMs);
        Log.getLogWriter().info("oldVersionVMs: " + oldVersionVMs);
        Log.getLogWriter().info("newWanSite1VMs: " + newWanSite1VMs);
        Log.getLogWriter().info("newWanSite2VMs: " + newWanSite2VMs);
        Log.getLogWriter().info("newWanSite3VMs: " + newWanSite3VMs);
        Log.getLogWriter().info("oldWanSite1VMs: " + oldWanSite1VMs);
        Log.getLogWriter().info("oldWanSite2VMs: " + oldWanSite2VMs);
        Log.getLogWriter().info("oldWanSite3VMs: " + oldWanSite3VMs);
        ArrayList<String> stopModesList = new ArrayList<String>();
        List targetVMs = StopStartVMs.getMatchVMs(newVersionVMs, "newVersion_");
        for (int i = 1; i <= targetVMs.size(); ++i) {
            stopModesList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
        }
        StopStartVMs.stopVMs(targetVMs, stopModesList);
        StopStartVMs.stopVMs(newLocators, stopModesList);
        int sleepMs = 60000;
        Log.getLogWriter().info("Sleeping " + sleepMs + "ms so ops can run...");
        MasterController.sleepForMs(sleepMs);
        try {
            for (int i = 1; i < oldWanSite1VMs.size(); ++i) {
                Log.getLogWriter().info("Stopping: " + oldWanSite1VMs.get(i));
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite1VMs.get(i));
                Log.getLogWriter().info("Stopping: " + oldWanSite2VMs.get(i));
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite2VMs.get(i));
                Log.getLogWriter().info("Stopping: " + oldWanSite3VMs.get(i));
                ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite3VMs.get(i));
            }
            Log.getLogWriter().info("Stopping: " + oldWanSite2VMs.get(0));
            ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite2VMs.get(0));
            Log.getLogWriter().info("Stopping: " + oldWanSite3VMs.get(0));
            ClientVmMgr.stop("Stopping old version vm", ClientVmMgr.toStopMode(TestConfig.tab().stringAt(StopStartPrms.stopModes)), -31, (ClientVmInfo)oldWanSite3VMs.get(0));
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
        TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.snapshotWritten", RecoveryBB.snapshotWritten, 1L, true, -1L, 1000L);
        try {
            Log.getLogWriter().info("Stopping: " + oldWanSite1VMs.get(0));
            ClientVmMgr.stop("Stopping old version vm", -21, -31, (ClientVmInfo)oldWanSite1VMs.get(0));
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Stopping the old version locator(s)");
        for (ClientVmInfo info : oldLocators) {
            try {
                ClientVmMgr.stop("Stopping old version locator", -21, -31, info);
            }
            catch (ClientVmNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        ArrayList<String> oldXmlFiles = new ArrayList<String>();
        oldXmlFiles.add(0, RecoveryTest.getXmlFileName(((ClientVmInfo)oldWanSite1VMs.get(0)).getVmid()));
        oldXmlFiles.add(1, RecoveryTest.getXmlFileName(((ClientVmInfo)oldWanSite2VMs.get(0)).getVmid()));
        oldXmlFiles.add(2, RecoveryTest.getXmlFileName(((ClientVmInfo)oldWanSite3VMs.get(0)).getVmid()));
        ArrayList<String> newXmlFiles = new ArrayList<String>();
        newXmlFiles.add(0, RecoveryTest.getXmlFileName(((ClientVmInfo)newWanSite1VMs.get(0)).getVmid()));
        newXmlFiles.add(1, RecoveryTest.getXmlFileName(((ClientVmInfo)newWanSite2VMs.get(0)).getVmid()));
        newXmlFiles.add(2, RecoveryTest.getXmlFileName(((ClientVmInfo)newWanSite3VMs.get(0)).getVmid()));
        RecoveryTest.rvvConvert(oldXmlFiles, newXmlFiles);
        GatewayHubBlackboard.getInstance().getSharedMap().clear();
        DistributedSystemBlackboard.getInstance().getSharedMap().clear();
        StopStartVMs.startVMs(newLocators);
        try {
            Log.getLogWriter().info("Starting: " + newWanSite1VMs.get(0));
            ClientVmMgr.start("Starting after conversion", (ClientVmInfo)newWanSite1VMs.get(0));
            Log.getLogWriter().info("Starting: " + newWanSite2VMs.get(0));
            ClientVmMgr.start("Starting after conversion", (ClientVmInfo)newWanSite2VMs.get(0));
            Log.getLogWriter().info("Starting: " + newWanSite3VMs.get(0));
            ClientVmMgr.start("Starting after conversion", (ClientVmInfo)newWanSite3VMs.get(0));
        }
        catch (ClientVmNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_rvvConvertWANTestResponder() throws Exception {
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        testInstance.doOperations(minTaskGranularityMS);
        if (RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.pausing) > 0L) {
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.pausing);
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.Pausing", RecoveryBB.pausing, 11L, true, -1L, 1000L);
            long leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader);
            if (leader == 1L) {
                RecoveryTest.HydraTask_writeToBB();
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.snapshotWritten);
            }
            MasterController.sleepForMs(Integer.MAX_VALUE);
        }
    }

    public static void HydraTask_rvvConvert() {
        long leader = RecoveryBB.getBB().getSharedCounters().incrementAndRead(RecoveryBB.leader);
        if (leader == 1L) {
            RecoveryTest.rvvConvert();
        }
    }

    public static void rvvConvert() {
        String[] dirContents;
        ArrayList<String> oldXmlFiles = new ArrayList<String>();
        ArrayList<String> newXmlFiles = new ArrayList<String>();
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (String fileName : dirContents = currDir.list()) {
            if (!fileName.endsWith(".xml")) continue;
            if (fileName.indexOf("oldVersion") >= 0) {
                oldXmlFiles.add(fileName);
                continue;
            }
            if (fileName.indexOf("newVersion") < 0) continue;
            newXmlFiles.add(fileName);
        }
        RecoveryTest.rvvConvert(oldXmlFiles, newXmlFiles);
    }

    public static void rvvConvert(List<String> oldXmlFiles, List<String> newXmlFiles) {
        Log.getLogWriter().info("Converting diskStores to 7.0 (RVV) format ...");
        RecoveryBB.getBB().getSharedMap().put(oldVersionXmlFilesKey, oldXmlFiles);
        RecoveryBB.getBB().getSharedMap().put(newVersionXmlFilesKey, newXmlFiles);
        RecoveryTest.listDiskFiles();
        for (String filename : oldXmlFiles) {
            List[] oldVersionXmlInfo = RecoveryTest.extractFromXmlFile(filename);
            List oldVersionRegionNames = oldVersionXmlInfo[0];
            List oldVersionDiskStoreNames = oldVersionXmlInfo[1];
            List oldVersionDiskDirs = oldVersionXmlInfo[2];
            List oldVersionDataPolicy = oldVersionXmlInfo[3];
            HashSet uniqueDiskStoreNames = new HashSet(oldVersionDiskStoreNames);
            for (String diskStoreName : uniqueDiskStoreNames) {
                if (diskStoreName == null) continue;
                HashSet persistRegNamesForDiskStore = new HashSet();
                HashSet diskDirsForDiskStore = new HashSet();
                for (int i = 0; i < oldVersionDiskStoreNames.size(); ++i) {
                    if (oldVersionDiskStoreNames.get(i) == null || !((String)oldVersionDiskStoreNames.get(i)).equals(diskStoreName)) continue;
                    diskDirsForDiskStore.addAll((Collection)oldVersionDiskDirs.get(i));
                    if (oldVersionDataPolicy.get(i) == null || ((String)oldVersionDataPolicy.get(i)).indexOf("persistent") < 0) continue;
                    persistRegNamesForDiskStore.add(oldVersionRegionNames.get(i));
                }
                ArrayList<File> diskDirsAsFile = new ArrayList<File>();
                for (String diskDirPath : diskDirsForDiskStore) {
                    diskDirsAsFile.add(new File(diskDirPath));
                }
                File[] diskDirArr = new File[diskDirsAsFile.size()];
                diskDirsAsFile.toArray(diskDirArr);
                if (diskDirArr.length <= 0 || !RecoveryTest.hasDiskInitFile(diskStoreName, diskDirArr)) continue;
                try {
                    RecoveryTest.rvvConvert(diskStoreName, diskDirArr);
                }
                catch (HydraRuntimeException e) {
                    if (persistRegNamesForDiskStore.size() == 0) {
                        String errStr = e.getCause().toString();
                        if (errStr.indexOf("The init file") >= 0 && errStr.indexOf(" does not exist") > 0) {
                            Log.getLogWriter().info("Got expected exception " + (Object)((Object)e) + " with cause " + errStr + " due to no persistent regions in " + " DiskStore " + diskStoreName);
                            continue;
                        }
                        throw e;
                    }
                    throw e;
                }
            }
        }
        RecoveryTest.listDiskFiles();
        if (RecoveryPrms.getConvertWithNewVersionXml()) {
            RecoveryTest.moveDiskFiles(oldXmlFiles, newXmlFiles);
        }
    }

    protected static boolean hasDiskInitFile(String diskStoreName, File[] diskDirArr) {
        boolean hasBackupIfFile = false;
        for (File diskDir : diskDirArr) {
            String[] diskDirFileNames;
            for (String diskFileName : diskDirFileNames = diskDir.list()) {
                String searchStr1 = "BACKUP";
                String searchStr2 = ".if";
                if (!diskFileName.startsWith(searchStr1) || diskFileName.indexOf(diskStoreName + "_") <= 0 && diskFileName.indexOf(diskStoreName + ".") <= 0 || !diskFileName.endsWith(searchStr2)) continue;
                Log.getLogWriter().info("diskInitFile " + diskFileName + " found in " + diskDir.getName());
                hasBackupIfFile = true;
            }
        }
        return hasBackupIfFile;
    }

    protected static void rvvConvert(String diskStoreName, File[] diskDirArr) {
        HydraVector diskStoreNames = TestConfig.tab().vecAt(DiskStorePrms.names);
        int i = diskStoreNames.indexOf(diskStoreName);
        HydraVector maxOpLogSizes = TestConfig.tab().vecAt(DiskStorePrms.maxOplogSize, new HydraVector());
        long opLogSize = 0L;
        opLogSize = maxOpLogSizes.size() == 0 || i < 0 || i >= maxOpLogSizes.size() ? DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE : Long.valueOf((String)maxOpLogSizes.get(i));
        if (RecoveryTest.hasDiskInitFile(diskStoreName, diskDirArr)) {
            RecoveryTest.rvvConvert(diskStoreName, diskDirArr, opLogSize);
        } else {
            Log.getLogWriter().info("Not converting files in " + diskDirArr + " for " + diskStoreName + " no BACKUP" + diskStoreName + ".if file exists");
        }
    }

    private static void rvvConvert(String diskStoreName, File[] diskDirArr, long opLogSize) {
        String diskDirStr = "";
        String delimeter = " ";
        if (CliHelperPrms.getUseCli()) {
            delimeter = ",";
        }
        for (int i = 0; i < diskDirArr.length; ++i) {
            File diskDir = diskDirArr[i];
            diskDirStr = diskDirStr + diskDir.getAbsolutePath();
            if (i >= diskDirArr.length - 1) continue;
            diskDirStr = diskDirStr + delimeter;
        }
        diskDirStr = diskDirStr + " ";
        String result = null;
        if (CliHelperPrms.getUseCli()) {
            CommandTest.HydraTask_initAndConnectCLI();
            String command = "upgrade offline-disk-store --name=" + diskStoreName + " --disk-dirs=" + diskDirStr + " --max-oplog-size=" + opLogSize;
            result = CliHelper.execCommandLocally(command, true)[1];
        } else {
            String exeName = "gemfire";
            String command = "env GF_JAVA=" + System.getProperty("java.home") + "/bin/java ";
            if (HostHelper.isWindows()) {
                exeName = "gemfire.bat";
                command = "cmd /c set GF_JAVA=" + System.getProperty("java.home") + "/bin/java.exe && cmd /c ";
            }
            command = command + System.getProperty("gemfire.home") + File.separator + "bin" + File.separator + exeName + " upgrade-disk-store " + diskStoreName + " " + diskDirStr + "-maxOplogSize=" + opLogSize;
            Log.getLogWriter().info("Calling offline conversion tool with diskStoreName " + diskStoreName + ", disk dirs " + diskDirStr + " and opLogSize " + opLogSize);
            long startTime = System.currentTimeMillis();
            result = ProcessMgr.fgexec(command, 0);
            long duration = System.currentTimeMillis() - startTime;
            Log.getLogWriter().info("Done calling offline conversion tool, result is " + result + ", conversion took " + duration + " ms");
        }
        if (result.indexOf("Upgrade disk store") < 0) {
            throw new TestException("Offline conversion tool returned " + result);
        }
    }

    public static void HydraTask_doOnlineBackup() {
        PersistenceUtil.doOnlineBackup(false);
    }

    protected static void doOfflineValAndCompaction() {
        String[] dirContents;
        ArrayList<String> oldXmlFiles = new ArrayList<String>();
        String currDirName = System.getProperty("user.dir");
        File currDir = new File(currDirName);
        for (String fileName : dirContents = currDir.list()) {
            if (!fileName.endsWith(".xml") || fileName.indexOf("oldVersion") < 0) continue;
            oldXmlFiles.add(fileName);
        }
        for (String filename : oldXmlFiles) {
            List[] oldVersionXmlInfo = RecoveryTest.extractFromXmlFile(filename);
            List oldVersionRegionNames = oldVersionXmlInfo[0];
            List oldVersionDiskStoreNames = oldVersionXmlInfo[1];
            List oldVersionDiskDirs = oldVersionXmlInfo[2];
            List oldVersionDataPolicy = oldVersionXmlInfo[3];
            HashSet uniqueDiskStoreNames = new HashSet(oldVersionDiskStoreNames);
            for (String diskStoreName : uniqueDiskStoreNames) {
                if (diskStoreName == null) continue;
                HashSet persistRegNamesForDiskStore = new HashSet();
                HashSet diskDirsForDiskStore = new HashSet();
                for (int i = 0; i < oldVersionDiskStoreNames.size(); ++i) {
                    if (oldVersionDiskStoreNames.get(i) == null || !((String)oldVersionDiskStoreNames.get(i)).equals(diskStoreName)) continue;
                    diskDirsForDiskStore.addAll((Collection)oldVersionDiskDirs.get(i));
                    if (oldVersionDataPolicy.get(i) == null || ((String)oldVersionDataPolicy.get(i)).indexOf("persistent") < 0) continue;
                    persistRegNamesForDiskStore.add(oldVersionRegionNames.get(i));
                }
                ArrayList<File> diskDirsAsFile = new ArrayList<File>();
                for (String diskDirPath : diskDirsForDiskStore) {
                    diskDirsAsFile.add(new File(diskDirPath));
                }
                File[] diskDirArr = new File[diskDirsAsFile.size()];
                diskDirsAsFile.toArray(diskDirArr);
                if (diskDirArr.length <= 0 || !RecoveryTest.hasDiskInitFile(diskStoreName, diskDirArr)) continue;
                try {
                    PersistenceUtil.runOfflineValAndCompaction(diskStoreName, diskDirArr);
                }
                catch (TestException e) {
                    if (persistRegNamesForDiskStore.size() == 0) {
                        String errStr = e.toString();
                        if (errStr.indexOf("The init file") >= 0 && errStr.indexOf(" does not exist") > 0) {
                            Log.getLogWriter().info("Got expected exception " + e + " with cause " + errStr + " due to no persistent regions in " + " DiskStore " + diskStoreName);
                            continue;
                        }
                        throw e;
                    }
                    Log.getLogWriter().info("Expected disk files for " + diskStoreName + " with persistent regions " + persistRegNamesForDiskStore);
                    throw e;
                }
            }
        }
    }

    public static void HydraTask_tombstoneTestController() {
        testInstance.tombstoneTestController();
    }

    private void tombstoneTestController() {
        String currentTaskStep = (String)RecoveryBB.getBB().getSharedMap().get("taskStep");
        Log.getLogWriter().info("In tombstoneTestController, currentTaskStep is " + currentTaskStep);
        if (currentTaskStep.equals(STARTING_STEP)) {
            RecoveryTest.logExecutionNumber();
            RecoveryTest.checkForLastIteration();
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneDestroyingCounter);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneAddingCounter);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneVerifyingCounter);
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneStartingCounter", RecoveryBB.doneStartingCounter, TestHelper.getNumVMs() - 1, true, -1L, 1000L);
            currentTaskStep = VERIFY_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneStartingCounter);
            return;
        }
        if (currentTaskStep.equals(VERIFY_STEP)) {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, TestHelper.getNumVMs() - 1, true, -1L, 5000L);
            NameBB.getBB().getSharedCounters().zero(NameBB.POSITIVE_NAME_COUNTER);
            currentTaskStep = ADD_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
            return;
        }
        if (currentTaskStep.equals(ADD_STEP)) {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneAddingCounter", RecoveryBB.doneAddingCounter, TestHelper.getNumThreads() - 1, true, -1L, 10000L);
            currentTaskStep = DESTROY_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneAddingCounter);
            return;
        }
        if (currentTaskStep.equals(DESTROY_STEP)) {
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneDestroyingCounter", RecoveryBB.doneDestroyingCounter, TestHelper.getNumThreads() - 1, true, -1L, 10000L);
            currentTaskStep = STOP_START_STEP;
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneDestroyingCounter);
            return;
        }
        if (currentTaskStep.equals(STOP_START_STEP)) {
            Vector otherVmIds = ClientVmMgr.getOtherClientVmids();
            ArrayList<ClientVmInfo> otherVMs = new ArrayList<ClientVmInfo>();
            ArrayList<ClientVmInfo> replicateVMs = new ArrayList<ClientVmInfo>();
            ArrayList<ClientVmInfo> persistentVMs = new ArrayList<ClientVmInfo>();
            ArrayList<String> stopModeList = new ArrayList<String>();
            for (int i = 0; i < otherVmIds.size(); ++i) {
                Integer otherVmId = (Integer)otherVmIds.get(i);
                ClientVmInfo info = new ClientVmInfo(otherVmId);
                otherVMs.add(info);
                if (RecoveryBB.getBB().getSharedMap().containsKey(persistentRegionKey + otherVmId)) {
                    persistentVMs.add(info);
                } else {
                    replicateVMs.add(info);
                }
                String choice = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                stopModeList.add(choice);
            }
            StopStartVMs.stopVMs(otherVMs, stopModeList);
            Log.getLogWriter().info("Sleeping for 60 seconds to allow tombstone-gc");
            MasterController.sleepForMs(60000);
            Log.getLogWriter().info("Finished sleeping for 60 seconds to allow tombstone-gc");
            currentTaskStep = STARTING_STEP;
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneStartingCounter);
            RecoveryBB.getBB().getSharedCounters().zero(RecoveryBB.doneAddingCounter);
            Log.getLogWriter().info("Changing currentTaskStep to " + currentTaskStep);
            RecoveryBB.getBB().getSharedMap().put("taskStep", currentTaskStep);
            long counter = RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.timeToStop);
            if (counter >= 1L) {
                throw new StopSchedulingOrder("Num controller executions is " + RecoveryBB.getBB().getSharedCounters().read(RecoveryBB.executionNumber));
            }
            StopStartVMs.startVMs(persistentVMs);
            StopStartVMs.startVMs(replicateVMs);
        }
    }

    public static void HydraTask_tombstoneTestResponder() {
        testInstance.tombstoneTestResponder();
    }

    private void tombstoneTestResponder() {
        String currentTaskStep = (String)RecoveryBB.getBB().getSharedMap().get("taskStep");
        Log.getLogWriter().info("In tombstoneTestResponder, currentTaskStep is " + currentTaskStep);
        if (currentTaskStep.equals(STARTING_STEP)) {
            if (this.startingCoordinator.incrementAndGet() == 1) {
                Log.getLogWriter().info("Initializing for startup...");
                this.verifyCoordinator = new AtomicInteger(0);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneStartingCounter);
            }
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneStartingCounter", RecoveryBB.doneStartingCounter, TestHelper.getNumVMs(), true, -1L, 1000L);
        } else if (currentTaskStep.equals(VERIFY_STEP)) {
            int coord = this.verifyCoordinator.incrementAndGet();
            if (coord == 1) {
                this.verifyAllRegionsEmpty();
                this.startingCoordinator = new AtomicInteger(0);
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneVerifyingCounter);
            }
            TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneVerifyingCounter", RecoveryBB.doneVerifyingCounter, TestHelper.getNumVMs(), true, -1L, 1000L);
        } else if (currentTaskStep.equals(ADD_STEP)) {
            if (((Boolean)addsCompleted.get()).booleanValue()) {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneAddingCounter", RecoveryBB.doneAddingCounter, TestHelper.getNumThreads(), true, -1L, 1000L);
            } else {
                int numKeysToCreate = RecoveryPrms.getMaxNumEntriesPerRegion();
                long nameCounter = 0L;
                while (nameCounter < (long)numKeysToCreate) {
                    String key = NameFactory.getNextPositiveObjectName();
                    nameCounter = NameFactory.getCounterForName(key);
                    for (Region aRegion : this.allRegions) {
                        aRegion.put((Object)key, this.getValueForKey(key));
                    }
                }
                addsCompleted.set(new Boolean(true));
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneAddingCounter);
            }
        } else if (currentTaskStep.equals(DESTROY_STEP)) {
            if (((Boolean)destroysCompleted.get()).booleanValue()) {
                TestHelper.waitForCounter(RecoveryBB.getBB(), "RecoveryBB.doneDestroyingCounter", RecoveryBB.doneDestroyingCounter, TestHelper.getNumThreads(), true, -1L, 1000L);
            } else {
                String destroyMethod = RecoveryPrms.getDestroyMethod();
                Log.getLogWriter().info("Destroying all entries via " + destroyMethod);
                if (destroyMethod.equals("destroy")) {
                    this.destroyAllEntries();
                } else if (destroyMethod.equals("clearRegion")) {
                    this.clearAllRegions();
                } else if (destroyMethod.equals("expiration")) {
                    Log.getLogWriter().info("waiting 60 seconds for expiration");
                    MasterController.sleepForMs(60000);
                    Log.getLogWriter().info("Done waiting for expiration");
                } else {
                    throw new TestException("Test issue: no destroyMethod support for " + destroyMethod);
                }
                destroysCompleted.set(new Boolean(true));
                RecoveryBB.getBB().getSharedCounters().increment(RecoveryBB.doneDestroyingCounter);
            }
        } else if (currentTaskStep.equals(STOP_START_STEP)) {
            MasterController.sleepForMs(5000);
        }
    }

    protected void verifyAllRegionsEmpty() {
        Set testRegions = (Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey);
        Cache theCache = CacheHelper.getCache();
        for (String regionName : testRegions) {
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            if (aRegion.size() == 0) continue;
            throw new TestException("Region " + regionName + " is not empty (but should be).  region.size() = " + aRegion.size());
        }
        Log.getLogWriter().info("Successfully verified that all test regions are empty (size=0).  Regions - " + testRegions);
        NameBB.getBB().getSharedCounters().zero(NameBB.POSITIVE_NAME_COUNTER);
    }

    protected void destroyAllEntries() {
        Set testRegions = (Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey);
        Cache theCache = CacheHelper.getCache();
        for (String regionName : testRegions) {
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            for (Object key : aRegion.keySet()) {
                try {
                    aRegion.destroy(key);
                }
                catch (EntryNotFoundException entryNotFoundException) {}
            }
            Log.getLogWriter().info("Successfully destroyed all entries in " + regionName);
        }
    }

    protected void clearAllRegions() {
        Set testRegions = (Set)RecoveryBB.getBB().getSharedMap().get(allRegionNamesKey);
        Cache theCache = CacheHelper.getCache();
        for (String regionName : testRegions) {
            Region aRegion = theCache.getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            aRegion.clear();
            Log.getLogWriter().info("Successfully cleared " + regionName);
        }
    }

    public static void HydraTask_verifyDeltaGII() {
        testInstance.verifyDeltaGII();
    }

    private void verifyDeltaGII() {
        boolean expectDeltaGII = true;
        Log.getLogWriter().info("verifyDeltaGII: invoked. expectDeltaGII = " + expectDeltaGII + ". ");
        for (Region aRegion : this.allRegions) {
            String regionName = aRegion.getName();
            DiskRegion diskRegion = ((LocalRegion)aRegion).getDiskRegion();
            if (diskRegion != null && diskRegion.getStats().getRemoteInitializations() == 0) {
                Log.getLogWriter().info("verifyDeltaGII: " + regionName + " was recovered from disk (Remote Initializations = " + diskRegion.getStats().getRemoteInitializations() + ").");
                continue;
            }
            int giisCompleted = TestHelper.getStat_getInitialImagesCompleted(regionName);
            int deltaGiisCompleted = TestHelper.getStat_deltaGetInitialImagesCompleted(regionName);
            if (expectDeltaGII && deltaGiisCompleted == 0 || !expectDeltaGII && deltaGiisCompleted == 1) {
                throw new TestException("Did not perform expected type of GII. expectDeltaGII = " + expectDeltaGII + " for region " + aRegion.getFullPath() + " GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted);
            }
            Log.getLogWriter().info("verifyDeltaGII: " + regionName + " Remote Initialization (GII): GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted + ".");
        }
    }
}

