/*
 * Decompiled with CFR 0.152.
 */
package diskRecovery;

import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import util.TestException;
import util.TestHelper;

public class XmlManipulator {
    public static void writeXml(Document doc, String xmlFilePath) {
        DOMSource domSource = new DOMSource(doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DocumentType docType = doc.getDoctype();
            transformer.setOutputProperty("doctype-system", docType.getSystemId());
            transformer.setOutputProperty("doctype-public", docType.getPublicId());
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            String xml = sw.toString();
            PrintWriter aFile = new PrintWriter(new FileOutputStream(new File(xmlFilePath)));
            aFile.print(xml);
            aFile.flush();
            aFile.close();
        }
        catch (TransformerConfigurationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TransformerException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (FileNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void sortRegions(String xmlFilePath, String sortedXmlFilePath) {
        class RegionNodeComparator
        implements Comparator {
            RegionNodeComparator() {
            }

            public int compare(Object o1, Object o2) {
                String regionName1 = ((Node)o1).getAttributes().getNamedItem("name").getNodeValue();
                String regionName2 = ((Node)o2).getAttributes().getNamedItem("name").getNodeValue();
                return regionName1.compareTo(regionName2);
            }

            @Override
            public boolean equals(Object anObj) {
                String regionName1 = ((Node)((Object)this)).getAttributes().getNamedItem("name").getNodeValue();
                String regionName2 = ((Node)anObj).getAttributes().getNamedItem("name").getNodeValue();
                return regionName1.equals(regionName2);
            }
        }
        TreeSet<Node> regionNodeSet = new TreeSet<Node>(new RegionNodeComparator());
        File file = new File(xmlFilePath);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            int i;
            DocumentBuilder db = dbf.newDocumentBuilder();
            CacheXmlParser handler = new CacheXmlParser();
            db.setEntityResolver((EntityResolver)handler);
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList baseNodeList = doc.getElementsByTagName("cache");
            if (baseNodeList.getLength() != 1) {
                throw new TestException("Error, baseNodeList size is " + baseNodeList.getLength());
            }
            Node cacheNode = baseNodeList.item(0);
            NodeList cacheNodeList = cacheNode.getChildNodes();
            ArrayList<Node> priorNodes = new ArrayList<Node>();
            ArrayList<Node> afterNodes = new ArrayList<Node>();
            boolean prior = true;
            for (i = 0; i < cacheNodeList.getLength(); ++i) {
                Node aNode = cacheNodeList.item(i);
                String nodeName = aNode.getNodeName();
                if (nodeName.equals("region")) {
                    regionNodeSet.add(aNode);
                    prior = false;
                    continue;
                }
                if (prior) {
                    priorNodes.add(aNode);
                    continue;
                }
                afterNodes.add(aNode);
            }
            for (i = 0; i < cacheNodeList.getLength(); ++i) {
                cacheNode.removeChild(cacheNodeList.item(i));
            }
            for (Node priorNode : priorNodes) {
                cacheNode.appendChild(priorNode);
            }
            for (Node regionNode : regionNodeSet) {
                cacheNode.appendChild(regionNode);
            }
            for (Node afterNode : afterNodes) {
                cacheNode.appendChild(afterNode);
            }
            XmlManipulator.writeXml(doc, sortedXmlFilePath);
        }
        catch (ParserConfigurationException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (SAXException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (IOException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }
}

