/*
 * Decompiled with CFR 0.152.
 */
package diskReg;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.internal.cache.LocalRegionHelper;
import diskReg.DiskRecoveryPrms;
import diskReg.DiskRegBB;
import diskReg.DiskRegTest;
import diskReg.DiskRegUtil;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import objects.ObjectHelper;
import util.TestException;

public class DiskRegRecoveryTest
extends DiskRegTest {
    private static final int CREATE = 0;
    private static final int DESTROY = 1;
    private static final int INVALIDATE = 2;
    private static final int UPDATE = 3;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new DiskRegRecoveryTest();
            testInstance.initialize();
            DiskRegBB.getBB().printSharedMap();
        }
    }

    public static synchronized void HydraTask_initializeMirroredRegion() {
        if (testInstance == null) {
            testInstance = new DiskRegRecoveryTest();
            ((DiskRegRecoveryTest)testInstance).syncOnCacheReady();
            testInstance.initialize();
        }
    }

    @Override
    protected void initialize() {
        String cwd = System.getProperty("user.dir");
        String dir = cwd + File.separator + RemoteTestModule.getMyClientName() + "_diskDir";
        System.setProperty("gfx.disk.dir.parent", dir);
        super.initialize();
    }

    public static void HydraTask_createEntries() {
        Log.getLogWriter().info("In createEntries ...");
        int maxKeys = TestConfig.tab().intAt(DiskRecoveryPrms.maxKeys, 100);
        int range = maxKeys / 4;
        Log.getLogWriter().info("CREATING " + maxKeys + " entries");
        for (int i = 0; i < maxKeys; ++i) {
            ((DiskRegRecoveryTest)testInstance).createEntry(i);
        }
        Log.getLogWriter().info("CREATED " + maxKeys + " entries in the range of 0 to " + (maxKeys - 1));
        DiskRegBB.getBB().getSharedCounters().add(DiskRegBB.completedOperations, range);
        MasterController.sleepForMs(30000);
        ((DiskRegRecoveryTest)testInstance).setCacheReady();
    }

    public static void HydraTask_doEntryOperations() {
        int i;
        Log.getLogWriter().info("In doEntryOperations ...");
        int maxKeys = TestConfig.tab().intAt(DiskRecoveryPrms.maxKeys, 100);
        int range = maxKeys / 4;
        int low = range * 1;
        int high = low + range;
        Log.getLogWriter().info("DESTROYING " + range + " entries\n");
        for (i = low; i < high; ++i) {
            ((DiskRegRecoveryTest)testInstance).destroyEntry(i);
            DiskRegBB.getBB().getSharedCounters().increment(DiskRegBB.completedOperations);
        }
        Log.getLogWriter().info("DESTROYED " + range + " entries in the range of " + low + " to " + (high - 1));
        low = 2 * range;
        high = low + range;
        Log.getLogWriter().info("INVALIDATING " + range + " entries\n");
        for (i = low; i < high; ++i) {
            ((DiskRegRecoveryTest)testInstance).invalidateEntry(i);
            DiskRegBB.getBB().getSharedCounters().increment(DiskRegBB.completedOperations);
        }
        Log.getLogWriter().info("INVALIDATED " + range + " entries in the range of " + low + " to " + (high - 1));
        low = 3 * range;
        high = low + range;
        Log.getLogWriter().info("UPDATING " + range + " entries\n");
        for (i = low; i < high; ++i) {
            ((DiskRegRecoveryTest)testInstance).updateEntry(i);
            DiskRegBB.getBB().getSharedCounters().increment(DiskRegBB.completedOperations);
        }
        Log.getLogWriter().info("UPDATED " + range + " entries in the range of " + low + " to " + (high - 1));
    }

    public static void HydraTask_updateEntries() {
        Log.getLogWriter().info("In updateEntries ...");
        int maxKeys = TestConfig.tab().intAt(DiskRecoveryPrms.maxKeys, 100);
        int range = maxKeys / 4;
        int low = 3 * range;
        int high = low + range;
        Log.getLogWriter().info("UPDATING " + range + " entries\n");
        for (int i = low; i < high; ++i) {
            ((DiskRegRecoveryTest)testInstance).updateEntry(i);
        }
    }

    public static void HydraTask_readEntries() {
        int i;
        Log.getLogWriter().info("In readEntries ...");
        int maxKeys = TestConfig.tab().intAt(DiskRecoveryPrms.maxKeys, 100);
        int range = maxKeys / 4;
        int low = 0 * range;
        int high = low + range;
        Log.getLogWriter().info("READING " + range + " entries\n");
        for (i = low; i < high; ++i) {
            ((DiskRegRecoveryTest)testInstance).readEntry(i);
        }
        low = 3 * range;
        high = low + range;
        Log.getLogWriter().info("READING " + range + " entries\n");
        for (i = low; i < high; ++i) {
            ((DiskRegRecoveryTest)testInstance).readEntry(i);
        }
    }

    public static void HydraTask_stopClientVm() throws ClientVmNotFoundException {
        Log.getLogWriter().info("In stopClientVm ...");
        long numOps = DiskRegBB.getBB().getSharedCounters().read(DiskRegBB.completedOperations);
        int maxKeys = TestConfig.tab().intAt(DiskRecoveryPrms.maxKeys, 100);
        int minimumNumOpsBeforeStop = TestConfig.tab().intAt(DiskRecoveryPrms.minimumNumOpsBeforeStop, maxKeys / 2);
        int stopType = DiskRecoveryPrms.getStopType();
        Log.getLogWriter().info("stopClientVm: numOps = " + numOps + " with minimumNumOpsBeforeStop = " + minimumNumOpsBeforeStop);
        if (numOps > (long)minimumNumOpsBeforeStop) {
            ClientVmMgr.stopAsync("Completed more than " + minimumNumOpsBeforeStop + " ops", stopType, -32);
            return;
        }
        long timeToSleep = 250L * ((long)minimumNumOpsBeforeStop - numOps);
        Log.getLogWriter().info("stopClientVm: have not met miniumumNumOps, napping for " + timeToSleep + " ms");
        MasterController.sleepForMs((int)timeToSleep);
    }

    public static void HydraTask_checkStats() {
        Log.getLogWriter().info("In checkStats() ...");
        ((DiskRegRecoveryTest)testInstance).checkStats();
        DiskRegBB.getBB().printSharedMap();
    }

    public static void HydraTask_validateRecovery() {
        Log.getLogWriter().info("In validateRecovery ...");
        ((DiskRegRecoveryTest)testInstance).checkStats();
        long completedOperations = DiskRegBB.getBB().getSharedCounters().read(DiskRegBB.completedOperations);
        Log.getLogWriter().info("validateRecovery verifying " + completedOperations + " keys");
        int i = 0;
        while ((long)i < completedOperations) {
            ((DiskRegRecoveryTest)testInstance).validateEntry(i);
            ++i;
        }
        ((DiskRegRecoveryTest)testInstance).checkRegionAPIs();
        DiskRegTest.removeDiskRegionFiles();
        Log.getLogWriter().info("Exiting validateRecovery.");
    }

    private void createEntry(int i) {
        String key = (String)ObjectHelper.createName(i);
        Object val = null;
        String objectType = TestConfig.tab().stringAt(DiskRecoveryPrms.objectType, "objects.ArrayOfByte");
        Log.getLogWriter().info("creating entries of type " + objectType);
        val = ObjectHelper.createObject(objectType, i);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("CREATING (putIfAbsent) key = " + key);
            this.aRegion.putIfAbsent((Object)key, val);
        } else {
            Log.getLogWriter().info("CREATING (put) key = " + key);
            this.aRegion.put((Object)key, val);
        }
    }

    private void destroyEntry(int i) {
        String key = (String)ObjectHelper.createName(i);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("REMOVING entry with key = " + key);
                this.aRegion.remove((Object)key);
            } else {
                Log.getLogWriter().info("DESTROYING entry with key = " + key);
                this.aRegion.destroy((Object)key);
            }
        }
        catch (EntryNotFoundException e) {
            throw new TestException("Exception destroying entry " + i, e);
        }
    }

    private void invalidateEntry(int i) {
        String key = (String)ObjectHelper.createName(i);
        Log.getLogWriter().info("INVALIDATING entry with key = " + key);
        try {
            this.aRegion.invalidate((Object)key);
        }
        catch (EntryNotFoundException e) {
            throw new TestException("Exception invalidating entry " + i, e);
        }
    }

    private void updateEntry(int i) {
        String key = (String)ObjectHelper.createName(i);
        Object val = null;
        String objectType = TestConfig.tab().stringAt(DiskRecoveryPrms.objectType, "objects.ArrayOfByte");
        Log.getLogWriter().info("updating entries of type " + objectType);
        val = ObjectHelper.createObject(objectType, i);
        try {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("REPLACING key = " + key);
                this.aRegion.replace((Object)key, val);
            } else {
                Log.getLogWriter().info("UPDATING key = " + key);
                this.aRegion.put((Object)key, val);
            }
        }
        catch (CancelException e) {
            return;
        }
    }

    private void readEntry(int i) {
        String key = (String)ObjectHelper.createName(i);
        Log.getLogWriter().info("READING key = " + key);
        Object val = this.aRegion.get((Object)key);
    }

    private void checkStats() {
        Log.getLogWriter().info("CHECKING stats ...");
        Log.getLogWriter().info("getNumOverflowOnDisk = " + DiskRegUtil.getNumOverflowOnDisk(this.aRegion));
        Log.getLogWriter().info("numWrites = " + DiskRegUtil.getNumEntriesWrittenToDisk(this.aRegion));
        Log.getLogWriter().info("numEntries in VM = " + DiskRegUtil.getNumEntriesInVM(this.aRegion));
    }

    private void checkRegionAPIs() {
        Log.getLogWriter().info("CHECKING regionAPIs (entries, keys, values) ...");
        Set entries = this.aRegion.entries(false);
        Log.getLogWriter().info("Region API entries() returns " + entries.size() + " entries");
        Set keys = this.aRegion.keys();
        Log.getLogWriter().info("RegionAPI keys() returns " + keys.size() + " entries");
        Collection values = this.aRegion.values();
        Log.getLogWriter().info("RegionAPI values() returns " + values.size() + " entries");
    }

    private void validateEntry(int i) {
        Object val = null;
        Log.getLogWriter().info("VALIDATING correctness of entry with key = " + i);
        String key = (String)ObjectHelper.createName(i);
        int range = DiskRegRecoveryTest.getRange(i);
        switch (range) {
            case 0: {
                val = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, key);
                ObjectHelper.validate(i, val);
                val = this.aRegion.get((Object)key);
                ObjectHelper.validate(i, val);
                break;
            }
            case 1: {
                if (!this.aRegion.containsKey((Object)key)) break;
                throw new HydraRuntimeException("Exception in RecoveryValidation for entry " + i + " -- should be destroyed but key exists");
            }
            case 2: {
                val = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, key);
                if (!LocalRegionHelper.isInvalidToken(val)) {
                    throw new HydraRuntimeException("Exception RecoveryValidation for entry " + i + " -- should be INVALID, but is class " + val.getClass().getName());
                }
                val = DiskRegUtil.getValueInVM(this.aRegion, key);
                if (!LocalRegionHelper.isInvalidToken(val)) {
                    throw new HydraRuntimeException("Exception RecoveryValidation for entry " + i + " -- should be INVALID, but has value" + val + ", val is invalid token: " + LocalRegionHelper.isInvalidToken(val));
                }
                if (!this.aRegion.containsValueForKey((Object)key)) break;
                throw new HydraRuntimeException("Exception RecoveryValidation for entry " + i + " -- should be invalidated, but has a value");
            }
            case 3: {
                val = this.aRegion.get((Object)key);
                ObjectHelper.validate(i, val);
                break;
            }
            default: {
                throw new HydraRuntimeException("Exception during RecoveryValidation -- key is out of range, entry = " + i);
            }
        }
    }

    private static int getRange(int x) {
        int maxKeys = TestConfig.tab().intAt(DiskRecoveryPrms.maxKeys);
        int range = maxKeys / 4;
        int operationRange = x < 1 * range ? 0 : (x < 2 * range ? 1 : (x < 3 * range ? 2 : 3));
        return operationRange;
    }

    private void syncOnCacheReady() {
        SharedCounters counters = DiskRegBB.getBB().getSharedCounters();
        String fieldName = new String("cacheReady");
        Field field = null;
        try {
            field = DiskRegBB.class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new HydraRuntimeException("Need to add field " + fieldName + " to DiskRegBB", e);
        }
        int counter = -1;
        try {
            counter = (Integer)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new HydraRuntimeException("Unable to access field " + fieldName + " in DiskRegBB", e);
        }
        Log.getLogWriter().fine("SYNC -- waiting for cacheReady");
        long cacheReady = 0L;
        while (cacheReady != 1L) {
            MasterController.sleepForMs(200);
            cacheReady = counters.read(counter);
        }
    }

    private void setCacheReady() {
        SharedCounters counters = DiskRegBB.getBB().getSharedCounters();
        String fieldName = new String("cacheReady");
        Field field = null;
        try {
            field = DiskRegBB.class.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new HydraRuntimeException("Need to add field " + fieldName + " to DiskRegBB", e);
        }
        int counter = -1;
        try {
            counter = (Integer)field.get(null);
        }
        catch (IllegalAccessException e) {
            throw new HydraRuntimeException("Unable to access field " + fieldName + " in DiskRegBB", e);
        }
        counters.incrementAndRead(counter);
        Log.getLogWriter().fine("SYNC ( " + fieldName + " ) counter set!");
    }
}

