/*
 * Decompiled with CFR 0.152.
 */
package diskReg;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import diskReg.DiskRegVersionHelper;
import util.TestException;
import util.TestHelper;

public class DiskRegUtil {
    public static long getNumEntriesInVM(Region aRegion) {
        long statsCount;
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return aRegion.keys().size();
        }
        if (diskReg.getStats() == null) {
            throw new TestException("stats is NULL");
        }
        long diskRegionCount = diskReg.getNumEntriesInVM();
        if (diskRegionCount != (statsCount = diskReg.getStats().getNumEntriesInVM())) {
            throw new TestException("BUG 41725 detected: DiskRegion.getEntriesInVM(" + diskRegionCount + ") != diskReg.getStats().getNumEntriesInVM(" + statsCount + ")" + TestHelper.getStackTrace());
        }
        return diskReg.getStats().getNumEntriesInVM();
    }

    public static long getNumEntriesWrittenToDisk(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return 0L;
        }
        return diskReg.getStats().getWrites();
    }

    public static long getNumOverflowOnDisk(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return 0L;
        }
        return diskReg.getStats().getNumOverflowOnDisk();
    }

    public static Object getValueInVM(Region aRegion, Object key) {
        return DiskRegVersionHelper.getValueInVM(aRegion, key);
    }

    public static Object getValueOnDiskOrBuffer(Region aRegion, Object key) {
        try {
            return ((LocalRegion)aRegion).getValueOnDiskOrBuffer(key);
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (EntryNotFoundException e) {
            return null;
        }
    }

    public static long compareValues(Region aRegion, Object key) {
        return DiskRegVersionHelper.compareValues(aRegion, key);
    }

    public static long getRecoveredEntryCount(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return 0L;
        }
        return diskReg.getRecoveredEntryCount();
    }

    public static boolean isBackup(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return false;
        }
        return diskReg.isBackup();
    }

    public static long getBufferSize(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return 0L;
        }
        return diskReg.getDiskStore().getStats().getQueueSize();
    }

    public static long getBytesWritten(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return 0L;
        }
        return diskReg.getStats().getBytesWritten();
    }

    public static long getCommits(Region aRegion) {
        return 0L;
    }

    public static long getRemoves(Region aRegion) {
        DiskRegion diskReg = ((LocalRegion)aRegion).getDiskRegion();
        if (diskReg == null) {
            return 0L;
        }
        return diskReg.getStats().getRemoves();
    }
}

