/*
 * Decompiled with CFR 0.152.
 */
package diskReg;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.lru.MemLRUCapacityController;
import diskReg.DiskRegBB;
import diskReg.DiskRegPrms;
import diskReg.DiskRegSizer;
import diskReg.DiskRegTest;
import diskReg.DiskRegUtil;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.util.Arrays;
import java.util.BitSet;
import util.NameFactory;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class SerialDiskRegTest
extends DiskRegTest {
    protected String sharedMapKey;
    protected boolean checkLRU;
    protected boolean isMemLRU;
    protected long bytesPerEntry_keyValue;
    protected long bytesPerEntry_keyOnly;
    protected long minEvictionBytes;
    protected long maxBytes;
    protected long perEntryOverhead;
    protected long numEntriesDeviation;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new SerialDiskRegTest();
            testInstance.initialize();
            Log.getLogWriter().info(testInstance.toVerboseString());
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.checkLRU = this.numVMs == 1;
        this.sharedMapKey = "OldestKey_" + ProcessMgr.getProcessId();
        DiskRegBB.getBB().getSharedMap().put(this.sharedMapKey, new Long(1L));
        this.isMemLRU = false;
        EvictionAttributes evAttr = this.aRegion.getAttributes().getEvictionAttributes();
        if (evAttr != null) {
            this.isMemLRU = evAttr.getAlgorithm().isLRUMemory();
            if (this.isMemLRU) {
                Object sampleValue = this.getNewValue(SerialDiskRegTest.getFixedLengthKeyForName("Object_1"));
                long valueSize = new DiskRegSizer().sizeof(sampleValue);
                Region aRegion = RegionHelper.getRegion("diskRegion");
                this.perEntryOverhead = ((MemLRUCapacityController)((LocalRegion)aRegion).getEvictionController()).getPerEntryOverhead();
                this.bytesPerEntry_keyOnly = (long)TestHelper.calculateStringSize(SerialDiskRegTest.getFixedLengthKeyForName("Object_1")) + this.perEntryOverhead;
                this.bytesPerEntry_keyValue = this.bytesPerEntry_keyOnly + valueSize + this.perEntryOverhead;
                this.numEntriesDeviation = TestConfig.tab().intAt(DiskRegPrms.numEntriesDeviation);
                this.minEvictionBytes = (long)(this.evictionLimit * 1024 * 1024) - this.bytesPerEntry_keyValue * this.numEntriesDeviation;
                this.maxBytes = (long)(this.evictionLimit * 1024 * 1024) + this.bytesPerEntry_keyValue * this.numEntriesDeviation;
                Log.getLogWriter().info("KEY_LENGTH = 20\nvalueSize = " + valueSize + "\n" + "perEntryOverhead = " + this.perEntryOverhead + "\n" + "bytesPerEntry_keyValue = " + this.bytesPerEntry_keyValue + "\n" + "bytesPerEntry_keyOnly = " + this.bytesPerEntry_keyOnly + "\n" + "numEntriesDeviation = " + this.numEntriesDeviation + "\n" + "minEvictionBytes = " + this.minEvictionBytes + "\n" + "maxBytes = " + this.maxBytes);
            }
        }
    }

    public static void HydraTask_addNew() {
        ((SerialDiskRegTest)testInstance).addNew();
    }

    private void addNew() {
        long exeNum = DiskRegBB.getBB().getSharedCounters().incrementAndRead(DiskRegBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_addNew, adding for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            ((SerialDiskRegTest)testInstance).doAddNew();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In HydraTask_addNew, done running for " + timeToRunSec + " seconds");
        int numKeys = SerialDiskRegTest.testInstance.aRegion.keys().size();
        int endTestOnNumKeysInRegion = TestConfig.tab().intAt(DiskRegPrms.endTestOnNumKeysInRegion, Integer.MAX_VALUE);
        if (numKeys >= endTestOnNumKeysInRegion) {
            throw new StopSchedulingOrder("Stopping client because the region has " + numKeys + " keys, endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
        }
    }

    public static void HydraTask_getOld() {
        ((SerialDiskRegTest)testInstance).getOld();
    }

    private void getOld() {
        long exeNum = DiskRegBB.getBB().getSharedCounters().incrementAndRead(DiskRegBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
        long timeToRunSec = TestConfig.tab().intAt(TestHelperPrms.minTaskGranularitySec);
        long timeToRunMS = timeToRunSec * 1000L;
        Log.getLogWriter().info("In HydraTask_getOld, getting for " + timeToRunSec + " seconds");
        long startTime = System.currentTimeMillis();
        do {
            ((SerialDiskRegTest)testInstance).doGetOld();
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("In HydraTask_getOld, done running for " + timeToRunSec + " seconds");
        int numKeys = SerialDiskRegTest.testInstance.aRegion.keys().size();
        int endTestOnNumKeysInRegion = TestConfig.tab().intAt(DiskRegPrms.endTestOnNumKeysInRegion, Integer.MAX_VALUE);
        if ((this.regionKind == 1 || this.regionKind == 3) && numKeys >= endTestOnNumKeysInRegion) {
            throw new StopSchedulingOrder("Stopping client because the region has " + numKeys + " keys, endTestOnNumKeysInRegion is " + endTestOnNumKeysInRegion);
        }
    }

    protected void doAddNew() {
        int beforeNumKeys = this.aRegion.keys().size();
        long beforeNumInVM = DiskRegUtil.getNumEntriesInVM(this.aRegion);
        long beforeNumOnDisk = DiskRegUtil.getNumEntriesWrittenToDisk(this.aRegion);
        long beforeNumOverflowOnDisk = DiskRegUtil.getNumOverflowOnDisk(this.aRegion);
        DataPolicy dataPolicy = this.aRegion.getAttributes().getDataPolicy();
        boolean putIfAbsentSupported = !dataPolicy.equals(DataPolicy.NORMAL) && !dataPolicy.equals(DataPolicy.EMPTY);
        Object[] keyAndValue = putIfAbsentSupported && TestConfig.tab().getRandGen().nextBoolean() ? this.putIfAbsent() : this.addEntry();
        Object key = keyAndValue[0];
        Object value = keyAndValue[1];
        boolean addViaGet = (Boolean)keyAndValue[2];
        this.verifyAfterAdd(key, value, beforeNumKeys, beforeNumInVM, beforeNumOnDisk, beforeNumOverflowOnDisk);
        if (addViaGet) {
            Log.getLogWriter().info("Doing a second get on key " + key + "...");
            this.aRegion.get(key);
        }
        this.verifyAfterAdd(key, value, beforeNumKeys, beforeNumInVM, beforeNumOnDisk, beforeNumOverflowOnDisk);
        SerialDiskRegTest.checkForEventError();
    }

    protected void doGetOld() {
        int RANGE = 30;
        int beforeNumKeys = this.aRegion.keys().size();
        long beforeNumInVM = DiskRegUtil.getNumEntriesInVM(this.aRegion);
        long beforeNumOnDisk = DiskRegUtil.getNumEntriesWrittenToDisk(this.aRegion);
        long beforeNumOverflowOnDisk = DiskRegUtil.getNumOverflowOnDisk(this.aRegion);
        Object[] objArr = this.randomGet(30);
        if (objArr == null) {
            return;
        }
        Object key = objArr[0];
        Object value = objArr[1];
        boolean containsKeyBeforeGet = (Boolean)objArr[2];
        if (!containsKeyBeforeGet) {
            this.verifyAfterAdd(key, value, beforeNumKeys, beforeNumInVM, beforeNumOnDisk, beforeNumOverflowOnDisk);
        }
        SerialDiskRegTest.checkForEventError();
    }

    protected void verifyAfterAdd(Object key, Object value, long beforeNumKeys, long beforeNumInVM, long beforeNumOnDisk, long beforeNumOverflowOnDisk) {
        int afterNumKeys = this.aRegion.size();
        long afterNumInVM = DiskRegUtil.getNumEntriesInVM(this.aRegion);
        long afterNumOnDisk = DiskRegUtil.getNumEntriesWrittenToDisk(this.aRegion);
        long afterNumOverflowOnDisk = DiskRegUtil.getNumOverflowOnDisk(this.aRegion);
        Object valueInVM = DiskRegUtil.getValueInVM(this.aRegion, key);
        Object valueOnDisk = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, key);
        StringBuffer aStr = new StringBuffer();
        aStr.append("In verifyAfterAdd with key " + key + ", value " + TestHelper.toString(value) + "\n");
        aStr.append("   beforeNumKeys: " + beforeNumKeys + "\n");
        aStr.append("   beforeNumInVM: " + beforeNumInVM + "\n");
        aStr.append("   beforeNumOnDisk: " + beforeNumOnDisk + "\n");
        aStr.append("   beforeNumOverflowOnDisk: " + beforeNumOverflowOnDisk + "\n");
        aStr.append("   afterNumKeys: " + afterNumKeys + "\n");
        aStr.append("   afterNumInVM: " + afterNumInVM + "\n");
        aStr.append("   afterNumOnDisk: " + afterNumOnDisk + "\n");
        aStr.append("   afterNumOverflowOnDisk: " + afterNumOverflowOnDisk + "\n");
        aStr.append("   valueInVM: " + valueInVM + "\n");
        aStr.append("   valueOnDisk: " + valueOnDisk + "\n");
        Log.getLogWriter().info(aStr.toString());
        this.checkValue(beforeNumKeys + 1L, (long)afterNumKeys, "after num keys");
        boolean containsKey = this.aRegion.containsKey(key);
        boolean containsValueForKey = this.aRegion.containsValueForKey(key);
        this.checkValue(true, containsKey, "containsKey()");
        this.checkValue(true, containsValueForKey, "containsValueForKey()");
        switch (this.regionKind) {
            case 1: {
                this.checkValue(beforeNumKeys + 1L, afterNumInVM, "after numInVM");
                this.checkValue(0L, afterNumOnDisk, "afterNumOnDisk");
                this.checkValue(0L, afterNumOverflowOnDisk, "afterNumOverflowOnDisk");
                this.checkValue(value, valueInVM, "value in VM");
                this.checkValue(null, valueOnDisk, "value on disk");
                break;
            }
            case 2: {
                boolean overflow;
                if (this.isMemLRU) {
                    long beforeBytesInVM = beforeNumInVM * this.bytesPerEntry_keyValue + beforeNumOnDisk * this.bytesPerEntry_keyOnly;
                    long afterBytesInVM = afterNumInVM * this.bytesPerEntry_keyValue + afterNumOverflowOnDisk * this.bytesPerEntry_keyOnly;
                    boolean evicted = afterNumInVM <= beforeNumInVM;
                    Log.getLogWriter().info("   beforeBytesInVM: " + beforeBytesInVM);
                    Log.getLogWriter().info("   afterBytesInVM: " + afterBytesInVM);
                    Log.getLogWriter().info("   evicted: " + evicted);
                    if (evicted && afterBytesInVM < this.minEvictionBytes) {
                        throw new TestException("Early eviction: afterBytesInVM is " + afterBytesInVM + ", minEvictionBytes is " + this.minEvictionBytes);
                    }
                    if (afterBytesInVM > this.maxBytes) {
                        if (afterNumInVM == 0L) {
                            Log.getLogWriter().info("Expected afterBytesInVM(" + afterBytesInVM + ") > maxBytes (" + this.maxBytes + ") but afterNumInVM == 0 so all entries are being written to disk; continuing test");
                        } else {
                            throw new TestException("Expected afterBytesInVM " + afterBytesInVM + " to be <= maxBytes " + this.maxBytes);
                        }
                    }
                    if (afterNumInVM > 0L) {
                        this.checkValue(value, valueInVM, "value in VM");
                        this.checkValue(null, valueOnDisk, "value on disk");
                        break;
                    }
                    this.checkValue(null, valueInVM, "value in VM");
                    this.checkValue(value, valueOnDisk, "value on disk");
                    break;
                }
                boolean bl = overflow = beforeNumKeys >= (long)this.evictionLimit;
                if (overflow) {
                    this.checkValue(beforeNumInVM, afterNumInVM, "numInVM");
                    this.checkValue(beforeNumOverflowOnDisk + 1L, afterNumOverflowOnDisk, "numOverflowOnDisk");
                    this.checkOverflowEviction();
                } else {
                    this.checkValue(beforeNumKeys + 1L, afterNumInVM, "after numInVM");
                    this.checkValue(beforeNumOnDisk, afterNumOnDisk, "afterNumOnDisk");
                    this.checkValue(beforeNumOverflowOnDisk, afterNumOverflowOnDisk, "afterNumOnDisk");
                }
                this.checkValue(value, valueInVM, "value in VM");
                this.checkValue(null, valueOnDisk, "value on disk");
                break;
            }
            case 3: {
                this.checkValue(beforeNumInVM + 1L, afterNumInVM, "numInVM");
                this.checkValue(beforeNumOnDisk + 1L, afterNumOnDisk, "numOnDisk");
                this.checkValue(value, valueInVM, "value in VM");
                this.checkValue(value, valueOnDisk, "value on disk");
                break;
            }
            case 4: {
                boolean overflow;
                if (this.isMemLRU) {
                    long beforeNumKeysOnlyInVM = beforeNumKeys - beforeNumInVM;
                    long beforeBytesInVM = beforeNumInVM * this.bytesPerEntry_keyValue + beforeNumKeysOnlyInVM * this.bytesPerEntry_keyOnly;
                    long afterNumKeysOnlyInVM = (long)afterNumKeys - afterNumInVM;
                    long afterBytesInVM = afterNumInVM * this.bytesPerEntry_keyValue + afterNumKeysOnlyInVM * this.bytesPerEntry_keyOnly;
                    boolean evicted = afterNumInVM <= beforeNumInVM;
                    Log.getLogWriter().info("   beforeNumKeysOnlyInVM: " + beforeNumKeysOnlyInVM);
                    Log.getLogWriter().info("   beforeBytesInVM: " + beforeBytesInVM);
                    Log.getLogWriter().info("   afterNumKeysOnlyInVM: " + afterNumKeysOnlyInVM);
                    Log.getLogWriter().info("   afterBytesInVM: " + afterBytesInVM);
                    Log.getLogWriter().info("   evicted: " + evicted);
                    if (evicted && afterBytesInVM < this.minEvictionBytes) {
                        throw new TestException("Early eviction: afterBytesInVM is " + afterBytesInVM + ", minEvictionBytes is " + this.minEvictionBytes);
                    }
                    if (afterBytesInVM > this.maxBytes) {
                        if (afterNumInVM == 0L) {
                            Log.getLogWriter().info("Expected afterBytesInVM(" + afterBytesInVM + ") > maxBytes (" + this.maxBytes + ") but afterNumInVM == 0 so all entries are being written to disk; continuing test");
                        } else {
                            throw new TestException("Expected afterBytesInVM " + afterBytesInVM + " to be <= maxBytes " + this.maxBytes);
                        }
                    }
                    if (afterNumInVM > 0L) {
                        this.checkValue(value, valueInVM, "value in VM");
                        this.checkValue(value, valueOnDisk, "value on disk");
                        break;
                    }
                    this.checkValue(null, valueInVM, "value in VM");
                    this.checkValue(value, valueOnDisk, "value on disk");
                    break;
                }
                boolean bl = overflow = beforeNumKeys >= (long)this.evictionLimit;
                if (overflow) {
                    this.checkValue(beforeNumInVM, afterNumInVM, "numInVM");
                    this.checkValue(beforeNumOnDisk + 1L, afterNumOnDisk, "numOnDisk");
                    this.checkOverflowEviction();
                } else {
                    this.checkValue(beforeNumKeys + 1L, afterNumInVM, "after numInVM");
                    this.checkValue(beforeNumOnDisk + 1L, afterNumOnDisk, "afterNumOnDisk");
                }
                this.checkValue(value, valueInVM, "value in VM");
                this.checkValue(value, valueOnDisk, "value on disk");
                break;
            }
            default: {
                throw new TestException("Unknown region kind " + this.regionKind);
            }
        }
    }

    protected void checkValue(long expectedValue, long actualValue, String valueDescript) {
        if (expectedValue != actualValue) {
            this.printKeyStatus();
            throw new TestException("Expected " + valueDescript + " to be " + expectedValue + ", but it is " + actualValue);
        }
    }

    protected void checkValue(int expectedValue, int actualValue, String valueDescript) {
        if (expectedValue != actualValue) {
            this.printKeyStatus();
            throw new TestException("Expected " + valueDescript + " to be " + expectedValue + ", but it is " + actualValue);
        }
    }

    protected void checkValue(boolean expectedValue, boolean actualValue, String valueDescript) {
        if (expectedValue != actualValue) {
            throw new TestException("Expected " + valueDescript + " to be " + expectedValue + ", but it is " + actualValue);
        }
    }

    protected void checkValue(Object expectedObj, Object actualObj, String descript) {
        if (expectedObj == null) {
            if (actualObj == null) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof byte[] && actualObj instanceof byte[]) {
            if (Arrays.equals((byte[])expectedObj, (byte[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof boolean[] && actualObj instanceof boolean[]) {
            if (Arrays.equals((boolean[])expectedObj, (boolean[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof long[] && actualObj instanceof long[]) {
            if (Arrays.equals((long[])expectedObj, (long[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof int[] && actualObj instanceof int[]) {
            if (Arrays.equals((int[])expectedObj, (int[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof short[] && actualObj instanceof short[]) {
            if (Arrays.equals((short[])expectedObj, (short[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof double[] && actualObj instanceof double[]) {
            if (Arrays.equals((double[])expectedObj, (double[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof float[] && actualObj instanceof float[]) {
            if (Arrays.equals((float[])expectedObj, (float[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof char[] && actualObj instanceof char[]) {
            if (Arrays.equals((char[])expectedObj, (char[])actualObj)) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (expectedObj instanceof StringBuffer && actualObj instanceof StringBuffer) {
            if (((StringBuffer)expectedObj).toString().equals(((StringBuffer)actualObj).toString())) {
                return;
            }
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
        if (!expectedObj.equals(actualObj)) {
            throw new TestException("Expected " + descript + " to be " + TestHelper.toString(expectedObj) + ", but it is " + TestHelper.toString(actualObj));
        }
    }

    protected void checkOverflowEviction() {
        if (!this.checkLRU) {
            return;
        }
        int NEXT_LRU_TO_CHECK = 100;
        long expEvictedKeyCounter = (Long)DiskRegBB.getBB().getSharedMap().get(this.sharedMapKey);
        String expEvictedKey = NameFactory.getObjectNameForCounter(expEvictedKeyCounter);
        Object valueInVM = DiskRegUtil.getValueInVM(this.aRegion, expEvictedKey);
        Object valueOnDisk = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, expEvictedKey);
        this.checkValue(null, valueInVM, "LRU overflowed value");
        if (valueOnDisk != null) {
            this.printKeyStatus();
            throw new TestException("Expected LRU overflowed value on disk to be null but it is " + TestHelper.toString(valueOnDisk));
        }
        long newestKeyCounter = NameFactory.getPositiveNameCounter();
        long numToCheck = Math.min(expEvictedKeyCounter + 100L, newestKeyCounter);
        for (long i = expEvictedKeyCounter + 1L; i <= numToCheck; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            valueInVM = DiskRegUtil.getValueInVM(this.aRegion, key);
            this.checkValue(null, valueInVM, "value in VM (key: " + key + ")");
        }
        DiskRegBB.getBB().getSharedMap().put(this.sharedMapKey, new Long(expEvictedKeyCounter + 1L));
    }

    private void printKeyStatus() {
        long lastNameCounter = NameFactory.getPositiveNameCounter();
        BitSet onDisk = new BitSet((int)lastNameCounter + 1);
        BitSet inVM = new BitSet((int)lastNameCounter + 1);
        int index = 1;
        while ((long)index <= lastNameCounter) {
            String key = SerialDiskRegTest.getFixedLengthKeyForName(NameFactory.getObjectNameForCounter(index));
            Object valueInVM = DiskRegUtil.getValueInVM(this.aRegion, key);
            Object valueOnDisk = DiskRegUtil.getValueOnDiskOrBuffer(this.aRegion, key);
            if (valueInVM != null) {
                inVM.set(index);
            }
            if (valueOnDisk != null) {
                onDisk.set(index);
            }
            ++index;
        }
        Log.getLogWriter().info("Entries in VM: " + this.getBitSetRanges(inVM, lastNameCounter) + "\n" + "Entries on disk: " + this.getBitSetRanges(onDisk, lastNameCounter));
    }

    private String getBitSetRanges(BitSet aBitSet, long maxBits) {
        StringBuffer aStr = new StringBuffer();
        boolean firstTime = true;
        int firstIndex = 0;
        boolean currentBoolState = false;
        int i = 1;
        while ((long)i <= maxBits) {
            boolean aBool = aBitSet.get(i);
            if (firstTime) {
                firstTime = false;
                currentBoolState = aBool;
                firstIndex = i;
            }
            if (aBool != currentBoolState) {
                aStr.append(firstIndex + " - " + (i - 1) + " is " + currentBoolState + "\n");
                currentBoolState = aBool;
                firstIndex = i;
            }
            if ((long)i == maxBits) {
                aStr.append(firstIndex + " - " + i + " is " + currentBoolState + "\n");
            }
            ++i;
        }
        return aStr.toString();
    }

    @Override
    public String toVerboseString() {
        StringBuffer aStr = new StringBuffer();
        aStr.append(super.toVerboseString());
        aStr.append("     checkLRU: " + this.checkLRU + "\n");
        aStr.append("     isMemLRU: " + this.isMemLRU + "\n");
        aStr.append("     perEntryOverhead: " + this.perEntryOverhead + "\n");
        aStr.append("     bytesPerEntry_keyValue: " + this.bytesPerEntry_keyValue + "\n");
        aStr.append("     bytesPerEntry_keyOnly: " + this.bytesPerEntry_keyOnly + "\n");
        aStr.append("     numEntriesDeviation: " + this.numEntriesDeviation + "\n");
        aStr.append("     minEvictionBytes: " + this.minEvictionBytes + "\n");
        aStr.append("     maxBytes: " + this.maxBytes + "\n");
        return aStr.toString();
    }
}

