/*
 * Decompiled with CFR 0.152.
 */
package diskReg.oplogs;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TestHelperForHydraTests;
import diskReg.oplogs.DiskBB;
import distcache.gemfire.GemFireCachePrms;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.Log;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.TestConfig;
import mapregion.MapPrms;
import objects.ObjectHelper;
import util.TestException;
import util.TestHelper;

public class DiskRegMiscTest {
    static DiskRegMiscTest testInstance;
    private static RegionAttributes attr;
    private static Cache cache;
    protected static boolean isCarefulValidation;
    static Region diskRegion;
    static String regionName;
    static String DEFAULT_UPDATE_STRING;
    static volatile int createKeyInt;
    static Object createKeyLock;
    protected volatile boolean hasBeenRolled = false;
    protected volatile boolean hasBeenFlushed = false;
    static int iteration;
    static Object populateCacheLock;
    static volatile int populateKeyInt;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new DiskRegMiscTest();
            testInstance.initialize();
        }
    }

    protected void initialize() {
        try {
            if (cache == null || cache.isClosed()) {
                cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            }
            TestHelperForHydraTests.setIssueCallbacksOfCacheObserver(true);
            attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
            regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            this.createDiskRegion();
            if (diskRegion != null) {
                this.startMonitorThread();
            }
            if (TestConfig.tab().booleanAt(MapPrms.populateCache)) {
                this.populateRegion();
            }
            isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void createDiskRegion() {
        try {
            diskRegion = RegionHelper.createRegion(regionName, attr);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void startMonitorThread() {
        Thread monitorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long limit = TestConfig.tab().longAt(Prms.totalTaskTimeSec) - 10L;
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() < startTime + limit * 1000L) {
                    int numKeys = diskRegion.size();
                    Log.getLogWriter().info(diskRegion.getFullPath() + " has " + numKeys + " keys");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        monitorThread.start();
    }

    public static void HydraTask_PerformOperations() {
        testInstance.createModifyModify();
        testInstance.createDestroyCreate();
        testInstance.createRemoveCreateModify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createModifyModify() {
        try {
            Object got;
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            Object object = createKeyLock;
            synchronized (object) {
                key = ObjectHelper.createName(createKeyInt);
                val = ObjectHelper.createObject(objectType, createKeyInt);
                ++createKeyInt;
            }
            diskRegion.put(key, val);
            val = val.toString().concat("-updated-1");
            diskRegion.put(key, val);
            if (isCarefulValidation) {
                got = diskRegion.get(key);
                Log.getLogWriter().info("Got value after first update: " + got.toString());
                if (!got.toString().endsWith("updated-1")) {
                    throw new TestException("Value is not updated by async writer thread. Expected to end with: \"updated-1\". But is: " + got.toString());
                }
            }
            val = val.toString().concat("-updated-2");
            diskRegion.put(key, val);
            if (isCarefulValidation) {
                got = diskRegion.get(key);
                Log.getLogWriter().info("Got value after second update: " + got.toString());
                if (!got.toString().endsWith("updated-2")) {
                    throw new TestException("Value is not updated by async writer thread. Expected to end with: \"updated-2\". But is: " + got.toString());
                }
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDestroyCreate() {
        try {
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            Object object = createKeyLock;
            synchronized (object) {
                key = ObjectHelper.createName(createKeyInt);
                val = ObjectHelper.createObject(objectType, createKeyInt);
                ++createKeyInt;
            }
            diskRegion.put(key, val);
            diskRegion.destroy(key);
            diskRegion.put(key, val);
            if (isCarefulValidation) {
                Object got = diskRegion.get(key);
                if (got == null) {
                    throw new TestException("Value obtained is null after create destroy create conflation");
                }
                ObjectHelper.validate(Integer.parseInt((String)key), got);
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRemoveCreateModify() {
        try {
            Object got;
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            Object object = createKeyLock;
            synchronized (object) {
                key = ObjectHelper.createName(createKeyInt);
                val = ObjectHelper.createObject(objectType, createKeyInt);
                ++createKeyInt;
            }
            diskRegion.put(key, val);
            diskRegion.remove(key);
            diskRegion.put(key, val);
            if (isCarefulValidation) {
                got = diskRegion.get(key);
                if (got == null) {
                    throw new TestException("Value obtained is null after create remove create conflation");
                }
                ObjectHelper.validate(Integer.parseInt((String)key), got);
            }
            val = val.toString().concat("-updated-1");
            diskRegion.put(key, val);
            if (isCarefulValidation) {
                got = diskRegion.get(key);
                Log.getLogWriter().info("Got value after first update: " + got.toString());
                if (!got.toString().endsWith("updated-1")) {
                    throw new TestException("Value is not updated by async writer thread. Expected to end with: \"updated-1\". But is: " + got.toString());
                }
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static void HydraTask_PerformGetOperations() {
        testInstance.getEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEntries() {
        try {
            this.hasBeenRolled = false;
            this.hasBeenFlushed = false;
            Object key = null;
            Object val = null;
            Object got = null;
            Log.getLogWriter().info("Region size is: " + diskRegion.size());
            ++iteration;
            int getKeyInt = 0;
            int keyInt = (int)DiskBB.getBB().getSharedCounters().read(DiskBB.NUM_GET);
            int queueSize = DiskStoreHelper.getDiskStore(attr.getDiskStoreName()).getQueueSize();
            do {
                ++getKeyInt;
                if (++keyInt > populateKeyInt) {
                    keyInt = 1;
                }
                key = ObjectHelper.createName(keyInt);
                got = ((LocalRegion)diskRegion).getValueOnDiskOrBuffer(key);
                val = got.toString().concat(DEFAULT_UPDATE_STRING) + Integer.toString(iteration);
                diskRegion.put(key, val);
                got = ((LocalRegion)diskRegion).getValueOnDiskOrBuffer(key);
                if (got.toString().indexOf(DEFAULT_UPDATE_STRING) != -1) continue;
                throw new TestException("Value obtained from buffer is " + got.toString() + " whereas it is expected to be " + val.toString());
            } while (getKeyInt < queueSize / 2);
            CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterWritingBytes() {
                    Region region = diskRegion;
                    synchronized (region) {
                        diskRegion.notify();
                        DiskRegMiscTest.this.hasBeenFlushed = true;
                        Log.getLogWriter().info("inside afterWritingBytes");
                    }
                }
            });
            ((LocalRegion)diskRegion).getDiskRegion().flushForTesting();
            Region region = diskRegion;
            synchronized (region) {
                if (!this.hasBeenFlushed) {
                    try {
                        diskRegion.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new TestException(TestHelper.getStackTrace(ex));
                    }
                }
            }
            Log.getLogWriter().info("flushed the data into oplogs");
            getKeyInt = 0;
            keyInt = (int)DiskBB.getBB().getSharedCounters().read(DiskBB.NUM_GET);
            do {
                ++getKeyInt;
                if (++keyInt > populateKeyInt) {
                    keyInt = 1;
                }
                key = ObjectHelper.createName(keyInt);
                val = diskRegion.get(key);
                got = ((LocalRegion)diskRegion).getValueOnDiskOrBuffer(key);
                if (got.toString().indexOf(DEFAULT_UPDATE_STRING) != -1) continue;
                throw new TestException("Value obtained from oplogs is " + got.toString() + " whereas it is expected to be " + val.toString());
            } while (getKeyInt < queueSize / 2);
            CacheObserverHolder.setInstance((CacheObserver)new CacheObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterHavingCompacted() {
                    Region region = diskRegion;
                    synchronized (region) {
                        diskRegion.notify();
                        DiskRegMiscTest.this.hasBeenRolled = true;
                        Log.getLogWriter().info("inside afterHavingCompacted");
                    }
                }
            });
            ((LocalRegion)diskRegion).getDiskStore().forceCompaction();
            region = diskRegion;
            synchronized (region) {
                if (!this.hasBeenRolled) {
                    try {
                        diskRegion.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new TestException(TestHelper.getStackTrace(ex));
                    }
                }
            }
            Log.getLogWriter().info("Data rolled into htree");
            getKeyInt = 0;
            keyInt = (int)DiskBB.getBB().getSharedCounters().read(DiskBB.NUM_GET);
            do {
                ++getKeyInt;
                if (++keyInt > populateKeyInt) {
                    keyInt = 1;
                }
                key = ObjectHelper.createName(keyInt);
                val = diskRegion.get(key);
                got = ((LocalRegion)diskRegion).getValueOnDiskOrBuffer(key);
                if (got.toString().indexOf(DEFAULT_UPDATE_STRING) == -1) {
                    throw new TestException("Value obtained from htree is " + got.toString() + " whereas it is expected to be " + val.toString());
                }
                DiskBB.getBB();
                DiskBB.incrementCounter("DiskBB.NUM_GET", DiskBB.NUM_GET);
            } while (getKeyInt < queueSize / 2);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateRegion() {
        try {
            long limit = TestConfig.tab().longAt(MapPrms.timeForPopulateCache);
            int maxKeys = MapPrms.getMaxPositiveKeys();
            Object key = null;
            Object val = null;
            Object returnObj = null;
            Log.getLogWriter().info("populating disk region...");
            long startTime = System.currentTimeMillis();
            int regionSize = diskRegion.size();
            do {
                Object object = populateCacheLock;
                synchronized (object) {
                    key = ObjectHelper.createName(++populateKeyInt);
                    String objectType = MapPrms.getObjectType();
                    val = ObjectHelper.createObject(objectType, populateKeyInt);
                }
                diskRegion.put(key, val);
                regionSize = diskRegion.size();
            } while (System.currentTimeMillis() - startTime < limit && regionSize < maxKeys);
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException may occur in concurrent environment - continuing with test");
            Log.getLogWriter().info("recovering region");
            this.recoverRegion();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected synchronized void recoverRegion() {
        try {
            if (diskRegion == null || diskRegion.isDestroyed()) {
                diskRegion = cache.createVMRegion(GemFireCachePrms.getRegionName(), attr);
                Log.getLogWriter().info("created region: " + diskRegion);
            }
        }
        catch (RegionExistsException rex) {
            Log.getLogWriter().info("RegionExistsException can occur in concurrent environment - continuing with test");
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_closeTask() {
        testInstance.closeCache();
    }

    protected synchronized void closeCache() {
        try {
            if (cache != null || !cache.isClosed()) {
                CacheHelper.closeCache();
            }
        }
        catch (Exception ex) {
            throw new TestException("Exception while closing the cache: " + TestHelper.getStackTrace(ex));
        }
    }

    static {
        isCarefulValidation = false;
        diskRegion = null;
        DEFAULT_UPDATE_STRING = "updated";
        createKeyInt = 0;
        createKeyLock = "createKey";
        iteration = 0;
        populateCacheLock = "populate";
        populateKeyInt = 0;
    }
}

