/*
 * Decompiled with CFR 0.152.
 */
package diskReg.oplogs;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.TreeMap;
import mapregion.MapBB;
import mapregion.MapPrms;
import objects.ObjectHelper;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class MultipleDiskRegions {
    static MultipleDiskRegions testInstance;
    static Cache cache;
    static Region[] regions;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int lowerThreshold;
    protected int upperThreshold;
    protected static final int PUT = 1;
    protected static final int PUT_ALL = 2;
    protected static final int REMOVE = 3;
    protected static final int INVALIDATE = 4;
    protected static final int PUT_IF_ABSENT = 5;
    protected static final int CM_REMOVE = 6;
    protected static final int CLEAR = 11;
    protected static final int REGION_INVALIDATE = 12;
    protected static final int REGION_DESTROY = 13;
    protected static final int FORCE_ROLLING = 14;
    protected static final int WRITE_TO_DISK = 15;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new MultipleDiskRegions();
            testInstance.initialize();
        }
    }

    protected void initialize() {
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        try {
            cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String[] regionNames = MapPrms.getRegionNames();
            regions = new Region[regionNames.length];
            for (int i = 0; i < regionNames.length; ++i) {
                RegionAttributes attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
                MultipleDiskRegions.regions[i] = RegionHelper.createRegion(regionNames[i], attr);
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_closetask() {
        if (testInstance != null) {
            testInstance.closeCache();
            testInstance = null;
        }
    }

    public void closeCache() {
        try {
            CacheHelper.closeCache();
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static void HydraTask_performEntryOperations() {
        testInstance.performEntryOperations();
    }

    public static void HydraTask_performRegionOperations() {
        testInstance.performRegionOperations();
    }

    protected int getEntryOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("put")) {
            op = 1;
        } else if (operation.equals("putAll")) {
            op = 2;
        } else if (operation.equals("remove")) {
            op = 3;
        } else if (operation.equals("invalidate")) {
            op = 4;
        } else if (operation.equalsIgnoreCase("putIfAbsent")) {
            op = 5;
        } else if (operation.equalsIgnoreCase("cm_remove")) {
            op = 6;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected int getRegionOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("clear")) {
            op = 11;
        } else if (operation.equals("regionInvalidate")) {
            op = 12;
        } else if (operation.equals("regionDestroy")) {
            op = 13;
        } else if (operation.equals("forceRolling")) {
            op = 14;
        } else if (operation.equals("writeToDisk")) {
            op = 15;
        } else {
            throw new TestException("Unknown region operation: " + operation);
        }
        return op;
    }

    protected void performEntryOperations() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        this.lowerThreshold = TestConfig.tab().intAt(MapPrms.lowerThreshold, -1);
        this.upperThreshold = TestConfig.tab().intAt(MapPrms.upperThreshold, Integer.MAX_VALUE);
        Log.getLogWriter().info("lowerThreshold " + this.lowerThreshold + ", " + "upperThreshold " + this.upperThreshold);
        long startTime = System.currentTimeMillis();
        do {
            int whichOp = this.getEntryOperation(MapPrms.entryOperationName);
            Region region = cache.getRegion(regionName);
            if (region == null || region.isDestroyed()) {
                this.recoverRegion(regionName);
                continue;
            }
            try {
                int size = region.size();
                if (size >= this.upperThreshold) {
                    whichOp = this.getEntryOperation(MapPrms.upperThresholdOperations);
                } else if (size <= this.lowerThreshold) {
                    whichOp = this.getEntryOperation(MapPrms.lowerThresholdOperations);
                }
                switch (whichOp) {
                    case 1: {
                        this.putObject(regionName);
                        break;
                    }
                    case 2: {
                        this.putAllObjects(regionName);
                        break;
                    }
                    case 3: {
                        this.removeObject(regionName);
                        break;
                    }
                    case 4: {
                        this.invalidateObject(regionName);
                        break;
                    }
                    case 5: {
                        this.putIfAbsent(regionName);
                        break;
                    }
                    case 6: {
                        this.cm_remove(regionName);
                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
                this.recoverRegion(regionName);
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected void performRegionOperations() {
        String regionName = TestConfig.tab().stringAt(MapPrms.regionForOps);
        try {
            int whichOp = this.getRegionOperation(MapPrms.regionOperationName);
            switch (whichOp) {
                case 11: {
                    this.clearRegion(regionName);
                    break;
                }
                case 12: {
                    this.invalidateRegion(regionName);
                    break;
                }
                case 13: {
                    this.destroyRegion(regionName);
                    break;
                }
                case 14: {
                    this.forceRollOplogs(regionName);
                    break;
                }
                case 15: {
                    this.writeToDisk(regionName);
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected synchronized void recoverRegion(String regionName) {
        final ArrayList<Boolean> revoking = new ArrayList<Boolean>();
        revoking.add(new Boolean(true));
        Thread revokeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (((Boolean)revoking.get(0)).booleanValue()) {
                    RecoveryTestVersionHelper.forceRecovery(false);
                    MasterController.sleepForMs(1000);
                }
            }
        });
        try {
            Region region = cache.getRegion(regionName);
            if (region == null || region.isDestroyed()) {
                Log.getLogWriter().info("recovering region...");
                Thread.sleep(4000L);
                RegionAttributes attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
                Log.getLogWriter().info("Starting thread to revoke members...");
                revokeThread.start();
                RegionHelper.createRegion(regionName, attr);
                Log.getLogWriter().info("region recovered..." + regionName);
                revoking.set(0, new Boolean(false));
                revokeThread.join();
                Log.getLogWriter().info("Thread to revoke members terminated");
            }
        }
        catch (Exception ex) {
            String stack = TestHelper.getStackTrace(ex);
            if (stack.indexOf("RegionExistsException") != -1) {
                Log.getLogWriter().warning("RegionExistsException is caught. It may appear in concurrent environment...continuing with the test");
            }
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putObject(String regionName) {
        try {
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            Region region = cache.getRegion(regionName);
            if (region != null) {
                int putKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
                key = ObjectHelper.createName(putKeyInt);
                val = ObjectHelper.createObject(objectType, putKeyInt);
                region.put(key, val);
                Log.getLogWriter().info("----performed put operation on " + regionName + " with " + key);
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent execution mode. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putIfAbsent(String regionName) {
        try {
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            Region region = cache.getRegion(regionName);
            if (region != null) {
                DataPolicy dataPolicy = region.getAttributes().getDataPolicy();
                if (dataPolicy.equals(DataPolicy.NORMAL) || dataPolicy.equals(DataPolicy.EMPTY)) {
                    return;
                }
                int putKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
                key = ObjectHelper.createName(putKeyInt);
                val = ObjectHelper.createObject(objectType, putKeyInt);
                Object retVal = region.putIfAbsent(key, val);
                Log.getLogWriter().info("----performed putIfAbsent operation on " + regionName + " with " + key + ".  putIfAbsent returned " + retVal);
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent execution mode. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void putAllObjects(String regionName) {
        Object key = null;
        Object val = null;
        String objectType = MapPrms.getObjectType();
        TreeMap<Object, Object> m = new TreeMap<Object, Object>();
        int numEntries = TestConfig.tab().getRandGen().nextInt(1, 25);
        int mapSize = 0;
        do {
            int putAllKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_PUT);
            key = ObjectHelper.createName(putAllKeyInt);
            val = ObjectHelper.createObject(objectType, putAllKeyInt);
            m.put(key, val);
        } while (++mapSize < numEntries);
        Region region = cache.getRegion(regionName);
        if (region != null) {
            try {
                region.putAll(m);
                Log.getLogWriter().info("----performed putAll operation on " + regionName + " with map size = " + m.size());
            }
            catch (RegionDestroyedException rdex) {
                Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment mode. Continuing with test.");
                this.recoverRegion(regionName);
            }
            catch (Exception ex) {
                throw new TestException(TestHelper.getStackTrace(ex));
            }
        }
    }

    protected void removeObject(String regionName) {
        try {
            Object key = null;
            Region region = cache.getRegion(regionName);
            if (region != null) {
                int removeKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
                key = ObjectHelper.createName(removeKeyInt);
                Object got = region.get(key);
                if (got == null) {
                    Log.getLogWriter().info("removeObject: " + key + " does NOT exist in " + regionName);
                } else {
                    region.remove(key);
                    Log.getLogWriter().info("----performed remove operation on " + regionName + " with " + key);
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void cm_remove(String regionName) {
        try {
            Object key = null;
            Region region = cache.getRegion(regionName);
            if (region != null) {
                DataPolicy dataPolicy = region.getAttributes().getDataPolicy();
                if (dataPolicy.equals(DataPolicy.NORMAL) || dataPolicy.equals(DataPolicy.EMPTY)) {
                    return;
                }
                int removeKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_REMOVE);
                key = ObjectHelper.createName(removeKeyInt);
                Object got = region.get(key);
                if (got == null) {
                    Log.getLogWriter().info("cm_remove: " + key + " does NOT exist in " + regionName);
                } else {
                    boolean removed = region.remove(key, got);
                    Log.getLogWriter().info("----performed remove operation on " + regionName + " with " + key + " previous value " + got + ".  remove returned " + removed);
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void invalidateObject(String regionName) {
        try {
            Object key = null;
            Region region = cache.getRegion(regionName);
            if (region != null) {
                int invalidateKeyInt = (int)MapBB.getBB().getSharedCounters().incrementAndRead(MapBB.NUM_INVALIDATE);
                key = ObjectHelper.createName(invalidateKeyInt);
                Object got = region.get(key);
                if (got == null) {
                    Log.getLogWriter().info("invalidate: NO entry exists in " + region.getName() + " for key " + key);
                } else {
                    region.invalidate(key);
                    Log.getLogWriter().info("----performed invalidate operation on " + regionName + " with " + key);
                }
            }
        }
        catch (EntryNotFoundException enfe) {
            Log.getLogWriter().info("EntryNotFoundException ...may occur in concurrent execution. Continuing with test.");
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...can occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void clearRegion(String regionName) {
        try {
            Region region = cache.getRegion(regionName);
            if (region != null) {
                region.clear();
                Log.getLogWriter().info("----performed clear operation on region" + regionName);
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void invalidateRegion(String regionName) {
        try {
            Region region = cache.getRegion(regionName);
            if (region != null) {
                region.invalidateRegion();
                Log.getLogWriter().info("----performed invalidateRegion operation on region" + regionName);
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void destroyRegion(String regionName) {
        try {
            Region region = cache.getRegion(regionName);
            if (region != null) {
                region.destroyRegion();
                Log.getLogWriter().info("----performed destroyRegion operation on region" + regionName);
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void forceRollOplogs(String regionName) {
        try {
            int NO_DISK = 1001;
            int DISK_FOR_OVRFLW = 1002;
            int DISK_FOR_PERSIST = 1003;
            int DISK_FOR_OVRFLW_PERSIST = 1004;
            int regionType = 0;
            Region region = cache.getRegion(regionName);
            if (region != null) {
                RegionAttributes attr = region.getAttributes();
                boolean persistentReplicate = attr.getDataPolicy().isPersistentReplicate();
                int evictionLimit = attr.getEvictionAttributes().getMaximum();
                regionType = persistentReplicate ? (evictionLimit <= 0 ? DISK_FOR_PERSIST : DISK_FOR_OVRFLW_PERSIST) : (evictionLimit <= 0 ? NO_DISK : DISK_FOR_OVRFLW);
                if (regionType == DISK_FOR_PERSIST || regionType == DISK_FOR_OVRFLW_PERSIST || regionType == DISK_FOR_OVRFLW) {
                    region.forceRolling();
                    Log.getLogWriter().info("force rolled oplogs");
                }
                if (regionType == NO_DISK) {
                    try {
                        region.forceRolling();
                        throw new TestException("Should have thrown UnsupportedOperationException while performing forceRolling on non disk regions");
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void writeToDisk(String regionName) {
        try {
            int NO_DISK = 1001;
            int DISK_FOR_OVRFLW = 1002;
            int DISK_FOR_PERSIST = 1003;
            int DISK_FOR_OVRFLW_PERSIST = 1004;
            int regionType = 0;
            Region region = cache.getRegion(regionName);
            if (region != null) {
                RegionAttributes attr = region.getAttributes();
                boolean persistentReplicate = attr.getDataPolicy().isPersistentReplicate();
                int evictionLimit = attr.getEvictionAttributes().getMaximum();
                if (persistentReplicate) {
                    if (evictionLimit <= 0) {
                        regionType = DISK_FOR_PERSIST;
                    }
                } else {
                    regionType = DISK_FOR_OVRFLW_PERSIST;
                }
                if (regionType == DISK_FOR_PERSIST || regionType == DISK_FOR_OVRFLW_PERSIST) {
                    region.writeToDisk();
                    Log.getLogWriter().info("writeToDisk performed on region: " + region.getName());
                }
            }
        }
        catch (RegionDestroyedException rdex) {
            Log.getLogWriter().info("RegionDestroyedException...may occur in concurrent environment. Continuing with test.");
            this.recoverRegion(regionName);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }
}

