/*
 * Decompiled with CFR 0.152.
 */
package distcache;

import distcache.DistCache;
import distcache.DistCacheException;
import distcache.DistCachePrms;
import hydra.Log;

public class DistCacheFactory {
    public static DistCache createInstance() {
        try {
            Class<?> cls = null;
            switch (DistCachePrms.getCacheVendor()) {
                case 0: {
                    Log.getLogWriter().fine("Creating a GemFire cache implementation");
                    cls = Class.forName("distcache.gemfire.GemFireCacheTestImpl");
                    break;
                }
                case 1: {
                    Log.getLogWriter().fine("Creating a HashMap cache implementation");
                    cls = Class.forName("distcache.hashmap.HashMapCacheImpl");
                    break;
                }
                default: {
                    throw new DistCacheException("Should not happen");
                }
            }
            DistCache cache = (DistCache)cls.newInstance();
            Log.getLogWriter().fine("Created the cache implementation");
            return cache;
        }
        catch (DistCacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DistCacheException("Problem creating cache implementation", e);
        }
    }
}

