/*
 * Decompiled with CFR 0.152.
 */
package distcache.gemfire;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import distcache.DistCache;
import distcache.DistCacheException;
import distcache.gemfire.GemFireCachePrms;
import hydra.AsyncEventQueueHelper;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.Log;
import hydra.RegionHelper;
import java.util.Map;

public class GemFireCacheTestImpl
implements DistCache {
    private String cacheConfig;
    private String regionConfig;
    private String bridgeConfig;
    private String senderConfig;
    private String receiverConfig;
    private String asyncEventQueueConfig;
    private String cacheName;
    private String regionName;
    private Region region;
    private InterestResultPolicy policy;
    private CacheTransactionManager tm = null;
    private LogWriter log = Log.getLogWriter();
    private boolean fine = this.log.fineEnabled();

    @Override
    public void createCache() throws DistCacheException {
        this.cacheConfig = ConfigPrms.getCacheConfig();
        Cache cache = CacheHelper.createCache(this.cacheConfig);
    }

    @Override
    public void open() throws DistCacheException {
        try {
            this.cacheConfig = ConfigPrms.getCacheConfig();
            this.regionConfig = ConfigPrms.getRegionConfig();
            this.bridgeConfig = ConfigPrms.getBridgeConfig();
            this.senderConfig = ConfigPrms.getGatewaySenderConfig();
            this.receiverConfig = ConfigPrms.getGatewayReceiverConfig();
            this.asyncEventQueueConfig = ConfigPrms.getAsyncEventQueueConfig();
            this.cacheName = "GemFireCacheImpl";
            this.regionName = GemFireCachePrms.getRegionName();
            if (this.regionName == null) {
                this.regionName = RegionHelper.getRegionDescription(this.regionConfig).getRegionName();
            }
            Cache cache = CacheHelper.createCache(this.cacheConfig);
            if (this.senderConfig != null) {
                GatewaySenderHelper.createAndStartGatewaySenders(this.senderConfig);
            }
            if (this.asyncEventQueueConfig != null) {
                AsyncEventQueueHelper.createAndStartAsyncEventQueue(this.asyncEventQueueConfig);
            }
            this.region = RegionHelper.createRegion(this.regionName, this.regionConfig);
            if (this.bridgeConfig != null) {
                BridgeHelper.startBridgeServer(this.bridgeConfig);
            }
            if (this.receiverConfig != null) {
                GatewayReceiverHelper.createAndStartGatewayReceivers(this.receiverConfig);
            }
            this.policy = GemFireCachePrms.getInterestResultPolicy();
            this.tm = cache.getCacheTransactionManager();
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void close() throws DistCacheException {
        try {
            BridgeHelper.stopBridgeServer();
            CacheHelper.closeCache();
            this.region = null;
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public Object getCacheTransactionManager() {
        return this.tm;
    }

    @Override
    public void addMembers(Map caches) throws DistCacheException {
    }

    @Override
    public void createKey(Object key) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Creating key " + key);
            }
            this.region.create(key, null);
            if (this.fine) {
                this.log.fine("Created key " + key);
            }
        }
        catch (EntryExistsException e) {
            throw new DistCacheException(key + " already exists", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void create(Object key, Object value) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Creating key " + key + "=" + value);
            }
            this.region.create(key, value);
            if (this.fine) {
                this.log.fine("Created key " + key + "=" + value);
            }
        }
        catch (EntryExistsException e) {
            throw new DistCacheException(key + " already exists", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void put(Object key, Object value) throws DistCacheException {
        if (value == null) {
            throw new DistCacheException("Cannot put null value");
        }
        try {
            if (this.fine) {
                this.log.fine("Putting key " + key + "=" + value);
            }
            this.region.put(key, value);
            if (this.fine) {
                this.log.fine("Put key " + key + "=" + value);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void synchPut(Object key, Object value) throws DistCacheException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public Object get(Object key) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Getting key " + key);
            }
            Object value = this.region.get(key);
            if (this.fine) {
                this.log.fine("Got key " + key + "=" + value);
            }
            return value;
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public Object localGet(Object key) {
        try {
            if (this.fine) {
                this.log.fine("Locally getting key " + key);
            }
            Object value = this.region.getEntry(key).getValue();
            if (this.fine) {
                this.log.fine("Locally got key " + key + "=" + value);
            }
            return value;
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void invalidate(Object key) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Invalidating key " + key);
            }
            this.region.invalidate(key);
            if (this.fine) {
                this.log.fine("Invalidated key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void localInvalidate(Object key) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Locally invalidating key " + key);
            }
            this.region.localInvalidate(key);
            if (this.fine) {
                this.log.fine("Locally invalidated key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void destroy(Object key) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Destroying key " + key);
            }
            this.region.destroy(key);
            if (this.fine) {
                this.log.fine("Destroyed key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void localDestroy(Object key) throws DistCacheException {
        try {
            if (this.fine) {
                this.log.fine("Locally destroying key " + key);
            }
            this.region.localDestroy(key);
            if (this.fine) {
                this.log.fine("Locally destroyed key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public int size() throws DistCacheException {
        try {
            return this.region.size();
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    public Region getRegion() {
        return this.region;
    }

    public void registerInterest(Object keyOrList, boolean durable) {
        if (this.fine) {
            if (durable) {
                this.log.fine("Registering durable interest in list/key " + keyOrList);
            } else {
                this.log.fine("Registering interest in list/key " + keyOrList);
            }
        }
        this.region.registerInterest(keyOrList, this.policy, durable);
        if (durable) {
            CacheHelper.getCache().readyForEvents();
        }
        if (this.fine) {
            if (durable) {
                this.log.fine("Registered durable interest in list/key " + keyOrList);
            } else {
                this.log.fine("Registered interest in list/key " + keyOrList);
            }
        }
    }

    public void registerInterestRegex(String regex, boolean durable) {
        if (this.fine) {
            if (durable) {
                this.log.fine("Registering durable interest in regex " + regex);
            } else {
                this.log.fine("Registering interest in regex " + regex);
            }
        }
        this.region.registerInterestRegex(regex, this.policy, durable);
        if (durable) {
            CacheHelper.getCache().readyForEvents();
        }
        if (this.fine) {
            if (durable) {
                this.log.fine("Registered durable interest in regex " + regex);
            } else {
                this.log.fine("Registered interest in regex " + regex);
            }
        }
    }
}

