/*
 * Decompiled with CFR 0.152.
 */
package distcache.hashmap;

import com.gemstone.gemfire.LogWriter;
import distcache.DistCache;
import distcache.DistCacheException;
import distcache.hashmap.HashMapCachePrms;
import hydra.Log;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapCacheImpl
implements DistCache {
    private String cacheName = "HashMapCache";
    private ConcurrentHashMap cache;
    private LogWriter log = Log.getLogWriter();
    private boolean fine = this.log.fineEnabled();

    public ConcurrentHashMap getMap() {
        return this.cache;
    }

    @Override
    public void createCache() throws DistCacheException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DistCacheException {
        try {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (this.cache == null) {
                    int initialCapacity = HashMapCachePrms.getInitialCapacity();
                    double loadFactor = HashMapCachePrms.getLoadFactor();
                    int concurrencyLevel = HashMapCachePrms.getConcurrencyLevel();
                    this.cache = new ConcurrentHashMap(initialCapacity, (float)loadFactor, concurrencyLevel);
                    this.log.info("Created cache " + this.cache);
                }
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.cache != null) {
                this.log.info("Releasing the cache");
                this.cache = null;
            }
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public Object getCacheTransactionManager() {
        return null;
    }

    @Override
    public void addMembers(Map caches) throws DistCacheException {
    }

    @Override
    public void createKey(Object key) throws DistCacheException {
        try {
            this.cache.put(key, null);
            if (this.fine) {
                this.log.fine("Created key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void create(Object key, Object value) throws DistCacheException {
        try {
            this.cache.put(key, value);
            if (this.fine) {
                this.log.fine("Created " + key + "=" + value);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void put(Object key, Object value) throws DistCacheException {
        if (value == null) {
            throw new DistCacheException("Cannot put null value");
        }
        try {
            this.cache.put(key, value);
            if (this.fine) {
                this.log.fine("Put key " + key + "=" + value);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void synchPut(Object key, Object value) throws DistCacheException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) throws DistCacheException {
        try {
            Object value = this.cache.get(key);
            if (this.fine) {
                this.log.fine("Got key " + key + "=" + value);
            }
            return value;
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public Object localGet(Object key) {
        try {
            Object value = this.cache.get(key);
            if (this.fine) {
                this.log.fine("Got key " + key + "=" + value);
            }
            return value;
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void invalidate(Object key) throws DistCacheException {
        try {
            this.cache.put(key, null);
            if (this.fine) {
                this.log.fine("Invalidated key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void localInvalidate(Object key) throws DistCacheException {
        try {
            this.cache.put(key, null);
            if (this.fine) {
                this.log.fine("Invalidated key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void destroy(Object key) throws DistCacheException {
        try {
            this.cache.remove(key);
            if (this.fine) {
                this.log.fine("Destroyed key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public void localDestroy(Object key) throws DistCacheException {
        try {
            this.cache.remove(key);
            if (this.fine) {
                this.log.fine("Destroyed key " + key);
            }
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }

    @Override
    public int size() throws DistCacheException {
        try {
            return this.cache.size();
        }
        catch (Exception e) {
            throw new DistCacheException(e);
        }
    }
}

