/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import dlock.DLockBlackboard;
import dlock.DLockPrms;
import dlock.DLockTestException;
import dlock.DLockUtil;
import dlock.Info;
import dlock.Lockable;
import hydra.BasePrms;
import hydra.ClientDescription;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.DistributedConnectionMgr;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import util.CacheUtil;
import util.TestHelper;

public class BasicDLockClient {
    private static Cache TheCache;
    private static Region TheRegion;
    public static final String ROOT_REGION_NAME = "DLockRegion";
    private static Map Wrappers;
    protected static HydraThreadLocal localinfo;
    protected static HydraThreadLocal localindex;

    public static synchronized void createCacheTask() {
        if (TheCache == null) {
            int cacheLockTimeout;
            TheCache = CacheUtil.createCache();
            int cacheLeaseTime = TestConfig.tab().intAt(DLockPrms.cacheLeaseTime, -1);
            if (cacheLeaseTime != -1) {
                Log.getLogWriter().info("Setting cache lock lease time to " + cacheLeaseTime + " seconds");
                TheCache.setLockLease(cacheLeaseTime);
            }
            if ((cacheLockTimeout = TestConfig.tab().intAt(DLockPrms.cacheLockTimeout, -1)) != -1) {
                Log.getLogWriter().info("Setting cache lock timeout to " + cacheLockTimeout + " seconds");
                TheCache.setLockTimeout(cacheLockTimeout);
            }
            RegionAttributes ratts = BasicDLockClient.getRegionAttributes();
            TheRegion = CacheUtil.createRegion(ROOT_REGION_NAME, ratts);
        }
    }

    private static RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        Scope scope = DLockPrms.getScope();
        factory.setScope(DLockPrms.getScope());
        Log.getLogWriter().info("Setting scope to " + scope);
        RegionAttributes ratts = factory.createRegionAttributes();
        return ratts;
    }

    public static synchronized void closeCacheTask() {
        if (TheCache != null) {
            CacheUtil.closeCache();
            TheCache = null;
            TheRegion = null;
        }
    }

    public static void createDataTask() {
        HydraVector datatypes = BasicDLockClient.tab().vecAt(DLockPrms.datatypes);
        if (datatypes == null) {
            throw new HydraConfigException("No datatypes specified");
        }
        for (int i = 0; i < datatypes.size(); ++i) {
            String datatype = (String)datatypes.elementAt(i);
            int datasize = BasicDLockClient.tab().intAtWild(DLockPrms.datasizes, i, 1);
            if (datasize <= 0) {
                throw new HydraConfigException("Datatype " + datatype + " must have positive datasize");
            }
            BasicDLockClient.log().info("Creating " + datasize + " lockable objects of type " + datatype + " in region " + TheRegion.getName());
            for (int j = 0; j < datasize; ++j) {
                Object name = BasicDLockClient.generateName(datatype, i, j);
                Lockable wrapper = BasicDLockClient.generateWrapper(datatype);
                wrapper.createDataInCache(TheRegion, name);
            }
        }
        BasicDLockClient.log().info("CONTENTS:\n" + CacheUtil.getContentString(TheRegion, true));
    }

    public static void initTask() {
        HydraVector datatypes = BasicDLockClient.tab().vecAt(DLockPrms.datatypes);
        int total = 0;
        for (int i = 0; i < datatypes.size(); ++i) {
            int datasize = BasicDLockClient.tab().intAtWild(DLockPrms.datasizes, i, 1);
            total += datasize;
        }
        Info[] info = new Info[total];
        int index = 0;
        for (int i = 0; i < datatypes.size(); ++i) {
            String datatype = (String)datatypes.elementAt(i);
            int datasize = BasicDLockClient.tab().intAtWild(DLockPrms.datasizes, i, 1);
            for (int j = 0; j < datasize; ++j) {
                Object name = BasicDLockClient.generateName(datatype, i, j);
                Lockable wrapper = BasicDLockClient.generateWrapper(datatype);
                info[index] = new Info(name, wrapper);
                ++index;
            }
        }
        BasicDLockClient.log().info(BasicDLockClient.infoAsShortStrings(info));
        localinfo.set(info);
        localindex.set(new Integer(0));
    }

    private static synchronized Lockable generateWrapper(String datatype) {
        Lockable wrapper = (Lockable)Wrappers.get(datatype);
        if (wrapper == null) {
            try {
                Class<?> cls = Class.forName(datatype);
                wrapper = (Lockable)cls.newInstance();
                Wrappers.put(datatype, wrapper);
            }
            catch (ClassNotFoundException e) {
                throw new HydraConfigException(datatype + " not found", e);
            }
            catch (ClassCastException e) {
                throw new HydraConfigException(datatype + " does not implement Lockable", e);
            }
            catch (IllegalAccessException e) {
                throw new HydraConfigException("Unable to access code for " + datatype, e);
            }
            catch (InstantiationException e) {
                throw new HydraConfigException("Unable to instantiate " + datatype, e);
            }
        }
        return wrapper;
    }

    public static void noContentionTask() {
        BasicDLockClient client = new BasicDLockClient();
        client.noContentionWork();
    }

    private void noContentionWork() {
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        Info[] info = (Info[])localinfo.get();
        int totalObjects = info.length;
        int totalThreads = TestConfig.getInstance().getTotalThreads();
        if (totalThreads > totalObjects) {
            throw new HydraConfigException("Fewer objects than client threads");
        }
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        int i = tid % totalObjects;
        for (int it = 0; it < BasicDLockClient.tab().intAt(DLockPrms.iterations); ++it) {
            int counter;
            int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
            Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
            if (getLockFirst) {
                for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                    info[i].getWrapper().lock(TheRegion, info[i].getName());
                    info[i].incrementLocks();
                }
            }
            info[i].getWrapper().update(TheRegion, info[i].getName());
            info[i].incrementUpdates();
            if (!getLockFirst) continue;
            for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                info[i].getWrapper().unlock(TheRegion, info[i].getName());
                info[i].incrementUnlocks();
            }
            this.checkLocksNotHeldByThisThread(info[i].getName());
        }
    }

    public static void singleFileTask() {
        BasicDLockClient client = new BasicDLockClient();
        client.singleFileWork();
    }

    private void singleFileWork() {
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        Info[] info = (Info[])localinfo.get();
        int maxobjects = info.length;
        int i = (Integer)localindex.get();
        for (int it = 0; it < BasicDLockClient.tab().intAt(DLockPrms.iterations); ++it) {
            int counter;
            int n;
            int numToLock = BasicDLockClient.tab().intAt(DLockPrms.numToLock);
            int loop_start = i;
            int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
            Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
            if (getLockFirst) {
                i = loop_start;
                for (n = 0; n < numToLock; ++n) {
                    for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                        info[i].getWrapper().lock(TheRegion, info[i].getName());
                        info[i].incrementLocks();
                    }
                    if (++i != maxobjects) continue;
                    i = 0;
                }
            }
            i = loop_start;
            for (n = 0; n < numToLock; ++n) {
                info[i].getWrapper().update(TheRegion, info[i].getName());
                info[i].incrementUpdates();
                if (++i != maxobjects) continue;
                i = 0;
            }
            if (!getLockFirst) continue;
            i = loop_start;
            for (n = 0; n < numToLock; ++n) {
                for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                    info[i].getWrapper().unlock(TheRegion, info[i].getName());
                    info[i].incrementUnlocks();
                }
                this.checkLocksNotHeldByThisThread(info[i].getName());
                if (++i != maxobjects) continue;
                i = 0;
            }
        }
        localindex.set(new Integer(i));
    }

    public static void randomLockTask() {
        BasicDLockClient client = new BasicDLockClient();
        client.randomLockWork();
    }

    protected void randomLockWork() {
        Log.getLogWriter().info("Starting randomLockWork");
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        Info[] info = (Info[])localinfo.get();
        GsRandom rng = BasicDLockClient.tab().getRandGen();
        for (int it = 0; it < BasicDLockClient.tab().intAt(DLockPrms.iterations); ++it) {
            int counter;
            int i;
            int numToLock = BasicDLockClient.tab().intAt(DLockPrms.numToLock);
            if (numToLock > info.length) {
                throw new HydraConfigException(BasePrms.nameForKey(DLockPrms.numToLock) + " is larger than the number of object available");
            }
            Log.getLogWriter().info("Finding object to lock: " + numToLock);
            for (int n = 0; n < numToLock; ++n) {
                while (info[i = rng.nextInt(0, info.length - 1)].isLocked()) {
                }
                info[i].setLocked(true);
            }
            int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
            Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
            if (getLockFirst) {
                for (i = 0; i < info.length; ++i) {
                    if (!info[i].isLocked()) continue;
                    for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                        info[i].getWrapper().lock(TheRegion, info[i].getName());
                        info[i].incrementLocks();
                    }
                }
            }
            for (i = 0; i < info.length; ++i) {
                if (!info[i].isLocked()) continue;
                info[i].getWrapper().update(TheRegion, info[i].getName());
                info[i].incrementUpdates();
            }
            if (getLockFirst) {
                for (i = 0; i < info.length; ++i) {
                    if (!info[i].isLocked()) continue;
                    for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                        info[i].getWrapper().unlock(TheRegion, info[i].getName());
                        info[i].incrementUnlocks();
                    }
                    this.checkLocksNotHeldByThisThread(info[i].getName());
                }
            }
            for (i = 0; i < info.length; ++i) {
                info[i].setLocked(false);
            }
        }
    }

    public static void lockRegionTask() {
        BasicDLockClient client = new BasicDLockClient();
        client.lockRegionWork();
    }

    private void lockRegionWork() {
        Lock aLock;
        int counter;
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        Info[] info = (Info[])localinfo.get();
        int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
        if (numTimesToEnterLock > 1) {
            throw new IllegalArgumentException("Test parameter is invalid because RegionDistributedLock is non-re-entrant");
        }
        Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
        if (getLockFirst) {
            for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                Log.getLogWriter().info("Getting region lock on " + TheRegion.getName());
                aLock = TheRegion.getRegionDistributedLock();
                aLock.lock();
                Log.getLogWriter().info("Done getting region lock on " + TheRegion.getName());
            }
        }
        for (int i = 0; i < info.length; ++i) {
            info[i].getWrapper().update(TheRegion, info[i].getName());
            info[i].incrementUpdates();
        }
        if (getLockFirst) {
            for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                Log.getLogWriter().info("Unlocking region " + TheRegion.getName());
                aLock = TheRegion.getRegionDistributedLock();
                aLock.unlock();
                Log.getLogWriter().info("Done unlocking region " + TheRegion.getName());
            }
        }
    }

    public static void lockEmAllAtOnceTask() {
        BasicDLockClient client = new BasicDLockClient();
        client.lockEmAllAtOnceWork();
    }

    private void lockEmAllAtOnceWork() {
        int counter;
        int i;
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        Info[] info = (Info[])localinfo.get();
        int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
        Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
        if (getLockFirst) {
            for (i = 0; i < info.length; ++i) {
                for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                    info[i].getWrapper().lock(TheRegion, info[i].getName());
                    info[i].incrementLocks();
                }
            }
        }
        for (i = 0; i < info.length; ++i) {
            info[i].getWrapper().update(TheRegion, info[i].getName());
            info[i].incrementUpdates();
        }
        if (getLockFirst) {
            for (i = 0; i < info.length; ++i) {
                for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                    info[i].getWrapper().unlock(TheRegion, info[i].getName());
                    info[i].incrementUnlocks();
                }
                this.checkLocksNotHeldByThisThread(info[i].getName());
            }
        }
    }

    public static void initBBCrashLockHolderTask() {
        BasicDLockClient client = new BasicDLockClient();
        client.initBBCrashLockHolderWork();
    }

    private void initBBCrashLockHolderWork() {
        DLockBlackboard bb = DLockBlackboard.getInstance();
        SharedCounters sc = bb.getSharedCounters();
        sc.increment(DLockBlackboard.NumCurrentThreads);
    }

    public static void crashLockHolderTask() throws ClientVmNotFoundException {
        BasicDLockClient client = new BasicDLockClient();
        client.crashLockHolderWork();
    }

    private void crashLockHolderWork() throws ClientVmNotFoundException {
        int counter;
        int i;
        if (TheCache == null) {
            BasicDLockClient.createCacheTask();
        }
        DLockBlackboard bb = DLockBlackboard.getInstance();
        SharedCounters sc = bb.getSharedCounters();
        int numVms = TestHelper.getNumVMs();
        int totalThreadsInTest = TestHelper.getNumThreads();
        ClientDescription clientDesc = TestConfig.getInstance().getClientDescription(RemoteTestModule.getMyClientName());
        int numThreadsInClientVm = clientDesc.getVmThreads();
        Info[] info = (Info[])localinfo.get();
        int waitLimit = 360000;
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        int numTimesToCrash = BasicDLockClient.tab().intAt(DLockPrms.numTimesToCrash);
        int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
        boolean crashGrantor = BasicDLockClient.tab().booleanAt(DLockPrms.crashGrantor);
        Log.getLogWriter().info("### total threads: " + totalThreadsInTest);
        Log.getLogWriter().info("### num Vms: " + numVms);
        Log.getLogWriter().info("### num in this client VM: " + numThreadsInClientVm);
        Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
        Log.getLogWriter().info("numTimesToCrash is " + numTimesToCrash);
        int numCurrentThreads = (int)sc.read(DLockBlackboard.NumCurrentThreads);
        sc.increment(DLockBlackboard.ReadyToLock);
        TestHelper.waitForCounter(bb, "DLockBlackboard.ReadyToLock", DLockBlackboard.ReadyToLock, numCurrentThreads, true, waitLimit);
        sc.zero(DLockBlackboard.DoneWithTask);
        Log.getLogWriter().info("###Thread ready to lock: " + Thread.currentThread().getName());
        Log.getLogWriter().info("###CrashGrantor is: " + crashGrantor);
        boolean isGrantor = ((DistributedRegion)TheRegion).getLockService().isLockGrantor();
        Log.getLogWriter().info("###isGrantor is: " + isGrantor);
        if (getLockFirst) {
            for (i = 0; i < info.length; ++i) {
                for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                    info[i].getWrapper().lock(TheRegion, info[i].getName());
                    info[i].incrementLocks();
                }
            }
        }
        if (crashGrantor == isGrantor && (long)numTimesToCrash > sc.incrementAndRead(DLockBlackboard.NumCrashes) - 1L) {
            Log.getLogWriter().info("###### testing crash");
            sc.subtract(DLockBlackboard.NumCurrentThreads, numThreadsInClientVm);
            sc.add(DLockBlackboard.DoneWithTask, numThreadsInClientVm);
            sc.add(DLockBlackboard.DoneWithLock, numThreadsInClientVm);
            BasicDLockClient.closeTask();
            ClientVmMgr.stopAsync("testing crash", -21, -32);
            return;
        }
        for (i = 0; i < info.length; ++i) {
            info[i].getWrapper().update(TheRegion, info[i].getName());
            info[i].incrementUpdates();
        }
        if (getLockFirst) {
            for (i = 0; i < info.length; ++i) {
                for (counter = 1; counter <= numTimesToEnterLock; ++counter) {
                    info[i].getWrapper().unlock(TheRegion, info[i].getName());
                    info[i].incrementUnlocks();
                }
                this.checkLocksNotHeldByThisThread(info[i].getName());
            }
        }
        Log.getLogWriter().info("###numThreads after possible crash: " + numCurrentThreads);
        sc.increment(DLockBlackboard.DoneWithLock);
        TestHelper.waitForCounter(bb, "DLockBlackboard.DoneWithLock", DLockBlackboard.DoneWithLock, numCurrentThreads, true, Integer.MAX_VALUE);
        Log.getLogWriter().info("###DoneWithLock: " + sc.read(DLockBlackboard.DoneWithLock));
        sc.zero(DLockBlackboard.ReadyToLock);
        sc.increment(DLockBlackboard.DoneWithTask);
        TestHelper.waitForCounter(bb, "DLockBlackboard.DoneWithLock", DLockBlackboard.DoneWithTask, numCurrentThreads, true, waitLimit);
        Log.getLogWriter().info("###DoneWithTask: " + sc.read(DLockBlackboard.DoneWithTask));
        sc.zero(DLockBlackboard.DoneWithLock);
    }

    public static void stickLocks() {
        BasicDLockClient client = new BasicDLockClient();
        client.stickLocksWork();
    }

    private void stickLocksWork() {
        boolean getLockFirst = BasicDLockClient.tab().booleanAt(DLockPrms.getLockFirst);
        Info[] info = (Info[])localinfo.get();
        GsRandom rng = BasicDLockClient.tab().getRandGen();
        for (int it = 0; it < BasicDLockClient.tab().intAt(DLockPrms.iterations); ++it) {
            int i;
            int numToLock = BasicDLockClient.tab().intAt(DLockPrms.numToLock);
            if (numToLock > info.length) {
                throw new HydraConfigException(BasePrms.nameForKey(DLockPrms.numToLock) + " is larger than the number of object available");
            }
            for (int n = 0; n < numToLock; ++n) {
                while (info[i = rng.nextInt(0, info.length - 1)].isLocked()) {
                }
                info[i].setLocked(true);
            }
            int numTimesToEnterLock = BasicDLockClient.tab().intAt(DLockPrms.numTimesToEnterLock);
            Log.getLogWriter().info("numTimesToEnterLock is " + numTimesToEnterLock);
            if (getLockFirst) {
                for (i = 0; i < info.length; ++i) {
                    if (!info[i].isLocked()) continue;
                    for (int counter = 1; counter <= numTimesToEnterLock; ++counter) {
                        info[i].getWrapper().lock(TheRegion, info[i].getName());
                        info[i].incrementLocks();
                    }
                }
            }
            for (i = 0; i < info.length; ++i) {
                if (!info[i].isLocked()) continue;
                info[i].getWrapper().update(TheRegion, info[i].getName());
                info[i].incrementUpdates();
            }
            for (i = 0; i < info.length; ++i) {
                info[i].setLocked(false);
            }
            BasicDLockClient.log().info("Bouncing connection..");
            BasicDLockClient.log().info("Old connection -> " + DistributedConnectionMgr.getConnection());
            DistributedConnectionMgr.disconnect();
            DistributedConnectionMgr.connect();
            BasicDLockClient.log().info("New connection -> " + DistributedConnectionMgr.getConnection());
        }
    }

    public static void closeTask() {
        Info[] info = (Info[])localinfo.get();
        BasicDLockClient.log().info(info.toString());
        SharedMap map = DLockBlackboard.getInstance().getSharedMap();
        String key = "UpdateCounts" + RemoteTestModule.getCurrentThread().getThreadId();
        map.put(key, info);
    }

    public static void validateTask() {
        Info[] totalinfo = null;
        SharedMap map = DLockBlackboard.getInstance().getSharedMap();
        for (String key : map.getMap().keySet()) {
            if (!key.startsWith("UpdateCounts")) continue;
            Info[] info = (Info[])map.get(key);
            if (totalinfo == null) {
                totalinfo = new Info[info.length];
            }
            for (int i = 0; i < info.length; ++i) {
                if (totalinfo[i] == null) {
                    totalinfo[i] = info[i];
                    continue;
                }
                totalinfo[i].addInfo(info[i]);
            }
        }
        for (int i = 0; i < totalinfo.length; ++i) {
            totalinfo[i].getWrapper().validate(TheRegion, (Info)totalinfo[i]);
        }
    }

    private void checkLocksNotHeldByThisThread(Object name) {
        if (TestConfig.tab().booleanAt(DLockPrms.useEntryLock)) {
            return;
        }
        boolean hasLock = DLockUtil.hasLock(name);
        if (hasLock) {
            throw new DLockTestException("Expected this thread to hold no locks on " + name + ", but hasLock is " + hasLock);
        }
    }

    private static Object generateName(String datatype, int i, int j) {
        return datatype + "_" + i + "_" + j;
    }

    private static String infoAsShortStrings(Info[] info) {
        StringBuffer buf = new StringBuffer();
        buf.append("INFO....");
        for (int i = 0; i < info.length; ++i) {
            buf.append("\n    " + info[i].toShortString());
        }
        return buf.toString();
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }

    protected static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    static {
        Wrappers = new HashMap();
        localinfo = new HydraThreadLocal();
        localindex = new HydraThreadLocal();
    }
}

