/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.DistributedConnectionMgr;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.util.concurrent.locks.Lock;
import util.TestException;

public class DLockUtil {
    public static final String LOCK_SERVICE_NAME = "MyLockService";

    public static synchronized DistributedLockService getLockService() {
        DistributedLockService dls = DistributedLockService.getServiceNamed((String)LOCK_SERVICE_NAME);
        if (dls == null) {
            DistributedSystem ds = DistributedConnectionMgr.connect();
            if (ds == null) {
                throw new TestException("DistributedSystem is " + ds);
            }
            dls = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)ds);
        }
        return dls;
    }

    public static void getLock(Object name) {
        DLockUtil.getLock(name, Long.MAX_VALUE);
    }

    public static void getEntryLock(Region aRegion, Object key) {
        Lock aLock = aRegion.getDistributedLock(key);
        long startTime = System.currentTimeMillis();
        aLock.lock();
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("Getting entry lock on " + key + " took " + (endTime - startTime) + " ms");
    }

    public static void unlockEntryLock(Region aRegion, Object key) {
        Lock aLock = aRegion.getDistributedLock(key);
        long startTime = System.currentTimeMillis();
        aLock.unlock();
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("Unlocking entry lock for " + key + " took " + (endTime - startTime) + " ms");
    }

    public static void getLock(Object name, long timeoutMs) {
        DistributedLockService dls = DLockUtil.getLockService();
        long startTime = System.currentTimeMillis();
        boolean lock = dls.lock(name, timeoutMs, -1L);
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("Getting lock on " + name + " took " + (endTime - startTime) + " ms");
        if (!lock) {
            throw new HydraRuntimeException("Timed out getting lock on " + name + " with timeout set to " + timeoutMs);
        }
    }

    public static void unlock(Object name) {
        if (!DLockUtil.hasLock(name)) {
            throw new HydraRuntimeException("Thread does not have the lock on " + name);
        }
        DistributedLockService dls = DLockUtil.getLockService();
        long startTime = System.currentTimeMillis();
        dls.unlock(name);
        long endTime = System.currentTimeMillis();
        Log.getLogWriter().info("Unlocking " + name + " took " + (endTime - startTime) + " ms");
    }

    public static boolean hasLock(Object name) {
        return DLockUtil.getLockService().isHeldByCurrentThread(name);
    }
}

