/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import dlock.DLockBlackboard;
import dlock.DLockPrms;
import dlock.DLockUtil;
import hydra.Log;
import hydra.MasterController;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.Iterator;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class LeaseTimeTest {
    protected static final String ObjectToLock = "objectToLock";
    protected static final int lockOrderIndex = 0;
    protected static final int startTimeIndex = 1;
    protected static final int grantTimeIndex = 2;
    protected static final int releaseTimeIndex = 3;
    protected static final int leaseTimeIndex = 4;
    protected static final int resultsArrSize = 5;

    public static void HydraTask_leaseTimeTest() {
        LeaseTimeTest testInstance = new LeaseTimeTest();
        testInstance.doLeaseTimeTest();
    }

    public static void HydraTask_validateResults() {
        LeaseTimeTest testInstance = new LeaseTimeTest();
        testInstance.checkResultsInBlackboard();
    }

    private void doLeaseTimeTest() {
        DLockBlackboard bb = DLockBlackboard.getInstance();
        bb.getSharedMap().put(Thread.currentThread().getName(), "empty");
        SharedCounters sc = bb.getSharedCounters();
        int numThreads = TestHelper.getNumThreads();
        int leaseTime = TestConfig.tab().intAt(DLockPrms.leaseTime);
        Log.getLogWriter().info("numThreads is " + numThreads + "; lease time is " + leaseTime + " millis");
        DistributedLockService dls = DLockUtil.getLockService();
        DM dm = ((DLockService)dls).getDistributionManager();
        int waitLimit = 360000;
        sc.increment(DLockBlackboard.ReadyToLock);
        TestHelper.waitForCounter(bb, "DLockBlackboard.ReadyToLock", DLockBlackboard.ReadyToLock, numThreads, true, waitLimit, 0L);
        Log.getLogWriter().info("Sleeping for 15 seconds");
        MasterController.sleepForMs(15000);
        Log.getLogWriter().info("Done Sleeping for 15 seconds");
        long startTime = dm.cacheTimeMillis();
        boolean result = dls.lock((Object)ObjectToLock, -1L, (long)leaseTime);
        long grantTime = dm.cacheTimeMillis();
        long lockOrder = sc.incrementAndRead(DLockBlackboard.LockOrder);
        Log.getLogWriter().info("Got the lock, result is " + result + ", lockOrder is " + lockOrder);
        while (dls.isHeldByCurrentThread((Object)ObjectToLock)) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        long releaseTime = dm.cacheTimeMillis();
        long waitTimeForLock = grantTime - startTime;
        long actualLeaseTime = releaseTime - grantTime;
        long diff = Math.abs(actualLeaseTime - (long)leaseTime);
        Log.getLogWriter().info("Waited " + waitTimeForLock + " millis for lock; set lease time " + leaseTime + " millis; actual lease time " + actualLeaseTime + " millis (difference is " + diff + "); order of getting lock was " + lockOrder + " out of " + numThreads);
        if (!result) {
            throw new TestException("Result of getting lock is " + result);
        }
        Object[] resultsArr = new Object[]{new Long(lockOrder), new Long(startTime), new Long(grantTime), new Long(releaseTime), new Long(leaseTime)};
        bb.getSharedMap().put(Thread.currentThread().getName(), resultsArr);
    }

    protected void checkResultsInBlackboard() {
        Map aMap = DLockBlackboard.getInstance().getSharedMap().getMap();
        int numLocks = aMap.size();
        String[] threadIDArr = new String[numLocks];
        long[] startTimeArr = new long[numLocks];
        long[] grantTimeArr = new long[numLocks];
        long[] releaseTimeArr = new long[numLocks];
        long[] leaseTimeArr = new long[numLocks];
        long[] waitTimeArr = new long[numLocks];
        long[] actualLeaseTimeArr = new long[numLocks];
        long[] leaseTimeDiffArr = new long[numLocks];
        long[] waitTimeAfterAvailArr = new long[numLocks];
        Iterator it = aMap.keySet().iterator();
        long minStartTime = Long.MAX_VALUE;
        long maxStartTime = Long.MIN_VALUE;
        while (it.hasNext()) {
            String key = (String)it.next();
            Object[] anArr = (Object[])aMap.get(key);
            int lockOrder = (int)((Long)anArr[0]).longValue();
            long startTime = (Long)anArr[1];
            long grantTime = (Long)anArr[2];
            long releaseTime = (Long)anArr[3];
            long leaseTime = (Long)anArr[4];
            int lockOrderIndex = lockOrder - 1;
            threadIDArr[lockOrderIndex] = key;
            startTimeArr[lockOrderIndex] = startTime;
            grantTimeArr[lockOrderIndex] = grantTime;
            releaseTimeArr[lockOrderIndex] = releaseTime;
            leaseTimeArr[lockOrderIndex] = leaseTime;
            waitTimeArr[lockOrderIndex] = grantTime - startTime;
            actualLeaseTimeArr[lockOrderIndex] = releaseTime - grantTime;
            leaseTimeDiffArr[lockOrderIndex] = Math.abs(actualLeaseTimeArr[lockOrderIndex] - leaseTime);
            minStartTime = Math.min(minStartTime, startTime);
            maxStartTime = Math.max(maxStartTime, startTime);
        }
        StringBuffer aStr = new StringBuffer();
        for (int i = 0; i < threadIDArr.length; ++i) {
            waitTimeAfterAvailArr[i] = i == 0 ? grantTimeArr[i] - startTimeArr[i] : grantTimeArr[i] - releaseTimeArr[i - 1];
            aStr.append("Lock " + (i + 1) + " granted to " + threadIDArr[i] + "\n" + "   lease time: " + leaseTimeArr[i] + " ms\n" + "   start time: " + startTimeArr[i] + "\n" + "   grant time: " + grantTimeArr[i] + "\n" + "   release time: " + releaseTimeArr[i] + "\n" + "   lock wait time: " + waitTimeArr[i] + "\n" + "   actual lease time: " + actualLeaseTimeArr[i] + "\n" + "   difference between lease time and actual: " + leaseTimeDiffArr[i] + " ms\n" + "   time it took to get the lock after the lock became available: " + waitTimeAfterAvailArr[i] + " ms\n");
        }
        aStr.append("Min start time: " + minStartTime + "\n");
        aStr.append("Max start time: " + maxStartTime + "\n");
        long diff = maxStartTime - minStartTime;
        aStr.append("Difference between min and max start time: " + diff + "ms\n");
        Log.getLogWriter().info(aStr.toString());
        aStr = new StringBuffer();
        long upperThreshold = 1000L;
        long lowerThreshold = 500L;
        for (int i = 0; i < threadIDArr.length; ++i) {
            if (actualLeaseTimeArr[i] < leaseTimeArr[i] - lowerThreshold) {
                aStr.append("Bug 33006 detected; For lock acquisition " + (i + 1) + ", thread " + threadIDArr[i] + ", lease was not held long enough, actual lease time was " + actualLeaseTimeArr[i] + ", but lease time is " + leaseTimeArr[i] + "\n");
            } else if (leaseTimeDiffArr[i] > upperThreshold) {
                aStr.append("For lock acquisition " + (i + 1) + ", thread " + threadIDArr[i] + ", actual lease time was " + leaseTimeArr[i] + " ms, but lock was held for " + actualLeaseTimeArr[i] + " ms, difference in time is " + leaseTimeDiffArr[i] + "\n");
            }
            if (i == 0) {
                if (waitTimeAfterAvailArr[i] <= upperThreshold) continue;
                aStr.append("For lock acquisition " + (i + 1) + ", wait time in thread " + threadIDArr[i] + " took " + waitTimeAfterAvailArr[i] + " millis (too long!)\n");
                continue;
            }
            if (waitTimeAfterAvailArr[i] <= upperThreshold) continue;
            aStr.append("For lock acquistion " + (i + 1) + ", previous thread " + threadIDArr[i - 1] + " released its lock at " + releaseTimeArr[i - 1] + ", thread " + threadIDArr[i] + " obtained the lock at " + grantTimeArr[i] + ", difference in time is " + waitTimeAfterAvailArr[i] + " ms (too long!)\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new TestException("Test was interrupted", e);
        }
    }
}

