/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import dlock.DLockPrms;
import dlock.DLockUtil;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.io.Serializable;
import util.CacheUtil;
import util.NameFactory;

public class StressDLockClient {
    private static Cache TheCache;
    private static Region TheRegion;
    private static final String ROOT_REGION_NAME = "DLockRegion";
    private SharedCounters counters;

    public static synchronized void createCacheTask() {
        if (TheCache == null) {
            TheCache = CacheUtil.createCache();
            RegionAttributes ratts = StressDLockClient.getRegionAttributes();
            TheRegion = CacheUtil.createRegion(ROOT_REGION_NAME, ratts);
        }
    }

    private static RegionAttributes getRegionAttributes() {
        AttributesFactory factory = new AttributesFactory();
        Scope scope = DLockPrms.getScope();
        factory.setScope(scope);
        Log.getLogWriter().info("Setting scope to " + scope);
        RegionAttributes ratts = factory.createRegionAttributes();
        return ratts;
    }

    public static synchronized void closeCacheTask() {
        if (TheCache != null) {
            CacheUtil.closeCache();
            TheCache = null;
            TheRegion = null;
        }
    }

    public static void createDataTask() {
        int n = StressDLockClient.tab().intAt(DLockPrms.numLocks);
        for (int i = 0; i < n; ++i) {
            SerializableObject val = new SerializableObject();
            String key = NameFactory.getObjectNameForCounter(i);
            CacheUtil.put(TheRegion, key, val);
        }
    }

    public static void lockByTidTask() {
        StressDLockClient client = new StressDLockClient();
        client.lockByTidWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockByTidWork() {
        int n = StressDLockClient.tab().intAt(DLockPrms.numLocks);
        int tid = RemoteTestModule.getCurrentThread().getThreadId();
        int index = tid % n;
        String key = NameFactory.getObjectNameForCounter(index);
        boolean sleep = StressDLockClient.tab().booleanAt(DLockPrms.sleep);
        int iterations = StressDLockClient.tab().intAt(DLockPrms.iterations);
        for (int i = 0; i < iterations; ++i) {
            StressDLockClient.log().info("locking " + key);
            DLockUtil.getLock(key);
            StressDLockClient.log().info("locked " + key);
            try {
                if (!sleep) continue;
                this.sleep();
                continue;
            }
            finally {
                StressDLockClient.log().info("unlocking " + key);
                DLockUtil.unlock(key);
                StressDLockClient.log().info("unlocked " + key);
            }
        }
    }

    private void sleep() {
        try {
            int sleepMs = StressDLockClient.tab().intAt(DLockPrms.sleepMs);
            if (sleepMs > 0) {
                Thread.sleep(sleepMs);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }

    public static class SerializableObject
    implements Serializable {
    }
}

