/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.NanoTimer;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import java.util.ArrayList;
import util.CacheUtil;

public class ArrayListWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        ArrayList obj = new ArrayList();
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        ArrayList obj = (ArrayList)CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.ArrayListReads);
    }

    @Override
    protected Object update(Object obj) {
        ArrayList newobj = (ArrayList)obj;
        newobj.add(String.valueOf(NanoTimer.getTime()));
        return newobj;
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.ArrayListUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        ArrayList obj = (ArrayList)CacheUtil.get(region, info.getName());
        if ((long)obj.size() != info.getUpdates()) {
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

