/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import java.util.HashSet;
import util.CacheUtil;
import util.NameFactory;

public class HashSetWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        HashSet obj = new HashSet();
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        HashSet obj = (HashSet)CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.HashSetReads);
    }

    @Override
    protected Object update(Object obj) {
        HashSet newobj = (HashSet)obj;
        newobj.add(NameFactory.getNextPositiveObjectName());
        return newobj;
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.HashSetUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        HashSet obj = (HashSet)CacheUtil.get(region, info.getName());
        if ((long)obj.size() != info.getUpdates()) {
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

