/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import util.CacheUtil;

public class IntegerWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        Integer obj = new Integer(0);
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        Integer obj = (Integer)CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.IntegerReads);
    }

    @Override
    protected Object update(Object obj) {
        return new Integer((Integer)obj + 1);
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.IntegerUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        Integer obj = (Integer)CacheUtil.get(region, info.getName());
        if ((long)obj.intValue() != info.getUpdates()) {
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

