/*
 * Decompiled with CFR 0.152.
 */
package dlock.lockable;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.NanoTimer;
import dlock.DLockBlackboard;
import dlock.DLockTestException;
import dlock.Info;
import dlock.lockable.BaseWrapper;
import java.util.LinkedList;
import util.CacheUtil;

public class LinkedListWrapper
extends BaseWrapper {
    @Override
    public void createDataInCache(Region region, Object name) {
        LinkedList obj = new LinkedList();
        CacheUtil.put(region, name, obj);
    }

    @Override
    public void read(Region region, Object name) {
        LinkedList obj = (LinkedList)CacheUtil.get(region, name);
        this.counters.increment(DLockBlackboard.LinkedListReads);
    }

    @Override
    protected Object update(Object obj) {
        LinkedList newobj = (LinkedList)obj;
        newobj.add(String.valueOf(NanoTimer.getTime()));
        return newobj;
    }

    @Override
    protected void noteUpdate() {
        this.counters.increment(DLockBlackboard.LinkedListUpdates);
    }

    @Override
    public void validate(Region region, Info info) {
        LinkedList obj = (LinkedList)CacheUtil.get(region, info.getName());
        if ((long)obj.size() != info.getUpdates()) {
            throw new DLockTestException("Object data is invalid for " + info.getName() + " with expected count " + info.getUpdates() + ": " + obj);
        }
    }
}

