/*
 * Decompiled with CFR 0.152.
 */
package dunit;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemFailure;
import dunit.RMIException;
import java.util.concurrent.TimeoutException;

public class AsyncInvocation
extends Thread {
    private static final ThreadLocal returnValue = new ThreadLocal();
    private static final ThreadGroup GROUP = new AsyncInvocationGroup();
    protected volatile Throwable exception;
    private Object receiver;
    private String methodName;
    public volatile Object returnedObj = null;

    public AsyncInvocation(Object receiver, String methodName, Runnable work) {
        super(GROUP, work, AsyncInvocation.getName(receiver, methodName));
        this.receiver = receiver;
        this.methodName = methodName;
        this.exception = null;
    }

    private static String getName(Object receiver, String methodName) {
        StringBuffer sb = new StringBuffer(methodName);
        sb.append(" invoked on ");
        if (receiver instanceof Class) {
            sb.append("class ");
            sb.append(((Class)receiver).getName());
        } else {
            sb.append("an instance of ");
            sb.append(receiver.getClass().getName());
        }
        return sb.toString();
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean exceptionOccurred() {
        if (this.isAlive()) {
            throw new InternalGemFireError("Exception status not available while thread is alive.");
        }
        return this.exception != null;
    }

    public Throwable getException() {
        if (this.isAlive()) {
            throw new InternalGemFireError("Exception status not available while thread is alive.");
        }
        if (this.exception instanceof RMIException) {
            return ((RMIException)((Object)this.exception)).getCause();
        }
        return this.exception;
    }

    public Object getResult() throws Throwable {
        this.join();
        if (this.exceptionOccurred()) {
            throw new Exception("An exception occured during async invocation", this.exception);
        }
        return this.returnedObj;
    }

    public Object getResult(long waitTime) throws Throwable {
        this.join(waitTime);
        if (this.isAlive()) {
            throw new TimeoutException();
        }
        if (this.exceptionOccurred()) {
            throw new Exception("An exception occured during async invocation", this.exception);
        }
        return this.returnedObj;
    }

    public Object getReturnValue() {
        if (this.isAlive()) {
            throw new InternalGemFireError("Return value not available while thread is alive.");
        }
        return this.returnedObj;
    }

    @Override
    public void run() {
        super.run();
        this.returnedObj = returnValue.get();
        returnValue.set(null);
    }

    static void setReturnValue(Object v) {
        returnValue.set(v);
    }

    private static class AsyncInvocationGroup
    extends ThreadGroup {
        AsyncInvocationGroup() {
            super("Async Invocations");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError) {
                SystemFailure.setFailure((Error)((VirtualMachineError)e));
            }
            if (t instanceof AsyncInvocation) {
                ((AsyncInvocation)t).exception = e;
            }
        }
    }
}

