/*
 * Decompiled with CFR 0.152.
 */
package dunit;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.QueryTestUtils;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import com.gemstone.gemfire.cache30.GlobalLockingTest;
import com.gemstone.gemfire.cache30.MultiVMRegionTestCase;
import com.gemstone.gemfire.cache30.RegionTestCase;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.MembershipManagerHelper;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.InternalInstantiator;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.LogWriterImpl;
import com.gemstone.gemfire.internal.ManagerLogWriter;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.admin.ClientStatsManager;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.tier.InternalBridgeMembership;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerTestUtil;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.DataSerializerPropogationDUnitTest;
import com.gemstone.gemfire.internal.util.DebuggerSupport;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import dunit.DUnitEnv;
import dunit.Host;
import dunit.RepeatableRunnable;
import dunit.SerializableCallable;
import dunit.SerializableRunnable;
import dunit.VM;
import dunit.eclipse.DUnitLauncher;
import dunit.impl.DUnitBB;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.TestConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import util.TestException;

public abstract class DistributedTestCase
extends TestCase
implements Serializable {
    public static InternalDistributedSystem system;
    private static Class lastSystemCreatedInTest;
    private static Properties lastSystemProperties;
    public static volatile String testName;
    private static final DecimalFormat format;
    public static boolean reconnect;
    public static final boolean logPerTest;
    private static final boolean USE_JITTER = true;
    private static final Random jitter;

    public void attachDebugger(VM vm, final String msg) {
        vm.invoke(new SerializableRunnable("Attach Debugger"){

            @Override
            public void run() {
                DebuggerSupport.waitForJavaDebugger((LogWriterI18n)DistributedTestCase.this.getSystem().getLogWriter().convertToLogWriterI18n(), (String)msg);
            }
        });
    }

    public static void invokeInEveryVM(SerializableRunnable work) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(work);
            }
        }
    }

    public static void invokeInLocator(SerializableRunnable work) {
        Host.getLocator().invoke(work);
    }

    protected static Map invokeInEveryVM(SerializableCallable work) {
        HashMap<VM, Object> ret = new HashMap<VM, Object>();
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                ret.put(vm, vm.invoke(work));
            }
        }
        return ret;
    }

    protected static void invokeInEveryVM(Class c, String method) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(c, method);
            }
        }
    }

    protected static void invokeInEveryVM(Class c, String method, Object[] methodArgs) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invoke(c, method, methodArgs);
            }
        }
    }

    protected long getRepeatTimeoutMs() {
        return 0L;
    }

    protected void invokeRepeatingIfNecessary(VM vm, RepeatableRunnable task) {
        vm.invokeRepeatingIfNecessary(task, this.getRepeatTimeoutMs());
    }

    protected void invokeInEveryVMRepeatingIfNecessary(RepeatableRunnable work) {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            for (int v = 0; v < host.getVMCount(); ++v) {
                VM vm = host.getVM(v);
                vm.invokeRepeatingIfNecessary(work, this.getRepeatTimeoutMs());
            }
        }
    }

    protected static int getVMCount() {
        int count = 0;
        for (int h = 0; h < Host.getHostCount(); ++h) {
            Host host = Host.getHost(h);
            count += host.getVMCount();
        }
        return count;
    }

    public static void dumpStack() {
        OSProcess.printStacks((int)0, (LogWriter)Log.getLogWriter(), (boolean)false);
    }

    public static void dumpStack(VM vm) {
        vm.invoke(DistributedTestCase.class, "dumpStack");
    }

    public static void dumpStack(Host host) {
        for (int v = 0; v < host.getVMCount(); ++v) {
            host.getVM(v).invoke(DistributedTestCase.class, "dumpStack");
        }
    }

    public static void dumpAllStacks() {
        for (int h = 0; h < Host.getHostCount(); ++h) {
            DistributedTestCase.dumpStack(Host.getHost(h));
        }
    }

    public static String noteTiming(long operations, String operationUnit, long beginTime, long endTime, String timeUnit) {
        long delta = endTime - beginTime;
        StringBuffer sb = new StringBuffer();
        sb.append("  Performed ");
        sb.append(operations);
        sb.append(" ");
        sb.append(operationUnit);
        sb.append(" in ");
        sb.append(delta);
        sb.append(" ");
        sb.append(timeUnit);
        sb.append("\n");
        double ratio = (double)operations / (double)delta;
        sb.append("    ");
        sb.append(format.format(ratio));
        sb.append(" ");
        sb.append(operationUnit);
        sb.append(" per ");
        sb.append(timeUnit);
        sb.append("\n");
        ratio = (double)delta / (double)operations;
        sb.append("    ");
        sb.append(format.format(ratio));
        sb.append(" ");
        sb.append(timeUnit);
        sb.append(" per ");
        sb.append(operationUnit);
        sb.append("\n");
        return sb.toString();
    }

    protected static LogWriter createLogWriter(Properties config) {
        Properties nonDefault = config;
        if (nonDefault == null) {
            nonDefault = new Properties();
        }
        DistributedTestCase.addHydraProperties(nonDefault);
        DistributionConfigImpl dc = new DistributionConfigImpl(nonDefault);
        FileOutputStream[] fos = new FileOutputStream[1];
        LogWriterImpl logger = InternalDistributedSystem.createLogWriter((boolean)false, (boolean)false, (boolean)false, (DistributionConfig)dc, (boolean)false, (FileOutputStream[])fos);
        FileOutputStream loggerFileStream = fos[0];
        nonDefault.put("log-writer", logger);
        nonDefault.put("log-output-stream", loggerFileStream);
        return logger;
    }

    protected static void addHydraProperties(Properties config) {
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        String hostName = gfd.getHostDescription().getCanonicalHostName();
        if (HostHelper.isLocalHost(hostName)) {
            Properties p = gfd.getDistributedSystemProperties();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (config.getProperty(key) != null) continue;
                config.setProperty(key, value);
            }
        } else {
            String s = hostName + " must be a local host to add hydra properties.";
            throw new HydraConfigException(s);
        }
    }

    public DistributedTestCase(String name) {
        super(name);
        DUnitLauncher.launchIfNeeded();
    }

    protected Class getTestClass() {
        Class<?> clazz = this.getClass();
        while (clazz.getDeclaringClass() != null) {
            clazz = clazz.getDeclaringClass();
        }
        return clazz;
    }

    public static String getDUnitLogLevel() {
        Properties p = DUnitEnv.get().getDistributedSystemProperties();
        String result = p.getProperty("log-level");
        if (result == null) {
            result = ManagerLogWriter.levelToString((int)700);
        }
        return result;
    }

    public final Properties getAllDistributedSystemProperties(Properties props) {
        Properties p = DUnitEnv.get().getDistributedSystemProperties();
        if (!p.contains("disable-auto-reconnect")) {
            p.put("disable-auto-reconnect", "true");
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            p.put(key, value);
        }
        return p;
    }

    public void setSystem(Properties props, DistributedSystem ds) {
        system = (InternalDistributedSystem)ds;
        lastSystemProperties = props;
        lastSystemCreatedInTest = this.getTestClass();
    }

    public InternalDistributedSystem getSystem(Properties props) {
        block5: {
            boolean needNewSystem;
            block7: {
                block6: {
                    block4: {
                        if (system == null) {
                            system = InternalDistributedSystem.getAnyInstance();
                        }
                        if (system != null && system.isConnected()) break block4;
                        Properties p = this.getAllDistributedSystemProperties(props);
                        lastSystemCreatedInTest = this.getTestClass();
                        if (logPerTest) {
                            String testMethod = DistributedTestCase.getTestName();
                            String testName = lastSystemCreatedInTest.getName() + '-' + testMethod;
                            String oldLogFile = p.getProperty("log-file");
                            p.put("log-file", oldLogFile.replace("system.log", testName + ".log"));
                            String oldStatFile = p.getProperty("statistic-archive-file");
                            p.put("statistic-archive-file", oldStatFile.replace("statArchive.gfs", testName + ".gfs"));
                        }
                        system = (InternalDistributedSystem)DistributedSystem.connect((Properties)p);
                        lastSystemProperties = p;
                        break block5;
                    }
                    needNewSystem = false;
                    if (this.getTestClass().equals(lastSystemCreatedInTest)) break block6;
                    Properties newProps = this.getAllDistributedSystemProperties(props);
                    boolean bl = needNewSystem = !newProps.equals(lastSystemProperties);
                    if (!needNewSystem) break block7;
                    DistributedTestCase.getLogWriter().info("Test class has changed and the new DS properties are not an exact match. Forcing DS disconnect. Old props = " + lastSystemProperties + "new props=" + newProps);
                    break block7;
                }
                Properties activeProps = system.getProperties();
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value.equals(activeProps.getProperty(key))) continue;
                    needNewSystem = true;
                    DistributedTestCase.getLogWriter().info("Forcing DS disconnect. For property " + key + " old value = " + activeProps.getProperty(key) + " new value = " + value);
                    break;
                }
            }
            if (needNewSystem) {
                DistributedTestCase.getLogWriter().info("Disconnecting from current DS in order to make a new one");
                DistributedTestCase.disconnectFromDS();
                this.getSystem(props);
            }
        }
        return system;
    }

    public boolean crashDistributedSystem(VM vm) {
        return (Boolean)vm.invoke(new SerializableCallable("crash distributed system"){

            public Object call() throws Exception {
                InternalDistributedSystem msys = InternalDistributedSystem.getAnyInstance();
                DistributedTestCase.this.crashDistributedSystem((DistributedSystem)msys);
                return true;
            }
        });
    }

    public void crashDistributedSystem(final DistributedSystem msys) {
        MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)true);
        MembershipManagerHelper.playDead((DistributedSystem)msys);
        JChannel c = MembershipManagerHelper.getJChannel((DistributedSystem)msys);
        Protocol udp = c.getProtocolStack().findProtocol("UDP");
        udp.stop();
        udp.passUp(new Event(46, (Object)new RuntimeException("killing member's ds")));
        try {
            MembershipManagerHelper.getJChannel((DistributedSystem)msys).waitForClose();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        MembershipManagerHelper.inhibitForcedDisconnectLogging((boolean)false);
        WaitCriterion wc = new WaitCriterion(){

            @Override
            public boolean done() {
                return !msys.isConnected();
            }

            @Override
            public String description() {
                return "waiting for distributed system to finish disconnecting: " + msys;
            }
        };
        DistributedTestCase.waitForCriterion(wc, 10000L, 1000L, true);
    }

    private String getDefaultDiskStoreName() {
        String vmid = System.getProperty("vmid");
        return "DiskStore-" + vmid + "-" + this.getTestClass().getCanonicalName() + "." + DistributedTestCase.getTestName();
    }

    public final InternalDistributedSystem getSystem() {
        return this.getSystem(this.getDistributedSystemProperties());
    }

    public final InternalDistributedSystem getLonerSystem() {
        Properties props = this.getDistributedSystemProperties();
        props.put("mcast-port", "0");
        props.put("locators", "");
        return this.getSystem(props);
    }

    public final InternalDistributedSystem getMcastSystem() {
        Properties props = this.getDistributedSystemProperties();
        int port = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", "" + port);
        props.put("mcast-ttl", "0");
        props.put("locators", "");
        return this.getSystem(props);
    }

    public final InternalDistributedSystem getMcastSystem(int jgroupsPort) {
        Properties props = this.getDistributedSystemProperties();
        props.put("mcast-port", "" + jgroupsPort);
        props.put("mcast-ttl", "0");
        props.put("locators", "");
        return this.getSystem(props);
    }

    public final boolean isConnectedToDS() {
        return system != null && system.isConnected();
    }

    public Properties getDistributedSystemProperties() {
        return new Properties();
    }

    public void setUp() throws Exception {
        testName = this.getName();
        System.setProperty("gemfire.ALLOW_STANDALONE_HDFS_FILESYSTEM", "true");
        System.setProperty("gemfire.preAllocateDisk", "false");
        if (testName != null) {
            GemFireCacheImpl.setDefaultDiskStoreName((String)this.getDefaultDiskStoreName());
            String baseDefaultDiskStoreName = this.getTestClass().getCanonicalName() + "." + DistributedTestCase.getTestName();
            for (int h = 0; h < Host.getHostCount(); ++h) {
                Host host = Host.getHost(h);
                for (int v = 0; v < host.getVMCount(); ++v) {
                    VM vm = host.getVM(v);
                    String vmDefaultDiskStoreName = "DiskStore-" + h + "-" + v + "-" + baseDefaultDiskStoreName;
                    vm.invoke(DistributedTestCase.class, "perVMSetUp", new Object[]{testName, vmDefaultDiskStoreName});
                }
            }
        }
    }

    public static void perVMSetUp(String name, String defaultDiskStoreName) {
        DistributedTestCase.setTestName(name);
        GemFireCacheImpl.setDefaultDiskStoreName((String)defaultDiskStoreName);
        System.setProperty("gemfire.ALLOW_STANDALONE_HDFS_FILESYSTEM", "true");
        System.setProperty("gemfire.preAllocateDisk", "false");
    }

    public static void setTestName(String name) {
        testName = name;
    }

    public static String getTestName() {
        return testName;
    }

    public final void tearDown() throws Exception {
        this.tearDown2();
        this.realTearDown();
    }

    protected void realTearDown() throws Exception {
        if (logPerTest) {
            DistributedTestCase.disconnectFromDS();
            DistributedTestCase.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
        }
        DistributedTestCase.cleanupAllVms();
    }

    public void tearDown2() throws Exception {
    }

    public static void cleanupAllVms() {
        DistributedTestCase.cleanupThisVM();
        DistributedTestCase.invokeInEveryVM(DistributedTestCase.class, "cleanupThisVM");
        DistributedTestCase.invokeInLocator(new SerializableRunnable(){

            @Override
            public void run() {
                DistributionMessageObserver.setInstance(null);
                DistributedTestCase.unregisterInstantiatorsInThisVM();
            }
        });
    }

    private static void cleanupThisVM() {
        IpAddress.resolve_dns = true;
        SocketCreator.resolve_dns = true;
        InitialImageOperation.slowImageProcessing = 0;
        DistributionMessageObserver.setInstance(null);
        QueryTestUtils.setCache(null);
        CacheServerTestUtil.clearCacheReference();
        RegionTestCase.preSnapshotRegion = null;
        GlobalLockingTest.region_testBug32356 = null;
        LogWrapper.close();
        ClientProxyMembershipID.system = null;
        MultiVMRegionTestCase.CCRegion = null;
        InternalBridgeMembership.unregisterAllListeners();
        ClientStatsManager.cleanupForTests();
        DistributedTestCase.unregisterInstantiatorsInThisVM();
        DUnitLauncher.checkForSuspectStrings();
        Protocol.trace = GemFireTracer.DEBUG = (JGroupMembershipManager.DEBUG_JAVAGROUPS = Boolean.getBoolean("JGroups.DEBUG"));
        if (InternalDistributedSystem.systemAttemptingReconnect != null) {
            InternalDistributedSystem.systemAttemptingReconnect.stopReconnecting();
        }
    }

    public static void unregisterAllDataSerializersFromAllVms() {
        DistributedTestCase.unregisterDataSerializerInThisVM();
        DistributedTestCase.invokeInEveryVM(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.unregisterDataSerializerInThisVM();
            }
        });
        DistributedTestCase.invokeInLocator(new SerializableRunnable(){

            @Override
            public void run() {
                DistributedTestCase.unregisterDataSerializerInThisVM();
            }
        });
    }

    public static void unregisterInstantiatorsInThisVM() {
        InternalInstantiator.reinitialize();
        DistributedTestCase.assertEquals((int)0, (int)InternalInstantiator.getInstantiators().length);
    }

    public static void unregisterDataSerializerInThisVM() {
        DataSerializerPropogationDUnitTest.successfullyLoadedTestDataSerializer = false;
        InternalDataSerializer.reinitialize();
        DistributedTestCase.assertEquals((int)0, (int)InternalDataSerializer.getSerializers().length);
    }

    protected static void disconnectAllFromDS() {
        DistributedTestCase.disconnectFromDS();
        DistributedTestCase.invokeInEveryVM(DistributedTestCase.class, "disconnectFromDS");
    }

    public static void disconnectFromDS() {
        InternalDistributedSystem ds;
        testName = null;
        GemFireCacheImpl.testCacheXml = null;
        if (system != null) {
            system.disconnect();
            system = null;
        }
        while ((ds = InternalDistributedSystem.getConnectedInstance()) != null) {
            try {
                ds.disconnect();
            }
            catch (Exception exception) {}
        }
        AdminDistributedSystemImpl ads = AdminDistributedSystemImpl.getConnectedInstance();
        if (ads != null) {
            ads.disconnect();
        }
    }

    private String getShortClassName() {
        String result = this.getClass().getName();
        int idx = result.lastIndexOf(46);
        if (idx != -1) {
            result = result.substring(idx + 1);
        }
        return result;
    }

    public static String getServerHostName(Host host) {
        return System.getProperty("gemfire.server-bind-address") != null ? System.getProperty("gemfire.server-bind-address") : host.getHostName();
    }

    public static String getIPLiteral() {
        return HostHelper.getHostAddress();
    }

    public static int getDUnitLocatorPort() {
        return DUnitEnv.get().getLocatorPort();
    }

    public static String getDUnitLocatorAddress() {
        return DUnitEnv.get().getLocatorAddress();
    }

    public static String getDUnitLocatorString() {
        return DUnitEnv.get().getLocatorString();
    }

    public String getUniqueName() {
        return this.getShortClassName() + "_" + this.getName();
    }

    public static LogWriter getLogWriter() {
        return Log.getLogWriter();
    }

    public static void fail(String message, Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        pw.print(message);
        pw.print(": ");
        ex.printStackTrace(pw);
        DistributedTestCase.fail((String)sw.toString());
    }

    protected void pause() {
        DistributedTestCase.pause(250);
    }

    public static final void staticPause(int ms) {
        long target = System.currentTimeMillis() + (long)ms;
        try {
            long msLeft;
            while ((msLeft = target - System.currentTimeMillis()) > 0L) {
                Thread.sleep(msLeft);
            }
        }
        catch (InterruptedException e) {
            DistributedTestCase.fail("interrupted", e);
        }
    }

    public static final void pause(int ms) {
        DistributedTestCase.getLogWriter().info("Pausing for " + ms + " ms...");
        long target = System.currentTimeMillis() + (long)ms;
        try {
            long msLeft;
            while ((msLeft = target - System.currentTimeMillis()) > 0L) {
                Thread.sleep(msLeft);
            }
        }
        catch (InterruptedException e) {
            DistributedTestCase.fail("interrupted", e);
        }
    }

    private static int jitterInterval(long ms) {
        int minLegal = 50;
        int maxLegal = 5000;
        if (ms <= 50L) {
            return (int)ms;
        }
        int maxReturn = 5000;
        if (ms < 5000L) {
            maxReturn = (int)ms;
        }
        return 50 + jitter.nextInt(maxReturn - 50 + 1);
    }

    public static void waitForCriterion(WaitCriterion ev, long ms, long interval, boolean throwOnTimeout) {
        long waitThisTime = DistributedTestCase.jitterInterval(interval);
        long tilt = System.currentTimeMillis() + ms;
        while (!ev.done()) {
            WaitCriterion2 ev2;
            if (ev instanceof WaitCriterion2 && (ev2 = (WaitCriterion2)ev).stopWaiting()) {
                if (throwOnTimeout) {
                    DistributedTestCase.fail((String)("stopWaiting returned true: " + ev.description()));
                }
                return;
            }
            long timeLeft = tilt - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                if (!throwOnTimeout) {
                    return;
                }
                DistributedTestCase.fail((String)("Event never occurred after " + ms + " ms: " + ev.description()));
            }
            if (waitThisTime > timeLeft) {
                waitThisTime = timeLeft;
            }
            Thread.yield();
            try {
                Thread.sleep(waitThisTime);
                continue;
            }
            catch (InterruptedException e) {
                DistributedTestCase.fail((String)"interrupted");
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void waitMutex(WaitCriterion ev, Object mutex, long ms, long interval, boolean throwOnTimeout) {
        long tilt = System.currentTimeMillis() + ms;
        long waitThisTime = DistributedTestCase.jitterInterval(interval);
        Object object = mutex;
        synchronized (object) {
            while (!ev.done()) {
                long timeLeft = tilt - System.currentTimeMillis();
                if (timeLeft <= 0L) {
                    if (!throwOnTimeout) {
                        return;
                    }
                    DistributedTestCase.fail((String)("Event never occurred after " + ms + " ms: " + ev.description()));
                }
                if (waitThisTime > timeLeft) {
                    waitThisTime = timeLeft;
                }
                try {
                    mutex.wait(waitThisTime);
                }
                catch (InterruptedException e) {
                    DistributedTestCase.fail((String)"interrupted");
                    continue;
                }
                break;
            }
            return;
        }
    }

    public static void join(Thread t, long ms, LogWriter logger) {
        long elapsedMs;
        long tilt = System.currentTimeMillis() + ms;
        long incrementalWait = DistributedTestCase.jitterInterval(ms);
        long start = System.currentTimeMillis();
        while (t.isAlive()) {
            try {
                t.join(incrementalWait);
            }
            catch (InterruptedException e) {
                DistributedTestCase.fail((String)"interrupted");
            }
            if (System.currentTimeMillis() < tilt) continue;
        }
        if (logger == null) {
            logger = new LocalLogWriter(800, System.out);
        }
        if (t.isAlive()) {
            logger.info("HUNG THREAD");
            DistributedTestCase.dumpStackTrace(t, t.getStackTrace(), logger);
            DistributedTestCase.dumpMyThreads(logger);
            t.interrupt();
            DistributedTestCase.fail((String)("Thread did not terminate after " + ms + " ms: " + t));
        }
        if ((elapsedMs = System.currentTimeMillis() - start) > 0L) {
            String msg = "Thread " + t + " took " + elapsedMs + " ms to exit.";
            logger.info(msg);
        }
    }

    public static void dumpStackTrace(Thread t, StackTraceElement[] stack, LogWriter logger) {
        StringBuilder msg = new StringBuilder();
        msg.append("Thread=<").append(t).append("> stackDump:\n");
        for (int i = 0; i < stack.length; ++i) {
            msg.append("\t").append(stack[i]).append("\n");
        }
        logger.info(msg.toString());
    }

    public static void dumpMyThreads(LogWriter logger) {
        OSProcess.printStacks((int)0, (LogWriter)logger, (boolean)false);
    }

    protected static void setDiskStoreForGateway(Cache cache, String gatewayId, GatewayQueueAttributes queueAttributes) {
        File overflowDirectory = new File(gatewayId + "_disk_" + System.currentTimeMillis());
        overflowDirectory.mkdir();
        DiskStoreFactory dsf = cache.createDiskStoreFactory();
        File[] dirs1 = new File[]{overflowDirectory};
        queueAttributes.setDiskStoreName(dsf.setDiskDirs(dirs1).create(gatewayId).getName());
    }

    public static ExpectedException addExpectedException(String exception) {
        return DistributedTestCase.addExpectedException(exception, null);
    }

    public static ExpectedException addExpectedException(String exception, VM v) {
        ExpectedException ret = v != null ? new ExpectedException(exception, v) : new ExpectedException(exception);
        final String add = ret.getAddString();
        SerializableRunnable addRunnable = new SerializableRunnable("addExpectedExceptions"){

            @Override
            public void run() {
                InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
                if (sys != null) {
                    sys.getLogWriter().info(add);
                }
                try {
                    DistributedTestCase.getLogWriter().info(add);
                }
                catch (HydraRuntimeException hydraRuntimeException) {
                    // empty catch block
                }
                LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
                bgexecLogger.info(add);
            }
        };
        if (v != null) {
            v.invoke(addRunnable);
        } else {
            DistributedTestCase.invokeInEveryVM(addRunnable);
        }
        InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
        if (sys != null) {
            sys.getLogWriter().info(add);
        }
        DistributedTestCase.getLogWriter().info(add);
        return ret;
    }

    public static void incBBFlag(String name) {
        DUnitBB bb = DUnitBB.getBB();
        bb.getSharedLock().lock();
        int currentVal = 0;
        Object result = bb.getSharedMap().get(name);
        if (result != null && result instanceof Integer) {
            currentVal = (Integer)result;
        }
        bb.getSharedMap().put(name, ++currentVal);
        bb.getSharedLock().unlock();
    }

    public static void clearBBFlag(String name) {
        DUnitBB bb = DUnitBB.getBB();
        bb.getSharedLock().lock();
        bb.getSharedMap().remove(name);
        bb.getSharedLock().unlock();
    }

    public static void checkBBFlag(String name, int expectedValue) throws CacheException {
        DUnitBB bb = DUnitBB.getBB();
        int gotValue = -1;
        bb.getSharedLock().lock();
        Object result = bb.getSharedMap().get(name);
        if (result != null && result instanceof Integer) {
            gotValue = (Integer)result;
        }
        bb.getSharedLock().unlock();
        if (expectedValue != gotValue) {
            throw new TestException("Expected value " + expectedValue + " for flag [" + name + "] but got " + gotValue){};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForBBFlag(String name, int expectedValue, long timeout) throws TimeoutException {
        DUnitBB bb = DUnitBB.getBB();
        int gotValue = -1;
        long endTime = System.currentTimeMillis() + timeout;
        while (gotValue != expectedValue) {
            if (timeout > 0L && System.currentTimeMillis() >= endTime) {
                throw new TestException("timed out waiting for BB key " + name + " for " + timeout + " millis");
            }
            bb.getSharedLock().lock();
            try {
                Object result = bb.getSharedMap().get(name);
                if (result == null || !(result instanceof Integer)) continue;
                gotValue = (Integer)result;
            }
            finally {
                bb.getSharedLock().unlock();
            }
        }
    }

    static {
        System.setProperty("gemfire.enableCreationStack", "true");
        format = new DecimalFormat("###.###");
        reconnect = false;
        logPerTest = Boolean.getBoolean("dunitLogPerTest");
        jitter = new Random();
    }

    public static class ExpectedException
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String ex;
        final transient VM v;

        public ExpectedException(String exception) {
            this.ex = exception;
            this.v = null;
        }

        ExpectedException(String exception, VM vm) {
            this.ex = exception;
            this.v = vm;
        }

        public String getRemoveString() {
            return "<ExpectedException action=remove>" + this.ex + "</ExpectedException>";
        }

        public String getAddString() {
            return "<ExpectedException action=add>" + this.ex + "</ExpectedException>";
        }

        public void remove() {
            SerializableRunnable removeRunnable = new SerializableRunnable("removeExpectedExceptions"){

                @Override
                public void run() {
                    String remove = ExpectedException.this.getRemoveString();
                    InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
                    if (sys != null) {
                        sys.getLogWriter().info(remove);
                    }
                    try {
                        DistributedTestCase.getLogWriter().info(remove);
                    }
                    catch (HydraRuntimeException hydraRuntimeException) {
                        // empty catch block
                    }
                    LocalLogWriter bgexecLogger = new LocalLogWriter(Integer.MIN_VALUE, System.out);
                    bgexecLogger.info(remove);
                }
            };
            if (this.v != null) {
                this.v.invoke(removeRunnable);
            } else {
                DistributedTestCase.invokeInEveryVM(removeRunnable);
            }
            String s = this.getRemoveString();
            InternalDistributedSystem sys = InternalDistributedSystem.getConnectedInstance();
            if (sys != null) {
                sys.getLogWriter().info(s);
            }
            DistributedTestCase.getLogWriter().info(s);
        }
    }

    public static interface WaitCriterion2
    extends WaitCriterion {
        public boolean stopWaiting();
    }

    public static interface WaitCriterion {
        public boolean done();

        public String description();
    }
}

