/*
 * Decompiled with CFR 0.152.
 */
package dunit;

import dunit.DUnitEnv;
import hydra.DistributedSystemHelper;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.List;
import java.util.Properties;

public class HydraDUnitEnv
extends DUnitEnv {
    @Override
    public String getLocatorString() {
        List endpoints = DistributedSystemHelper.getSystemEndpoints();
        DistributedSystemHelper.Endpoint ep = (DistributedSystemHelper.Endpoint)endpoints.get(0);
        return ep.getId();
    }

    @Override
    public String getLocatorAddress() {
        List endpoints = DistributedSystemHelper.getSystemEndpoints();
        DistributedSystemHelper.Endpoint ep = (DistributedSystemHelper.Endpoint)endpoints.get(0);
        return ep.getAddress();
    }

    @Override
    public int getLocatorPort() {
        List endpoints = DistributedSystemHelper.getSystemEndpoints();
        DistributedSystemHelper.Endpoint ep = (DistributedSystemHelper.Endpoint)endpoints.get(0);
        return ep.getPort();
    }

    @Override
    public Properties getDistributedSystemProperties() {
        String gemfireName = System.getProperty("gemfireName");
        if (gemfireName == null) {
            String s = "No gemfire name has been specified";
            throw new HydraConfigException(s);
        }
        GemFireDescription gfd = TestConfig.getInstance().getGemFireDescription(gemfireName);
        String hostName = gfd.getHostDescription().getCanonicalHostName();
        if (HostHelper.isLocalHost(hostName)) {
            return gfd.getDistributedSystemProperties();
        }
        String s = gemfireName + " is on remote system " + hostName;
        throw new HydraConfigException(s);
    }

    @Override
    public GemFireDescription getGemfireDescription() {
        String gemFireName = this.getGemFireName();
        TestConfig tc = TestConfig.getInstance();
        return tc.getGemFireDescription(gemFireName);
    }

    private String getGemFireName() {
        String gemFireName = System.getProperty("gemfireName");
        if (gemFireName == null) {
            throw new HydraConfigException("No gemfire name has been specified");
        }
        return gemFireName;
    }

    @Override
    public int getPid() {
        return RemoteTestModule.getMyPid();
    }
}

