/*
 * Decompiled with CFR 0.152.
 */
package dunit.eclipse;

import com.gemstone.gemfire.LogWriter;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.RemoteTestModuleIF;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class FakeRemoteTestModule
extends UnicastRemoteObject
implements RemoteTestModuleIF {
    private LogWriter log;

    public FakeRemoteTestModule(LogWriter log) throws RemoteException {
        this.log = log;
    }

    @Override
    public MethExecutorResult executeMethodOnObject(Object obj, String methodName) {
        String name = obj.getClass().getName() + "." + methodName + " on object: " + obj;
        this.log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.executeObject(obj, methodName);
        long delta = System.currentTimeMillis() - start;
        this.log.info("Got result: " + result.toString().trim() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnObject(Object obj, String methodName, Object[] args) {
        String name = obj.getClass().getName() + "." + methodName + (args != null ? " with " + args.length + " args" : "") + " on object: " + obj;
        this.log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.executeObject(obj, methodName, args);
        long delta = System.currentTimeMillis() - start;
        this.log.info("Got result: " + result.toString() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnClass(String className, String methodName) {
        String name = className + "." + methodName;
        this.log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(className, methodName);
        long delta = System.currentTimeMillis() - start;
        this.log.info("Got result: " + result.toString() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnClass(String className, String methodName, Object[] args) {
        String name = className + "." + methodName + (args != null ? " with " + args.length + " args" : "");
        this.log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(className, methodName, args);
        long delta = System.currentTimeMillis() - start;
        this.log.info("Got result: " + result.toString() + " from " + name + " (took " + delta + " ms)");
        return result;
    }

    @Override
    public void executeTask(int tsid, int type, int index) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runShutdownHook() throws RemoteException {
    }

    @Override
    public void notifyDynamicActionComplete(int actionId) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnectVM() throws RemoteException {
    }

    @Override
    public void shutDownVM(boolean disconnect, boolean runShutdownHook) throws RemoteException {
    }
}

