/*
 * Decompiled with CFR 0.152.
 */
package dunit.impl;

import dunit.Host;
import dunit.VM;
import hydra.ClientRecord;
import hydra.ClientVmRecord;
import hydra.GemFireDescription;
import hydra.HostDescription;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class HostImpl
extends Host {
    private static boolean initialized = false;
    private static Map hosts;

    public static void initialize() throws RemoteException {
        if (initialized) {
            String s = "Already been initialized";
            throw new IllegalStateException(s);
        }
        initialized = true;
        hosts = new HashMap();
        TestConfig config = TestConfig.getInstance();
        String myLogicalHostName = RemoteTestModule.getMyLogicalHost();
        for (HostDescription hd : config.getHostDescriptions().values()) {
            if (!myLogicalHostName.equals(hd.getName())) continue;
            HostImpl.hostNamed(hd.getCanonicalHostName());
        }
        for (GemFireDescription desc : config.getGemFireDescriptions().values()) {
            HostDescription hd = desc.getHostDescription();
            if (!myLogicalHostName.equals(hd.getName())) continue;
            HostImpl host = HostImpl.hostNamed(hd.getCanonicalHostName());
            host.addSystem(desc.getName(), desc.getSystemDirectory().getAbsolutePath());
        }
        Map vms = RemoteTestModule.Master.getClientVms();
        TreeMap<String, Vector<ClientVmRecord>> vmsort = new TreeMap<String, Vector<ClientVmRecord>>();
        for (ClientVmRecord cvmr : vms.values()) {
            String clientName = cvmr.getClientName();
            Vector<ClientVmRecord> vmsWithName = (Vector<ClientVmRecord>)vmsort.get(clientName);
            if (vmsWithName == null) {
                vmsWithName = new Vector<ClientVmRecord>();
                vmsort.put(clientName, vmsWithName);
            }
            vmsWithName.add(cvmr);
        }
        for (List vmsWithName : vmsort.values()) {
            for (ClientVmRecord vm : vmsWithName) {
                String hostName = vm.getClientDescription().getVmDescription().getHostDescription().getCanonicalHostName().trim();
                String logicalHostName = vm.getClientDescription().getVmDescription().getHostDescription().getName().trim();
                if (!logicalHostName.equals(myLogicalHostName)) continue;
                HostImpl host = HostImpl.hostNamed(hostName);
                int vmPid = vm.getPid();
                ClientRecord cr = vm.getRepresentativeClient();
                if (cr.getThreadGroupName().startsWith("controller")) continue;
                String gemfireName = vm.getClientDescription().getGemFireDescription().getName();
                if (vm.getClientName().startsWith("locator")) {
                    host.addLocator(vmPid, gemfireName, cr.getTestModule());
                    continue;
                }
                host.addVM(vmPid, gemfireName, cr.getTestModule());
            }
        }
        for (int h = 0; h < HostImpl.getHostCount(); ++h) {
            Host host = HostImpl.getHost(h);
            StringBuffer sb = new StringBuffer();
            sb.append("DUnit VMs on host ");
            sb.append(host.getHostName());
            sb.append("\n");
            int vmCount = host.getVMCount();
            for (int i = 0; i < vmCount; ++i) {
                VM vm = host.getVM(i);
                sb.append("  VM ");
                sb.append(i);
                sb.append(" PID ");
                sb.append(vm.getPid());
                sb.append('\n');
            }
            Log.getLogWriter().info(sb.toString());
        }
    }

    private static HostImpl hostNamed(String hostName) {
        HostImpl host = (HostImpl)hosts.get(hostName);
        if (host == null) {
            host = new HostImpl(hostName);
            hosts.put(hostName, host);
            Host.addHost(host);
        }
        return host;
    }

    HostImpl(String name) {
        super(name);
    }
}

