/*
 * Decompiled with CFR 0.152.
 */
package dunit.tests;

import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.VM;
import java.util.Properties;

public class BasicTest
extends DistributedTestCase {
    private static Properties bindings = new Properties();

    public BasicTest(String name) {
        super(name);
    }

    public void _testDontCatchRemoteException() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        vm.invoke(this.getClass(), "remoteThrowException");
    }

    public void testRemoteInvocationWithException() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invoke(this.getClass(), "remoteThrowException");
            BasicTest.fail((String)"Should have thrown a BasicTestException");
        }
        catch (RMIException ex) {
            BasicTest.assertTrue((boolean)(ex.getCause() instanceof BasicTestException));
        }
    }

    protected static void remoteThrowException() {
        String s = "Test exception.  Please ignore.";
        throw new BasicTestException(s);
    }

    public void _testRemoteInvocationBoolean() {
    }

    public void testRemoteInvokeAsync() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        String name = this.getUniqueName();
        String value = "Hello";
        AsyncInvocation ai = vm.invokeAsync(this.getClass(), "remoteBind", new Object[]{name, value});
        ai.join();
        if (ai.exceptionOccurred()) {
            BasicTest.fail("remoteBind failed", ai.getException());
        }
        ai = vm.invokeAsync(this.getClass(), "remoteValidateBind", new Object[]{name, value});
        ai.join();
        if (ai.exceptionOccurred()) {
            BasicTest.fail("remoteValidateBind failed", ai.getException());
        }
    }

    private static void remoteBind(String name, String s) {
        new BasicTest("bogus").getSystem();
        bindings.setProperty(name, s);
    }

    private static void remoteValidateBind(String name, String expected) {
        BasicTest.assertEquals((String)expected, (String)bindings.getProperty(name));
    }

    public void testRemoteInvokeAsyncWithException() throws InterruptedException {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        AsyncInvocation ai = vm.invokeAsync(this.getClass(), "remoteThrowException");
        ai.join();
        BasicTest.assertTrue((boolean)ai.exceptionOccurred());
        Throwable ex = ai.getException();
        BasicTest.assertTrue((boolean)(ex instanceof BasicTestException));
    }

    static class BasicTestException
    extends RuntimeException {
        BasicTestException() {
            this("Test exception.  Please ignore.");
        }

        BasicTestException(String s) {
            super(s);
        }
    }
}

