/*
 * Decompiled with CFR 0.152.
 */
package dunit.tests;

import dunit.AsyncInvocation;
import dunit.DistributedTestCase;
import dunit.Host;
import dunit.RMIException;
import dunit.VM;
import dunit.tests.BasicTest;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public class VMTest
extends DistributedTestCase {
    private static final boolean BOOLEAN_VALUE = true;
    private static final byte BYTE_VALUE = 40;
    private static final long LONG_VALUE = 42L;
    private static final String STRING_VALUE = "BLAH BLAH BLAH";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public VMTest(String name) {
        super(name);
    }

    public void notestInvokeNonExistentMethod() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invoke(VMTest.class, "nonExistentMethod");
            VMTest.fail((String)"Should have thrown an RMIException");
        }
        catch (RMIException ex) {
            String s = "Excepted a NoSuchMethodException, got a " + ex.getCause();
            VMTest.assertTrue((String)s, (boolean)(ex.getCause() instanceof NoSuchMethodException));
        }
    }

    protected static byte remoteByteMethod() {
        return 40;
    }

    public void notestInvokeStaticBoolean() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        VMTest.assertEquals((boolean)true, (boolean)vm.invokeBoolean(VMTest.class, "remoteBooleanMethod"));
    }

    protected static boolean remoteBooleanMethod() {
        return true;
    }

    public void notestInvokeStaticBooleanNotBoolean() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invokeBoolean(VMTest.class, "remoteByteMethod");
            VMTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void notestInvokeStaticLong() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        VMTest.assertEquals((long)42L, (long)vm.invokeLong(VMTest.class, "remoteLongMethod"));
    }

    protected static long remoteLongMethod() {
        return 42L;
    }

    public void notestInvokeStaticLongNotLong() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invokeLong(VMTest.class, "remoteByteMethod");
            VMTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void notestInvokeInstanceLong() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        VMTest.assertEquals((long)42L, (long)vm.invokeLong(new ClassWithLong(), "getLong"));
    }

    public void notestInvokeInstanceLongNotLong() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invokeLong(new ClassWithByte(), "getByte");
            VMTest.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void notestInvokeInstance() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        VMTest.assertEquals((Object)STRING_VALUE, (Object)vm.invoke(new ClassWithString(), "getString"));
    }

    public void notestInvokeRunnable() {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        try {
            vm.invoke(new InvokeRunnable());
            VMTest.fail((String)"Should have thrown a BasicTestException");
        }
        catch (RMIException ex) {
            VMTest.assertTrue((boolean)(ex.getCause() instanceof BasicTest.BasicTestException));
        }
    }

    public static Integer getAndIncStaticCount() {
        return new Integer(COUNTER.getAndIncrement());
    }

    public static Integer incrementStaticCount(Integer inc) {
        return new Integer(COUNTER.addAndGet(inc));
    }

    public static void incStaticCount() {
        COUNTER.incrementAndGet();
    }

    public void testReturnValue() throws Exception {
        Host host = Host.getHost(0);
        VM vm = host.getVM(0);
        AsyncInvocation a1 = vm.invokeAsync(this.getClass(), "getAndIncStaticCount");
        a1.join();
        VMTest.assertEquals((Object)new Integer(0), (Object)a1.getReturnValue());
        a1 = vm.invokeAsync(this.getClass(), "incrementStaticCount", new Object[]{new Integer(2)});
        a1.join();
        VMTest.assertEquals((Object)new Integer(3), (Object)a1.getReturnValue());
        a1 = vm.invokeAsync(this.getClass(), "incStaticCount");
        a1.join();
        VMTest.assertNull((Object)a1.getReturnValue());
        a1 = vm.invokeAsync(this.getClass(), "getAndIncStaticCount");
        a1.join();
        VMTest.assertEquals((Object)new Integer(4), (Object)a1.getReturnValue());
        VMTestObject o = new VMTestObject(0);
        a1 = vm.invokeAsync(o, "incrementAndGet", new Object[0]);
        a1.join();
        VMTest.assertEquals((Object)new Integer(1), (Object)a1.getReturnValue());
        a1 = vm.invokeAsync(o, "set", new Object[]{new Integer(3)});
        a1.join();
        VMTest.assertNull((Object)a1.getReturnValue());
    }

    public static class VMTestObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final AtomicInteger val;

        public VMTestObject(int init) {
            this.val = new AtomicInteger(init);
        }

        public Integer get() {
            return new Integer(this.val.get());
        }

        public Integer incrementAndGet() {
            return new Integer(this.val.incrementAndGet());
        }

        public void set(Integer newVal) {
            this.val.set(newVal);
        }
    }

    protected static class ClassWithString
    implements Serializable {
        protected ClassWithString() {
        }

        public String getString() {
            return VMTest.STRING_VALUE;
        }
    }

    protected static class InvokeRunnable
    implements Serializable,
    Runnable {
        protected InvokeRunnable() {
        }

        @Override
        public void run() {
            throw new BasicTest.BasicTestException();
        }
    }

    protected static class ClassWithByte
    implements Serializable {
        protected ClassWithByte() {
        }

        public byte getByte() {
            return 40;
        }
    }

    protected static class ClassWithLong
    implements Serializable {
        protected ClassWithLong() {
        }

        public long getLong() {
            return 42L;
        }
    }
}

