/*
 * Decompiled with CFR 0.152.
 */
package durableClients;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import durableClients.DurableClientsBB;
import durableClients.DurableClientsTest;
import hydra.Log;
import java.util.HashMap;
import util.AbstractListener;

public class CQOpListener
extends AbstractListener
implements CqListener {
    static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(CqEvent event) {
        DurableClientsTest.lastEventReceivedTime = System.currentTimeMillis();
        this.logCQEvent("onEvent", event);
        Operation op = event.getQueryOperation();
        if (op.equals(Operation.CREATE)) {
            Long value;
            String key = (String)event.getKey();
            if (key.equals("last_key")) {
                DurableClientsTest.receivedLastKey = true;
                Log.getLogWriter().info("'last_key' received at client");
            }
            if ((value = (Long)event.getNewValue()) == null) {
                this.throwException("value in afterCreate cannot be null: key = " + key);
            }
            String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
            Object object = lock;
            synchronized (object) {
                boolean isDuplicate = false;
                if (value != 0L) {
                    isDuplicate = this.validateIncrementByOne(key, value);
                }
                if (!isDuplicate) {
                    HashMap<String, Integer> threadMap;
                    HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
                    if (!map.containsKey(key)) {
                        Log.getLogWriter().info("Putting thread map into the vm for the vm " + VmDurableId + " key" + key);
                        threadMap = new HashMap<String, Integer>();
                        threadMap.put("EVENT No :", new Integer(0));
                        map.put(key, threadMap);
                    }
                    threadMap = (HashMap<String, Integer>)map.get(key);
                    int eventNo = (Integer)threadMap.get("EVENT No :");
                    threadMap.put("EVENT No :", new Integer(++eventNo));
                    threadMap.put("EVENT SR. No : " + eventNo, (Integer)event.getNewValue());
                    threadMap.put(key, (Integer)((Object)value));
                    map.put(key, threadMap);
                    DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
                }
            }
        }
        if (op.equals(Operation.UPDATE)) {
            String key = (String)event.getKey();
            Long newValue = (Long)event.getNewValue();
            if (newValue == null) {
                this.throwException("newValue in afterUpdate cannot be null: key = " + key);
            }
            String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
            Object object = lock;
            synchronized (object) {
                boolean isDurable = false;
                isDurable = this.validateIncrementByOne(key, newValue);
                if (!isDurable) {
                    HashMap<String, Integer> threadMap;
                    HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
                    if (!map.containsKey(key)) {
                        Log.getLogWriter().info("Putting thread map into the vm for the vm " + VmDurableId + " key" + key);
                        threadMap = new HashMap<String, Integer>();
                        threadMap.put("EVENT No :", new Integer(0));
                        map.put(key, threadMap);
                    }
                    threadMap = (HashMap<String, Integer>)map.get(key);
                    int eventNo = (Integer)threadMap.get("EVENT No :");
                    threadMap.put("EVENT No :", new Integer(++eventNo));
                    threadMap.put("EVENT SR. No : " + eventNo, (Integer)event.getNewValue());
                    threadMap.put(key, (Integer)((Object)newValue));
                    map.put(key, threadMap);
                    DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
                }
            }
        }
    }

    public void onError(CqEvent event) {
        this.logCQEvent("onError", event);
    }

    public void close() {
    }

    private boolean validateIncrementByOne(String key, Long newValue) {
        boolean isDuplicate = false;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
        HashMap threadMap = (HashMap)map.get(key);
        if (threadMap == null) {
            Log.getLogWriter().info("ThreadMap is null for vm " + VmDurableId + " for key " + key);
        } else {
            long diff;
            Long oldValue = (Long)threadMap.get(key);
            if (oldValue == null) {
                this.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
            }
            if ((diff = newValue - oldValue) > 1L) {
                this.throwException("difference expected in newValue and oldValue is 1 or less (duplicates allowed), but is was " + diff + " for key = " + key + " & newVal = " + newValue + "vm is " + VmDurableId);
            }
            if (diff < 1L) {
                isDuplicate = true;
            }
        }
        return isDuplicate;
    }

    public void throwException(String reason) {
        long exceptionNumber = DurableClientsBB.getBB().getSharedCounters().incrementAndRead(DurableClientsBB.NUM_EXCEPTION);
        DurableClientsBB.getBB().getSharedMap().put(new Long(exceptionNumber), reason);
        DurableClientsBB.getBB().getSharedCounters().incrementAndRead(DurableClientsBB.NUM_COMPLETED_EXCEPTION_LOGGING);
    }
}

