/*
 * Decompiled with CFR 0.152.
 */
package durableClients;

import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import durableClients.DurableClientsBB;
import durableClients.DurableClientsPrms;
import durableClients.DurableClientsTest;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import util.TestException;
import util.TestHelper;

public class Feeder {
    static final int TOTAL_PUT_THREADS = TestConfig.tab().intAt(DurableClientsPrms.numPutThreads);
    static final int PUT_KEY_RANGE = TestConfig.tab().intAt(DurableClientsPrms.numKeyRangePerThread);
    static Thread[] putThreads = new Thread[TOTAL_PUT_THREADS];
    static final String regionName = TestConfig.tab().stringAt(DurableClientsPrms.regionName);
    static List threadList = new ArrayList(TOTAL_PUT_THREADS);
    static volatile boolean stop = false;
    static volatile boolean exceptionOccured = false;
    static StringBuffer exceptionMsg = new StringBuffer();
    protected static final Map latestValues = new HashMap();
    public static ArrayList keyList = new ArrayList();
    public static ArrayList partialList = new ArrayList();
    protected static final String REGION_NAME = TestConfig.tab().stringAt(DurableClientsPrms.regionName, "Region");
    static int numOfRegion = 1;
    public static final String LAST_KEY = "last_key";

    private static void createEntries(Region region, String threadIdKeyPrefix) {
        for (int j = 0; j < TOTAL_PUT_THREADS; ++j) {
            String threadIdkey = threadIdKeyPrefix + j;
            HashMap<String, Long> values = new HashMap<String, Long>();
            Long initValue = new Long(0L);
            for (int k = 0; k < PUT_KEY_RANGE; ++k) {
                String key = region.getFullPath() + threadIdkey + "_" + k;
                try {
                    if (TestConfig.tab().getRandGen().nextBoolean()) {
                        Log.getLogWriter().fine("putIfAbsent(" + key + ")");
                        region.putIfAbsent((Object)key, (Object)initValue);
                    } else {
                        Log.getLogWriter().fine("create(" + key + ")");
                        region.create((Object)key, (Object)initValue);
                    }
                    Log.getLogWriter().info("Adding key to the Full ArrayList " + keyList.add(key) + " Size is " + keyList.size());
                    if (k % 2 == 0) {
                        Log.getLogWriter().info("Adding key to the Partial ArrayList " + partialList.add(key) + "Size is " + partialList.size());
                    }
                }
                catch (Exception e) {
                    Log.getLogWriter().info(TOTAL_PUT_THREADS + "Exception in creating entry for starting with " + j + " for key = " + key);
                    exceptionMsg.append(e.getMessage());
                    exceptionOccured = true;
                }
                values.put(key, initValue);
            }
            latestValues.put(threadIdkey, values);
            DurableClientsBB.getBB().getSharedMap().put("FULL LIST : ", keyList);
            DurableClientsBB.getBB().getSharedMap().put("PARTIAL LIST : ", partialList);
        }
    }

    public static void initTask() {
        int i;
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region == null) {
                exceptionMsg.append("Region created is null ");
                exceptionOccured = true;
            }
            String threadIdkeyPrefix = "Thread_";
            Feeder.createEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage());
                                    exceptionOccured = true;
                                }
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        int numRegion = TestConfig.tab().intAt(DurableClientsPrms.regionRange, 1) - 1;
                        Region region = RegionHelper.getRegion(regionName + numRegion);
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(DurableClientsPrms.entryOperations, "put");
                                if (operation.equals("put")) {
                                    Long newVal = null;
                                    if (region.containsKey((Object)key)) {
                                        Long oldVal = (Long)region.get((Object)key);
                                        if (oldVal == null) {
                                            newVal = Feeder.getLatestValue(key, threadIdkey);
                                            if (TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        } else {
                                            newVal = new Long(oldVal + 1L);
                                            if (TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        }
                                        ++numUpdate;
                                    } else {
                                        newVal = Feeder.getLatestValue(key, threadIdkey);
                                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("putIfAbsent(" + key + ")");
                                            region.putIfAbsent((Object)key, (Object)newVal);
                                        } else {
                                            Log.getLogWriter().fine("create(" + key + ")");
                                            region.create((Object)key, (Object)newVal);
                                        }
                                        ++numCreate;
                                    }
                                } else if (operation.equals("invalidate")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                        region.invalidate((Object)key);
                                        ++numInvalidate;
                                    }
                                } else if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        if (TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("remove(" + key + ")");
                                            region.remove((Object)key, region.get((Object)key));
                                        } else {
                                            Log.getLogWriter().fine("destroy(" + key + ")");
                                            region.destroy((Object)key);
                                        }
                                        ++numDestroy;
                                    }
                                } else {
                                    throw new TestException("Unknown entry operation: " + operation);
                                }
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(e.getMessage());
                                exceptionOccured = true;
                            }
                        }
                        Log.getLogWriter().info("Task completed thread for id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    private static String getKeyForOperation() {
        Random r = new Random();
        int randint = r.nextInt(PUT_KEY_RANGE);
        return "KEY-" + randint;
    }

    protected static void createEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (!region.containsKey((Object)key)) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                } else {
                    region.create((Object)key, (Object)(key + "_VALUE"));
                }
            }
        }
        catch (EntryExistsException e) {
            Log.getLogWriter().warning("EntryExistsException occured while creating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while creating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void updateEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key)) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    region.replace((Object)key, (Object)(key + "_VALUE"));
                } else {
                    region.put((Object)key, (Object)(key + "_VALUE"));
                }
            }
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while updating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void invalidateEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key) && region.get((Object)key) != null) {
                region.invalidate((Object)key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().warning("EntryNotFoundException occured while invalidating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while invalidating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void destroyEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key)) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    region.remove((Object)key, region.get((Object)key));
                } else {
                    region.destroy((Object)key);
                }
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().warning("EntryNotFoundException occured while invalidating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while invalidating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void registerInterest(Region region) {
        String key = Feeder.getKeyForOperation();
        long start = System.currentTimeMillis();
        long total = 0L;
        try {
            region.registerInterest((Object)key);
            total = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while registerInterest. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        if (total > 0L) {
            Log.getLogWriter().info("time taken for registerInterest : " + total);
        }
    }

    protected static void unregisterInterest(Region region) {
        String key = Feeder.getKeyForOperation();
        long start = System.currentTimeMillis();
        long total = 0L;
        try {
            region.unregisterInterest((Object)key);
            total = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while unregisterInterest. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        if (total > 0L) {
            Log.getLogWriter().info("time taken for unregisterInterest : " + total);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void feederTask() {
        List list = threadList;
        synchronized (list) {
            DurableClientsTest.checkBlackBoardForException();
            for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
                int newCounter = (Integer)threadList.get(i) + 1;
                threadList.set(i, new Integer(newCounter));
            }
            threadList.notifyAll();
        }
    }

    public static void populateSharedMapWithRegionData() {
        try {
            numOfRegion = TestConfig.tab().intAt(DurableClientsPrms.numberOfRegions, 1);
            for (int i = 0; i < numOfRegion; ++i) {
                Region region = RegionHelper.getRegion(regionName + i);
                if (region == null) {
                    throw new TestException("Region created is null " + TestHelper.getStackTrace());
                }
                if (region.isEmpty()) {
                    throw new TestException(" Region has no entries to copy to the SharedMap " + TestHelper.getStackTrace());
                }
                Iterator iterator = region.entrySet(false).iterator();
                Region.Entry entry = null;
                while (iterator.hasNext()) {
                    entry = (Region.Entry)iterator.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    DurableClientsBB.getBB().getSharedMap().put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
        }
    }

    public static void closeTask() {
        Feeder.waitForFeederThreadsToComplete();
        Region region = RegionHelper.getRegion(regionName + 0);
        if (region == null) {
            throw new TestException("Region created is null " + TestHelper.getStackTrace());
        }
        if (TestConfig.tab().booleanAt(DurableClientsPrms.putLastKey, false)) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                Long last_value = new Long(0L);
                region.put((Object)LAST_KEY, (Object)last_value);
                Log.getLogWriter().info("Putting the last key in the region: " + region.getName());
            }
            catch (Exception e) {
                throw new TestException("Exception while performing put of the last_key" + TestHelper.getStackTrace());
            }
        }
        Log.getLogWriter().info("Close Task Complete...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForFeederThreadsToComplete() {
        List list = threadList;
        synchronized (list) {
            stop = true;
            threadList.notifyAll();
        }
        for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
            try {
                putThreads[i].join(120000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
            }
        }
        if (exceptionOccured) {
            throw new TestException(exceptionMsg.toString());
        }
        Log.getLogWriter().info("Setting feed signal...");
    }

    protected static Long getLatestValue(String key, String threadIdKey) {
        Map latestValueForThread = (Map)latestValues.get(threadIdKey);
        Long oldVal = (Long)latestValueForThread.remove(key);
        if (oldVal == null) {
            throw new TestException("oldVal cannot be null");
        }
        return new Long(oldVal + 1L);
    }

    protected static boolean updateLatestValueMap(Region region, String key, String threadId, boolean isDestroyCall) throws Exception {
        Object oldVal = null;
        if (region.containsKey((Object)key)) {
            oldVal = region.get((Object)key);
            if (oldVal == null) {
                return isDestroyCall;
            }
            Map latestValueForThread = (Map)latestValues.get(threadId);
            latestValueForThread.put(key, oldVal);
            return true;
        }
        return false;
    }
}

