/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import event.EventBB;
import event.EventPrms;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;

public class CMListener
extends AbstractListener
implements CacheListener,
Declarable {
    private boolean isCarefulValidation;
    private boolean useTransactions;

    public CMListener() {
        TestConfig config = TestConfig.getInstance();
        ConfigHashtable tab = config.getParameters();
        this.isCarefulValidation = tab.booleanAt(Prms.serialExecution);
        this.useTransactions = tab.booleanAt(EventPrms.useTransactions, false);
    }

    public CMListener(boolean isCarefulValidation) {
        this.isCarefulValidation = isCarefulValidation;
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        if (!event.getOperation().equals(Operation.SEARCH_CREATE)) {
            this.incrementAfterCreateCounters(event, (Blackboard)EventCountersBB.getBB());
        }
        this.checkVM();
        String key = (String)event.getKey();
        this.validateProxyEventBehavior(event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.incrementAfterDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.validateProxyEventBehavior(event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        this.incrementAfterInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.validateProxyEventBehavior(event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.incrementAfterUpdateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.validateProxyEventBehavior(event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        if (!event.getOperation().isClose()) {
            this.incrementAfterRegionDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
        }
        this.checkVM();
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.incrementAfterRegionInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
        this.incrementAfterRegionCreateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
        this.incrementAfterRegionLiveCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
    }

    public void close() {
        this.logCall("close", null);
        EventCountersBB.getBB().getSharedCounters().increment(EventCountersBB.numClose);
        this.checkVM();
    }

    protected void validateProxyEventBehavior(EntryEvent event) {
        DataPolicy dataPolicy = null;
        try {
            dataPolicy = event.getRegion().getAttributes().getDataPolicy();
        }
        catch (RegionDestroyedException e) {
            if (this.isCarefulValidation) {
                this.throwException("Listener caught RegionDestroyedException while processing event " + event);
            }
            return;
        }
        catch (CancelException e) {
            return;
        }
        if (dataPolicy.isEmpty()) {
            if (event.isOriginRemote()) {
                if (!event.isOldValueAvailable() && event.getOldValue() != null) {
                    this.throwException("Listener detected remote Event with getOldValue = " + event.getOldValue() + " with DataPolicy " + dataPolicy + ".  Expected getOldValue null when event.isOldValueAvailable() is false");
                }
            } else if (!this.useTransactions && event.getOldValue() != null) {
                this.throwException("Listener detected local Event with getOldValue = " + event.getOldValue() + " with DataPolicy " + dataPolicy + " expected getOldValue = null");
            }
        }
    }

    protected void checkVM() {
        int myPID = ProcessMgr.getProcessId();
        if (this.whereIWasRegistered != myPID) {
            String errStr = "Expected event to be invoked in VM " + this.whereIWasRegistered + ", but it was invoked in " + myPID + ": " + this.toString() + "; see system.log for call stack";
            SharedMap aMap = EventBB.getBB().getSharedMap();
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

