/*
 * Decompiled with CFR 0.152.
 */
package event;

import hydra.Log;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;

public class EventBB
extends Blackboard {
    static String EVENT_BB_NAME = "Event_Blackboard";
    static String EVENT_BB_TYPE = "RMI";
    static String SERIAL_EXECUTION = "SerialExecution";
    static String CURRENT_REGION_NAMES = "CurrentRegionNames";
    static String ROUND_ROBIN = "RoundRobin";
    static String REGION_OP = "RegionOp";
    static String TARGET_REGION = "TargetRegion";
    static String RR_LEADER = "RRLeader";
    static String SHADOW_OPERATIONS = "ShadowOperations";
    public static int EXECUTION_NUMBER;
    public static int NUM_CREATE;
    public static int NUM_UPDATE;
    public static int NUM_DESTROY;
    public static int NUM_INVALIDATE;
    public static int NUM_REGION_DESTROY;
    public static int NUM_REGION_INVALIDATE;
    public static int NUM_REGION_CREATE;
    public static int NUM_LOCAL_DESTROY;
    public static int NUM_LOCAL_INVALIDATE;
    public static int NUM_LOCAL_REGION_DESTROY;
    public static int NUM_LOCAL_REGION_INVALIDATE;
    public static int NUM_CLOSE;
    public static int NUM_CLEAR;
    public static int numInRound;
    public static int EXPECTED_REMOTE_REGION_CREATE;
    public static int EXPECTED_REMOTE_REGION_DEPARTED;
    public static int actualRegionCreateEvents;
    public static int actualRegionDepartedEvents;
    public static int REQUEST_REGION_UPDATE;
    public static int REGION_UPDATE_COMPLETE;
    public static int CONTINUE_MONITOR;
    public static int MAX_GET_CURR_REGION_NAMES_MILLIS;
    public static int MAX_NUM_GET_CURR_REGION_NAMES;
    public static int MAX_FAULT_IN_REGIONS_MILLIS;
    public static int MAX_WRITE_CURR_REGION_NAMES_MILLIS;
    public static int MAX_NUM_WRITE_CURR_REGION_NAMES;
    public static EventBB bbInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBB getBB() {
        if (bbInstance != null) return bbInstance;
        Class<EventBB> clazz = EventBB.class;
        synchronized (EventBB.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new EventBB(EVENT_BB_NAME, EVENT_BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public static void HydraTask_initialize() {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(SERIAL_EXECUTION, new Boolean(TestConfig.tab().booleanAt(Prms.serialExecution)));
        aMap.put(ROUND_ROBIN, new Boolean(TestConfig.tab().booleanAt(Prms.roundRobin, false)));
        EventBB.clearRegionOpInfo();
        EventBB.getBB().printSharedCounters();
    }

    public static boolean isSerialExecution() {
        return (Boolean)EventBB.getBB().getSharedMap().get(SERIAL_EXECUTION);
    }

    public EventBB() {
    }

    public EventBB(String name, String type) {
        super(name, type, EventBB.class);
    }

    public static void zero(String counterName, int counter) {
        EventBB.getBB().getSharedCounters().zero(counter);
        Log.getLogWriter().info(counterName + " has been zeroed");
    }

    public static long incrementCounter(String counterName, int counter) {
        long counterValue = EventBB.getBB().getSharedCounters().incrementAndRead(counter);
        Log.getLogWriter().info("After incrementing, " + counterName + " is " + counterValue);
        return counterValue;
    }

    public static long add(String counterName, int counter, int amountToAdd) {
        long counterValue = EventBB.getBB().getSharedCounters().add(counter, amountToAdd);
        Log.getLogWriter().info("After adding " + amountToAdd + ", " + counterName + " is " + counterValue);
        return counterValue;
    }

    public static boolean isSerialRR() {
        boolean serialExecution = (Boolean)EventBB.getBB().getSharedMap().get(SERIAL_EXECUTION);
        boolean serialRR = (Boolean)EventBB.getBB().getSharedMap().get(ROUND_ROBIN);
        return serialExecution && serialRR;
    }

    public static boolean isRRLeader() {
        EventBB bb = EventBB.getBB();
        if (RemoteTestModule.getCurrentThread().getThreadGroupName().equals(RR_LEADER)) {
            Log.getLogWriter().info("I am the leader of the serialRoundRobin");
            return true;
        }
        return false;
    }

    public static void putRegionOpInfo(int operation, String regionName) {
        EventBB bb = EventBB.getBB();
        Log.getLogWriter().info("putRegionOpInfo to BB: operation = " + operation + " regionName = " + regionName);
        bb.getSharedMap().put(REGION_OP, new Integer(operation));
        bb.getSharedMap().put(TARGET_REGION, regionName);
    }

    public static void clearRegionOpInfo() {
        EventBB bb = EventBB.getBB();
        Log.getLogWriter().info("clearRegionOpInfo()");
        bb.getSharedMap().put(REGION_OP, new Integer(-1));
    }

    public static int getRegionOp() {
        EventBB bb = EventBB.getBB();
        Integer operation = (Integer)bb.getSharedMap().get(REGION_OP);
        Log.getLogWriter().info("getRegionOp from EventBB returns " + operation);
        return operation;
    }

    public static String getTargetRegion() {
        EventBB bb = EventBB.getBB();
        String regionName = (String)bb.getSharedMap().get(TARGET_REGION);
        Log.getLogWriter().info("getTargetRegion from EventBB returns " + regionName);
        return regionName;
    }

    public static void clearRemoteRegionCounters() {
        EventBB.zero("EventBB.EXPECTED_REMOTE_REGION_CREATE", EXPECTED_REMOTE_REGION_CREATE);
        EventBB.zero("EventBB.EXPECTED_REMOTE_REGION_DEPARTED", EXPECTED_REMOTE_REGION_DEPARTED);
        EventBB.zero("EventBB.actualRegionCreateEvents", actualRegionCreateEvents);
        EventBB.zero("EventBB.actualRegionDepartedEvents", actualRegionDepartedEvents);
    }

    static {
        bbInstance = null;
    }
}

