/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import event.ListenerBB;
import hydra.Prms;
import hydra.TestConfig;
import java.util.Properties;
import util.AbstractListener;

public class MultiListener
extends AbstractListener
implements CacheListener,
Declarable {
    private boolean isCarefulValidation;
    private String name = "MultiListener";

    public MultiListener() {
        this.isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
    }

    public MultiListener(String name) {
        this.name = name;
        this.isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        this.updateBB(event.getRegion().getName());
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        this.updateBB(event.getRegion().getName());
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        this.updateBB(event.getRegion().getName());
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        if (!event.getOperation().isClose()) {
            this.updateBB(event.getRegion().getName());
        }
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.updateBB(event.getRegion().getName());
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        this.updateBB(event.getRegion().getName());
    }

    public void close() {
        this.logCall("close", null);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
        this.updateBB(event.getRegion().getName());
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
        if (event.getRegion().getParentRegion() != null) {
            this.updateBB(event.getRegion().getParentRegion().getName());
        }
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
        if (event.getRegion().getParentRegion() != null) {
            this.updateBB(event.getRegion().getParentRegion().getName());
        }
    }

    private void updateBB(String regionName) {
        if (!this.isCarefulValidation) {
            return;
        }
        String clientName = System.getProperty("clientName");
        String key = ListenerBB.InvokedListeners + clientName + "_" + regionName;
        String invokedList = (String)ListenerBB.getBB().getSharedMap().get(key);
        if (invokedList != null) {
            StringBuffer invoked = new StringBuffer(invokedList);
            invoked.append(this.name + ":");
            ListenerBB.getBB().getSharedMap().put(key, invoked.toString());
        }
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

