/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import event.EventBB;
import event.EventPrms;
import event.RegionListener;
import hydra.ClientPrms;
import hydra.DistributedConnectionMgr;
import hydra.GemFirePrms;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import util.BaseValueHolder;
import util.CacheBB;
import util.CacheUtil;
import util.EventCountersBB;
import util.NameBB;
import util.NameFactory;
import util.OperationCountersBB;
import util.RandomValues;
import util.RegionDefPrms;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;

public class ProxyEventTest {
    protected static ProxyEventTest eventTest;
    protected static final int ADD_OPERATION = 1;
    protected static final int UPDATE_OPERATION = 2;
    protected static final int INVALIDATE_OPERATION = 3;
    protected static final int DESTROY_OPERATION = 4;
    protected static final int READ_OPERATION = 5;
    protected static final int LOCAL_INVALIDATE_OPERATION = 6;
    protected static final int LOCAL_DESTROY_OPERATION = 7;
    protected static final int REGION_CLOSE_OPERATION = 8;
    protected static final int CLEAR_OPERATION = 9;
    protected static final int NO_OPERATION = -1;
    protected boolean useTransactions;
    protected boolean isSerialExecution;
    protected boolean isCarefulValidation = false;
    public static final int MILLIS_TO_WAIT = 60000;
    protected int numVMs;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected RandomValues randomValues = null;
    protected boolean useEvictionController;
    protected int maxObjects;
    protected int maxRegions;
    protected DistributedLockService distLockService;
    protected boolean isMirrored;
    protected String clientName;
    protected Region shadow;
    protected String regionName;
    public String shadowRegionName;
    protected boolean isSerialRR;
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String memberIdString = " memberId=";
    protected static String LOCK_SERVICE_NAME;
    protected static String LOCK_NAME;

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new ProxyEventTest();
            eventTest.initialize();
        }
    }

    protected void initialize() {
        this.clientName = System.getProperty("clientName");
        this.createRootRegions();
        Region aRegion = CacheUtil.createCache().getRegion(this.regionName);
        this.useTransactions = EventPrms.useTransactions();
        this.isSerialExecution = EventBB.isSerialExecution();
        this.isCarefulValidation = this.isCarefulValidation || this.isSerialExecution;
        this.isSerialRR = EventBB.isSerialRR();
        if (this.isSerialRR) {
            Log.getLogWriter().info("isRRLeader() returns " + EventBB.isRRLeader());
        }
        this.numVMs = 0;
        HydraVector gemFireNamesVec = TestConfig.tab().vecAt(GemFirePrms.names);
        HydraVector numVMsVec = TestConfig.tab().vecAt(ClientPrms.vmQuantities);
        if (gemFireNamesVec.size() == numVMsVec.size()) {
            for (int i = 0; i < numVMsVec.size(); ++i) {
                this.numVMs += new Integer((String)numVMsVec.elementAt(i)).intValue();
            }
        } else {
            this.numVMs = new Integer((String)numVMsVec.elementAt(0)) * gemFireNamesVec.size();
        }
        Log.getLogWriter().info("numVMs is " + this.numVMs);
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        this.minTaskGranularityMS = this.minTaskGranularitySec * 1000L;
        this.maxRegions = TestConfig.tab().intAt(EventPrms.maxRegions, -1);
        this.maxObjects = TestConfig.tab().intAt(EventPrms.maxObjects, -1);
        this.randomValues = new RandomValues();
        EventBB.getBB().getSharedMap().put(EventBB.CURRENT_REGION_NAMES, new ArrayList());
        ProxyEventTest.createLockService();
        EventBB.getBB().printSharedCounters();
        EventCountersBB.getBB().printSharedCounters();
        OperationCountersBB.getBB().printSharedCounters();
    }

    static synchronized void createLockService() {
        if (ProxyEventTest.eventTest.distLockService == null) {
            Log.getLogWriter().info("Creating lock service " + LOCK_SERVICE_NAME);
            ProxyEventTest.eventTest.distLockService = DistributedLockService.create((String)LOCK_SERVICE_NAME, (DistributedSystem)DistributedConnectionMgr.getConnection());
            Log.getLogWriter().info("Created lock service " + LOCK_SERVICE_NAME);
        }
    }

    public static void HydraTask_doEntryOperations() {
        Region rootRegion = CacheUtil.getCache().getRegion(ProxyEventTest.eventTest.regionName);
        eventTest.doEntryOperations(rootRegion);
    }

    public static void HydraTask_doRegionOperations() {
        eventTest.doRegionOperations();
    }

    public static void HydraTask_addToRegion() {
        eventTest.addToRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doEntryOperations(Region aRegion) {
        startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            ProxyEventTest.logExecutionNumber();
        }
        haveALock = false;
        isMirrored = false;
        dataPolicy = aRegion.getAttributes().getDataPolicy();
        if (dataPolicy == null) {
            mt = aRegion.getAttributes().getMirrorType();
            isMirrored = mt.isMirrored();
        } else {
            isMirrored = dataPolicy.withReplication();
        }
        if (this.useTransactions) {
            TxHelper.begin();
        }
        do {
            TestHelper.checkForEventError(EventBB.getBB());
            useRandomLocks = TestConfig.tab().booleanAt(EventPrms.useRandomLocks);
            if (useRandomLocks) {
                Log.getLogWriter().info("Trying to get distributed lock " + ProxyEventTest.LOCK_NAME + "...");
                haveALock = this.distLockService.lock((Object)ProxyEventTest.LOCK_NAME, -1L, -1L);
                Log.getLogWriter().info("Returned from trying to get distributed lock " + ProxyEventTest.LOCK_NAME + ", lock acquired is " + haveALock);
                if (haveALock) {
                    Log.getLogWriter().info("Obtained distributed lock " + ProxyEventTest.LOCK_NAME);
                }
            }
            try {
                whichOp = this.getOperation(EventPrms.entryOperations, isMirrored);
                switch (whichOp) {
                    case 1: {
                        this.addObject(aRegion, true);
                        ** break;
lbl29:
                        // 1 sources

                        break;
                    }
                    case 3: {
                        this.invalidateObject(aRegion, false);
                        ** break;
lbl33:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        this.destroyObject(aRegion, false);
                        ** break;
lbl37:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        this.updateObject(aRegion);
                        ** break;
lbl41:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        this.readObject(aRegion);
                        ** break;
lbl45:
                        // 1 sources

                        break;
                    }
                    case 6: {
                        this.invalidateObject(aRegion, true);
                        ** break;
lbl49:
                        // 1 sources

                        break;
                    }
                    case 7: {
                        this.destroyObject(aRegion, true);
                        ** break;
lbl53:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new TestException("Unknown operation " + whichOp);
                    }
                }
            }
            finally {
                if (haveALock) {
                    haveALock = false;
                    this.distLockService.unlock((Object)ProxyEventTest.LOCK_NAME);
                    Log.getLogWriter().info("Released distributed lock " + ProxyEventTest.LOCK_NAME);
                }
            }
            MasterController.sleepForMs(EventPrms.sleepTimeMs());
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        if (this.useTransactions) {
            n = 0;
            commitPercentage = EventPrms.getCommitPercentage();
            if (!this.isSerialExecution) {
                n = TestConfig.tab().getRandGen().nextInt(1, 100);
            }
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    if (this.isSerialExecution) {
                        throw new TestException("Unexpected conflict Exception " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ConflictException " + (Object)e + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
            if (this.isSerialExecution) {
                this.checkEventCounters();
            }
        }
    }

    protected void addObject(Region aRegion, boolean logAddition) {
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedConnectionMgr.getConnection().getDistributedMember();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long numPut = EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
    }

    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        Set aSet = this.shadow.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("invalidateObject: No names in region");
            return;
        }
        Iterator it = aSet.iterator();
        Object name = null;
        if (!it.hasNext()) {
            Log.getLogWriter().info("invalidateObject: Unable to get name from region");
            return;
        }
        name = it.next();
        boolean containsValue = this.shadow.containsValueForKey(name);
        boolean alreadyInvalidated = !containsValue;
        Log.getLogWriter().info("containsValue for " + name + ": " + containsValue);
        Log.getLogWriter().info("alreadyInvalidated for " + name + ": " + alreadyInvalidated);
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedConnectionMgr.getConnection().getDistributedMember();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("invalidateObject: local invalidate for " + name + " callback is " + callback);
                aRegion.localInvalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done with local invalidate for " + name);
                if (!alreadyInvalidated) {
                    long l = EventBB.incrementCounter("EventBB.NUM_LOCAL_INVALIDATE", EventBB.NUM_LOCAL_INVALIDATE);
                }
            } else {
                Log.getLogWriter().info("invalidateObject: invalidating name " + name + " callback is " + callback);
                aRegion.invalidate(name, (Object)callback);
                Log.getLogWriter().info("invalidateObject: done invalidating name " + name);
                long l = EventBB.incrementCounter("EventBB.NUM_INVALIDATE", EventBB.NUM_INVALIDATE);
            }
            if (this.isCarefulValidation) {
                this.verifyObjectInvalidated(this.shadow, name);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        Set aSet = this.shadow.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("destroyObject: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            this.destroyObject(aRegion, name, isLocalDestroy);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void destroyObject(Region aRegion, Object name, boolean isLocalDestroy) {
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedConnectionMgr.getConnection().getDistributedMember();
            if (isLocalDestroy) {
                Log.getLogWriter().info("destroyObject: local destroy for " + name + " callback is " + callback);
                aRegion.localDestroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done with local destroy for " + name);
                long l = EventBB.incrementCounter("EventBB.NUM_LOCAL_DESTROY", EventBB.NUM_LOCAL_DESTROY);
            } else {
                Log.getLogWriter().info("destroyObject: destroying name " + name + " callback is " + callback);
                aRegion.destroy(name, (Object)callback);
                Log.getLogWriter().info("destroyObject: done destroying name " + name);
                long l = EventBB.incrementCounter("EventBB.NUM_DESTROY", EventBB.NUM_DESTROY);
            }
        }
        catch (EntryNotFoundException e) {
            if (this.isCarefulValidation) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateObject(Region aRegion) {
        Set aSet = this.shadow.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        Object name = null;
        while (iter.hasNext() && !this.shadow.containsValueForKey(name = iter.next())) {
        }
        if (name == null) {
            Log.getLogWriter().info("updateObject: No keys w/values to update");
            return;
        }
        this.updateObject(aRegion, name);
    }

    protected void updateObject(Region aRegion, Object name) {
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        String callback = createCallbackPrefix;
        callback = callback + ProcessMgr.getProcessId() + memberIdString + DistributedConnectionMgr.getConnection().getDistributedMember();
        Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ", callback is " + callback);
        try {
            aRegion.put(name, newObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        EventBB.incrementCounter("EventBB.NUM_CREATE", EventBB.NUM_CREATE);
    }

    protected void readObject(Region aRegion) {
        Set aSet = this.shadow.keys();
        if (aSet.size() == 0) {
            Log.getLogWriter().info("readObject: No names in region");
            return;
        }
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            Log.getLogWriter().info("readObject: max positive name counter is " + maxNames);
            return;
        }
        String name = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, (int)maxNames));
        Log.getLogWriter().info("readObject: getting name " + name);
        try {
            Object anObj = aRegion.get((Object)name);
            Log.getLogWriter().info("readObject: got value for name " + name + ": " + TestHelper.toString(anObj));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void doRegionOperations() {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            ProxyEventTest.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventBB.getBB());
        if (this.useTransactions) {
            TxHelper.begin();
        }
        do {
            if (this.isSerialRR) {
                EventBB.clearRegionOpInfo();
                EventBB.clearRemoteRegionCounters();
                EventBB.zero("EventBB.numInRound", EventBB.numInRound);
            }
            long numRegions = this.getNumNonRootRegions();
            int whichOp = this.getOperation(EventPrms.regionOperations, false);
            if (numRegions == 0L) {
                whichOp = 1;
            } else if (numRegions >= (long)this.maxRegions) {
                whichOp = 4;
            }
            switch (whichOp) {
                case 1: {
                    this.addRegion();
                    break;
                }
                case 4: {
                    this.destroyRegion(false);
                    break;
                }
                case 3: {
                    this.invalidateRegion(false);
                    break;
                }
                case 7: {
                    this.destroyRegion(true);
                    break;
                }
                case 6: {
                    this.invalidateRegion(true);
                    break;
                }
                case 8: {
                    this.closeRegion();
                    break;
                }
                case 9: {
                    this.clearRegion();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
        } while (EventBB.getRegionOp() == -1 && System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
        if (this.useTransactions) {
            int n = 0;
            int commitPercentage = EventPrms.getCommitPercentage();
            if (!this.isSerialExecution) {
                n = TestConfig.tab().getRandGen().nextInt(1, 100);
            }
            if (n <= commitPercentage) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    if (this.isSerialExecution) {
                        throw new TestException("Unexpected conflict Exception " + TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ConflictException " + (Object)((Object)e) + " expected, continuing test");
                }
            } else {
                TxHelper.rollback();
            }
            if (this.isSerialExecution) {
                this.checkEventCounters();
            }
        }
        EventBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
    }

    public static void HydraTask_executeRegionOp() {
        eventTest.executeRegionOp();
    }

    protected void executeRegionOp() {
        long rrNum = EventBB.incrementCounter("EventBB.numInRound", EventBB.numInRound);
        Log.getLogWriter().info("I am member " + rrNum + " in the RoundRobin");
        TestHelper.checkForEventError(EventBB.getBB());
        int whichOp = EventBB.getRegionOp();
        if (whichOp == -1) {
            return;
        }
        String regionName = EventBB.getTargetRegion();
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        Log.getLogWriter().info("executing operation " + whichOp + " on " + regionName);
        switch (whichOp) {
            case 1: {
                String parentRegionName = regionName.substring(0, regionName.lastIndexOf(47));
                String subregionName = regionName.substring(regionName.lastIndexOf(47) + 1);
                Log.getLogWriter().info("adding region " + subregionName + " to parentRegion " + parentRegionName);
                Region parentRegion = CacheUtil.getCache().getRegion(parentRegionName);
                this.addRegion(parentRegion, subregionName);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            case 7: {
                this.destroyRegion(true, aRegion);
                break;
            }
            case 6: {
                this.invalidateRegion(true, aRegion);
                break;
            }
            case 8: {
                this.closeRegion(aRegion);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichOp);
            }
        }
    }

    protected void addRegion() {
        Region parentRegion = this.getRandomRegion(true);
        String regionName = NameFactory.getNextRegionName();
        this.addRegion(parentRegion, regionName);
    }

    protected void addRegion(Region parentRegion, String regionName) {
        Region newRegion = null;
        try {
            RegionAttributes ratts = parentRegion.getAttributes();
            AttributesFactory factory = new AttributesFactory(ratts);
            CacheListener[] listenerList = ratts.getCacheListeners();
            CacheListener[] newListenerList = new CacheListener[listenerList.length - 1];
            int j = 0;
            for (int i = 0; i < listenerList.length; ++i) {
                if (listenerList[i] instanceof RegionListener) continue;
                newListenerList[j++] = listenerList[i];
            }
            factory.initCacheListeners(newListenerList);
            CacheListener regionListener = EventPrms.getRegionListener(regionName);
            if (regionListener != null) {
                factory.addCacheListener(regionListener);
            }
            RegionAttributes regAttr = factory.createRegionAttributes();
            Log.getLogWriter().info("Creating a new subregion of: " + TestHelper.regionToString(parentRegion, false) + " with name " + regionName);
            newRegion = parentRegion.createSubregion(regionName, regAttr);
            Log.getLogWriter().info("Created new region: " + TestHelper.regionToString(newRegion, true));
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(parentRegion, e);
            return;
        }
        catch (CacheException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int initRegionNumObjects = TestConfig.tab().intAt(EventPrms.initRegionNumObjects);
        for (int i = 1; i <= initRegionNumObjects; ++i) {
            this.addObject(newRegion, false);
        }
        Log.getLogWriter().info("Added " + initRegionNumObjects + " to " + TestHelper.regionToString(newRegion, false));
        if (this.isCarefulValidation) {
            EventBB.incrementCounter("EventBB.NUM_REGION_CREATE", EventBB.NUM_REGION_CREATE);
        }
        if (this.isSerialRR) {
            int rrNum = (int)EventBB.getBB().getSharedCounters().read(EventBB.numInRound);
            EventBB.add("EventBB.EXPECTED_REMOTE_REGION_CREATE", EventBB.EXPECTED_REMOTE_REGION_CREATE, rrNum);
            EventBB.putRegionOpInfo(1, newRegion.getFullPath());
        }
    }

    protected int invalidateRegion(boolean isLocalInvalidate) {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("invalidateRegion, not causing invalidate event because no regions exist other than roots");
            return 0;
        }
        return this.invalidateRegion(isLocalInvalidate, aRegion);
    }

    protected int invalidateRegion(boolean isLocalInvalidate, Region aRegion) {
        Log.getLogWriter().info("In invalidateRegion, region is " + TestHelper.regionsToString(aRegion, false));
        String regionName = TestHelper.regionToString(aRegion, false);
        int numRegions = 0;
        try {
            numRegions = aRegion.subregions(true).size() + 1;
        }
        catch (RegionDestroyedException e) {
            if (this.isCarefulValidation) {
                throw new TestException("Unexpected " + TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Not invalidating " + aRegion.getFullPath() + ", got " + (Object)((Object)e) + " while getting number of subregions; continuing test");
        }
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterRegionInvalidateEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterRegionInvalidateEvents_isNotExp)};
        try {
            long l;
            String callback = regionInvalidateCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedConnectionMgr.getConnection().getDistributedMember();
            if (isLocalInvalidate) {
                Log.getLogWriter().info("local invalidate for " + regionName + " callback is " + callback);
                aRegion.invalidateRegion((Object)callback);
                Log.getLogWriter().info("Done with local invalidate for " + regionName);
                l = EventBB.add("EventBB.NUM_LOCAL_REGION_INVALIDATE", EventBB.NUM_LOCAL_REGION_INVALIDATE, numRegions);
            } else {
                Log.getLogWriter().info("Invalidating " + regionName + " callback is " + callback);
                aRegion.invalidateRegion((Object)callback);
                Log.getLogWriter().info("Done invalidating " + regionName);
                l = EventBB.add("EventBB.NUM_REGION_INVALIDATE", EventBB.NUM_REGION_INVALIDATE, numRegions);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isCarefulValidation) {
            HashSet<Region> aSet = new HashSet<Region>(aRegion.subregions(true));
            aSet.add(aRegion);
            for (Region thisRegion : aSet) {
                for (Object key : thisRegion.keys()) {
                    this.verifyObjectInvalidated(thisRegion, key);
                }
            }
            long expectedCounter = beforeCounter[0] + (long)(numRegions * this.getNumVMsWithListeners());
            TestHelper.waitForCounter(EventCountersBB.getBB(), "numAfterRegionInvalidateEvents_isNotExp", EventCountersBB.numAfterRegionInvalidateEvents_isNotExp, expectedCounter, true, 60000L);
            expectedCounter = beforeCounter[1] + (long)(numRegions * this.getNumVMsWithListeners());
            TestHelper.waitForCounter(OperationCountersBB.getBB(), "numAfterRegionInvalidateOperationss_isNotExp", OperationCountersBB.numAfterRegionInvalidateEvents_isNotExp, expectedCounter, true, 60000L);
            this.checkEventCounters();
        }
        if (this.isSerialRR) {
            if (isLocalInvalidate) {
                EventBB.putRegionOpInfo(6, aRegion.getFullPath());
            } else {
                EventBB.putRegionOpInfo(3, aRegion.getFullPath());
            }
        }
        return numRegions;
    }

    protected int closeRegion() {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("closeRegion, not causing close event bcause no regions exist other than roots");
            return 0;
        }
        return this.closeRegion(aRegion);
    }

    protected int closeRegion(Region aRegion) {
        String regionName = TestHelper.regionToString(aRegion, false);
        Log.getLogWriter().info("In closeRegion, region is " + regionName);
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterRegionDestroyEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterRegionDestroyEvents_isNotExp)};
        Set regionSet = null;
        int numRegions = 0;
        if (this.isCarefulValidation) {
            regionSet = aRegion.subregions(true);
            numRegions = regionSet.size() + 1;
            Log.getLogWriter().info("numRegions being closed is " + numRegions + " " + TestHelper.regionsToString(aRegion, false));
        }
        try {
            Log.getLogWriter().info("Closing region " + regionName);
            aRegion.close();
            Log.getLogWriter().info("Done closing " + regionName);
            if (this.isCarefulValidation) {
                EventBB.add("EventBB.NUM_CLOSE", EventBB.NUM_CLOSE, numRegions);
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        StringBuffer errStr = new StringBuffer();
        if (this.isCarefulValidation) {
            HashSet<Region> newSet = new HashSet<Region>(regionSet);
            newSet.add(aRegion);
            for (Region thisRegion : regionSet) {
                boolean isDestroyed = thisRegion.isDestroyed();
                if (!isDestroyed) {
                    errStr.append("Unexpected " + thisRegion + ".isDestroyed() returned " + isDestroyed);
                }
                try {
                    Iterator it2 = thisRegion.keys().iterator();
                    errStr.append("Successfully was able to get keys() of destroyed region\n");
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
            if (this.isSerialRR) {
                int rrNum = (int)EventBB.getBB().getSharedCounters().read(EventBB.numInRound);
                EventBB.add("EventBB.EXPECTED_REMOTE_REGION_DEPARTED", EventBB.EXPECTED_REMOTE_REGION_DEPARTED, numRegions * (this.getNumVMsWithListeners() - (rrNum + 1)));
                EventBB.putRegionOpInfo(8, aRegion.getFullPath());
            }
            this.checkEventCounters();
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        return numRegions;
    }

    protected int destroyRegion(boolean isLocalDestroy) {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("destroyRegion, not causing destroy event bcause no regions exist other than roots");
            return 0;
        }
        return this.destroyRegion(isLocalDestroy, aRegion);
    }

    protected int destroyRegion(boolean isLocalDestroy, Region aRegion) {
        String regionName = TestHelper.regionToString(aRegion, false);
        Log.getLogWriter().info("In destroyRegion, region is " + regionName);
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterRegionDestroyEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterRegionDestroyEvents_isNotExp)};
        Set regionSet = null;
        int numRegions = 0;
        if (this.isCarefulValidation) {
            regionSet = aRegion.subregions(true);
            numRegions = regionSet.size() + 1;
            Log.getLogWriter().info("numRegions being destroyed is " + numRegions + " " + TestHelper.regionsToString(aRegion, false));
        }
        try {
            String callback = regionDestroyCallbackPrefix + ProcessMgr.getProcessId() + memberIdString + DistributedConnectionMgr.getConnection().getDistributedMember();
            if (isLocalDestroy) {
                Log.getLogWriter().info("local destroy for region " + regionName + " callback is " + callback);
                aRegion.localDestroyRegion((Object)callback);
                Log.getLogWriter().info("Done with local destroy for " + regionName);
                if (this.isCarefulValidation) {
                    EventBB.add("EventBB.NUM_LOCAL_REGION_DESTROY", EventBB.NUM_LOCAL_REGION_DESTROY, numRegions);
                    EventBB.add("EventBB.NUM_CLOSE", EventBB.NUM_CLOSE, numRegions);
                }
            } else {
                Log.getLogWriter().info("destroying region " + regionName + " callback is " + callback);
                aRegion.destroyRegion((Object)callback);
                Log.getLogWriter().info("Done destroying " + regionName);
                if (this.isCarefulValidation) {
                    EventBB.add("EventBB.NUM_REGION_DESTROY", EventBB.NUM_REGION_DESTROY, numRegions);
                    EventBB.add("EventBB.NUM_CLOSE", EventBB.NUM_CLOSE, numRegions);
                }
            }
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        StringBuffer errStr = new StringBuffer();
        if (this.isCarefulValidation) {
            HashSet<Region> newSet = new HashSet<Region>(regionSet);
            newSet.add(aRegion);
            for (Region thisRegion : regionSet) {
                boolean isDestroyed = thisRegion.isDestroyed();
                if (!isDestroyed) {
                    errStr.append("Unexpected " + thisRegion + ".isDestroyed() returned " + isDestroyed);
                }
                try {
                    Iterator it2 = thisRegion.keys().iterator();
                    errStr.append("Successfully was able to get keys() of destroyed region\n");
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
            long expectedCounter = beforeCounter[0] + (long)(numRegions * this.getNumVMsWithListeners());
            TestHelper.waitForCounter(EventCountersBB.getBB(), "numAfterRegionDestroyEvents_isNotExp", EventCountersBB.numAfterRegionDestroyEvents_isNotExp, expectedCounter, true, 60000L);
            expectedCounter = beforeCounter[1] + (long)(numRegions * this.getNumVMsWithListeners());
            TestHelper.waitForCounter(OperationCountersBB.getBB(), "numAfterRegionDestroyEvents_isNotExp", OperationCountersBB.numAfterRegionDestroyEvents_isNotExp, expectedCounter, true, 60000L);
            this.checkEventCounters();
        }
        if (this.isSerialRR) {
            if (isLocalDestroy) {
                EventBB.putRegionOpInfo(7, aRegion.getFullPath());
                int rrNum = (int)EventBB.getBB().getSharedCounters().read(EventBB.numInRound);
                EventBB.add("EventBB.EXPECTED_REMOTE_REGION_DEPARTED", EventBB.EXPECTED_REMOTE_REGION_DEPARTED, numRegions * (this.getNumVMsWithListeners() - (rrNum + 1)));
            } else {
                EventBB.putRegionOpInfo(4, aRegion.getFullPath());
            }
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        return numRegions;
    }

    protected int clearRegion() {
        Region aRegion = this.getRandomRegion(false);
        if (aRegion == null) {
            Log.getLogWriter().info("clearRegion, not causing clear event because no regions exist other than roots");
            return 0;
        }
        return this.clearRegion(aRegion);
    }

    protected int clearRegion(Region aRegion) {
        String regionName = TestHelper.regionToString(aRegion, false);
        Log.getLogWriter().info("In clearRegion, region is " + regionName);
        long[] beforeCounter = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterClearEvents_isNotExp), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numAfterClearEvents_isNotExp)};
        int numRegions = 0;
        if (this.isCarefulValidation) {
            // empty if block
        }
        try {
            Log.getLogWriter().info("clearing region " + regionName);
            aRegion.clear();
            Log.getLogWriter().info("Done clearing " + regionName);
            long l = EventBB.add("EventBB.NUM_CLEAR", EventBB.NUM_CLEAR, numRegions);
        }
        catch (RegionDestroyedException e) {
            this.handleRegionDestroyedException(aRegion, e);
            return numRegions;
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (this.isCarefulValidation) {
            if (!aRegion.isEmpty()) {
                throw new TestException("The region was not found empty after clear");
            }
            long expectedCounter = beforeCounter[0] + (long)(numRegions * this.getNumVMsWithListeners());
            TestHelper.waitForCounter(EventCountersBB.getBB(), "numAfterClearEvents_isNotExp", EventCountersBB.numAfterClearEvents_isNotExp, expectedCounter, true, 60000L);
            expectedCounter = beforeCounter[1] + (long)(numRegions * this.getNumVMsWithListeners());
            TestHelper.waitForCounter(OperationCountersBB.getBB(), "numAfterClearEvents_isNotExp", OperationCountersBB.numAfterClearEvents_isNotExp, expectedCounter, true, 60000L);
            this.checkEventCounters();
        }
        if (this.isSerialRR) {
            EventBB.putRegionOpInfo(9, aRegion.getFullPath());
        }
        return numRegions;
    }

    protected void addToRegion() {
        long startTime = System.currentTimeMillis();
        if (this.isSerialExecution) {
            ProxyEventTest.logExecutionNumber();
        }
        TestHelper.checkForEventError(EventBB.getBB());
        Log.getLogWriter().info("Faulting in available regions...");
        this.faultInNewRegions();
        Log.getLogWriter().info("Done faulting in available regions.");
        do {
            Region aRegion;
            if ((aRegion = this.getRandomRegion(false)) == null) continue;
            this.addObject(aRegion, true);
        } while (System.currentTimeMillis() - startTime < this.minTaskGranularityMS);
    }

    protected int faultInNewRegions() {
        int numCreated = 0;
        StringBuffer logStr = new StringBuffer();
        long startTime = System.currentTimeMillis();
        Region rootRegion = CacheUtil.getCache().getRegion(this.regionName);
        Log.getLogWriter().info("Before faulting in: " + TestHelper.regionsToString(rootRegion, false));
        RegionAttributes attr = rootRegion.getAttributes();
        List aList = (List)EventBB.getBB().getSharedMap().get(EventBB.CURRENT_REGION_NAMES);
        block0: for (int i = 0; i < aList.size(); ++i) {
            String regionName = (String)aList.get(i);
            Region previousRegion = null;
            StringTokenizer st = new StringTokenizer(regionName, "/", false);
            while (st.hasMoreTokens()) {
                String singleRegionName = st.nextToken();
                if (singleRegionName.equals(regionName)) {
                    previousRegion = rootRegion;
                    continue;
                }
                Object[] tmp = this.faultInRegion(previousRegion, singleRegionName, attr);
                previousRegion = (Region)tmp[0];
                logStr.append(tmp[1]);
                boolean created = (Boolean)tmp[2];
                if (created) {
                    ++numCreated;
                }
                if (previousRegion != null) continue;
                continue block0;
            }
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        EventBB.getBB().getSharedCounters().setIfLarger(EventBB.MAX_FAULT_IN_REGIONS_MILLIS, duration);
        Log.getLogWriter().info("Done faulting in new regions, " + logStr.toString());
        Log.getLogWriter().info("Done faulting in new regions, elapsed time " + TestHelper.millisToString(duration) + ", all regions: " + TestHelper.regionsToString(rootRegion, false));
        return numCreated;
    }

    protected Object[] faultInRegion(Region parentRegion, String newRegionName, RegionAttributes attr) {
        boolean verbose = true;
        try {
            Region newRegion;
            if (verbose) {
                String s = "In faultInRegion: Attempting to create " + newRegionName + " as a subregion of " + TestHelper.regionToString(parentRegion, false);
                Log.getLogWriter().info(s);
            }
            if ((newRegion = CacheUtil.getCache().getRegion(parentRegion.getFullPath() + "/" + newRegionName)) == null) {
                newRegion = parentRegion.createSubregion(newRegionName, attr);
            }
            if (verbose) {
                Log.getLogWriter().info("In faultInRegion: Created " + newRegionName);
            }
            return new Object[]{newRegion, "Faulted in new region " + newRegionName + "\n", new Boolean(true)};
        }
        catch (RegionExistsException e) {
            if (verbose) {
                String s = "In faultInRegion: Region " + newRegionName + " already exists as a subregion of " + TestHelper.regionToString(parentRegion, false) + "; continuing";
                Log.getLogWriter().info(s);
            }
            try {
                return new Object[]{parentRegion.getSubregion(newRegionName), "Region " + newRegionName + " already exists\n", new Boolean(false)};
            }
            catch (RegionDestroyedException anExcept) {
                if (!this.isCarefulValidation) {
                    if (verbose) {
                        String s = "In faultInRegion: Region " + newRegionName + " has been destroyed ; continuing";
                        Log.getLogWriter().info(s);
                    }
                    return new Object[]{null, "Region " + newRegionName + " has been destroyed\n", new Boolean(false)};
                }
                throw new TestException(TestHelper.getStackTrace(anExcept));
            }
        }
        catch (RegionDestroyedException e) {
            if (verbose) {
                Log.getLogWriter().info("In faultInRegion: Region " + newRegionName + " has been destroyed; continuing");
            }
            return new Object[]{null, "Region " + newRegionName + " has been destroyed\n", new Boolean(false)};
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void checkEventCounters() {
        throw new TestException("checkEventCounters must be implmented in a subclass");
    }

    protected Object getObjectToAdd(String name) {
        ValueHolder anObj = new ValueHolder(name, this.randomValues);
        return anObj;
    }

    protected Object getUpdateObject(String name) {
        Region rootRegion = CacheUtil.getCache().getRegion(this.regionName);
        BaseValueHolder anObj = null;
        BaseValueHolder newObj = null;
        try {
            anObj = (BaseValueHolder)rootRegion.get((Object)name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        newObj = anObj == null ? new ValueHolder(name, this.randomValues) : anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    protected int getNumVMsWithListeners() {
        throw new TestException("getNumVMsWithListeners must be implemented in a subclass");
    }

    protected void createRootRegions() {
        MirrorType mt;
        String regionListenerName;
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        this.regionName = regDef.getRegionName();
        if (this.clientName.equals("client1")) {
            regDef.setDataPolicy(DataPolicy.NORMAL);
            regDef.setSubscriptionAttributes(new SubscriptionAttributes(InterestPolicy.ALL));
            regDef.setCacheListener("event.ShadowListener");
        }
        if ((regionListenerName = TestConfig.tab().stringAt(EventPrms.regionListener, null)) != null) {
            regDef.addCacheListener(regionListenerName);
        }
        regDef.createRootRegion(CacheUtil.createCache(), this.regionName, null, null, null);
        this.isMirrored = false;
        DataPolicy dataPolicy = regDef.getDataPolicy();
        this.isMirrored = dataPolicy == null ? ((mt = regDef.getMirroring()) == null ? false : mt.isMirrored()) : dataPolicy.withReplication();
        RegionDefinition shadowRegDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, "shadowRegion");
        this.shadow = shadowRegDef.createRootRegion(CacheUtil.getCache(), null, null, null, null);
        this.shadowRegionName = shadowRegDef.getRegionName();
    }

    public static void HydraTask_printBB() throws Throwable {
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        OperationCountersBB.getBB().print();
        TestHelper.checkForEventError(EventBB.getBB());
    }

    public static void HydraTask_iterate() throws Throwable {
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        regDef.setEntryIdleTimeoutSec(null);
        regDef.setEntryIdleTimeoutAction(null);
        regDef.setEntryTTLSec(null);
        regDef.setEntryTTLAction(null);
        regDef.createRootRegion(CacheUtil.createCache(), regDef.getRegionName(), null, null, null);
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        OperationCountersBB.getBB().print();
        TestHelper.checkForEventError(EventBB.getBB());
    }

    public static void HydraTask_endTask() throws Throwable {
        TestHelper.checkForEventError(EventBB.getBB());
        CacheBB.getBB().print();
        EventBB.getBB().print();
        EventCountersBB.getBB().print();
        OperationCountersBB.getBB().print();
        eventTest = new ProxyEventTest();
        eventTest.initialize();
        StringBuffer errStr = new StringBuffer();
        try {
            eventTest.checkEventCounters();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            Log.getLogWriter().info(e.toString());
            errStr.append(e.toString());
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        TestHelper.checkForEventError(EventBB.getBB());
    }

    protected Object[] iterateRegion(Region aRegion, boolean allowZeroKeys, boolean allowZeroNonNullValues) {
        StringBuffer errStr = new StringBuffer();
        Set keys = this.shadow.keys();
        Log.getLogWriter().info("For " + TestHelper.regionToString(aRegion, false) + ", found " + keys.size() + " keys");
        int numKeys = keys.size();
        if (numKeys == 0 && !allowZeroKeys) {
            errStr.append("Region " + TestHelper.regionToString(aRegion, false) + " has " + numKeys + " keys\n");
        }
        int valueCount = 0;
        for (Object key : keys) {
            String valueHolderValue;
            Object value;
            try {
                value = aRegion.get(key);
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            Log.getLogWriter().info("Checking key " + key + ", value " + value);
            if (value == null) continue;
            ++valueCount;
            BaseValueHolder vh = (BaseValueHolder)value;
            String nameValue = "" + NameFactory.getCounterForName(key);
            if (nameValue.equals(valueHolderValue = "" + vh.myValue)) continue;
            String aStr = "Expected counter of key/value to match, key: " + key + ", value: " + vh.toString();
            Log.getLogWriter().info(aStr);
            errStr.append(aStr + "\n");
        }
        if (valueCount == 0 && !allowZeroNonNullValues) {
            errStr.append("Region " + TestHelper.regionToString(aRegion, false) + " has " + valueCount + " non-null values\n");
        }
        return new Object[]{new Integer(numKeys), new Integer(valueCount), errStr.toString()};
    }

    protected int getOperation(Long whichPrm, boolean disallowLocalEntryOps) {
        long limit = 60000L;
        long startTime = System.currentTimeMillis();
        int op = 0;
        do {
            String operation;
            if ((operation = TestConfig.tab().stringAt(whichPrm)).equals("add")) {
                op = 1;
            } else if (operation.equals("update")) {
                op = 2;
            } else if (operation.equals("invalidate")) {
                op = 3;
            } else if (operation.equals("destroy")) {
                op = 4;
            } else if (operation.equals("read")) {
                op = 5;
            } else if (operation.equals("localInvalidate")) {
                op = 6;
            } else if (operation.equals("localDestroy")) {
                op = 7;
            } else if (operation.equals("close")) {
                op = 8;
            } else if (operation.equals("clear")) {
                op = 9;
            } else {
                throw new TestException("Unknown entry operation: " + operation);
            }
            if (System.currentTimeMillis() - startTime <= limit) continue;
            throw new TestException("Could not find an operation in " + limit + " millis; disallowLocalEntryOps is " + true + "; check that the operations list has allowable choices");
        } while (disallowLocalEntryOps && (op == 6 || op == 7));
        return op;
    }

    protected static void logExecutionNumber() {
        long exeNum = EventBB.getBB().getSharedCounters().incrementAndRead(EventBB.EXECUTION_NUMBER);
        Log.getLogWriter().info("Beginning task with execution number " + exeNum);
    }

    protected void writeMyRegionNames() {
        this.writeMyRegionNames(null);
    }

    protected void writeMyRegionNames(Region excludeRegion) {
        String excludeRegionName = "";
        if (excludeRegion != null) {
            excludeRegionName = TestHelper.regionToString(excludeRegion, false);
        }
        Region rootRegion = CacheUtil.getCache().getRegion(this.regionName);
        Log.getLogWriter().info("In writeMyRegionNames: getting regions to write...");
        StringBuffer logStr = new StringBuffer();
        Set regionSet = rootRegion.subregions(true);
        Iterator it = regionSet.iterator();
        ArrayList<String> aList = new ArrayList<String>();
        while (it.hasNext()) {
            String regionName = ((Region)it.next()).getFullPath();
            if (regionName.equals(excludeRegionName)) continue;
            aList.add(regionName);
            logStr.append("   " + regionName + "\n");
        }
        logStr.insert(0, "In writeMyRegionNames: writing " + aList.size() + " regions to blackboard with name " + EventBB.CURRENT_REGION_NAMES + "\n");
        Log.getLogWriter().info(logStr.toString());
        long start = System.currentTimeMillis();
        EventBB.getBB().getSharedMap().put(EventBB.CURRENT_REGION_NAMES, aList);
        long end = System.currentTimeMillis();
        long duration = end - start;
        EventBB.getBB().getSharedCounters().setIfLarger(EventBB.MAX_WRITE_CURR_REGION_NAMES_MILLIS, duration);
        EventBB.getBB().getSharedCounters().setIfLarger(EventBB.MAX_NUM_WRITE_CURR_REGION_NAMES, aList.size());
        Log.getLogWriter().info("In writeMyRegionNames: time to write " + aList.size() + " region names is " + TestHelper.millisToString(end - start));
    }

    protected Region getRandomRegion(boolean allowRootRegion) {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        if (rootRegions.size() == 1) {
            return null;
        }
        Object[] regionList = rootRegions.toArray();
        Region rootRegion = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
        while (rootRegion == null) {
            Region testRegion = (Region)regionList[randInt];
            if (!testRegion.getName().equals(this.shadowRegionName)) {
                rootRegion = (Region)regionList[randInt];
            }
            randInt = TestConfig.tab().getRandGen().nextInt(0, rootRegions.size() - 1);
        }
        Set subregionsSet = rootRegion.subregions(true);
        if (subregionsSet.size() == 0) {
            if (allowRootRegion) {
                return rootRegion;
            }
            return null;
        }
        ArrayList<Object> aList = null;
        try {
            Object[] array = subregionsSet.toArray();
            aList = new ArrayList<Object>(array.length);
            for (int i = 0; i < array.length; ++i) {
                aList.add(array[i]);
            }
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
        if (allowRootRegion) {
            aList.add(rootRegion);
        }
        if (aList.size() == 0) {
            return null;
        }
        randInt = TestConfig.tab().getRandGen().nextInt(0, aList.size() - 1);
        Region aRegion = (Region)aList.get(randInt);
        if (aRegion == null) {
            throw new TestException("Bug 30171 detected: aRegion is null");
        }
        return aRegion;
    }

    protected void handleRegionDestroyedException(Region aRegion, RegionDestroyedException anException) {
        if (this.isCarefulValidation) {
            throw new TestException(TestHelper.getStackTrace(anException));
        }
        if (!anException.getRegionFullPath().equals(aRegion.getFullPath())) {
            TestException te = new TestException("Got a RegionDestroyedException when operating on region " + TestHelper.regionToString(aRegion, false) + ", but the region destroyed is '" + anException.getRegionFullPath() + "'");
            te.initCause(anException);
            throw te;
        }
        boolean isDestroyed = aRegion.isDestroyed();
        if (!isDestroyed) {
            throw new TestException("Bug 30645 (likely): isDestroyed returned " + isDestroyed + " for region " + TestHelper.regionToString(aRegion, false) + ", but a region destroyed exception was thrown: " + TestHelper.getStackTrace(anException));
        }
        Log.getLogWriter().info("Got " + RegionDestroyedException.class.getName() + " on " + TestHelper.regionToString(aRegion, false) + "; exception expected, continuing test");
    }

    protected long getNumNonRootRegions() {
        Set rootRegions = CacheUtil.getCache().rootRegions();
        long numRegions = 0L;
        for (Region aRegion : rootRegions) {
            if (aRegion.getName().equals(this.shadowRegionName)) continue;
            numRegions += (long)aRegion.subregions(true).size();
        }
        Log.getLogWriter().info("Num non-root regions is " + numRegions + ", num root region is " + rootRegions.size());
        return numRegions;
    }

    protected void verifyObjectInvalidated(Region aRegion, Object key) {
        Object entryValue;
        Object entryKey;
        Region.Entry entry;
        boolean containsValueForKey;
        if (this.useTransactions) {
            return;
        }
        StringBuffer errStr = new StringBuffer();
        TestHelper.waitForContainsValueForKey(aRegion, key, false, 60000L, false);
        boolean containsKey = aRegion.containsKey(key);
        if (!containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) == null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned null\n");
        }
        if (!(entryKey = entry.getKey()).equals(key)) {
            errStr.append("getEntry.getKey() " + entryKey + " does not equal key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entryValue = entry.getValue()) != null) {
            errStr.append("Expected getEntry.getValue() " + TestHelper.toString(entryValue) + " to be null.\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    protected void verifyObjectDestroyed(Region aRegion, Object key) {
        Region.Entry entry;
        boolean containsValueForKey;
        if (this.useTransactions) {
            return;
        }
        StringBuffer errStr = new StringBuffer();
        TestHelper.waitForContainsKey(aRegion, key, false, 60000L, false);
        boolean containsKey = aRegion.containsKey(key);
        if (containsKey) {
            errStr.append("Unexpected containsKey " + containsKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if (containsValueForKey = aRegion.containsValueForKey(key)) {
            errStr.append("Unexpected containsValueForKey " + containsValueForKey + " for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + "\n");
        }
        if ((entry = aRegion.getEntry(key)) != null) {
            errStr.append("getEntry for key " + key + " in region " + TestHelper.regionToString(aRegion, false) + " returned was non-null; getKey is " + entry.getKey() + ", value is " + TestHelper.toString(entry.getValue()) + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    static {
        LOCK_SERVICE_NAME = "MyLockService";
        LOCK_NAME = "MyLock";
    }
}

