/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import event.EventBB;
import event.ProxyEventTest;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.CacheUtil;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.OperationCountersBB;
import util.TestHelper;

public class ProxySerialEntryEventTest
extends ProxyEventTest {
    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new ProxySerialEntryEventTest();
            eventTest.initialize();
            EventCountersBB.getBB().zeroAllCounters();
            OperationCountersBB.getBB().zeroAllCounters();
        }
    }

    public static synchronized void HydraTask_closeTask() {
        ((ProxySerialEntryEventTest)eventTest).checkEventCounters(false);
    }

    @Override
    protected int getNumVMsWithListeners() {
        RegionAttributes ra = CacheUtil.getRegion(ProxySerialEntryEventTest.eventTest.regionName).getAttributes();
        DataPolicy dataPolicy = ra.getDataPolicy();
        InterestPolicy interestPolicy = ra.getSubscriptionAttributes().getInterestPolicy();
        boolean allEvents = dataPolicy.withReplication() || interestPolicy.isAll();
        return allEvents ? TestHelper.getNumVMs() - 1 : 1;
    }

    @Override
    protected void addObject(Region aRegion, boolean aBoolean) {
        super.addObject(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        super.invalidateObject(aRegion, isLocalInvalidate);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        super.destroyObject(aRegion, isLocalDestroy);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void updateObject(Region aRegion) {
        super.updateObject(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void checkEventCounters() {
        this.checkEventCounters(true);
    }

    protected void checkEventCounters(boolean numCloseIsExact) {
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInval = counters.read(EventBB.NUM_INVALIDATE);
        long numRegionCreate = counters.read(EventBB.NUM_REGION_CREATE);
        long numRegionDestroy = counters.read(EventBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(EventBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(EventBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(EventBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(EventBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(EventBB.NUM_LOCAL_REGION_INVALIDATE);
        long numClose = counters.read(EventBB.NUM_CLOSE);
        numCreate += numUpdate;
        numUpdate = 0L;
        int numVmsWithList = this.getNumVMsWithListeners();
        Log.getLogWriter().info("num VMs InterestALL with listener installed: " + numVmsWithList);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", numCreate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", numCreate * (long)numVmsWithList + numUpdate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", numCreate * (long)numVmsWithList + numUpdate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", numCreate * (long)numVmsWithList + numUpdate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", numCreate * (long)numVmsWithList + numUpdate * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", numDestroy * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotRemote", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", numDestroy * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", numInval * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotRemote", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", numInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", numRegionInval * (long)numVmsWithList));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", numRegionInval * (long)numVmsWithList + numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", numRegionInval * (long)(numVmsWithList - 1)));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", numRegionInval + numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotRemote", 0L));
        al.add(new ExpCounterValue("numClose", numClose, numCloseIsExact));
        EventCountersBB.getBB().checkEventCounters(al);
        OperationCountersBB.getBB().checkEventCounters(al);
    }
}

