/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.RegionAttributes;
import event.EventBB;
import event.ProxyEventTest;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.CacheUtil;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.OperationCountersBB;
import util.TestException;
import util.TestHelper;

public class ProxySerialRegionEventTest
extends ProxyEventTest {
    boolean inEndTask = false;

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new ProxySerialRegionEventTest();
            eventTest.initialize();
            EventCountersBB.getBB().zeroAllCounters();
            OperationCountersBB.getBB().zeroAllCounters();
        }
    }

    @Override
    protected int getNumVMsWithListeners() {
        RegionAttributes ra = CacheUtil.getRegion(this.regionName).getAttributes();
        DataPolicy dataPolicy = ra.getDataPolicy();
        InterestPolicy interestPolicy = ra.getSubscriptionAttributes().getInterestPolicy();
        boolean allEvents = dataPolicy.withReplication() || interestPolicy.isAll();
        return allEvents ? TestHelper.getNumVMs() - 1 : 1;
    }

    @Override
    protected void addRegion() {
        super.addRegion();
        this.checkEventCounters();
    }

    @Override
    protected int invalidateRegion(boolean isLocalInvalidate) {
        int numInval = super.invalidateRegion(isLocalInvalidate);
        this.checkEventCounters();
        return numInval;
    }

    @Override
    protected int destroyRegion(boolean isLocalDestroy) {
        int numDestroy = super.destroyRegion(isLocalDestroy);
        this.checkEventCounters();
        return numDestroy;
    }

    @Override
    protected void checkEventCounters() {
        long actualDepartedEvents;
        if (!this.isSerialExecution) {
            return;
        }
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInval = counters.read(EventBB.NUM_INVALIDATE);
        long numRegionCreate = counters.read(EventBB.NUM_REGION_CREATE);
        long numRegionDestroy = counters.read(EventBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(EventBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(EventBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(EventBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(EventBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(EventBB.NUM_LOCAL_REGION_INVALIDATE);
        long totalRegDestroys = numLocalRegionDestroy + numRegionDestroy;
        long totalRegInval = numLocalRegionInval + numRegionInval;
        long numClose = counters.read(EventBB.NUM_CLOSE);
        int numVms = this.getNumVMsWithListeners();
        boolean countIsExact = false;
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", 0L, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", numCreate, countIsExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", "numAfterDestroyEvents_isNotRemote", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", numDestroy));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", "numAfterInvalidateEvents_isNotRemote", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", numInval));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", "numAfterUpdateEvents_isNotRemote", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", numUpdate));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", numRegionDestroy * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", numLocalRegionDestroy * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", (numRegionDestroy + numLocalRegionDestroy) * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", "numAfterRegionDestroyEvents_isNotRemote", (numRegionDestroy + numLocalRegionDestroy) * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isDist", numRegionInval * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotDist", numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotExp", (numRegionInval + numLocalRegionInval) * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isRemote", "numAfterRegionInvalidateEvents_isNotRemote", (numRegionInval + numLocalRegionInval) * (long)numVms));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotDist", numRegionCreate));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotExp", numRegionCreate));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotRemote", numRegionCreate));
        if (this.inEndTask) {
            long[] counterValue = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numClose), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numClose)};
            if (numClose > counterValue[0] || numClose > counterValue[1]) {
                throw new TestException("Expected EventCountersBB.numClose " + counterValue + " to be > " + numClose);
            }
        } else {
            al.add(new ExpCounterValue("numClose", numClose + numRegionDestroy * (long)(numVms - 1)));
        }
        EventCountersBB.getBB().checkEventCounters(al);
        OperationCountersBB.getBB().checkEventCounters(al);
        long expectedCreateEvents = EventBB.getBB().getSharedCounters().read(EventBB.EXPECTED_REMOTE_REGION_CREATE);
        long actualCreateEvents = EventBB.getBB().getSharedCounters().read(EventBB.actualRegionCreateEvents);
        if (expectedCreateEvents != actualCreateEvents) {
            throw new TestException("Expected " + expectedCreateEvents + " remoteRegionCreate events, but actual = " + actualCreateEvents);
        }
        long expectedDepartedEvents = EventBB.getBB().getSharedCounters().read(EventBB.EXPECTED_REMOTE_REGION_DEPARTED);
        if (expectedDepartedEvents != (actualDepartedEvents = EventBB.getBB().getSharedCounters().read(EventBB.actualRegionDepartedEvents))) {
            throw new TestException("Expected " + expectedDepartedEvents + " remoteRegionDeparted events, but actual = " + actualDepartedEvents);
        }
    }
}

