/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.RegionMembershipListener;
import com.gemstone.gemfire.distributed.DistributedMember;
import event.EventBB;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.TestException;
import util.TestHelper;

public class RegionListener
extends AbstractListener
implements RegionMembershipListener,
Declarable {
    private String name = "EventRegion";
    private boolean isCarefulValidation;

    public RegionListener() {
        this.isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
    }

    public RegionListener(String name) {
        this.name = name;
        this.isCarefulValidation = TestConfig.tab().booleanAt(Prms.serialExecution);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void initialMembers(Region r, DistributedMember[] members) {
        long rrNum;
        if (r.getParentRegion() == null) {
            return;
        }
        StringBuffer aStr = new StringBuffer("RegionListener: InitialMembers for region " + this.getName() + " =\n");
        for (int i = 0; i < members.length; ++i) {
            aStr.append("   member[" + i + "] = " + members[i] + "\n");
        }
        Log.getLogWriter().info(aStr.toString());
        if (EventBB.isSerialRR() && (rrNum = EventBB.getBB().getSharedCounters().read(EventBB.numInRound)) != (long)members.length) {
            this.throwException("RegionListener.initialMembers list length may not have enough members.  Expected " + rrNum + " members, but found " + members.length + " : " + aStr.toString());
        }
    }

    public void afterRemoteRegionCreate(RegionEvent event) {
        this.logCall("afterRemoteRegionCreate", (CacheEvent)event);
        EventBB.incrementCounter("EventBB.actualRegionCreateEvents", EventBB.actualRegionCreateEvents);
    }

    public void afterRemoteRegionDeparture(RegionEvent event) {
        this.logCall("afterRemoteRegionDeparture", (CacheEvent)event);
        EventBB.incrementCounter("EventBB.actualRegionDepartedEvents", EventBB.actualRegionDepartedEvents);
    }

    public void afterRemoteRegionCrash(RegionEvent event) {
        this.logCall("afterRemoteRegionCrash", (CacheEvent)event);
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

