/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import event.EventBB;
import event.EventTest;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.CacheUtil;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.OperationCountersBB;
import util.TestHelper;
import util.WriterCountersBB;

public class SerialEntryEventTest
extends EventTest {
    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startLocatorAndAdminDSTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new SerialEntryEventTest();
            eventTest.initialize();
            EventCountersBB.getBB().zeroAllCounters();
            OperationCountersBB.getBB().zeroAllCounters();
        }
    }

    public static synchronized void HydraTask_endTask() {
        eventTest = new SerialEntryEventTest();
        eventTest.initialize();
        ((SerialEntryEventTest)eventTest).checkEventCounters(false);
    }

    @Override
    protected int getNumVMsWithListeners() {
        boolean allEvents;
        RegionAttributes ra = CacheUtil.getRegion(this.regionName).getAttributes();
        DataPolicy dataPolicy = ra.getDataPolicy();
        InterestPolicy interestPolicy = ra.getSubscriptionAttributes().getInterestPolicy();
        boolean bl = allEvents = dataPolicy.withReplication() || interestPolicy.isAll();
        if (allEvents) {
            int numVMs = TestHelper.getNumVMs();
            boolean masterManagedLocator = TestConfig.tab().booleanAt(Prms.manageLocatorAgents);
            return masterManagedLocator ? numVMs : numVMs - 1;
        }
        return 1;
    }

    @Override
    protected void addObject(Region aRegion, boolean aBoolean) {
        super.addObject(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        super.invalidateObject(aRegion, isLocalInvalidate);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        super.destroyObject(aRegion, isLocalDestroy);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void updateObject(Region aRegion) {
        super.updateObject(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean aBoolean) {
        super.putIfAbsent(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void replace(Region aRegion) {
        super.replace(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void remove(Region aRegion) {
        super.remove(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void checkEventCounters() {
        boolean allEvents;
        boolean eventCountExact = false;
        RegionAttributes ra = CacheUtil.getRegion(this.regionName).getAttributes();
        DataPolicy dataPolicy = ra.getDataPolicy();
        InterestPolicy interestPolicy = ra.getSubscriptionAttributes().getInterestPolicy();
        boolean bl = allEvents = dataPolicy.withReplication() || interestPolicy.isAll();
        if (allEvents) {
            eventCountExact = true;
        }
        String dpString = eventCountExact ? "exact" : "an established minimum";
        Log.getLogWriter().info("checkEventCounters will validate that counters are " + dpString + " based on dataPolicy " + dataPolicy + " and interestPolicy " + interestPolicy);
        this.checkEventCounters(eventCountExact);
    }

    protected void checkEventCounters(boolean eventCountExact) {
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInval = counters.read(EventBB.NUM_INVALIDATE);
        long numRegionCreate = counters.read(EventBB.NUM_REGION_CREATE);
        long numRegionDestroy = counters.read(EventBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(EventBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(EventBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(EventBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(EventBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(EventBB.NUM_LOCAL_REGION_INVALIDATE);
        long numClose = counters.read(EventBB.NUM_CLOSE);
        int numVmsWithList = this.getNumVMsWithListeners();
        Log.getLogWriter().info("num VMs InterestALL with listener installed: " + numVmsWithList);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", numCreate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", numCreate * (long)(numVmsWithList - 1), eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotRemote", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", numCreate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", numCreate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", numCreate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", numCreate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", numDestroy * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", numDestroy * (long)(numVmsWithList - 1), eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotRemote", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", numDestroy * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", numDestroy * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", numDestroy * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", numDestroy * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", numInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", numInval * (long)(numVmsWithList - 1), eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotRemote", numInval, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", numInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", numInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", numInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", numInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", numUpdate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", numUpdate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", numUpdate * (long)(numVmsWithList - 1), eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotRemote", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", numUpdate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", numUpdate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", numUpdate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", numUpdate * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", numRegionInval * (long)numVmsWithList, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", numLocalRegionInval, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", numRegionInval * (long)numVmsWithList + numLocalRegionInval, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", numRegionInval * (long)(numVmsWithList - 1), eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotRemote", numRegionInval + numLocalRegionInval, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numClose", numClose, eventCountExact));
        EventCountersBB.getBB().checkEventCounters(al);
        OperationCountersBB.getBB().checkEventCounters(al);
        al = new ArrayList();
        al.add(new ExpCounterValue("numBeforeCreateEvents_isDist", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotExp", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isRemote", "numBeforeCreateEvents_isNotRemote", numCreate));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLoad", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotLocalLoad", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetLoad", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeCreateEvents_isNotNetSearch", numCreate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isDist", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotExp", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isRemote", "numBeforeDestroyEvents_isNotRemote", numDestroy));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLoad", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotLocalLoad", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetLoad", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeDestroyEvents_isNotNetSearch", numDestroy, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isDist", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotExp", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isRemote", "numBeforeUpdateEvents_isNotRemote", numUpdate));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLoad", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isLocalLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotLocalLoad", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetLoad", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetLoad", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNetSearch", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeUpdateEvents_isNotNetSearch", numUpdate, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionDestroyEvents_isNotRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionClearEvents_isDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionClearEvents_isNotDist", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionClearEvents_isExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionClearEvents_isNotExp", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionClearEvents_isRemote", 0L, eventCountExact));
        al.add(new ExpCounterValue("numBeforeRegionClearEvents_isNotRemote", 0L, eventCountExact));
        WriterCountersBB.getBB().checkEventCounters(al);
    }
}

