/*
 * Decompiled with CFR 0.152.
 */
package event;

import event.EventBB;
import event.EventTest;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.OperationCountersBB;
import util.TestException;

public class SerialRegionEventTest
extends EventTest {
    boolean inEndTask = false;

    public static synchronized void HydraTask_initialize() {
        if (eventTest == null) {
            eventTest = new SerialRegionEventTest();
            eventTest.initialize();
            EventCountersBB.getBB().zeroAllCounters();
            OperationCountersBB.getBB().zeroAllCounters();
        }
    }

    public static void HydraTask_endTask() throws Throwable {
        ((SerialRegionEventTest)SerialRegionEventTest.eventTest).inEndTask = true;
        eventTest.checkEventCounters();
    }

    @Override
    protected int getNumVMsWithListeners() {
        return 1;
    }

    @Override
    protected void addRegion() {
        super.addRegion();
        this.checkEventCounters();
    }

    @Override
    protected int invalidateRegion(boolean isLocalInvalidate) {
        int numInval = super.invalidateRegion(isLocalInvalidate);
        this.checkEventCounters();
        return numInval;
    }

    @Override
    protected int destroyRegion(boolean isLocalDestroy) {
        int numDestroy = super.destroyRegion(isLocalDestroy);
        this.checkEventCounters();
        return numDestroy;
    }

    @Override
    protected void checkEventCounters() {
        SharedCounters counters = EventBB.getBB().getSharedCounters();
        long numCreate = counters.read(EventBB.NUM_CREATE);
        long numUpdate = counters.read(EventBB.NUM_UPDATE);
        long numDestroy = counters.read(EventBB.NUM_DESTROY);
        long numInval = counters.read(EventBB.NUM_INVALIDATE);
        long numRegionCreate = counters.read(EventBB.NUM_REGION_CREATE);
        long numRegionDestroy = counters.read(EventBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(EventBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(EventBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(EventBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(EventBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(EventBB.NUM_LOCAL_REGION_INVALIDATE);
        long totalRegDestroys = numLocalRegionDestroy + numRegionDestroy;
        long totalRegInval = numLocalRegionInval + numRegionInval;
        long numClose = counters.read(EventBB.NUM_CLOSE);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isDist", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isRemote", "numAfterCreateEvents_isNotRemote", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLoad", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotLocalLoad", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetLoad", numCreate));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotNetSearch", numCreate));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isDist", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isRemote", "numAfterDestroyEvents_isNotRemote", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLoad", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotLocalLoad", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetLoad", numDestroy));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterDestroyEvents_isNotNetSearch", numDestroy));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isDist", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isRemote", "numAfterInvalidateEvents_isNotRemote", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLoad", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotLocalLoad", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetLoad", numInval));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotNetSearch", numInval));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isDist", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotDist", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isRemote", "numAfterUpdateEvents_isNotRemote", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLoad", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isLocalLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotLocalLoad", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetLoad", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetLoad", numUpdate));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNetSearch", 0L));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotNetSearch", numUpdate));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isDist", numRegionDestroy));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotDist", numLocalRegionDestroy));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", numRegionDestroy + numLocalRegionDestroy));
        al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isRemote", "numAfterRegionDestroyEvents_isNotRemote", numRegionDestroy + numLocalRegionDestroy));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isDist", numRegionInval));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotDist", numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotExp", numRegionInval + numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isRemote", "numAfterRegionInvalidateEvents_isNotRemote", numRegionInval + numLocalRegionInval));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isDist", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotDist", numRegionCreate));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isExp", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotExp", numRegionCreate));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isRemote", 0L));
        al.add(new ExpCounterValue("numAfterRegionCreateEvents_isNotRemote", numRegionCreate));
        if (this.inEndTask) {
            long[] counterValue = new long[]{EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numClose), OperationCountersBB.getBB().getSharedCounters().read(OperationCountersBB.numClose)};
            if (numClose > counterValue[0] || numClose > counterValue[1]) {
                throw new TestException("Expected EventCountersBB.numClose " + counterValue + " to be > " + numClose);
            }
        } else {
            al.add(new ExpCounterValue("numClose", numClose));
        }
        EventCountersBB.getBB().checkEventCounters(al);
        OperationCountersBB.getBB().checkEventCounters(al);
    }
}

