/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.util.GatewayEvent;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import event.EventBB;
import event.WBCLEventBB;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.List;
import java.util.Properties;
import util.TestException;
import util.TestHelper;

public class WBCLEventListener
implements GatewayEventListener,
Declarable {
    public int whereIWasRegistered = ProcessMgr.getProcessId();

    public boolean processEvents(List events) {
        boolean status = false;
        if (TestConfig.tab().getRandGen().nextInt(1, 100) < 90) {
            for (GatewayEvent event : events) {
                try {
                    this.logCall("processEvents", event);
                }
                catch (Exception e) {
                    this.throwException("Caught unexpected Exception " + e + ", " + TestHelper.getStackTrace(e));
                }
                Operation op = event.getOperation();
                try {
                    Operation operation;
                    if (op.isCreate()) {
                        WBCLEventBB.getBB().getSharedCounters().incrementAndRead(WBCLEventBB.NUM_CREATES);
                        operation = op.getCorrespondingCreateOp();
                        continue;
                    }
                    if (op.isUpdate()) {
                        WBCLEventBB.getBB().getSharedCounters().incrementAndRead(WBCLEventBB.NUM_UPDATES);
                        operation = op.getCorrespondingUpdateOp();
                        continue;
                    }
                    if (op.isInvalidate()) {
                        WBCLEventBB.getBB().getSharedCounters().incrementAndRead(WBCLEventBB.NUM_INVALIDATES);
                        this.throwException("Unexpected INVALIDATE encounted in WBCLEventListener " + op.toString() + ", " + TestHelper.getStackTrace());
                        continue;
                    }
                    if (!op.isDestroy()) continue;
                    WBCLEventBB.getBB().getSharedCounters().incrementAndRead(WBCLEventBB.NUM_DESTROYS);
                }
                catch (Exception e) {
                    this.throwException("Caught unexpected Exception " + e + ", " + TestHelper.getStackTrace(e));
                }
            }
            status = true;
        }
        if (status) {
            Log.getLogWriter().info("WBCLEventListener processed batch of " + events.size() + " events, returning " + status);
        } else {
            Log.getLogWriter().info("WBCLEventListener DID NOT process batch of " + events.size() + " events, returning " + status);
        }
        return status;
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }

    public void close() {
        this.logCall("close", null);
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public String logCall(String methodName, GatewayEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
        return aStr;
    }

    public String toString(String methodName, GatewayEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + this.getClass().getName() + ": " + methodName + " in " + RemoteTestModule.getMyClientName() + "\n");
        aStr.append("   whereIWasRegistered: " + this.whereIWasRegistered + "\n");
        if (event == null) {
            return aStr.toString();
        }
        Operation op = event.getOperation();
        aStr.append("   Operation: " + op.toString() + "\n");
        if (op.isCreate()) {
            aStr.append("      Operation.getCorrespondingCreateOp(): " + op.getCorrespondingCreateOp().toString() + "\n");
        } else if (op.isUpdate()) {
            aStr.append("      Operation.getCorrespondingUpdate(Op): " + op.getCorrespondingUpdateOp().toString() + "\n");
        }
        aStr.append("      Operation.guaranteesOldValue(): " + op.guaranteesOldValue() + "\n");
        aStr.append("      Operation.isEntry(): " + op.isEntry() + "\n");
        aStr.append("      Operation.isPutAll(): " + op.isPutAll() + "\n");
        aStr.append("      Operation.isDistributed(): " + op.isDistributed() + "\n");
        aStr.append("      Operation.isLoad(): " + op.isLoad() + "\n");
        aStr.append("      Operation.isLocal(): " + op.isLocal() + "\n");
        aStr.append("      Operation.isLocalLoad(): " + op.isLocalLoad() + "\n");
        aStr.append("      Operation.isNetLoad(): " + op.isNetLoad() + "\n");
        aStr.append("      Operation.isNetSearch(): " + op.isNetSearch() + "\n");
        aStr.append("      Operation.isSearchOrLoad(): " + op.isSearchOrLoad() + "\n");
        aStr.append("   event.getCallbackArgument(): " + TestHelper.toString(event.getCallbackArgument()) + "\n");
        aStr.append("   event.getRegion(): " + TestHelper.regionToString(event.getRegion(), false) + "\n");
        aStr.append("   event.getKey(): " + event.getKey() + "\n");
        aStr.append("   event.getDeserializedValue(): " + event.getDeserializedValue() + "\n");
        aStr.append("   event.getSerializedValue(): " + event.getSerializedValue() + "\n");
        return aStr.toString();
    }
}

