/*
 * Decompiled with CFR 0.152.
 */
package examples.dist;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheListener;
import examples.dist.FlashListener;
import examples.dist.FlashcacheBB;
import examples.dist.FlashcachePrms;
import flashcache.Quote;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import util.CacheUtil;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;

public class Flashcache {
    private static Quote quoteInstance = null;

    public static synchronized void HydraTask_initTask() {
        if (quoteInstance == null) {
            quoteInstance = new Quote();
            try {
                quoteInstance.initializeCache(CacheUtil.createCache(), (CacheListener)new FlashListener());
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    public static void HydraTask_quoteTask() {
        long numInvalidates = EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.numAfterInvalidateEvents_isExp);
        String symbol = TestConfig.tab().stringAt(FlashcachePrms.symbol);
        String quote = null;
        try {
            quote = quoteInstance.getQuote(symbol);
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Log.getLogWriter().info("Quote for " + symbol + ": " + quote);
        Flashcache.validateQuote(symbol, quote);
        FlashcacheBB.getBB().getSharedCounters().increment(FlashcacheBB.NUM_GET_QUOTE);
        String hitQuote = null;
        try {
            hitQuote = quoteInstance.getQuote(symbol);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (!quote.equals(hitQuote)) {
            throw new TestException("Expected first getQuote " + quote + " to be equal to second getQuote " + hitQuote);
        }
        long expectedNumInvalidates = numInvalidates + 1L;
        TestHelper.waitForCounter(EventCountersBB.getBB(), "EventCountersBB.numAfterInvalidateEvents_isExp", EventCountersBB.numAfterInvalidateEvents_isExp, expectedNumInvalidates, true, 60000L, 2000L);
        String missQuote = null;
        try {
            missQuote = quoteInstance.getQuote(symbol);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Flashcache.validateQuote(symbol, missQuote);
        TestHelper.waitForCounter(EventCountersBB.getBB(), "EventCountersBB.numAfterInvalidateEvents_isExp", EventCountersBB.numAfterInvalidateEvents_isExp, ++expectedNumInvalidates, true, 60000L, 2000L);
    }

    public static void HydraTask_mainQuoteTask() throws IOException {
        int NUM_QUOTES = 5;
        String inputFileName = "mainInput.txt";
        String inputStr = "";
        ArrayList<String> inputStrList = new ArrayList<String>();
        for (int i = 1; i <= 5; ++i) {
            String symbol = TestConfig.tab().stringAt(FlashcachePrms.symbol);
            inputStr = inputStr + symbol;
            inputStr = inputStr + "\n";
            inputStrList.add(symbol);
        }
        inputStr = inputStr + "\n";
        File aFile = new File(inputFileName);
        FileWriter fileWriter = new FileWriter(aFile);
        fileWriter.write(inputStr);
        fileWriter.close();
        Log.getLogWriter().info("Input to main is " + inputStr);
        String classpath = System.getProperty("gemfire.home") + File.separator + "examples" + File.separator + "dist" + File.separator + "classes" + System.getProperty("path.separator") + System.getProperty("java.class.path");
        ArrayList<String> cmd = new ArrayList<String>();
        if (System.getProperty("os.name").indexOf("Windows") == -1) {
            cmd.add("bash");
            cmd.add("--norc");
            cmd.add("-c");
        } else {
            cmd.add("cmd");
            cmd.add("/c");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(System.getProperty("java.home")).append(File.separator).append("bin").append(File.separator).append("java");
        buf.append(" -Xms256m -Xmx256m");
        buf.append(" -classpath ").append(classpath);
        buf.append(" flashcache.Quote");
        buf.append(" < mainInput.txt > mainOutput.txt");
        cmd.add(buf.toString());
        String[] cmdStrings = cmd.toArray(new String[0]);
        Log.getLogWriter().info("cmd is " + buf.toString());
        int maxWaitSec = TestConfig.tab().intAt(Prms.maxResultWaitSec) - 10;
        String output = ProcessMgr.fgexec(cmdStrings, maxWaitSec);
        Log.getLogWriter().info("output is " + output);
        if (output.contains("xception") || output.contains("timed out")) {
            throw new TestException("While trying to get quote, got " + output);
        }
        String outputFileName = "mainOutput.txt";
        FileReader reader = new FileReader(outputFileName);
        BufferedReader bReader = new BufferedReader(reader);
        String line = bReader.readLine();
        if (line == null) {
            throw new TestException("No output from running " + cmd);
        }
        String total = "";
        ArrayList<String> outputStrList = new ArrayList<String>();
        while (line != null) {
            total = total + line;
            outputStrList.add(line);
            line = bReader.readLine();
        }
        Log.getLogWriter().info("Total output *" + total + "*");
        Flashcache.validateQuotes(inputStrList, outputStrList);
    }

    private static void validateQuote(String symbol, String quote) {
        ArrayList<String> symbolList = new ArrayList<String>();
        symbolList.add(symbol);
        ArrayList<String> quoteList = new ArrayList<String>();
        quoteList.add(quote);
        Flashcache.validateQuotes(symbolList, quoteList);
    }

    private static void validateQuotes(List inputStrList, List outputStrList) {
        int outputStrListSize = outputStrList.size();
        String outputLine1 = "(QuoteLoader netSearching for ";
        String outputLine2 = "(QuoteLoader querying nasdaq for ";
        String regExForOutputLine3 = "last sale=([0-9]+)((\\.)([0-9]+))?  net change=(((-|\\+)([0-9]+)((\\.)([0-9]+))?)|unch)  volume=([0-9]{1,3})((,([0-9]{3}))*)";
        String enter1 = "Enter symbol: ";
        String enter2 = "Enter next symbol: ";
        StringBuffer inputSB = new StringBuffer();
        inputSB.append("Input:");
        for (int i = 0; i < inputStrList.size(); ++i) {
            inputSB.append("\n   " + inputStrList.get(i));
        }
        StringBuffer outputSB = new StringBuffer();
        outputSB.append("Output:");
        for (int i = 0; i < outputStrList.size(); ++i) {
            outputSB.append("\n   " + outputStrList.get(i));
        }
        int outputListIndex = 0;
        for (int i = 0; i < inputStrList.size(); ++i) {
            String symbol = (String)inputStrList.get(i);
            String regEx = symbol + ": " + "last sale=([0-9]+)((\\.)([0-9]+))?  net change=(((-|\\+)([0-9]+)((\\.)([0-9]+))?)|unch)  volume=([0-9]{1,3})((,([0-9]{3}))*)";
            if (outputListIndex >= outputStrListSize) {
                throw new TestException("No output for symbol " + symbol + " see files mainInput.txt and mainOutput.txt");
            }
            String outputLine = (String)outputStrList.get(outputListIndex);
            ++outputListIndex;
            if (outputLine == null) {
                throw new TestException("Quote returned null for stock symbol " + symbol + "; probably timed out waiting for nasdaq to respond, see bg*.log files to verify");
            }
            if (outputLine.startsWith("Enter symbol: ")) {
                outputLine = outputLine.substring("Enter symbol: ".length(), outputLine.length());
            } else if (outputLine.startsWith("Enter next symbol: ")) {
                outputLine = outputLine.substring("Enter next symbol: ".length(), outputLine.length());
            }
            if (outputLine.matches(regEx)) continue;
            String expectedStr = "(QuoteLoader netSearching for " + symbol + ")";
            if (!outputLine.equals(expectedStr)) {
                throw new TestException("Unexpected 1st output line \"" + outputLine + "\" for stock symbol " + symbol + ", expected \"" + expectedStr + "\"" + "\n" + inputSB.toString() + "\n" + outputSB.toString());
            }
            if (outputListIndex >= outputStrListSize) {
                throw new TestException("No 2nd output line for symbol " + symbol + "\n" + inputSB.toString() + "\n" + outputSB.toString());
            }
            if ((outputLine = (String)outputStrList.get(outputListIndex++)).matches(regEx)) continue;
            expectedStr = "(QuoteLoader querying nasdaq for " + symbol + ")";
            if (!outputLine.equals(expectedStr)) {
                throw new TestException("Unexpected 2nd output line \"" + outputLine + "\" for stock symbol " + symbol + ", expected \"" + expectedStr + "\"" + "\n" + inputSB.toString() + "\n" + outputSB.toString());
            }
            if (outputListIndex >= outputStrListSize) {
                throw new TestException("No 3rd output line for symbol " + symbol + " see files mainInput.txt and mainOutput.txt");
            }
            if ((outputLine = (String)outputStrList.get(outputListIndex++)).matches(regEx)) continue;
            throw new TestException("Unexpected 3rd output line \"" + outputLine + "\" for stock symbol " + symbol + "; does not match the regular expression " + regEx + "\n" + inputSB.toString() + "\n" + outputSB.toString());
        }
    }

    public static void HydraTask_endTask() {
        FlashcacheBB.getBB().printSharedCounters();
        EventCountersBB.getBB().printSharedCounters();
    }
}

