/*
 * Decompiled with CFR 0.152.
 */
package expiration;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.ExpirationAttributes;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import expiration.ExpirPrms;
import hydra.GsRandom;
import hydra.TestConfig;
import java.util.Random;
import util.CacheUtil;
import util.TxHelper;

public class TestBug30828 {
    private static Region region;

    public static synchronized void createRegion() throws Exception {
        if (region != null) {
            return;
        }
        Cache cache = CacheUtil.createCache();
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(Scope.DISTRIBUTED_NO_ACK);
        factory.setMirrorType(MirrorType.KEYS_VALUES);
        factory.setCacheLoader(new CacheLoader(){

            public Object load(LoaderHelper helper) {
                return String.valueOf(helper.getKey());
            }

            public void close() {
            }
        });
        factory.setStatisticsEnabled(true);
        ExpirationAttributes expire = new ExpirationAttributes(300, ExpirationAction.INVALIDATE);
        factory.setEntryTimeToLive(expire);
        region = cache.createVMRegion("TestRegion", factory.createRegionAttributes());
    }

    public static void doGets() throws Exception {
        GsRandom random = TestConfig.tab().getRandGen();
        for (int i = 0; i < 1000; ++i) {
            if (TestConfig.tab().booleanAt(ExpirPrms.useTransactions, false)) {
                TxHelper.begin();
            }
            region.get((Object)new Integer(((Random)random).nextInt(1000)));
            if (!TxHelper.exists()) continue;
            try {
                TxHelper.commit();
                continue;
            }
            catch (ConflictException conflictException) {
                // empty catch block
            }
        }
    }
}

