/*
 * Decompiled with CFR 0.152.
 */
package getInitialImage;

import cacheperf.CachePerfClient;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.SerialAckedMessage;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import distcache.gemfire.GemFireCacheTestImpl;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.DistributedSystemHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import java.util.List;
import objects.ObjectHelper;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;
import util.TestException;
import util.TestHelper;

public class InitImageClient
extends CachePerfClient {
    public static void closeCacheTask() {
        InitImageClient c = new InitImageClient();
        c.initHydraThreadLocals();
        c.closeCache();
        c.updateHydraThreadLocals();
    }

    @Override
    protected void closeCache() {
        boolean waitForGetInitialImageStart = InitImagePrms.waitForGetInitialImageStart();
        if (waitForGetInitialImageStart) {
            InitImageClient.log().info("closeCache: checking getInitialImage status before closing cache");
            while (InitImageBB.getBB().getSharedCounters().read(InitImageBB.getInitialImageInProgress) == 0L) {
                InitImageClient.log().fine("closeCache: waiting for getInitialImageInProgress before closing cache");
                MasterController.sleepForMs(200);
            }
        }
        super.closeCache();
        this.cacheClosedSignal();
    }

    private void cacheClosedSignal() {
        InitImageBB.getBB().getSharedCounters().increment(InitImageBB.cacheClosedSignal);
    }

    public static void waitForGetInitialImageInProgress() {
        InitImageClient c = new InitImageClient();
        c._waitForGetInitialImageInProgress();
    }

    private void _waitForGetInitialImageInProgress() {
        InitImageClient.log().info("waitForGetInitialImageInProgress: checking getInitialImage status before proceeding");
        while (InitImageBB.getBB().getSharedCounters().read(InitImageBB.getInitialImageInProgress) == 0L) {
            InitImageClient.log().fine("waitForGetInitialImageInProgress: waiting for getInitialImageInProgress before proceeding ...");
            MasterController.sleepForMs(200);
        }
        InitImageClient.log().info("GetInitialImage is IN PROGRESS");
    }

    public static void destroyDataTask() {
        InitImageClient c = new InitImageClient();
        c.initialize(7);
        c.destroyData();
    }

    @Override
    protected void destroy(int i) {
        Object key;
        Object val;
        super.destroy(i);
        boolean validateDestroyed = InitImagePrms.validateDestroyed();
        if (validateDestroyed && (val = this.cache.get(key = ObjectHelper.createName(this.keyType, i))) != null) {
            throw new HydraRuntimeException("Expected get to return null for " + key + ", but got " + val);
        }
    }

    public static void monitorGetInitialImage() {
        InitImageClient c = new InitImageClient();
        c.initHydraThreadLocals();
        c._monitorGetInitialImage();
        c.updateHydraThreadLocals();
    }

    private void _monitorGetInitialImage() {
        InitImageClient.log().info("monitorGetInitialImage: checking for getInitialImageInProgress");
        while (TestHelper.getStat_getInitialImagesInProgress("DefaultRegion") == 0) {
            InitImageClient.log().fine("monitorGetInitialImage: waiting for getInitialImage to complete ...");
            MasterController.sleepForMs(200);
        }
        InitImageBB.getBB().getSharedCounters().increment(InitImageBB.getInitialImageInProgress);
        InitImageClient.log().info("monitorGetInitialImage: checking for getInitialImageCompleted");
        while (TestHelper.getStat_getInitialImagesCompleted("DefaultRegion") == 0) {
            InitImageClient.log().fine("monitorGetInitialImage: waiting for getInitialImage to complete ...");
            MasterController.sleepForMs(200);
        }
        InitImageBB.getBB().getSharedCounters().increment(InitImageBB.getInitialImageComplete);
    }

    public static void sendSerialMessageToAllTask() {
        InitImageClient c = new InitImageClient();
        c.initialize();
        c.sendSerialMessageToAll();
    }

    private void sendSerialMessageToAll() {
        if (this.cache instanceof GemFireCacheTestImpl) {
            try {
                SerialAckedMessage msg = new SerialAckedMessage();
                Region r = ((GemFireCacheTestImpl)this.cache).getRegion();
                boolean mcast = r.getAttributes().getMulticastEnabled();
                msg.send(DistributedSystemHelper.getMembers(), mcast);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to send serial message due to exception", e);
            }
        }
    }

    public static void verifyOpsNotBlocked() {
        String statName = InitImagePrms.opStatName();
        int minOps = InitImagePrms.getMinOps();
        String spec = "* cacheperf.CachePerfStats * " + statName + " " + "filter=none combine=combineAcrossArchives ops=max-min trimspec=cacheOpens";
        InitImageClient.log().info("statspec = " + spec);
        List psvs = PerfStatMgr.getInstance().readStatistics(spec);
        if (psvs == null) {
            InitImageClient.log().info("There was no statistic for " + statName);
        } else {
            PerfStatValue psv = (PerfStatValue)psvs.get(0);
            int max = (int)psv.getMaxMinusMin();
            if (max < minOps) {
                throw new HydraRuntimeException(max + " " + statName + " operations occurred during openCache, expected a minimum of " + minOps);
            }
            InitImageClient.log().info(statName + ": " + max + " (minAcceptable = " + minOps + ")");
        }
    }

    public static void verifyGII() {
        InitImageClient iic = new InitImageClient();
        iic.initialize();
        Region region = ((GemFireCacheTestImpl)iic.getCache()).getRegion();
        iic.verifyGII(region);
    }

    private void verifyGII(Region aRegion) {
        boolean expectDeltaGII = InitImagePrms.expectDeltaGII();
        StringBuffer aStr = new StringBuffer("verifyGII invoked with expectDeltaGII = " + expectDeltaGII + ". ");
        String regionName = aRegion.getName();
        DiskRegion diskRegion = ((LocalRegion)aRegion).getDiskRegion();
        if (diskRegion != null && diskRegion.getStats().getRemoteInitializations() == 0) {
            aStr.append(regionName + " was recovered from disk (Remote Initializations = " + diskRegion.getStats().getRemoteInitializations() + ").");
        } else {
            int giisCompleted = TestHelper.getStat_getInitialImagesCompleted(regionName);
            int deltaGiisCompleted = TestHelper.getStat_deltaGetInitialImagesCompleted(regionName);
            if (expectDeltaGII && deltaGiisCompleted < 1 || !expectDeltaGII && (giisCompleted < 1 || deltaGiisCompleted > 0)) {
                throw new TestException("Did not perform expected type of GII. expectDeltaGII = " + expectDeltaGII + aRegion.getFullPath() + " GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted);
            }
            aStr.append(regionName + " Remote Initialization (GII): GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted + ".");
        }
        Log.getLogWriter().info(aStr.toString());
    }
}

