/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import getInitialImage.InitImagePrms;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractListener;
import util.EventCountersBB;
import util.TestException;
import util.TestHelper;

public class NoInterestListener
extends AbstractListener
implements CacheListener,
Declarable {
    private boolean isCarefulValidation;
    private boolean useTransactions;

    public NoInterestListener() {
        TestConfig config = TestConfig.getInstance();
        ConfigHashtable tab = config.getParameters();
        this.isCarefulValidation = tab.booleanAt(Prms.serialExecution);
        this.useTransactions = InitImagePrms.useTransactions();
    }

    public NoInterestListener(boolean isCarefulValidation) {
        this.isCarefulValidation = isCarefulValidation;
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        if (event.isOriginRemote()) {
            this.throwException("Received event " + event.toString() + " but we have not registered an interest in any keys ");
        }
        this.incrementAfterCreateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        if (event.isOriginRemote()) {
            this.throwException("Received event " + event.toString() + " but we have not registered an interest in any keys ");
        }
        this.incrementAfterDestroyCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Destroy event originated in pid ");
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        if (event.isOriginRemote()) {
            this.throwException("Received event " + event.toString() + " but we have not registered an interest in any keys ");
        }
        this.incrementAfterInvalidateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Invalidate event originated in pid ");
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        if (event.isOriginRemote()) {
            this.throwException("Received event " + event.toString() + " but we have not registered an interest in any keys ");
        }
        this.incrementAfterUpdateCounters(event, (Blackboard)EventCountersBB.getBB());
        this.checkVM();
        this.checkCallback((CacheEvent)event, "Update event originated in pid ");
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
        this.checkVM();
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
        this.checkVM();
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
        this.checkVM();
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void close() {
        this.logCall("close", null);
        EventCountersBB.getBB().getSharedCounters().increment(EventCountersBB.numClose);
        this.checkVM();
    }

    protected void checkVM() {
        int myPID = ProcessMgr.getProcessId();
        if (this.whereIWasRegistered != myPID) {
            String errStr = "Expected event to be invoked in VM " + this.whereIWasRegistered + ", but it was invoked in " + myPID + ": " + this.toString() + "; see system.log for call stack";
            this.throwException(errStr);
        }
    }

    protected void checkCallback(CacheEvent event, String expectedCallbackPrefix) {
        String callbackObj = (String)event.getCallbackArgument();
        if (callbackObj == null) {
            return;
        }
        if (this.useTransactions) {
            return;
        }
        if (this.isCarefulValidation) {
            String errStr;
            if (callbackObj == null) {
                errStr = "Callback object is " + TestHelper.toString(callbackObj);
                this.throwException(errStr);
            }
            if (!callbackObj.startsWith(expectedCallbackPrefix)) {
                errStr = "Expected " + expectedCallbackPrefix + ", but callback object is " + TestHelper.toString(callbackObj);
                this.throwException(errStr);
            }
        }
        if (callbackObj != null) {
            int myPID = ProcessMgr.getProcessId();
            String tmpCallbackObj = callbackObj + " ";
            boolean eventProducedInThisVM = tmpCallbackObj.indexOf("pid " + myPID + " ") >= 0;
            boolean isRemote = event.isOriginRemote();
            if (isRemote == eventProducedInThisVM) {
                String errStr = "Unexpected event.isOriginRemote() = " + isRemote + ", myPID = " + myPID + ", callbackObj showing origination VM = " + callbackObj;
                this.throwException(errStr);
            }
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventCountersBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

