/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import cq.CQUtilPrms;
import hct.BridgeNotify;
import hct.BridgeNotifyBB;
import hct.BridgeNotifyPrms;
import hct.EventListener;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.Log;
import hydra.MasterController;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import parReg.query.NewPortfolio;
import util.EventCountersBB;
import util.ExpCounterValue;
import util.NameFactory;
import util.OperationCountersBB;
import util.PRObserver;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;

public class PutAllBridgeNotify
extends BridgeNotify {
    protected static PutAllBridgeNotify putAllBridgeNotify;
    protected static Random rnd;
    protected static long maxNames;

    public static synchronized void HydraTask_initialize() {
        if (bridgeClient == null) {
            bridgeClient = new PutAllBridgeNotify();
            bridgeClient.initialize();
            OperationCountersBB.getBB().zeroAllCounters();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        maxNames = TestConfig.tab().longAt(BridgeNotifyPrms.numKeys, 50000L);
        Log.getLogWriter().info("Max number of keys in the test is " + maxNames);
        Region aRegion = RegionHelper.getRegion("myRegion");
        CacheListener[] assignedListeners = aRegion.getAttributes().getCacheListeners();
        CacheListener myListener = BridgeNotifyPrms.getClientListener();
        if (myListener != null) {
            for (int i = 0; i < assignedListeners.length; ++i) {
                if (!(assignedListeners[i] instanceof EventListener)) continue;
                aRegion.getAttributesMutator().removeCacheListener(assignedListeners[i]);
            }
        }
    }

    public static void HydraTask_verifyPutAllCounters() {
        SilenceListener.waitForSilence(30L, 1000L);
        bridgeClient.checkEventCounters();
    }

    protected int getSizeForPutAll() {
        if (this.useTransactions) {
            return 1;
        }
        int minQty = TestConfig.tab().intAt(CQUtilPrms.minPutAllSize, 100);
        int maxQty = TestConfig.tab().intAt(CQUtilPrms.maxPutAllSize, 300);
        return rnd.nextInt(maxQty - minQty) + minQty;
    }

    public static void HydraTask_doEntryOperations() {
        Region rootRegion = CacheHelper.getCache().getRegion("myRegion");
        bridgeClient.doEntryOperations(rootRegion);
    }

    @Override
    protected Object getUpdateObject(String name) {
        return this.getObjectToAdd(name);
    }

    @Override
    protected Object getObjectToAdd(String name) {
        NewPortfolio anObject = new NewPortfolio(name, (int)NameFactory.getCounterForName(name));
        return anObject;
    }

    @Override
    protected void addObject(Region aRegion, String name, boolean logAddition) {
        List singleKeyList;
        Object anObj = this.getObjectToAdd(name);
        String callback = "Create event originated in pid " + ProcessMgr.getProcessId();
        if (logAddition) {
            Log.getLogWriter().info("addObject: calling put for name " + name + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.put((Object)name, anObj, (Object)callback);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedCounters().add(BridgeNotifyBB.EXPECTED_CREATE, numExpectedEvents);
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        List singleKeyList;
        String name = NameFactory.getNextPositiveObjectName();
        Object anObj = this.getObjectToAdd(name);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for name " + name + ", object " + TestHelper.toString(anObj));
        }
        try {
            aRegion.putIfAbsent((Object)name, anObj);
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedCounters().add(BridgeNotifyBB.EXPECTED_CREATE, numExpectedEvents);
    }

    @Override
    protected void addObjectViaPutAll(Region aRegion, boolean logAddition) {
        int sizeForPutAll = this.getSizeForPutAll();
        this.addObjectViaPutAll(aRegion, sizeForPutAll, logAddition);
    }

    protected void addObjectViaPutAll(Region aRegion, int sizeForPutAll, boolean logAddition) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = null;
        for (int i = 0; i < sizeForPutAll; ++i) {
            name = NameFactory.getNextPositiveObjectName();
            Object anObj = this.getObjectToAdd(name);
            map.put(name, anObj);
            if (!logAddition) continue;
            Log.getLogWriter().info("addObjectViaPutAll: put in putAll map for name " + name + ", " + "object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
        }
        try {
            aRegion.putAll(map);
            Log.getLogWriter().info("PutAllCreate: put into region " + aRegion.getFullPath() + " with mapSize " + map.size());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        BridgeNotifyBB.add("BridgeNotifyBB.NUM_PUTALL_CREATE", BridgeNotifyBB.NUM_PUTALL_CREATE, sizeForPutAll);
        int numExpectedEvents = map.size();
        List singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED);
        for (String key : map.keySet()) {
            if (this.originalKeyList.contains(key)) {
                ++numExpectedEvents;
            }
            if (!singleKeyList.contains(key)) continue;
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedCounters().add(BridgeNotifyBB.EXPECTED_CREATE, numExpectedEvents);
    }

    @Override
    protected void updateObject(Region aRegion, Object name) {
        List singleKeyList;
        Region.Entry anObj = null;
        anObj = aRegion.getEntry(name);
        if (anObj == null) {
            return;
        }
        Object newObj = this.getUpdateObject((String)name);
        try {
            String callback = "Update event originated in pid " + ProcessMgr.getProcessId();
            Log.getLogWriter().info("updateObject: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj.getValue()) + ", callback is " + callback);
            aRegion.put(name, newObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedCounters().add(BridgeNotifyBB.EXPECTED_UPDATE, numExpectedEvents);
    }

    @Override
    protected void replace(Region aRegion, Object name) {
        List singleKeyList;
        boolean replaced = false;
        Object anObj = null;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        Object newObj = this.getUpdateObject((String)name);
        try {
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + ".");
            Object returnVal = aRegion.replace(name, newObj);
            if (returnVal != null) {
                replaced = true;
            }
            Log.getLogWriter().info("Done with call to replace");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        int numExpectedEvents = 1;
        if (this.originalKeyList.contains(name)) {
            ++numExpectedEvents;
        }
        if ((singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED)).contains(name)) {
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedCounters().add(BridgeNotifyBB.EXPECTED_UPDATE, numExpectedEvents);
    }

    @Override
    protected void updateObjectViaPutAll(Region aRegion) {
        int sizeForPutAll = this.getSizeForPutAll();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String name = null;
        Set aSet = aRegion.keySet();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("updateObject: No names in region");
            return;
        }
        int mapSize = 0;
        Object newObj = null;
        while (iter.hasNext() && mapSize < sizeForPutAll) {
            Object potentialKey = iter.next();
            if (aRegion.getEntry(potentialKey) == null) continue;
            name = (String)potentialKey;
            newObj = this.getUpdateObject(name);
            map.put(name, newObj);
            Log.getLogWriter().info("updateObjectViaPutAll: put in putAll map for name " + name + ", object " + TestHelper.toString(newObj));
            ++mapSize;
        }
        try {
            aRegion.putAll(map);
            Log.getLogWriter().info("Done with call to putall (update) mapSize " + mapSize + " to region " + aRegion.getFullPath());
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        BridgeNotifyBB.add("BridgeNotifyBB.NUM_PUTALL_UPDATE", BridgeNotifyBB.NUM_PUTALL_UPDATE, mapSize);
        int numExpectedEvents = mapSize;
        List singleKeyList = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED);
        for (String key : map.keySet()) {
            if (this.originalKeyList.contains(key)) {
                ++numExpectedEvents;
            }
            if (!singleKeyList.contains(key)) continue;
            ++numExpectedEvents;
        }
        BridgeNotifyBB.getBB().getSharedCounters().add(BridgeNotifyBB.EXPECTED_UPDATE, numExpectedEvents);
    }

    @Override
    protected void checkEventCounters() {
        MasterController.sleepForMs(180000);
        Log.getLogWriter().info("checkOperationCounters will validate that putAll operations are exact");
        try {
            this.checkPutAllCounters(true);
        }
        catch (TestException e1) {
            Log.getLogWriter().info("checkPutAllCounters failed, checkEventCounters will validate that counters are exact");
            try {
                this.checkEventCounters(true);
            }
            catch (TestException e2) {
                Log.getLogWriter().info("checkEventCounters failed.");
                throw new TestException("missing events -- " + TestHelper.getStackTrace(e1) + TestHelper.getStackTrace(e2));
            }
            throw new TestException("missing events -- " + TestHelper.getStackTrace(e1));
        }
        Log.getLogWriter().info("checkEventCounters will validate that counters are exact");
        this.checkEventCounters(true);
    }

    protected void checkEventCounters(boolean eventCountExact) {
        SharedCounters counters = BridgeNotifyBB.getBB().getSharedCounters();
        long expectedCreate = counters.read(BridgeNotifyBB.EXPECTED_CREATE);
        long expectedUpdate = counters.read(BridgeNotifyBB.EXPECTED_UPDATE);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", expectedCreate, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", expectedUpdate, eventCountExact));
        EventCountersBB.getBB().checkEventCounters(al);
    }

    protected void checkPutAllCounters(boolean eventCountExact) {
        long expPutAllUpdate;
        long expPutAllCreate;
        int numBridges = TestConfig.tab().intAt(BridgeNotifyPrms.numBridges);
        boolean isPartition = TestConfig.tab().booleanAt(BridgeNotifyPrms.isPartition, false);
        SharedCounters counters = BridgeNotifyBB.getBB().getSharedCounters();
        boolean isHA = TestConfig.tab().booleanAt(BridgeNotifyPrms.isHATest, false);
        if (!isPartition) {
            if (isHA) {
                Log.getLogWriter().info("For HA test, could not check putAll events on bridges");
                return;
            }
            expPutAllCreate = counters.read(BridgeNotifyBB.NUM_PUTALL_CREATE) * (long)(numBridges + 1);
            expPutAllUpdate = counters.read(BridgeNotifyBB.NUM_PUTALL_UPDATE) * (long)(numBridges + 1);
        } else {
            expPutAllCreate = counters.read(BridgeNotifyBB.NUM_PUTALL_CREATE) * 2L;
            expPutAllUpdate = counters.read(BridgeNotifyBB.NUM_PUTALL_UPDATE) * 2L;
        }
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        al.add(new ExpCounterValue("numAfterCreateEvents_isPutAll", expPutAllCreate, eventCountExact));
        al.add(new ExpCounterValue("numAfterUpdateEvents_isPutAll", expPutAllUpdate, eventCountExact));
        OperationCountersBB.getBB().checkEventCounters(al);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void registerInterest(Region aRegion, CacheListener myListener, ArrayList oddKeys, ArrayList evenKeys) {
        String clientInterest = TestConfig.tasktab().stringAt(BridgeNotifyPrms.clientInterest, TestConfig.tab().stringAt(BridgeNotifyPrms.clientInterest, null));
        try {
            if (clientInterest.equalsIgnoreCase("allKeys")) {
                aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in ALL_KEYS");
                return;
            }
            if (clientInterest.equalsIgnoreCase("singleKey")) {
                String myKey = NameFactory.getObjectNameForCounter(TestConfig.tab().getRandGen().nextInt(1, 20000));
                aRegion.registerInterest((Object)myKey, InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in a singleKey " + myKey);
                Class<BridgeNotifyBB> clazz = BridgeNotifyBB.class;
                synchronized (BridgeNotifyBB.class) {
                    List registeredKeys = (List)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.SINGLE_KEYS_REGISTERED);
                    registeredKeys.add(myKey);
                    BridgeNotifyBB.getBB().getSharedMap().put(BridgeNotifyBB.SINGLE_KEYS_REGISTERED, registeredKeys);
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    return;
                }
            }
            if (clientInterest.equalsIgnoreCase("evenKeys")) {
                aRegion.registerInterest((Object)evenKeys, InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in KeyList " + evenKeys);
                return;
            } else if (clientInterest.equalsIgnoreCase("oddKeys")) {
                aRegion.registerInterest((Object)oddKeys, InterestResultPolicy.KEYS_VALUES);
                Log.getLogWriter().info("Registered interest in KeyList " + oddKeys);
                return;
            } else {
                if (!clientInterest.equalsIgnoreCase("noInterest")) throw new TestException("Invalid clientInterest " + clientInterest);
                aRegion.registerInterest((Object)"None", InterestResultPolicy.NONE);
                Log.getLogWriter().info("Not registering interest in any keys");
            }
            return;
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_recycleServer() throws ClientVmNotFoundException {
        PRObserver.initialize();
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        int i = rnd.nextInt(endpoints.size());
        BridgeHelper.Endpoint endpoint = endpoints.get(i);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        ClientVmMgr.stop("HydraTask_recycleServer: " + endpoint, -22, -31, target);
        ClientVmMgr.start("starting " + target, target);
        Object value = BridgeNotifyBB.getBB().getSharedMap().get("expectRecovery");
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            PRObserver.waitForRebalRecov(target, 1, 1, null, null, false);
        }
    }

    static {
        rnd = new Random();
        maxNames = TestConfig.tab().longAt(BridgeNotifyPrms.numKeys, 50000L);
    }
}

