/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.Region;
import hct.BridgeNotify;
import hct.BridgeNotifyBB;
import hydra.Log;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import util.EventCountersBB;
import util.ExpCounterValue;

public class SerialBridgeNotify
extends BridgeNotify {
    public static synchronized void HydraTask_initialize() {
        if (bridgeClient == null) {
            bridgeClient = new SerialBridgeNotify();
            bridgeClient.initialize();
            EventCountersBB.getBB().zeroAllCounters();
        }
    }

    public static synchronized void HydraTask_endTask() {
        bridgeClient = new SerialBridgeNotify();
        bridgeClient.initialize();
        ((SerialBridgeNotify)bridgeClient).checkEventCounters(false);
    }

    @Override
    protected int getNumVMsWithListeners() {
        BridgeNotifyBB.getBB().printSharedCounters();
        return (int)BridgeNotifyBB.getBB().getSharedCounters().read(BridgeNotifyBB.NUM_LISTENERS);
    }

    @Override
    protected void addObject(Region aRegion, boolean aBoolean) {
        super.addObject(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void invalidateObject(Region aRegion, boolean isLocalInvalidate) {
        super.invalidateObject(aRegion, isLocalInvalidate);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void destroyObject(Region aRegion, boolean isLocalDestroy) {
        super.destroyObject(aRegion, isLocalDestroy);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void updateObject(Region aRegion) {
        super.updateObject(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void putIfAbsent(Region aRegion, boolean aBoolean) {
        super.putIfAbsent(aRegion, aBoolean);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void remove(Region aRegion) {
        super.remove(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void replace(Region aRegion) {
        super.replace(aRegion);
        if (!this.useTransactions) {
            this.checkEventCounters();
        }
    }

    @Override
    protected void checkEventCounters() {
        Log.getLogWriter().info("checkEventCounters will validate that counters are exact");
        this.checkEventCounters(true);
    }

    protected void checkEventCounters(boolean eventCountExact) {
        SharedCounters counters = BridgeNotifyBB.getBB().getSharedCounters();
        long numCreate = counters.read(BridgeNotifyBB.NUM_CREATE);
        long numUpdate = counters.read(BridgeNotifyBB.NUM_UPDATE);
        long numPutAllCreate = counters.read(BridgeNotifyBB.NUM_PUTALL_CREATE);
        long numPutAllUpdate = counters.read(BridgeNotifyBB.NUM_PUTALL_UPDATE);
        long numDestroy = counters.read(BridgeNotifyBB.NUM_DESTROY);
        long numInval = counters.read(BridgeNotifyBB.NUM_INVALIDATE);
        long numRegionCreate = counters.read(BridgeNotifyBB.NUM_REGION_CREATE);
        long numRegionDestroy = counters.read(BridgeNotifyBB.NUM_REGION_DESTROY);
        long numRegionInval = counters.read(BridgeNotifyBB.NUM_REGION_INVALIDATE);
        long numLocalDestroy = counters.read(BridgeNotifyBB.NUM_LOCAL_DESTROY);
        long numLocalInval = counters.read(BridgeNotifyBB.NUM_LOCAL_INVALIDATE);
        long numLocalRegionDestroy = counters.read(BridgeNotifyBB.NUM_LOCAL_REGION_DESTROY);
        long numLocalRegionInval = counters.read(BridgeNotifyBB.NUM_LOCAL_REGION_INVALIDATE);
        long numClose = counters.read(BridgeNotifyBB.NUM_CLOSE);
        int numVmsWithList = this.getNumVMsWithListeners();
        Log.getLogWriter().info("num VMs with listener installed: " + numVmsWithList);
        boolean receiveValuesAsInvalidates = (Boolean)BridgeNotifyBB.getBB().getSharedMap().get(BridgeNotifyBB.RECEIVE_VALUES_AS_INVALIDATES);
        ArrayList<ExpCounterValue> al = new ArrayList<ExpCounterValue>();
        Log.getLogWriter().info("BridgeNotifyBB.RECEIVE_VALUES_AS_INVALIDATES is set to " + receiveValuesAsInvalidates);
        if (!receiveValuesAsInvalidates) {
            al.add(new ExpCounterValue("numAfterCreateEvents_isNotExp", numCreate * (long)numVmsWithList + numPutAllCreate * (long)numVmsWithList, eventCountExact));
            al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy * (long)numVmsWithList, eventCountExact));
            al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numInval * (long)numVmsWithList, eventCountExact));
            al.add(new ExpCounterValue("numAfterUpdateEvents_isNotExp", numUpdate * (long)numVmsWithList + numPutAllUpdate * (long)numVmsWithList, eventCountExact));
            al.add(new ExpCounterValue("numAfterRegionDestroyEvents_isNotExp", 0L, eventCountExact));
            al.add(new ExpCounterValue("numAfterRegionInvalidateEvents_isNotExp", 0L, eventCountExact));
            al.add(new ExpCounterValue("numClose", numClose, eventCountExact));
        } else {
            al.add(new ExpCounterValue("numAfterInvalidateEvents_isNotExp", numUpdate * (long)(numVmsWithList - 1) + numCreate * (long)(numVmsWithList - 1) + numPutAllUpdate * (long)(numVmsWithList - 1) + numPutAllCreate * (long)(numVmsWithList - 1), eventCountExact));
            al.add(new ExpCounterValue("numAfterDestroyEvents_isNotExp", numDestroy * (long)numVmsWithList, eventCountExact));
        }
        EventCountersBB.getBB().checkEventCounters(al);
    }
}

