/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.Region;
import hct.BridgeNotify;
import hct.BridgeNotifyBB;
import hct.ClientQueuePrms;
import hct.SerialBridgeNotify;
import hydra.CacheHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import util.EventCountersBB;
import util.NameFactory;
import util.TestException;
import util.TestHelper;

public class SerialClientQueue
extends SerialBridgeNotify {
    protected static boolean isConflationEnabled;
    protected static SerialClientQueue bridgeClientConflation;
    private static String CLIENT_NAME;

    public static void HydraTask_populateRegion() {
        isConflationEnabled = TestConfig.tab().booleanAt(ClientQueuePrms.conflationEnabled, false);
        if (isConflationEnabled) {
            return;
        }
        BridgeNotify.HydraTask_populateRegion();
    }

    public static void HydraTask_doEntryOperations() {
        isConflationEnabled = TestConfig.tab().booleanAt(ClientQueuePrms.conflationEnabled, false);
        if (!isConflationEnabled) {
            BridgeNotify.HydraTask_doEntryOperations();
        } else {
            bridgeClientConflation = new SerialClientQueue();
            Region rootRegion = CacheHelper.getCache().getRegion("myRegion");
            bridgeClientConflation.addObjectForConflation(rootRegion);
        }
    }

    private void checkDataCounters(String name) {
        String anObj = (String)BridgeNotifyBB.getBB().getSharedMap().get("Conflation_key");
        String key = this.getConflationKey(name);
        for (Object clientKey : EventCountersBB.getBB().getSharedMap().getMap().keySet()) {
            if (!(clientKey instanceof String) || ((String)clientKey).indexOf("Client_") == -1) continue;
            String actualObj = (String)EventCountersBB.getBB().getSharedMap().get(clientKey);
            Log.getLogWriter().info("Excepted Object : " + anObj + "  Actual Object : " + actualObj);
            if (anObj.equals(actualObj)) continue;
            String errStr = "Data Validation Failed";
            throw new TestException(errStr.toString());
        }
    }

    protected void addObjectForConflation(Region aRegion) {
        BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_CREATE", BridgeNotifyBB.NUM_CREATE);
        String name = NameFactory.getNextPositiveObjectName();
        try {
            aRegion.put((Object)name, (Object)"value");
            BridgeNotifyBB.getBB().getSharedMap().put("Conflation_key", "dummyVlaue");
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        long timeToWaitForConflation = TestConfig.tab().longAt(ClientQueuePrms.timeToWaitForConflation, 60000L);
        String anObj = null;
        for (int i = 0; i < 100; ++i) {
            anObj = "val_" + i;
            try {
                aRegion.put((Object)name, (Object)anObj);
                BridgeNotifyBB.getBB().getSharedMap().put("Conflation_key", anObj);
                BridgeNotifyBB.incrementCounter("BridgeNotifyBB.NUM_UPDATE", BridgeNotifyBB.NUM_UPDATE);
                continue;
            }
            catch (Exception e) {
                throw new TestException(TestHelper.getStackTrace());
            }
        }
        try {
            Thread.sleep(timeToWaitForConflation);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.checkDataCounters(name);
        this.checkUpdateCounters();
    }

    private void checkUpdateCounters() {
        SharedCounters counters = BridgeNotifyBB.getBB().getSharedCounters();
        long numUpdate = counters.read(BridgeNotifyBB.NUM_UPDATE);
        int numVmsWithList = this.getNumVMsWithListeners();
        Log.getLogWriter().info("num VMs with listener installed: " + numVmsWithList);
        long expectedEvents = numUpdate * (long)numVmsWithList;
        long actualEvents = EventCountersBB.getBB().getSharedCounters().read(EventCountersBB.getBB().getSharedCounter("numAfterUpdateEvents_isNotExp"));
        Log.getLogWriter().info("ActualEvents : " + actualEvents + "  ExpectedEvents : " + expectedEvents);
        if (actualEvents >= expectedEvents) {
            String errStr = "Event Validation Failed";
            throw new TestException(errStr.toString());
        }
    }

    private String getConflationKey(String key) {
        return CLIENT_NAME + "_" + key;
    }

    static {
        CLIENT_NAME = "Client_" + ProcessMgr.getProcessId();
    }
}

