/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.cache.util.UniversalMembershipListenerAdapter;
import hct.BBoard;
import hydra.Log;
import hydra.blackboard.SharedCounters;

public class UniversalMembershipListener
extends UniversalMembershipListenerAdapter {
    public void memberJoined(SystemMembershipEvent event) {
        this.logCall("memberJoined", event);
        SharedCounters sc = BBoard.getInstance().getSharedCounters();
        if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
            if (((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient()) {
                long count = sc.incrementAndRead(BBoard.actualClientJoinedEvents);
                Log.getLogWriter().info("After incrementing counter, actualClientJoinedEvents =  " + count);
            } else {
                long count = sc.incrementAndRead(BBoard.actualServerJoinedEvents);
                Log.getLogWriter().info("After incrementing counter, actualServerJoinedEvents =  " + count);
            }
        }
    }

    public void memberLeft(SystemMembershipEvent event) {
        this.logCall("memberLeft", event);
        SharedCounters sc = BBoard.getInstance().getSharedCounters();
        if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
            if (((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient()) {
                long count = sc.incrementAndRead(BBoard.actualClientDepartedEvents);
                Log.getLogWriter().info("After incrementing counter, actualClientDepartedEvents =  " + count);
            } else {
                long count = sc.incrementAndRead(BBoard.actualServerDepartedEvents);
                Log.getLogWriter().info("After incrementing counter, actualServerDepartedEvents =  " + count);
            }
        }
    }

    public void memberCrashed(SystemMembershipEvent event) {
        this.logCall("memberCrashed", event);
        SharedCounters sc = BBoard.getInstance().getSharedCounters();
        if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
            if (((UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event).isClient()) {
                long count = sc.incrementAndRead(BBoard.actualClientCrashedEvents);
                Log.getLogWriter().info("After incrementing counter, actualClientCrashedEvents =  " + count);
            } else {
                long count = sc.incrementAndRead(BBoard.actualServerCrashedEvents);
                Log.getLogWriter().info("After incrementing counter, actualServerCrashedEvents =  " + count);
            }
        }
    }

    private void logCall(String methodName, SystemMembershipEvent event) {
        String aStr = this.toString(methodName, event);
        Log.getLogWriter().info(aStr);
    }

    private String toString(String methodName, SystemMembershipEvent event) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Invoked " + ((Object)((Object)this)).getClass().getName() + ": " + methodName + " in " + this.getMyAppName() + "\n");
        if (event == null) {
            return aStr.toString();
        }
        if (event instanceof UniversalMembershipListenerAdapter.AdaptedMembershipEvent) {
            UniversalMembershipListenerAdapter.AdaptedMembershipEvent uEvent = (UniversalMembershipListenerAdapter.AdaptedMembershipEvent)event;
            aStr.append("event.getMemberId(): " + uEvent.getMemberId() + "\n");
            aStr.append("event.isClient(): " + uEvent.isClient() + "\n");
        } else {
            aStr.append(event.toString());
        }
        return aStr.toString();
    }

    public String getMyAppName() {
        return System.getProperty("clientName");
    }
}

