/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.internal.NanoTimer;
import hct.UseCase1Client;
import hydra.CacheHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolHelper;
import hydra.RemoteTestModule;
import hydra.TestTask;
import java.io.File;
import java.util.Random;

public class UseCase1LoadMoveClient {
    public static final String STRING_PAD = "1234567890123456789012345678901234567890";
    public static boolean init_ = false;
    public static final int REGION_0A = 0;
    public static final int REGION_0B = 1;
    public static final String[] REGION_NAMES = new String[]{"root/day0a", "root/day0b", "root/day1", "root/day7"};
    public static Region[] _regions = new Region[REGION_NAMES.length];
    public static Random rand = new Random();
    private static Pool pool;
    int sleepTime_ = 500;
    int groupSize_ = 50;
    int entrySize_ = 20480;
    int totalKeys_ = 11500;

    public static void initServerCache() {
        String bridgeName = System.getProperty("clientName");
        File aDir1 = new File(bridgeName + "_diskDir_day0a");
        aDir1.mkdir();
        File aDir2 = new File(bridgeName + "_diskDir_day0b");
        aDir2.mkdir();
        for (int i = 0; i <= 7; ++i) {
            File aDir = new File(bridgeName + "_diskDir_day" + i);
            aDir.mkdir();
        }
        String cacheXmlFile = "$JTESTS/hct/" + bridgeName + ".xml";
        CacheHelper.createCacheFromXml(cacheXmlFile);
        UseCase1Client.displayRegions();
    }

    public static synchronized void initEdgeCache() {
        pool = PoolHelper.createPool("brclient");
        String cacheXmlFile = "$JTESTS/hct/useCase1LoadMoveClient.xml";
        Cache cache = CacheHelper.createCacheFromXml(cacheXmlFile);
        UseCase1Client.displayRegions();
    }

    public static void invokeLoad() {
        UseCase1LoadMoveClient svc = new UseCase1LoadMoveClient();
        try {
            svc.invokeLoadWork();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            throw new HydraRuntimeException(t.getMessage(), t);
        }
        finally {
            svc.releaseClient();
        }
    }

    public static void invokePutGetRegionB() {
        UseCase1LoadMoveClient svc = new UseCase1LoadMoveClient();
        try {
            svc.invokePutGetRegionBWork();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            throw new HydraRuntimeException(t.getMessage(), t);
        }
        finally {
            svc.releaseClient();
        }
    }

    public static void invokeMoveAtoB() {
        UseCase1LoadMoveClient svc = new UseCase1LoadMoveClient();
        try {
            svc.invokeMoveAtoBWork();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            throw new HydraRuntimeException(t.getMessage(), t);
        }
        finally {
            svc.releaseClient();
        }
    }

    public static void invokeMoveBtoA() {
        UseCase1LoadMoveClient svc = new UseCase1LoadMoveClient();
        try {
            svc.invokeMoveBtoAWork();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            throw new HydraRuntimeException(t.getMessage(), t);
        }
        finally {
            svc.releaseClient();
        }
    }

    private void releaseClient() {
        pool.releaseThreadLocalConnection();
    }

    private void invokeLoadWork() throws Exception {
        TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
        int numThreads = task.getTotalThreads();
        String tgname = RemoteTestModule.getCurrentThread().getThreadGroupName();
        int tgid = RemoteTestModule.getCurrentThread().getThreadGroupId();
        int ttgid = task.getTaskThreadGroupId(tgname, tgid);
        Log.getLogWriter().info(numThreads + " threads loading " + this.totalKeys_ + " keys");
        int numKeys = (int)Math.ceil(this.totalKeys_ / numThreads);
        int firstKey = ttgid * numKeys;
        int lastKey = Math.min(firstKey + numKeys - 1, this.totalKeys_ - 1);
        Log.getLogWriter().info("Ttgid " + ttgid + " loading keys " + firstKey + "-" + lastKey);
        String key = null;
        byte[] value = null;
        for (int i = firstKey; i <= lastKey; ++i) {
            key = Integer.toString(i) + STRING_PAD;
            value = new byte[this.entrySize_];
            for (int regionNum = 0; regionNum < REGION_NAMES.length; ++regionNum) {
                long startTime = NanoTimer.getTime();
                _regions[regionNum].put((Object)key, (Object)value);
                long deltaTime = NanoTimer.getTime() - startTime;
                pool.releaseThreadLocalConnection();
            }
        }
    }

    private void invokePutGetRegionBWork() throws Exception {
        long deltaTime;
        long startTime;
        String key;
        int i;
        Random rng = new Random();
        int nulls = 0;
        byte[] value = null;
        for (i = 0; i < 10000; ++i) {
            key = Integer.toString(rng.nextInt(this.totalKeys_)) + STRING_PAD;
            value = new byte[this.entrySize_];
            startTime = NanoTimer.getTime();
            _regions[1].put((Object)key, (Object)value);
            deltaTime = NanoTimer.getTime() - startTime;
            pool.releaseThreadLocalConnection();
        }
        for (i = 0; i < 10000; ++i) {
            key = Integer.toString(rng.nextInt(this.totalKeys_)) + STRING_PAD;
            startTime = NanoTimer.getTime();
            if (_regions[1].get((Object)key) == null) {
                ++nulls;
            }
            deltaTime = NanoTimer.getTime() - startTime;
            pool.releaseThreadLocalConnection();
        }
        if (nulls > 0) {
            System.out.println("NULL GETS: " + nulls);
        }
    }

    private void invokeMoveAtoBWork() throws Exception {
        Random rng = new Random();
        String[] keys = new String[this.groupSize_];
        int nulls = 0;
        for (int i = 0; i < this.groupSize_; ++i) {
            keys[i] = Integer.toString(rng.nextInt(this.totalKeys_)) + STRING_PAD;
            long startTime = NanoTimer.getTime();
            if (_regions[0].get((Object)keys[i]) == null) {
                ++nulls;
            }
            long deltaTime = NanoTimer.getTime() - startTime;
            pool.releaseThreadLocalConnection();
        }
        if (nulls > 0) {
            System.out.println("NULL GETS: " + nulls);
        }
        if (this.sleepTime_ != 0) {
            Thread.sleep(this.sleepTime_);
        }
        byte[] value = null;
        for (int i = 0; i < 10; ++i) {
            value = new byte[this.entrySize_];
            long startTime = NanoTimer.getTime();
            _regions[1].put((Object)keys[i], (Object)value);
            long deltaTime = NanoTimer.getTime() - startTime;
            pool.releaseThreadLocalConnection();
        }
    }

    private void invokeMoveBtoAWork() throws Exception {
        Random rng = new Random();
        int nulls = 0;
        String[] keys = new String[this.groupSize_];
        for (int i = 0; i < this.groupSize_; ++i) {
            keys[i] = Integer.toString(rng.nextInt(this.totalKeys_)) + STRING_PAD;
            long startTime = NanoTimer.getTime();
            if (_regions[1].get((Object)keys[i]) == null) {
                ++nulls;
            }
            long deltaTime = NanoTimer.getTime() - startTime;
            pool.releaseThreadLocalConnection();
        }
        if (nulls > 0) {
            System.out.println("NULL GETS: " + nulls);
        }
        if (this.sleepTime_ != 0) {
            Thread.sleep(this.sleepTime_);
        }
        byte[] value = null;
        for (int i = 0; i < 10; ++i) {
            value = new byte[this.entrySize_];
            long startTime = NanoTimer.getTime();
            _regions[0].put((Object)keys[i], (Object)value);
            long deltaTime = NanoTimer.getTime() - startTime;
            pool.releaseThreadLocalConnection();
        }
    }
}

