/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CommitConflictException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import hct.HctPrms;
import hct.ha.HACache;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hct.ha.HAClientQueuePrms;
import hct.ha.Validator;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class Feeder {
    static final int TOTAL_PUT_THREADS = TestConfig.tab().intAt(HAClientQueuePrms.numPutThreads);
    static final int PUT_KEY_RANGE = TestConfig.tab().intAt(HAClientQueuePrms.numKeyRangePerThread);
    static Thread[] putThreads = new Thread[TOTAL_PUT_THREADS];
    static final String regionName = TestConfig.tab().stringAt(HctPrms.regionName);
    static List threadList = new ArrayList(TOTAL_PUT_THREADS);
    static volatile boolean stop = false;
    static volatile boolean exceptionOccured = false;
    static StringBuffer exceptionMsg = new StringBuffer();
    protected static final Map latestValues = new HashMap();
    protected static final String REGION_NAME = TestConfig.tab().stringAt(HctPrms.regionName);
    private static final int CREATE_OPERATION = 1;
    private static final int UPDATE_OPERATION = 2;
    private static final int INVALIDATE_OPERATION = 3;
    private static final int DESTROY_OPERATION = 4;
    private static final int REG_INTEREST_OPERATION = 5;
    private static final int UNREG_INTEREST_OPERATION = 6;
    private static final int KILL_CLIENT = 7;
    static int numOfRegion = 1;
    public static final String LAST_KEY = "last_key";
    protected static boolean allowConcurrentMapOps = true;
    private static int counter = 0;

    private static void createEntries(Region region, String threadIdKeyPrefix) {
        for (int j = 0; j < TOTAL_PUT_THREADS; ++j) {
            String threadIdkey = threadIdKeyPrefix + j;
            HashMap<String, Long> values = new HashMap<String, Long>();
            Long initValue = new Long(0L);
            for (int k = 0; k < PUT_KEY_RANGE; ++k) {
                String key = region.getFullPath() + threadIdkey + "_" + k;
                try {
                    if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                        Log.getLogWriter().fine("putIfAbsent(" + key + ", " + initValue + ")");
                        region.putIfAbsent((Object)key, (Object)initValue);
                    } else {
                        Log.getLogWriter().fine("create(" + key + ", " + initValue + ")");
                        region.create((Object)key, (Object)initValue);
                    }
                }
                catch (Exception e) {
                    Log.getLogWriter().info(TOTAL_PUT_THREADS + "Exception in creating entry for starting with " + j + " for key = " + key);
                    exceptionMsg.append(e.getMessage());
                    exceptionOccured = true;
                }
                values.put(key, initValue);
            }
            latestValues.put(threadIdkey, values);
            try {
                HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, PUT_KEY_RANGE);
                continue;
            }
            catch (Exception e) {
                Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                exceptionMsg.append(e.getMessage());
                exceptionOccured = true;
            }
        }
        if (TestConfig.tab().booleanAt(HAClientQueuePrms.precreateLastKeyAtClient, false)) {
            region.put((Object)LAST_KEY, (Object)"DUMMY_VALUE");
            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, 1L);
            Log.getLogWriter().info("createEntries  : created last_key for " + region.getFullPath());
        }
        Log.getLogWriter().info("Created entries on region : " + region.getFullPath());
    }

    public static void initTask() {
        int i;
        allowConcurrentMapOps = TestConfig.tab().booleanAt(HAClientQueuePrms.allowConcurrentMapOps, true);
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region == null) {
                exceptionMsg.append("Region created is null ");
                exceptionOccured = true;
            }
            String threadIdkeyPrefix = "Thread_";
            Feeder.createEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage());
                                    exceptionOccured = true;
                                }
                            }
                            if (stop) {
                                break;
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        int numRegion = TestConfig.tab().intAt(HAClientQueuePrms.regionRange, 1) - 1;
                        Region region = RegionHelper.getRegion(regionName + numRegion);
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(HAClientQueuePrms.entryOperations, "put");
                                if (operation.equals("put")) {
                                    Long newVal = null;
                                    if (region.containsKey((Object)key)) {
                                        Long oldVal = (Long)region.get((Object)key);
                                        if (oldVal == null) {
                                            newVal = Feeder.getLatestValue(key, threadIdkey);
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        } else {
                                            newVal = new Long(oldVal + 1L);
                                            Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                            region.put((Object)key, (Object)newVal);
                                        }
                                        ++numUpdate;
                                        continue;
                                    }
                                    newVal = Feeder.getLatestValue(key, threadIdkey);
                                    if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                        Log.getLogWriter().fine("putIfAbsent(" + key + ", " + newVal + ")");
                                        region.putIfAbsent((Object)key, (Object)newVal);
                                    } else {
                                        Log.getLogWriter().fine("create(" + key + ", " + newVal + ")");
                                        region.create((Object)key, (Object)newVal);
                                    }
                                    ++numCreate;
                                    continue;
                                }
                                if (operation.equals("invalidate")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                        region.invalidate((Object)key);
                                        ++numInvalidate;
                                    }
                                    continue;
                                }
                                if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("remove(" + key + ")");
                                            region.remove((Object)key, region.get((Object)key));
                                        } else {
                                            Log.getLogWriter().fine("destroy(" + key + ")");
                                            region.destroy((Object)key);
                                        }
                                        ++numDestroy;
                                    }
                                    continue;
                                }
                                throw new TestException("Unknown entry operation: " + operation);
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(e.getMessage());
                                exceptionOccured = true;
                            }
                        }
                        try {
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, numCreate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_UPDATE, numUpdate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_INVALIDATE, numInvalidate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_DESTROY, numDestroy);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                            exceptionMsg.append(e.getMessage());
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed for thread id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    public static void initCSTransactionsTask() {
        int i;
        final Cache cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region == null) {
                exceptionMsg.append("Region created is null ");
                exceptionOccured = true;
            }
            String threadIdkeyPrefix = "VM_" + ProcessMgr.getProcessId() + "_Thread_";
            Feeder.createEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage());
                                    exceptionOccured = true;
                                }
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "VM_" + ProcessMgr.getProcessId() + "_Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        int numRegion = TestConfig.tab().intAt(HAClientQueuePrms.regionRange, 1) - 1;
                        Region region = RegionHelper.getRegion(regionName + numRegion);
                        cache.getCacheTransactionManager().begin();
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(HAClientQueuePrms.entryOperations, "put");
                                if (operation.equals("put")) {
                                    Long newVal = null;
                                    if (region.containsKey((Object)key)) {
                                        Long oldVal = (Long)region.get((Object)key);
                                        if (oldVal == null) {
                                            newVal = Feeder.getLatestValue(key, threadIdkey);
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        } else {
                                            newVal = new Long(oldVal + 1L);
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        }
                                        ++numUpdate;
                                        continue;
                                    }
                                    newVal = Feeder.getLatestValue(key, threadIdkey);
                                    if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                        Log.getLogWriter().fine("putIfAbsent(" + key + ", " + newVal + ")");
                                        region.putIfAbsent((Object)key, (Object)newVal);
                                    } else {
                                        Log.getLogWriter().fine("create(" + key + ", " + newVal + ")");
                                        region.create((Object)key, (Object)newVal);
                                    }
                                    ++numCreate;
                                    continue;
                                }
                                if (operation.equals("invalidate")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                        region.invalidate((Object)key);
                                        ++numInvalidate;
                                    }
                                    continue;
                                }
                                if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("remove(" + key + ")");
                                            region.remove((Object)key, region.get((Object)key));
                                        } else {
                                            Log.getLogWriter().fine("destroy(" + key + ")");
                                            region.destroy((Object)key);
                                        }
                                        ++numDestroy;
                                    }
                                    continue;
                                }
                                throw new TestException("Unknown entry operation: " + operation);
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(e.getMessage());
                                exceptionOccured = true;
                            }
                        }
                        try {
                            cache.getCacheTransactionManager().commit();
                        }
                        catch (ConflictException e) {
                            numCreate = 0;
                            numDestroy = 0;
                            numInvalidate = 0;
                            numUpdate = 0;
                        }
                        try {
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, numCreate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_UPDATE, numUpdate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_INVALIDATE, numInvalidate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_DESTROY, numDestroy);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                            exceptionMsg.append(e.getMessage());
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed thread for id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    public static void initCSTransactionsOneOpPerTxTask() {
        int i;
        Cache cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region == null) {
                exceptionMsg.append("Region created is null ");
                exceptionOccured = true;
            }
            String threadIdkeyPrefix = "VM_" + ProcessMgr.getProcessId() + "_Thread_";
            Feeder.createEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage());
                                    exceptionOccured = true;
                                }
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "VM_" + ProcessMgr.getProcessId() + "_Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        int numRegion = TestConfig.tab().intAt(HAClientQueuePrms.regionRange, 1) - 1;
                        Region region = RegionHelper.getRegion(regionName + numRegion);
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            block32: {
                                try {
                                    String key = region.getFullPath() + threadIdkey + "_" + j;
                                    String operation = TestConfig.tab().stringAt(HAClientQueuePrms.entryOperations, "put");
                                    TxHelper.begin();
                                    if (operation.equals("put")) {
                                        Long newVal = null;
                                        if (region.containsKey((Object)key)) {
                                            Long oldVal = (Long)region.get((Object)key);
                                            if (oldVal == null) {
                                                newVal = Feeder.getLatestValue(key, threadIdkey);
                                                if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                    Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                    region.replace((Object)key, (Object)newVal);
                                                } else {
                                                    Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                    region.put((Object)key, (Object)newVal);
                                                }
                                            } else {
                                                newVal = new Long(oldVal + 1L);
                                                if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                    Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                    region.replace((Object)key, (Object)newVal);
                                                } else {
                                                    Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                    region.put((Object)key, (Object)newVal);
                                                }
                                            }
                                            ++numUpdate;
                                        } else {
                                            newVal = Feeder.getLatestValue(key, threadIdkey);
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("putIfAbsent(" + key + ", " + newVal + ")");
                                                region.putIfAbsent((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("create(" + key + ", " + newVal + ")");
                                                region.create((Object)key, (Object)newVal);
                                            }
                                            ++numCreate;
                                        }
                                        break block32;
                                    }
                                    if (operation.equals("invalidate")) {
                                        if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                            region.invalidate((Object)key);
                                            ++numInvalidate;
                                        }
                                        break block32;
                                    }
                                    if (operation.equals("destroy")) {
                                        if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("remove(" + key + ")");
                                                region.remove((Object)key, region.get((Object)key));
                                            } else {
                                                Log.getLogWriter().fine("destroy(" + key + ")");
                                                region.destroy((Object)key);
                                            }
                                            ++numDestroy;
                                        }
                                        break block32;
                                    }
                                    throw new TestException("Unknown entry operation: " + operation);
                                }
                                catch (Exception e) {
                                    Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                    exceptionMsg.append(e.getMessage());
                                    exceptionOccured = true;
                                }
                            }
                            try {
                                TxHelper.commit();
                                continue;
                            }
                            catch (CommitConflictException e) {
                                numCreate = 0;
                                numDestroy = 0;
                                numInvalidate = 0;
                                numUpdate = 0;
                            }
                        }
                        try {
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, numCreate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_UPDATE, numUpdate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_INVALIDATE, numInvalidate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_DESTROY, numDestroy);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                            exceptionMsg.append(e.getMessage());
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed thread for id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    public static void initTask2() {
        int i;
        HAClientQueue.initCacheClient();
        String regionName = TestConfig.tab().stringAt(HctPrms.regionName);
        final Region region = RegionHelper.getRegion("/" + regionName + 0);
        if (region == null) {
            exceptionMsg.append("Region created is null ");
            exceptionOccured = true;
        }
        String threadIdkeyPrefix = "Thread_";
        Feeder.createEntries(region, threadIdkeyPrefix);
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(TestHelper.getStackTrace(e));
                                    exceptionOccured = true;
                                }
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(HAClientQueuePrms.entryOperations, "put");
                                if (operation.equals("put")) {
                                    Long newVal = null;
                                    if (region.containsKey((Object)key)) {
                                        Long oldVal = (Long)region.get((Object)key);
                                        if (oldVal == null) {
                                            newVal = Feeder.getLatestValue(key, threadIdkey);
                                            region.getCache().getLogger().info(" going to put key " + key + " and value " + newVal);
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        } else {
                                            newVal = new Long(oldVal + 1L);
                                            region.getCache().getLogger().info(" going to put key " + key + " and value " + newVal);
                                            if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                                Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                                region.replace((Object)key, (Object)newVal);
                                            } else {
                                                Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                                region.put((Object)key, (Object)newVal);
                                            }
                                        }
                                        ++numUpdate;
                                        continue;
                                    }
                                    newVal = Feeder.getLatestValue(key, threadIdkey);
                                    region.getCache().getLogger().info(" going to put key " + key + " and value " + newVal);
                                    if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                        Log.getLogWriter().fine("putIfAbsent(" + key + ", " + newVal + ")");
                                        region.putIfAbsent((Object)key, (Object)newVal);
                                    } else {
                                        Log.getLogWriter().fine("create(" + key + ", " + newVal + ")");
                                        region.create((Object)key, (Object)newVal);
                                    }
                                    ++numCreate;
                                    continue;
                                }
                                if (operation.equals("invalidate")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                        region.invalidate((Object)key);
                                        ++numInvalidate;
                                    }
                                    continue;
                                }
                                if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("remove(" + key + ")");
                                            region.remove((Object)key, region.get((Object)key));
                                        } else {
                                            Log.getLogWriter().fine("destroy(" + key + ")");
                                            region.destroy((Object)key);
                                        }
                                        ++numDestroy;
                                    }
                                    continue;
                                }
                                throw new TestException("Unknown entry operation: " + operation);
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(TestHelper.getStackTrace(e));
                                exceptionOccured = true;
                            }
                        }
                        try {
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, numCreate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_UPDATE, numUpdate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_INVALIDATE, numInvalidate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_DESTROY, numDestroy);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                            exceptionMsg.append(e.getMessage());
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed thread for id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    public static void initTaskForCacheClientsDoingRandomOperations() {
        int i;
        HAClientQueue.initCacheClient();
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(1));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(TestHelper.getStackTrace(e));
                                    exceptionOccured = true;
                                }
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        Region region = RegionHelper.getRegion("/" + REGION_NAME + 0);
                        int opCode = TestConfig.tab().intAt(HAClientQueuePrms.opCode);
                        Log.getLogWriter().info("OPCODE = " + opCode);
                        switch (opCode) {
                            case 1: {
                                Feeder.createEntry(region);
                                break;
                            }
                            case 3: {
                                Feeder.invalidateEntry(region);
                                break;
                            }
                            case 4: {
                                Feeder.destroyEntry(region);
                                break;
                            }
                            case 2: {
                                Feeder.updateEntry(region);
                                break;
                            }
                            case 5: {
                                Feeder.registerInterest(region);
                                break;
                            }
                            case 6: {
                                Feeder.unregisterInterest(region);
                                break;
                            }
                            case 7: {
                                HACache.killClient();
                                break;
                            }
                            default: {
                                throw new TestException("Unknown operation " + opCode);
                            }
                        }
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }

    private static String getKeyForOperation() {
        Random r = new Random();
        int randint = r.nextInt(PUT_KEY_RANGE);
        return "KEY-" + randint;
    }

    protected static void createEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (!region.containsKey((Object)key)) {
                if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().fine("putIfAbsent(" + key + "_VALUE)");
                    region.putIfAbsent((Object)key, (Object)(key + "_VALUE"));
                } else {
                    Log.getLogWriter().fine("create(" + key + "_VALUE)");
                    region.create((Object)key, (Object)(key + "_VALUE"));
                }
            }
        }
        catch (EntryExistsException e) {
            Log.getLogWriter().warning("EntryExistsException occured while creating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while creating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void updateEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key)) {
                if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().fine("replace(" + key + "_VALUE)");
                    region.replace((Object)key, (Object)(key + "_VALUE"));
                } else {
                    Log.getLogWriter().fine("put(" + key + "_VALUE)");
                    region.put((Object)key, (Object)(key + "_VALUE"));
                }
            }
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while updating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void invalidateEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key) && region.get((Object)key) != null) {
                region.invalidate((Object)key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().warning("EntryNotFoundException occured while invalidating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while invalidating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void destroyEntry(Region region) {
        String key = Feeder.getKeyForOperation();
        try {
            if (region.containsKey((Object)key)) {
                if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().fine("remove(" + key + "_VALUE)");
                    region.remove((Object)key, (Object)(key + "_VALUE"));
                } else {
                    Log.getLogWriter().fine("destroy(" + key + "_VALUE)");
                    region.destroy((Object)key);
                }
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().warning("EntryNotFoundException occured while invalidating entry. " + TestHelper.getStackTrace(e));
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while invalidating entry. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
    }

    protected static void registerInterest(Region region) {
        String key = Feeder.getKeyForOperation();
        long start = System.currentTimeMillis();
        long total = 0L;
        try {
            region.registerInterest((Object)key);
            total = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while registerInterest. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        if (total > 0L) {
            Log.getLogWriter().info("time taken for registerInterest : " + total);
        }
    }

    protected static void unregisterInterest(Region region) {
        String key = Feeder.getKeyForOperation();
        long start = System.currentTimeMillis();
        long total = 0L;
        try {
            region.unregisterInterest((Object)key);
            total = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            exceptionMsg.append("Exception occured while unregisterInterest. " + TestHelper.getStackTrace(e));
            exceptionOccured = true;
        }
        if (total > 0L) {
            Log.getLogWriter().info("time taken for unregisterInterest : " + total);
        }
    }

    public static void feederTimedTask() {
        long end = System.currentTimeMillis() + TestConfig.tab().longAt(HAClientQueuePrms.feederTaskTimeSec) * 1000L;
        do {
            Feeder.feederTask();
        } while (System.currentTimeMillis() < end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void feederTask() {
        List list = threadList;
        synchronized (list) {
            String exceptionReason = Validator.checkBlackBoardForException();
            if (exceptionOccured) {
                throw new TestException(exceptionMsg.toString());
            }
            if (exceptionReason != null) {
                stop = true;
                threadList.notifyAll();
                for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
                    try {
                        putThreads[i].join(120000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
                    }
                }
                throw new TestException(exceptionReason);
            }
            for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
                int newCounter = (Integer)threadList.get(i) + 1;
                threadList.set(i, new Integer(newCounter));
            }
            threadList.notifyAll();
        }
    }

    public static void populateSharedMapWithRegionData() {
        try {
            numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
            for (int i = 0; i < numOfRegion; ++i) {
                Region region = RegionHelper.getRegion(regionName + i);
                if (region == null) {
                    throw new TestException("Region created is null " + TestHelper.getStackTrace());
                }
                if (region.isEmpty()) {
                    throw new TestException(" Region has no entries to copy to the SharedMap " + TestHelper.getStackTrace());
                }
                Iterator iterator = region.entrySet(false).iterator();
                Region.Entry entry = null;
                while (iterator.hasNext()) {
                    entry = (Region.Entry)iterator.next();
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    HAClientQueueBB.getBB().getSharedMap().put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
        }
    }

    public static void closeTask() {
        Feeder.waitForFeederThreadsToComplete();
        Region region = RegionHelper.getRegion(regionName + 0);
        if (region == null) {
            throw new TestException("Region created is null " + TestHelper.getStackTrace());
        }
        if (TestConfig.tab().booleanAt(HAClientQueuePrms.putLastKey, false)) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                Long last_value = new Long(0L);
                region.put((Object)LAST_KEY, (Object)last_value);
                Log.getLogWriter().info("Putting the last key in the region: " + region.getName());
                if (TestConfig.tab().booleanAt(HAClientQueuePrms.precreateLastKeyAtClient, false)) {
                    HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_UPDATE, 1L);
                } else {
                    HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, 1L);
                }
            }
            catch (Exception e) {
                throw new TestException("Exception while performing put of the last_key" + TestHelper.getStackTrace());
            }
        }
        Log.getLogWriter().info("No of puts done by feeder : " + HAClientQueueBB.getBB().getSharedCounters().read(HAClientQueueBB.NUM_UPDATE));
        Log.getLogWriter().info("Close Task Complete...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForFeederThreadsToComplete() {
        List list = threadList;
        synchronized (list) {
            stop = true;
            threadList.notifyAll();
        }
        for (int i = 0; i < TOTAL_PUT_THREADS; ++i) {
            try {
                putThreads[i].join(120000L);
                continue;
            }
            catch (InterruptedException e) {
                throw new TestException(e.getMessage() + TestHelper.getStackTrace(e));
            }
        }
        if (exceptionOccured) {
            throw new TestException(exceptionMsg.toString());
        }
        Log.getLogWriter().info("Setting feed signal...");
        try {
            HAClientQueueBB.getBB().getSharedCounters().increment(HAClientQueueBB.feedSignal);
        }
        catch (Exception e) {
            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
            exceptionMsg.append(e.getMessage());
            exceptionOccured = true;
        }
        Validator.checkBlackBoardForException();
    }

    protected static Long getLatestValue(String key, String threadIdKey) {
        Map latestValueForThread = (Map)latestValues.get(threadIdKey);
        Long oldVal = (Long)latestValueForThread.remove(key);
        if (oldVal == null) {
            exceptionMsg.append("oldVal cannot be null ");
            exceptionOccured = true;
            throw new TestException("oldVal cannot be null");
        }
        return new Long(oldVal + 1L);
    }

    protected static boolean updateLatestValueMap(Region region, String key, String threadId, boolean isDestroyCall) throws Exception {
        Object oldVal = null;
        if (region.containsKey((Object)key)) {
            oldVal = region.get((Object)key);
            if (oldVal == null) {
                return isDestroyCall;
            }
            Map latestValueForThread = (Map)latestValues.get(threadId);
            latestValueForThread.put(key, oldVal);
            return true;
        }
        return false;
    }

    public static void initTaskWithBulkyObject() {
        int i;
        int OBJECT_SIZE_VAL = 128;
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        numOfRegion = TestConfig.tab().intAt(HAClientQueuePrms.numberOfRegions, 1);
        for (i = 0; i < numOfRegion; ++i) {
            Region region = RegionHelper.createRegion(regionName + i, ConfigPrms.getRegionConfig());
            if (region == null) {
                exceptionMsg.append("Region created is null ");
                exceptionOccured = true;
            }
            String threadIdkeyPrefix = "Thread_";
            Feeder.createEntries(region, threadIdkeyPrefix);
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            threadList.add(new Integer(0));
        }
        for (i = 0; i < TOTAL_PUT_THREADS; ++i) {
            final int threadId = i;
            Feeder.putThreads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    do {
                        List list = threadList;
                        synchronized (list) {
                            if ((Integer)threadList.get(threadId) == 0 && !stop) {
                                try {
                                    threadList.wait();
                                }
                                catch (InterruptedException e) {
                                    exceptionMsg.append(e.getMessage());
                                    exceptionOccured = true;
                                }
                            }
                            if (stop) {
                                break;
                            }
                            threadList.set(threadId, new Integer((Integer)threadList.get(threadId) - 1));
                        }
                        String threadIdkey = "Thread_" + threadId;
                        if (latestValues.get(threadIdkey) == null) {
                            TestException ex = new TestException("Entries were not created in INITTASK for keys containing threadIdkey = " + threadIdkey);
                            exceptionMsg.append(TestHelper.getStackTrace(ex));
                            exceptionOccured = true;
                            continue;
                        }
                        int numCreate = 0;
                        int numUpdate = 0;
                        int numInvalidate = 0;
                        int numDestroy = 0;
                        int numRegion = TestConfig.tab().intAt(HAClientQueuePrms.regionRange, 1) - 1;
                        Region region = RegionHelper.getRegion(regionName + numRegion);
                        for (int j = 0; j < PUT_KEY_RANGE; ++j) {
                            try {
                                String key = region.getFullPath() + threadIdkey + "_" + j;
                                String operation = TestConfig.tab().stringAt(HAClientQueuePrms.entryOperations, "put");
                                if (operation.equals("put")) {
                                    byte[] newVal = new byte[16384];
                                    if (region.containsKey((Object)key)) {
                                        if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("replace(" + key + ", " + newVal + ")");
                                            region.replace((Object)key, (Object)newVal);
                                        } else {
                                            Log.getLogWriter().fine("put(" + key + ", " + newVal + ")");
                                            region.put((Object)key, (Object)newVal);
                                        }
                                        ++numUpdate;
                                        continue;
                                    }
                                    if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                        Log.getLogWriter().fine("putIfAbsent(" + key + ", " + newVal + ")");
                                        region.putIfAbsent((Object)key, (Object)newVal);
                                    } else {
                                        Log.getLogWriter().fine("create(" + key + ", " + newVal + ")");
                                        region.create((Object)key, (Object)newVal);
                                    }
                                    ++numCreate;
                                    continue;
                                }
                                if (operation.equals("invalidate")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, false)) {
                                        region.invalidate((Object)key);
                                        ++numInvalidate;
                                    }
                                    continue;
                                }
                                if (operation.equals("destroy")) {
                                    if (Feeder.updateLatestValueMap(region, key, threadIdkey, true)) {
                                        if (allowConcurrentMapOps && TestConfig.tab().getRandGen().nextBoolean()) {
                                            Log.getLogWriter().fine("remove(" + key + ")");
                                            region.remove((Object)key, region.get((Object)key));
                                        } else {
                                            Log.getLogWriter().fine("destroy(" + key + ")");
                                            region.destroy((Object)key);
                                        }
                                        ++numDestroy;
                                    }
                                    continue;
                                }
                                throw new TestException("Unknown entry operation: " + operation);
                            }
                            catch (Exception e) {
                                Log.getLogWriter().info(TOTAL_PUT_THREADS + "exception in put thread starting with " + threadId + " for key = " + j);
                                exceptionMsg.append(e.getMessage());
                                exceptionOccured = true;
                            }
                        }
                        try {
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_CREATE, numCreate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_UPDATE, numUpdate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_INVALIDATE, numInvalidate);
                            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_DESTROY, numDestroy);
                        }
                        catch (Exception e) {
                            Log.getLogWriter().info("Exception occured while updating SharedCounter ");
                            exceptionMsg.append(e.getMessage());
                            exceptionOccured = true;
                        }
                        Log.getLogWriter().info("Task completed for thread id = " + threadId);
                    } while (!stop);
                }
            };
            putThreads[i].start();
        }
    }
}

